/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

public class NumberOfTimesPermanentTargetedATurnWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> permanentsTargeted = new HashMap<MageObjectReference, Integer>();

    public NumberOfTimesPermanentTargetedATurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.TARGETED) {
            return;
        }
        StackObject targetingObject = game.findTargetingStackObject(this.getKey(), event);
        if (targetingObject == null) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            MageObjectReference mor = new MageObjectReference(permanent, game);
            int nTimes = this.permanentsTargeted.getOrDefault(mor, 0);
            this.permanentsTargeted.put(mor, nTimes + 1);
        }
    }

    public int numTimesTargetedThisTurn(Permanent permanent, Game game) {
        return this.permanentsTargeted.getOrDefault(new MageObjectReference(permanent, game), 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.permanentsTargeted.clear();
    }
}

