/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class PlayerAttackedStepWatcher
extends Watcher {
    private final Map<UUID, Integer> playerAttacked = new HashMap<UUID, Integer>();

    public PlayerAttackedStepWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DECLARE_ATTACKERS_STEP_POST) {
            this.playerAttacked.clear();
        }
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED) {
            this.playerAttacked.putIfAbsent(event.getTargetId(), 0);
            this.playerAttacked.compute(event.getTargetId(), (p, amount) -> amount + 1);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playerAttacked.clear();
    }

    public int getNumberAttackingCurrentStep(UUID playerId) {
        return this.playerAttacked.getOrDefault(playerId, 0);
    }
}

