/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class ProwlWatcher
extends Watcher {
    private final Map<UUID, Set<SubType>> damagingSubtypes = new HashMap<UUID, Set<SubType>>();
    private final Set<UUID> allSubtypes = new HashSet<UUID>();

    public ProwlWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER) {
            return;
        }
        DamagedPlayerEvent dEvent = (DamagedPlayerEvent)event;
        if (!dEvent.isCombatDamage()) {
            return;
        }
        Permanent creature = game.getPermanent(dEvent.getSourceId());
        if (creature == null || this.allSubtypes.contains(creature.getControllerId())) {
            return;
        }
        if (creature.isAllCreatureTypes(game)) {
            this.allSubtypes.add(creature.getControllerId());
            return;
        }
        this.damagingSubtypes.computeIfAbsent(creature.getControllerId(), m -> new LinkedHashSet()).addAll(creature.getSubtype(game));
    }

    @Override
    public void reset() {
        super.reset();
        this.damagingSubtypes.clear();
        this.allSubtypes.clear();
    }

    public boolean hasSubtypeMadeCombatDamage(UUID playerId, Card card, Game game) {
        if (this.allSubtypes.contains(playerId)) {
            return true;
        }
        Set<SubType> subtypes = this.damagingSubtypes.get(playerId);
        return subtypes != null && subtypes.stream().filter(subType -> subType.getSubTypeSet() == SubTypeSet.CreatureType).anyMatch(subType -> card.hasSubtype((SubType)((Object)subType), game));
    }
}

