/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.swing;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.JOptionPane;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truecommons.key.spec.PbeParameters;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.prompting.KeyPromptingDisabledException;
import net.java.truecommons.key.spec.prompting.KeyPromptingInterruptedException;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.PromptingPbeParameters;
import net.java.truecommons.key.swing.AuthenticationException;
import net.java.truecommons.key.swing.KeyStrengthPanel;
import net.java.truecommons.key.swing.ReadKeyPanel;
import net.java.truecommons.key.swing.WriteKeyPanel;
import net.java.truecommons.key.swing.feedback.Feedback;
import net.java.truecommons.key.swing.sl.InvalidKeyFeedbackLocator;
import net.java.truecommons.key.swing.sl.UnknownKeyFeedbackLocator;
import net.java.truecommons.key.swing.util.Windows;

@ThreadSafe
abstract class SwingPromptingPbeParametersView<P extends PromptingPbeParameters<P, S>, S extends KeyStrength>
implements PromptingKey.View<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(SwingPromptingPbeParametersView.class.getName());
    public static final int KEY_FILE_LEN = 512;
    @Nullable
    private volatile URI lastResource;

    SwingPromptingPbeParametersView() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPasswordOn(PbeParameters<?, ?> param, File keyFile, boolean check) throws AuthenticationException {
        byte[] key;
        if (check && keyFile.canWrite()) {
            throw new AuthenticationException(resources.getString("keyFile.canWrite"));
        }
        try {
            key = SwingPromptingPbeParametersView.readKeyFile(keyFile);
        }
        catch (FileNotFoundException ex) {
            throw new AuthenticationException(resources.getString("keyFile.fileNotFoundException"), ex);
        }
        catch (EOFException ex) {
            throw new AuthenticationException(resources.getString("keyFile.eofException"), ex);
        }
        catch (IOException ex) {
            throw new AuthenticationException(resources.getString("keyFile.ioException"), ex);
        }
        try {
            if (check) {
                SwingPromptingPbeParametersView.checkKeyEntropy(key);
            }
            SwingPromptingPbeParametersView.setPasswordOn(param, key);
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    private static void checkKeyEntropy(byte[] key) throws AuthenticationException {
        Deflater def = new Deflater();
        def.setInput(key);
        def.finish();
        assert (def.getTotalOut() == 0);
        int n = def.deflate(new byte[key.length * 2]);
        assert (def.getTotalOut() == n);
        def.end();
        if (n < 64) {
            throw new AuthenticationException(resources.getString("keyFile.badEntropy"));
        }
    }

    private static byte[] readKeyFile(File file) throws FileNotFoundException, EOFException, IOException {
        byte[] buf = new byte[512];
        try (FileInputStream _ = new FileInputStream(file);){
            new DataInputStream(_).readFully(buf);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPasswordOn(PbeParameters<?, ?> param, byte[] key) {
        char[] password = SwingPromptingPbeParametersView.decode(key);
        try {
            param.setPassword(password);
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    private static char[] decode(byte[] bytes) {
        CharBuffer cb = ByteBuffer.wrap(bytes).asCharBuffer();
        char[] chars = new char[cb.remaining()];
        cb.get(chars);
        return chars;
    }

    URI getLastResource() {
        return this.lastResource;
    }

    void setLastResource(URI lastResource) {
        this.lastResource = lastResource;
    }

    protected abstract P newPbeParameters();

    public final void promptKeyForWriting(final PromptingKey.Controller<P> controller) throws UnknownKeyException {
        class PromptKeyForWriting
        implements Runnable {
            PromptKeyForWriting() {
            }

            @Override
            public void run() {
                SwingPromptingPbeParametersView.this.promptKeyForWritingOnEDT(controller);
            }
        }
        SwingPromptingPbeParametersView.multiplexOnEDT(new PromptKeyForWriting());
    }

    void promptKeyForWritingOnEDT(PromptingKey.Controller<P> controller) {
        assert (EventQueue.isDispatchThread());
        URI resource = controller.getResource();
        assert (null != resource);
        Object param = (PromptingPbeParameters)controller.getKeyClone();
        if (null == param) {
            param = this.newPbeParameters();
        }
        KeyStrengthPanel keyStrengthPanel = new KeyStrengthPanel(param.getAllKeyStrengths());
        KeyStrength keyStrength = param.getKeyStrength();
        if (null != keyStrength) {
            keyStrengthPanel.setKeyStrength(keyStrength);
        }
        WriteKeyPanel keyPanel = new WriteKeyPanel(this);
        keyPanel.setExtraDataUI(keyStrengthPanel);
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback((Feedback)(null != keyPanel.getError() ? InvalidKeyFeedbackLocator.SINGLETON : UnknownKeyFeedbackLocator.SINGLETON).get());
            int result = JOptionPane.showConfirmDialog(parent, keyPanel, resources.getString("writeKeyDialog.title"), 2, 3);
            if (result != 0) break;
            if (keyPanel.updateParam((PromptingPbeParameters<?, ?>)param)) {
                param.setKeyStrength(keyStrengthPanel.getKeyStrength());
                break;
            }
            assert (keyPanel.getError() != null);
        }
        controller.setKeyClone((PromptingKey)param);
    }

    public final void promptKeyForReading(final PromptingKey.Controller<P> controller, final boolean invalid) throws UnknownKeyException {
        class PromptKeyForReading
        implements Runnable {
            PromptKeyForReading() {
            }

            @Override
            public void run() {
                SwingPromptingPbeParametersView.this.promptKeyForReadingOnEDT(controller, invalid);
            }
        }
        SwingPromptingPbeParametersView.multiplexOnEDT(new PromptKeyForReading());
    }

    void promptKeyForReadingOnEDT(PromptingKey.Controller<P> controller, boolean invalid) {
        assert (EventQueue.isDispatchThread());
        URI resource = controller.getResource();
        assert (null != resource);
        ReadKeyPanel keyPanel = new ReadKeyPanel(this);
        if (invalid) {
            keyPanel.setError(resources.getString("invalid"));
        }
        Window parent = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            keyPanel.setResource(resource);
            keyPanel.setFeedback((Feedback)(null != keyPanel.getError() ? InvalidKeyFeedbackLocator.SINGLETON : UnknownKeyFeedbackLocator.SINGLETON).get());
            int result = JOptionPane.showConfirmDialog(parent, keyPanel, resources.getString("readKeyDialog.title"), 2, 3);
            if (result != 0) {
                controller.setKeyClone(null);
                return;
            }
            P param = this.newPbeParameters();
            if (keyPanel.updateParam((PromptingPbeParameters<?, ?>)param)) {
                controller.setKeyClone(param);
                return;
            }
            assert (keyPanel.getError() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void multiplexOnEDT(Runnable task) throws UnknownKeyException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new KeyPromptingDisabledException();
        }
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        Class<SwingPromptingPbeParametersView> clazz = SwingPromptingPbeParametersView.class;
        synchronized (SwingPromptingPbeParametersView.class) {
            try {
                EventQueue.invokeAndWait(task);
            }
            catch (InterruptedException interrupt) {
                throw new KeyPromptingInterruptedException((Throwable)interrupt);
            }
            catch (InvocationTargetException failure) {
                throw new UnknownKeyException((Throwable)failure);
            }
            return;
        }
    }
}

