/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.bcodec;

import com.turn.ttorrent.bcodec.BEValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BEncoder {
    public static void bencode(Object o, OutputStream out) throws IOException, IllegalArgumentException {
        if (o instanceof BEValue) {
            o = ((BEValue)o).getValue();
        }
        if (o instanceof String) {
            BEncoder.bencode((String)o, out);
        } else if (o instanceof byte[]) {
            BEncoder.bencode((byte[])o, out);
        } else if (o instanceof Number) {
            BEncoder.bencode((Number)o, out);
        } else if (o instanceof List) {
            BEncoder.bencode((List)o, out);
        } else if (o instanceof Map) {
            BEncoder.bencode((Map)o, out);
        } else {
            throw new IllegalArgumentException("Cannot bencode: " + o.getClass());
        }
    }

    public static void bencode(String s, OutputStream out) throws IOException {
        byte[] bs = s.getBytes("UTF-8");
        BEncoder.bencode(bs, out);
    }

    public static void bencode(Number n, OutputStream out) throws IOException {
        out.write(105);
        String s = n.toString();
        out.write(s.getBytes("UTF-8"));
        out.write(101);
    }

    public static void bencode(List<BEValue> l, OutputStream out) throws IOException {
        out.write(108);
        for (BEValue value : l) {
            BEncoder.bencode(value, out);
        }
        out.write(101);
    }

    public static void bencode(byte[] bs, OutputStream out) throws IOException {
        String l = Integer.toString(bs.length);
        out.write(l.getBytes("UTF-8"));
        out.write(58);
        out.write(bs);
    }

    public static void bencode(Map<String, BEValue> m, OutputStream out) throws IOException {
        out.write(100);
        Set<String> s = m.keySet();
        ArrayList<String> l = new ArrayList<String>(s);
        Collections.sort(l);
        for (String key : l) {
            BEValue value = m.get(key);
            BEncoder.bencode(key, out);
            BEncoder.bencode(value, out);
        }
        out.write(101);
    }

    public static ByteBuffer bencode(Map<String, BEValue> m) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BEncoder.bencode(m, (OutputStream)baos);
        baos.close();
        return ByteBuffer.wrap(baos.toByteArray());
    }
}

