/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.peer;

import com.turn.ttorrent.client.SharedTorrent;
import com.turn.ttorrent.client.peer.MessageListener;
import com.turn.ttorrent.client.peer.Rate;
import com.turn.ttorrent.client.peer.SharingPeer;
import com.turn.ttorrent.common.protocol.PeerMessage;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.text.ParseException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PeerExchange {
    private static final Logger logger = LoggerFactory.getLogger(PeerExchange.class);
    private static final int KEEP_ALIVE_IDLE_MINUTES = 2;
    private SharingPeer peer;
    private SharedTorrent torrent;
    private SocketChannel channel;
    private Set<MessageListener> listeners;
    private IncomingThread in;
    private OutgoingThread out;
    private BlockingQueue<PeerMessage> sendQueue;
    private volatile boolean stop;

    public PeerExchange(SharingPeer peer, SharedTorrent torrent, SocketChannel channel) throws SocketException {
        this.peer = peer;
        this.torrent = torrent;
        this.channel = channel;
        this.listeners = new HashSet<MessageListener>();
        this.sendQueue = new LinkedBlockingQueue<PeerMessage>();
        if (!this.peer.hasPeerId()) {
            throw new IllegalStateException("Peer does not have a peer ID. Was the handshake made properly?");
        }
        this.in = new IncomingThread();
        this.in.setName("bt-peer(" + this.peer.getShortHexPeerId() + ")-recv");
        this.out = new OutgoingThread();
        this.out.setName("bt-peer(" + this.peer.getShortHexPeerId() + ")-send");
        this.out.setDaemon(true);
        this.stop = false;
        this.in.start();
        this.out.start();
        logger.debug("Started peer exchange with {} for {}.", (Object)this.peer, (Object)this.torrent);
        BitSet pieces = this.torrent.getCompletedPieces();
        if (pieces.cardinality() > 0) {
            this.send(PeerMessage.BitfieldMessage.craft(pieces));
        }
    }

    public void register(MessageListener listener) {
        this.listeners.add(listener);
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public void send(PeerMessage message) {
        try {
            this.sendQueue.put(message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void close() {
        this.stop = true;
        if (this.channel.isConnected()) {
            IOUtils.closeQuietly(this.channel);
        }
        logger.debug("Peer exchange with {} closed.", (Object)this.peer);
    }

    private class OutgoingThread
    extends RateLimitThread {
        private OutgoingThread() {
        }

        @Override
        public void run() {
            try {
                while (!PeerExchange.this.stop || PeerExchange.this.stop && PeerExchange.this.sendQueue.size() > 0) {
                    try {
                        PeerMessage message = (PeerMessage)PeerExchange.this.sendQueue.poll(2L, TimeUnit.MINUTES);
                        if (message == null) {
                            if (PeerExchange.this.stop) {
                                return;
                            }
                            message = PeerMessage.KeepAliveMessage.craft();
                        }
                        logger.trace("Sending {} to {}", (Object)message, (Object)PeerExchange.this.peer);
                        ByteBuffer data = message.getData();
                        long size = 0L;
                        while (!PeerExchange.this.stop && data.hasRemaining()) {
                            int written = PeerExchange.this.channel.write(data);
                            size += (long)written;
                            if (written >= 0) continue;
                            throw new EOFException("Reached end of stream while writing");
                        }
                        this.rateLimit(PeerExchange.this.torrent.getMaxUploadRate(), size, message);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (IOException ioe) {
                logger.debug("Could not send message to {}: {}", (Object)PeerExchange.this.peer, (Object)(ioe.getMessage() != null ? ioe.getMessage() : ioe.getClass().getName()));
                PeerExchange.this.peer.unbind(true);
            }
        }
    }

    private class IncomingThread
    extends RateLimitThread {
        private IncomingThread() {
        }

        private long read(Selector selector, ByteBuffer buffer) throws IOException {
            if (selector.select() == 0 || !buffer.hasRemaining()) {
                return 0L;
            }
            long size = 0L;
            Iterator<SelectionKey> it = selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                if (key.isReadable()) {
                    int read = ((SocketChannel)key.channel()).read(buffer);
                    if (read < 0) {
                        throw new IOException("Unexpected end-of-stream while reading");
                    }
                    size += (long)read;
                }
                it.remove();
            }
            return size;
        }

        private void handleIOE(IOException ioe) {
            logger.debug("Could not read message from {}: {}", (Object)PeerExchange.this.peer, (Object)(ioe.getMessage() != null ? ioe.getMessage() : ioe.getClass().getName()));
            PeerExchange.this.peer.unbind(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
            Selector selector = null;
            try {
                selector = Selector.open();
                PeerExchange.this.channel.register(selector, 1);
                while (!PeerExchange.this.stop) {
                    buffer.rewind();
                    buffer.limit(4);
                    while (!PeerExchange.this.stop && buffer.hasRemaining()) {
                        this.read(selector, buffer);
                    }
                    int pstrlen = buffer.getInt(0);
                    buffer.limit(4 + pstrlen);
                    long size = 0L;
                    while (!PeerExchange.this.stop && buffer.hasRemaining()) {
                        size += this.read(selector, buffer);
                    }
                    buffer.rewind();
                    try {
                        PeerMessage message = PeerMessage.parse(buffer, PeerExchange.this.torrent);
                        logger.trace("Received {} from {}", (Object)message, (Object)PeerExchange.this.peer);
                        this.rateLimit(PeerExchange.this.torrent.getMaxDownloadRate(), size, message);
                        for (MessageListener listener : PeerExchange.this.listeners) {
                            listener.handleMessage(message);
                        }
                    }
                    catch (ParseException pe) {
                        logger.warn("{}", (Object)pe.getMessage());
                    }
                }
            }
            catch (IOException ioe) {
                this.handleIOE(ioe);
            }
            finally {
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException ioe) {
                    this.handleIOE(ioe);
                }
            }
        }
    }

    private abstract class RateLimitThread
    extends Thread {
        protected final Rate rate = new Rate();
        protected long sleep = 1000L;

        private RateLimitThread() {
        }

        protected void rateLimit(double maxRate, long messageSize, PeerMessage message) {
            if (message.getType() != PeerMessage.Type.PIECE || maxRate <= 0.0) {
                return;
            }
            try {
                this.rate.add(messageSize);
                if ((double)this.rate.get() > maxRate * 1024.0) {
                    Thread.sleep(this.sleep);
                    this.sleep += 50L;
                } else {
                    this.sleep = this.sleep > 50L ? this.sleep - 50L : 0L;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

