/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.storage;

import com.turn.ttorrent.client.storage.FileStorage;
import com.turn.ttorrent.client.storage.TorrentByteStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCollectionStorage
implements TorrentByteStorage {
    private static final Logger logger = LoggerFactory.getLogger(FileCollectionStorage.class);
    private final List<FileStorage> files;
    private final long size;

    public FileCollectionStorage(List<FileStorage> files, long size) {
        this.files = files;
        this.size = size;
        logger.info("Initialized torrent byte storage on {} file(s) ({} total byte(s)).", (Object)files.size(), (Object)size);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public int read(ByteBuffer buffer, long offset) throws IOException {
        int requested = buffer.remaining();
        int bytes = 0;
        for (FileOffset fo : this.select(offset, requested)) {
            buffer.limit((int)((long)bytes + fo.length));
            bytes += fo.file.read(buffer, fo.offset);
        }
        if (bytes < requested) {
            throw new IOException("Storage collection read underrun!");
        }
        return bytes;
    }

    @Override
    public int write(ByteBuffer buffer, long offset) throws IOException {
        int requested = buffer.remaining();
        int bytes = 0;
        for (FileOffset fo : this.select(offset, requested)) {
            buffer.limit(bytes + (int)fo.length);
            bytes += fo.file.write(buffer, fo.offset);
        }
        if (bytes < requested) {
            throw new IOException("Storage collection write underrun!");
        }
        return bytes;
    }

    @Override
    public void close() throws IOException {
        for (FileStorage file : this.files) {
            file.close();
        }
    }

    @Override
    public void finish() throws IOException {
        for (FileStorage file : this.files) {
            file.finish();
        }
    }

    @Override
    public boolean isFinished() {
        for (FileStorage file : this.files) {
            if (file.isFinished()) continue;
            return false;
        }
        return true;
    }

    private List<FileOffset> select(long offset, long length) {
        if (offset + length > this.size) {
            throw new IllegalArgumentException("Buffer overrun (" + offset + " + " + length + " > " + this.size + ") !");
        }
        LinkedList<FileOffset> selected = new LinkedList<FileOffset>();
        long bytes = 0L;
        for (FileStorage file : this.files) {
            if (file.offset() >= offset + length) break;
            if (file.offset() + file.size() < offset) continue;
            long position = offset - file.offset();
            position = position > 0L ? position : 0L;
            long size = Math.min(file.size() - position, length - bytes);
            selected.add(new FileOffset(file, position, size));
            bytes += size;
        }
        if (selected.size() == 0 || bytes < length) {
            throw new IllegalStateException("Buffer underrun (only got " + bytes + " out of " + length + " byte(s) requested)!");
        }
        return selected;
    }

    private static class FileOffset {
        public final FileStorage file;
        public final long offset;
        public final long length;

        FileOffset(FileStorage file, long offset, long length) {
            this.file = file;
            this.offset = offset;
            this.length = length;
        }
    }
}

