/*
 * Decompiled with CFR 0.152.
 */
package com.xmage.launcher;

import com.turn.ttorrent.client.Client;
import com.turn.ttorrent.client.SharedTorrent;
import com.xmage.launcher.Config;
import com.xmage.launcher.Downloader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DownloadTask
extends SwingWorker<Void, Progress> {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger logger = LoggerFactory.getLogger(DownloadTask.class);
    private final JProgressBar progressBar;
    private final JTextArea textArea;
    private static final int OWNER_READ = 256;
    private static final int OWNER_WRITE = 128;
    private static final int OWNER_EXEC = 64;
    private static final int EVERYONE_READ = 4;
    private static final int EVERYONE_WRITE = 2;
    private static final int EVERYONE_EXEC = 1;

    public DownloadTask(JProgressBar progressBar, JTextArea textArea) {
        this.progressBar = progressBar;
        this.textArea = textArea;
    }

    protected boolean download(URL downloadURL, String saveDirectory, String cookies) throws IOException {
        try {
            int count;
            Downloader dl = new Downloader();
            dl.connect(downloadURL, cookies);
            BufferedInputStream in = dl.getInputStream();
            File temp = new File(saveDirectory + File.separator + "xmage.dl");
            FileOutputStream fout = new FileOutputStream(temp);
            byte[] data = new byte[4096];
            long total = 0L;
            long size = dl.getSize();
            this.publish(0);
            while ((count = in.read(data, 0, 4096)) != -1) {
                fout.write(data, 0, count);
                this.publish((int)((total += (long)count) * 100L / size));
            }
            fout.close();
            dl.disconnect();
            return true;
        }
        catch (IOException ex) {
            this.publish(0);
            this.cancel(true);
            logger.error("Error: ", ex);
            return false;
        }
    }

    protected void publish(int perc) {
        this.publish(new Progress(perc));
    }

    protected void publish(String text) {
        this.publish(new Progress(text));
    }

    @Override
    protected void process(List<Progress> chunks) {
        for (Progress chunk : chunks) {
            if (chunk.perc >= 0) {
                this.progressBar.setValue(chunk.perc);
            }
            if (chunk.text == null) continue;
            this.textArea.append(chunk.text);
        }
    }

    public void torrent(File from, File to) throws IOException {
        SharedTorrent torrent = SharedTorrent.fromFile(from, to);
        Client client = new Client(InetAddress.getLocalHost(), torrent);
        client.setMaxDownloadRate(Config.getTorrentDownRate());
        client.setMaxUploadRate(Config.getTorrentUpRate());
        client.download();
        while (!torrent.isComplete()) {
            this.publish((int)torrent.getCompletion());
        }
    }

    protected void extract(File from, File to) throws IOException {
        TarArchiveEntry tarEntry;
        TarArchiveInputStream tarIn = new TarArchiveInputStream(new GzipCompressorInputStream(new FileInputStream(from)));
        this.publish(0);
        long size = 0L;
        while ((tarEntry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
            size += tarEntry.getSize();
        }
        tarIn.close();
        long total = 0L;
        tarIn = new TarArchiveInputStream(new GzipCompressorInputStream(new FileInputStream(from)));
        while ((tarEntry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
            File destPath = new File(to, tarEntry.getName());
            int mode = tarEntry.getMode();
            if (tarEntry.isDirectory()) {
                destPath.mkdirs();
            } else {
                int count;
                destPath.createNewFile();
                byte[] data = new byte[4096];
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destPath), 4096);
                while ((count = tarIn.read(data, 0, 4096)) != -1) {
                    out.write(data, 0, count);
                }
                out.close();
                this.publish((int)((total += tarEntry.getSize()) * 100L / size));
            }
            this.setFilePermissions(destPath, mode);
        }
        tarIn.close();
    }

    private void setFilePermissions(File file, int mode) {
        if ((mode & 4) == 4) {
            file.setReadable(true, false);
        } else if ((mode & 0x100) == 256) {
            file.setReadable(true, true);
        } else {
            file.setReadable(false, false);
        }
        if ((mode & 2) == 2) {
            file.setWritable(true, false);
        } else if ((mode & 0x80) == 128) {
            file.setWritable(true, true);
        } else {
            file.setWritable(false, false);
        }
        if ((mode & 1) == 1) {
            file.setExecutable(true, false);
        } else if ((mode & 0x40) == 64) {
            file.setExecutable(true, true);
        } else {
            file.setExecutable(false, false);
        }
    }

    protected void unzip(File from, File to) throws IOException {
        ZipArchiveEntry zipEntry;
        ZipArchiveInputStream zipIn = new ZipArchiveInputStream(new FileInputStream(from));
        this.publish(0);
        long size = 0L;
        while ((zipEntry = (ZipArchiveEntry)zipIn.getNextEntry()) != null) {
            size += zipEntry.getSize();
        }
        zipIn.close();
        long total = 0L;
        zipIn = new ZipArchiveInputStream(new FileInputStream(from));
        while ((zipEntry = (ZipArchiveEntry)zipIn.getNextEntry()) != null) {
            int count;
            File destPath = new File(to, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                destPath.mkdirs();
                continue;
            }
            File pathFile = new File(destPath.getAbsolutePath().substring(0, destPath.getAbsolutePath().lastIndexOf(File.separator)));
            pathFile.mkdirs();
            destPath.createNewFile();
            byte[] data = new byte[4096];
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destPath), 4096);
            while ((count = zipIn.read(data, 0, 4096)) != -1) {
                out.write(data, 0, count);
            }
            out.close();
            this.publish((int)((total += zipEntry.getSize()) * 100L / size));
        }
        zipIn.close();
    }

    public static class Progress {
        String text;
        Integer perc;

        public Progress(String text) {
            this.text = text;
            this.perc = -1;
        }

        public Progress(Integer perc) {
            this.perc = perc;
            this.text = null;
        }
    }
}

