/*
 * Decompiled with CFR 0.152.
 */
package com.xmage.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGobbler
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(StreamGobbler.class);
    private final InputStream is;
    private final JTextArea text;

    public StreamGobbler(InputStream is, JTextArea text) {
        this.is = is;
        this.text = text;
    }

    @Override
    public void run() {
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                this.appendLine(line);
            }
        }
        catch (IOException ex) {
            this.appendLine(ex.toString());
            logger.error("Error processing stream", ex);
        }
    }

    private void appendLine(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StreamGobbler.this.text.append(line + "\n");
            }
        });
    }
}

