/*
 * Decompiled with CFR 0.152.
 */
package mage.tournament;

import mage.constants.TournamentPlayerState;
import mage.game.draft.DraftOptions;
import mage.game.draft.RichManCubeBoosterDraft;
import mage.game.events.TableEvent;
import mage.game.tournament.TournamentOptions;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.TournamentSingleElimination;

public class RichManCubeDraftEliminationTournament
extends TournamentSingleElimination {
    protected TournamentStep currentStep = TournamentStep.START;

    public RichManCubeDraftEliminationTournament(TournamentOptions options) {
        super(options);
    }

    protected void draft() {
        this.draft = new RichManCubeBoosterDraft((DraftOptions)this.options.getLimitedOptions(), this.getSets());
        for (TournamentPlayer player : this.players.values()) {
            this.draft.addPlayer(player.getPlayer());
            player.setState(TournamentPlayerState.DRAFTING);
        }
        this.tableEventSource.fireTableEvent(TableEvent.EventType.START_DRAFT, null, this.draft);
    }

    public void nextStep() {
        if (this.isAbort()) {
            this.currentStep = TournamentStep.COMPETE;
        }
        switch (this.currentStep) {
            case START: {
                this.currentStep = TournamentStep.DRAFT;
                this.draft();
                break;
            }
            case DRAFT: {
                this.currentStep = TournamentStep.CONSTRUCT;
                this.construct();
                break;
            }
            case CONSTRUCT: {
                this.currentStep = TournamentStep.COMPETE;
                this.runTournament();
                break;
            }
            case COMPETE: {
                this.currentStep = TournamentStep.WINNERS;
                this.winners();
                this.end();
            }
        }
    }

    protected static enum TournamentStep {
        START,
        DRAFT,
        CONSTRUCT,
        COMPETE,
        WINNERS;

    }
}

