/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ImageHelper;
import mage.client.util.TransformedImageCache;
import mage.constants.EnlargeMode;
import org.jdesktop.swingx.JXPanel;
import org.mage.card.arcane.ManaSymbols;
import org.mage.card.arcane.UI;

public class BigCard
extends JComponent {
    protected Image bigImage;
    protected BufferedImage source;
    protected volatile BufferedImage foil;
    protected UUID cardId;
    protected JXPanel panel;
    protected int oldWidth;
    protected boolean foilState;
    protected Thread foilThread;
    protected float hue = 0.005f;
    protected float dh = 0.005f;
    protected EnlargeMode enlargeMode;
    private JScrollPane scrollPane;
    private JTextPane text;

    public BigCard() {
        this(false);
    }

    public BigCard(boolean rotated) {
        this.initComponents();
        if (!Plugins.instance.isCardPluginLoaded()) {
            this.initBounds(rotated);
        }
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.scrollPane.setOpaque(true);
        this.scrollPane.setVisible(false);
        UI.setHTMLEditorKit(this.text);
        this.text.setEditable(false);
    }

    private void initBounds(boolean rotated) {
        this.oldWidth = this.getWidth();
        if (rotated) {
            this.scrollPane.setBounds(50, 50, 100, 100);
        } else {
            this.scrollPane.setBounds(this.getWidth() * 1000 / 17777, this.getWidth() * 1000 / 1150, this.getWidth() * 1000 / 1130, this.getWidth() * 1000 / 2100);
        }
    }

    public void clearUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCard(UUID cardId, EnlargeMode enlargeMode, Image image, List<String> strings, boolean rotate) {
        image = rotate && this.getWidth() > this.getHeight() ? TransformedImageCache.getRotatedResizedImage((BufferedImage)image, this.getHeight(), this.getWidth(), Math.toRadians(90.0)) : TransformedImageCache.getResizedImage((BufferedImage)image, this.getWidth(), this.getHeight());
        if (this.cardId == null || enlargeMode != this.enlargeMode || !this.cardId.equals(cardId)) {
            if (this.panel != null) {
                this.remove((Component)this.panel);
            }
            this.cardId = cardId;
            this.enlargeMode = enlargeMode;
            this.bigImage = image;
            BigCard bigCard = this;
            synchronized (bigCard) {
                this.source = null;
                this.hue = 0.0f;
            }
            StringBuilder displayedText = new StringBuilder();
            for (String textLine : strings) {
                if (textLine == null || textLine.replace(".", "").trim().isEmpty()) continue;
                displayedText.append("<p style='margin: 2px'>").append(textLine).append("</p>");
            }
            this.text.setText(ManaSymbols.replaceSymbolsWithHTML(displayedText.toString(), ManaSymbols.Type.DIALOG));
            this.repaint();
        }
    }

    public UUID getCardId() {
        return this.cardId;
    }

    public void resetCardId() {
        this.cardId = null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.bigImage != null) {
            graphics.drawImage(this.bigImage, 0, 0, this);
        }
        super.paintComponent(graphics);
    }

    public void hideTextComponent() {
        this.scrollPane.setVisible(false);
    }

    public void showTextComponent() {
        if (this.oldWidth != this.getWidth()) {
            this.initBounds(false);
        }
        this.scrollPane.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJXPanel(UUID cardId, JXPanel jxPanel) {
        this.cardId = cardId;
        this.bigImage = null;
        BigCard bigCard = this;
        synchronized (bigCard) {
            if (this.panel != null) {
                this.remove((Component)this.panel);
            }
            this.panel = jxPanel;
            this.add((Component)jxPanel);
        }
        this.repaint();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.text = new JTextPane();
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(256, 367));
        this.setName("bigCardPanel");
        this.setPreferredSize(this.getMinimumSize());
        this.setLayout(null);
        this.scrollPane.setBackground(new Color(220, 220, 220));
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportBorder(BorderFactory.createEtchedBorder());
        this.text.setFocusable(false);
        this.scrollPane.setViewportView(this.text);
        this.add(this.scrollPane);
        this.scrollPane.setBounds(20, 220, 210, 130);
        this.scrollPane.setBounds(new Rectangle(15, 232, 227, 105));
    }

    public void setDefaultImage() {
        this.bigImage = ImageHelper.getImageFromResources("/empty.png");
        this.bigImage = ImageHelper.getResizedImage((BufferedImage)this.bigImage, this.getWidth(), this.getHeight());
    }
}

