/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import mage.abilities.icon.CardIconColor;
import mage.abilities.icon.CardIconOrder;
import mage.abilities.icon.CardIconPosition;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.client.cards.BigCard;
import mage.client.cards.CardEventProducer;
import mage.client.cards.CardEventSource;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.Event;
import mage.client.util.GUISizeHelper;
import mage.client.util.Listener;
import mage.util.DebugUtil;
import mage.view.AbilityView;
import mage.view.CardView;
import mage.view.CardsView;
import org.apache.log4j.Logger;

public class CardArea
extends JPanel
implements CardEventProducer {
    private static final Logger logger = Logger.getLogger(CardArea.class);
    protected final CardEventSource cardEventSource = new CardEventSource();
    private static final int MAX_CARDS_PER_COLUMN = 20;
    private static final boolean SORTED_BY_CARD_NAME = true;
    private boolean reloaded = false;
    private final JLayeredPane cardArea;
    private final JScrollPane scrollPane;
    private int yCardCaptionOffsetPercent = 0;
    private int xOffsetBetweenCardsOrColumns = 0;
    private Dimension cardDimension;
    private int verticalCardOffset;
    private int customRenderMode = -1;
    private Dimension customCardSize = null;
    private boolean customNeedFullPermanentRender = false;
    private int customXOffsetBetweenCardsOrColumns = 0;
    private CardIconPosition customCardIconPosition = null;
    private CardIconOrder customCardIconOrder = null;
    private CardIconColor customCardIconColor = null;
    private int customCardIconsMaxVisibleCount = 0;

    public CardArea() {
        this.setLayout(new BorderLayout(0, 0));
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
        this.setGUISize();
        this.cardArea = new JLayeredPane();
        this.scrollPane.setViewportView(this.cardArea);
        if (DebugUtil.GUI_GAME_DIALOGS_DRAW_CARDS_AREA_BORDER) {
            this.setBorder(BorderFactory.createLineBorder(Color.yellow));
        }
        this.cardArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    Plugins.instance.getActionCallback().popupMenuPanel(e, (Component)CardArea.this);
                }
            }
        });
    }

    public void cleanUp() {
        for (Component comp : this.cardArea.getComponents()) {
            if (!(comp instanceof MageCard)) continue;
            ((MageCard)comp).cleanUp();
            this.cardArea.remove(comp);
        }
    }

    public void changeGUISize() {
        this.setGUISize();
        for (Component component : this.cardArea.getComponents()) {
            if (!(component instanceof MageCard)) continue;
            component.setBounds(0, 0, this.cardDimension.width, this.cardDimension.height);
        }
    }

    private void setGUISize() {
        if (this.customCardSize != null) {
            this.setCardDimension(this.customCardSize, GUISizeHelper.otherZonesCardVerticalOffset);
        } else {
            this.setCardDimension(GUISizeHelper.otherZonesCardDimension, GUISizeHelper.otherZonesCardVerticalOffset);
        }
        if (this.customXOffsetBetweenCardsOrColumns > 0) {
            this.xOffsetBetweenCardsOrColumns = this.customXOffsetBetweenCardsOrColumns;
        }
    }

    public void setCardDimension(Dimension dimension, int verticalCardOffset) {
        this.cardDimension = dimension;
        this.verticalCardOffset = verticalCardOffset;
    }

    private void fixDialogSize() {
        Dimension newSize = new Dimension(this.cardArea.getPreferredSize());
        newSize.width += 20;
        newSize.height += 20;
        this.setPreferredSize(newSize);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(GUISizeHelper.getCardsScrollbarUnitInc(this.cardDimension.width));
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(GUISizeHelper.getCardsScrollbarUnitInc(this.cardDimension.height));
    }

    public void loadCards(CardsView showCards, BigCard bigCard, UUID gameId) {
        this.reloaded = true;
        this.cardArea.removeAll();
        if (showCards != null && showCards.size() < 10) {
            this.yCardCaptionOffsetPercent = 8;
            this.loadCardsFew(showCards, bigCard, gameId);
        } else {
            this.yCardCaptionOffsetPercent = 0;
            this.loadCardsMany(showCards, bigCard, gameId);
        }
        this.redraw();
        this.fixDialogSize();
    }

    public void redraw() {
        this.cardArea.revalidate();
        this.revalidate();
        this.repaint();
    }

    public void loadCardsNarrow(CardsView showCards, BigCard bigCard, UUID gameId) {
        this.reloaded = true;
        this.cardArea.removeAll();
        this.yCardCaptionOffsetPercent = 0;
        this.loadCardsMany(showCards, bigCard, gameId);
        this.cardArea.revalidate();
        this.revalidate();
        this.repaint();
        this.fixDialogSize();
    }

    private List<CardView> getSortedList(CardsView showCards) {
        return showCards.values().stream().sorted(Comparator.comparing(CardView::getName)).collect(Collectors.toList());
    }

    private void loadCardsFew(CardsView showCards, BigCard bigCard, UUID gameId) {
        Rectangle rectangle = new Rectangle(this.cardDimension.width, this.cardDimension.height);
        int cardsAdded = 0;
        for (CardView card : this.getSortedList(showCards)) {
            if (cardsAdded > 0) {
                rectangle.translate(this.cardDimension.width + this.xOffsetBetweenCardsOrColumns, 0);
            }
            this.addCard(card, bigCard, gameId, rectangle);
            ++cardsAdded;
        }
        this.cardArea.setPreferredSize(new Dimension(this.cardDimension.width * showCards.size() + cardsAdded * this.xOffsetBetweenCardsOrColumns, this.cardDimension.height + this.verticalCardOffset));
    }

    private void addCard(CardView card, BigCard bigCard, UUID gameId, Rectangle rectangle) {
        if (card instanceof AbilityView) {
            CardView tmp = ((AbilityView)card).getSourceCard();
            tmp.overrideRules(card.getRules());
            tmp.setIsAbility(true);
            tmp.overrideTargets(card.getTargets());
            tmp.setAbility(card);
            card = tmp;
        }
        CardIconRenderSettings currentIconsRender = this.customRenderMode >= 0 ? new CardIconRenderSettings().withDebugMode(true).withCustomPosition(this.customCardIconPosition).withCustomOrder(this.customCardIconOrder).withCustomColor(this.customCardIconColor).withCustomMaxVisibleCount(this.customCardIconsMaxVisibleCount).withCustomIconSizePercent(30) : new CardIconRenderSettings();
        MageCard cardPanel = Plugins.instance.getMageCard(card, bigCard, currentIconsRender, this.cardDimension, gameId, true, true, this.customRenderMode != -1 ? this.customRenderMode : PreferencesDialog.getRenderMode(), this.customNeedFullPermanentRender);
        cardPanel.setCardContainerRef((Container)this);
        cardPanel.update(card);
        cardPanel.setCardBounds(rectangle.x, rectangle.y, this.cardDimension.width, this.cardDimension.height);
        this.cardArea.add((Component)cardPanel);
        this.cardArea.moveToFront((Component)cardPanel);
        cardPanel.setCardCaptionTopOffset(this.yCardCaptionOffsetPercent);
        cardPanel.showCardTitle();
    }

    private void loadCardsMany(CardsView showCards, BigCard bigCard, UUID gameId) {
        int columns = 1;
        if (showCards != null && !showCards.isEmpty()) {
            Rectangle rectangle = new Rectangle(this.cardDimension.width, this.cardDimension.height);
            int count = 0;
            for (CardView card : this.getSortedList(showCards)) {
                this.addCard(card, bigCard, gameId, rectangle);
                if (count >= 20) {
                    rectangle.translate(this.cardDimension.width + this.xOffsetBetweenCardsOrColumns, -(20 * this.verticalCardOffset));
                    ++columns;
                    count = 0;
                    continue;
                }
                rectangle.translate(0, this.verticalCardOffset);
                ++count;
            }
        }
        this.cardArea.setPreferredSize(new Dimension(this.cardDimension.width * columns + this.xOffsetBetweenCardsOrColumns * (columns - 1), this.cardDimension.height + 20 * this.verticalCardOffset));
    }

    public boolean isReloaded() {
        return this.reloaded;
    }

    public void clearReloaded() {
        this.reloaded = false;
    }

    public void selectCards(Set<UUID> selected) {
        for (Component component : this.cardArea.getComponents()) {
            MageCard mageCard;
            if (!(component instanceof MageCard) || !selected.contains((mageCard = (MageCard)component).getOriginal().getId())) continue;
            mageCard.setSelected(true);
        }
    }

    public void markCards(Set<UUID> marked) {
        for (Component component : this.cardArea.getComponents()) {
            MageCard mageCard;
            if (!(component instanceof MageCard) || !marked.contains((mageCard = (MageCard)component).getOriginal().getId())) continue;
            mageCard.setChoosable(true);
        }
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        for (Component component : this.cardArea.getComponents()) {
            if (!(component instanceof MageCard)) continue;
            MageCard mageCard = (MageCard)component;
            mageCard.setPopupMenu(popupMenu);
        }
    }

    public void addCardEventListener(Listener<Event> listener) {
        this.cardEventSource.addListener(listener);
    }

    public void clearCardEventListeners() {
        this.cardEventSource.clearListeners();
    }

    public void setCustomRenderMode(int customRenderMode) {
        this.customRenderMode = customRenderMode;
    }

    public void setCustomNeedFullPermanentRender(boolean customNeedFullPermanentRender) {
        this.customNeedFullPermanentRender = customNeedFullPermanentRender;
    }

    public void setCustomCardSize(Dimension customCardSize) {
        this.customCardSize = customCardSize;
    }

    public void setCustomXOffsetBetweenCardsOrColumns(int customXOffsetBetweenCardsOrColumns) {
        this.customXOffsetBetweenCardsOrColumns = customXOffsetBetweenCardsOrColumns;
    }

    public void setCustomCardIconsPanelPosition(CardIconPosition panelPosition) {
        this.customCardIconPosition = panelPosition;
    }

    public void setCustomCardIconsPanelOrder(CardIconOrder panelOrder) {
        this.customCardIconOrder = panelOrder;
    }

    public void setCustomCardIconsPanelColor(CardIconColor cardIconColor) {
        this.customCardIconColor = cardIconColor;
    }

    public void setCustomCardIconsMaxVisibleCount(int maxVisibleCount) {
        this.customCardIconsMaxVisibleCount = maxVisibleCount;
    }

    @Override
    public CardEventSource getCardEventSource() {
        return this.cardEventSource;
    }
}

