/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.client.MagePane;
import mage.client.cards.DragCardSource;
import mage.client.cards.DragCardTarget;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ClientDefaultSettings;
import mage.util.DebugUtil;
import mage.view.CardView;
import org.apache.log4j.Logger;

public class CardDraggerGlassPane {
    private static final Logger logger = Logger.getLogger(CardDraggerGlassPane.class);
    private final DragCardSource source;
    private DragCardTarget currentTarget;
    private MageCard draggingCard;
    private ArrayList<CardView> currentCards;
    private JComponent draggingGlassPane;
    private MageCard draggingDrawView;
    private MouseListener draggingMouseListener;
    private MouseMotionListener draggingMouseMotionListener;
    private boolean isDragging;
    private Dimension cardDimension;
    private MagePane eventRootPane;

    public CardDraggerGlassPane(DragCardSource source) {
        this.source = source;
    }

    public void handleDragStart(MageCard card, MouseEvent cardEvent) {
        Object rootMagePane;
        if (this.isDragging) {
            return;
        }
        this.isDragging = true;
        this.draggingCard = card;
        JRootPane currentRoot = SwingUtilities.getRootPane((Component)this.draggingCard);
        this.draggingGlassPane = (JComponent)currentRoot.getGlassPane();
        this.draggingGlassPane.setLayout(null);
        this.draggingGlassPane.setOpaque(false);
        this.draggingGlassPane.setVisible(true);
        if (DebugUtil.GUI_DECK_EDITOR_DRAW_DRAGGING_PANE_BORDER) {
            this.draggingGlassPane.setBorder(BorderFactory.createLineBorder(Color.MAGENTA));
        }
        for (rootMagePane = this.draggingCard; rootMagePane != null && !(rootMagePane instanceof MagePane); rootMagePane = rootMagePane.getParent()) {
        }
        if (rootMagePane == null) {
            throw new RuntimeException("CardDraggerGlassPane::beginDrag not in a MagePane?");
        }
        this.eventRootPane = (MagePane)rootMagePane;
        if (this.draggingMouseMotionListener == null) {
            this.draggingMouseMotionListener = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    CardDraggerGlassPane.this.handleDragging(e);
                }
            };
        }
        if (this.draggingMouseListener == null) {
            this.draggingMouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    CardDraggerGlassPane.this.handleDragEnd(e);
                }
            };
        }
        this.draggingCard.addMouseMotionListener(this.draggingMouseMotionListener);
        this.draggingCard.addMouseListener(this.draggingMouseListener);
        MouseEvent glassEvent = SwingUtilities.convertMouseEvent((Component)this.draggingCard.getMainPanel(), cardEvent, this.draggingGlassPane);
        this.currentCards = new ArrayList<CardView>(this.source.dragCardList());
        Rectangle rectangle = new Rectangle(glassEvent.getX(), glassEvent.getY(), this.getCardDimension().width, this.getCardDimension().height);
        this.draggingDrawView = Plugins.instance.getMageCard(this.currentCards.get(0), null, new CardIconRenderSettings(), this.getCardDimension(), null, true, false, PreferencesDialog.getRenderMode(), true);
        this.draggingDrawView.setCardContainerRef(null);
        this.draggingDrawView.update(this.currentCards.get(0));
        this.draggingDrawView.setCardBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (MouseListener mouseListener : this.draggingDrawView.getMouseListeners()) {
            this.draggingDrawView.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : this.draggingDrawView.getMouseMotionListeners()) {
            this.draggingDrawView.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        this.draggingGlassPane.add((Component)this.draggingDrawView);
        this.source.dragCardBegin();
        this.currentTarget = null;
        MouseEvent rootEvent = SwingUtilities.convertMouseEvent(this.draggingGlassPane, glassEvent, this.eventRootPane);
        this.updateCurrentTarget(rootEvent, false);
    }

    private void handleDragging(MouseEvent e) {
        MouseEvent glassEvent = SwingUtilities.convertMouseEvent((Component)this.draggingCard.getMainPanel(), e, this.draggingGlassPane);
        this.draggingDrawView.setCardLocation(glassEvent.getX(), glassEvent.getY());
        this.draggingDrawView.repaint();
        MouseEvent rootEvent = SwingUtilities.convertMouseEvent((Component)this.draggingCard.getMainPanel(), e, this.eventRootPane);
        this.updateCurrentTarget(rootEvent, false);
    }

    private void handleDragEnd(MouseEvent e) {
        this.isDragging = false;
        this.draggingCard.removeMouseListener(this.draggingMouseListener);
        this.draggingCard.removeMouseMotionListener(this.draggingMouseMotionListener);
        MouseEvent rootEvent = SwingUtilities.convertMouseEvent((Component)this.draggingCard.getMainPanel(), e, this.eventRootPane);
        this.draggingGlassPane.remove((Component)this.draggingDrawView);
        this.draggingGlassPane.repaint();
        this.source.dragCardEnd(this.currentTarget);
        this.updateCurrentTarget(rootEvent, true);
    }

    private void updateCurrentTarget(MouseEvent rootEvent, boolean isEnding) {
        for (Component mouseOver = SwingUtilities.getDeepestComponentAt(this.eventRootPane, rootEvent.getX(), rootEvent.getY()); mouseOver != null; mouseOver = mouseOver.getParent()) {
            if (!(mouseOver instanceof DragCardTarget)) continue;
            DragCardTarget target = (DragCardTarget)((Object)mouseOver);
            MouseEvent targetEvent = SwingUtilities.convertMouseEvent(this.eventRootPane, rootEvent, mouseOver);
            if (target != this.currentTarget) {
                if (this.currentTarget != null) {
                    MouseEvent oldTargetEvent = SwingUtilities.convertMouseEvent(this.eventRootPane, rootEvent, (Component)((Object)this.currentTarget));
                    this.currentTarget.dragCardExit(oldTargetEvent);
                }
                this.currentTarget = target;
                this.currentTarget.dragCardEnter(targetEvent);
            }
            if (isEnding) {
                this.currentTarget.dragCardExit(targetEvent);
                this.currentTarget.dragCardDrop(targetEvent, this.source, this.currentCards);
            } else {
                this.currentTarget.dragCardMove(targetEvent);
            }
            return;
        }
        if (this.currentTarget != null) {
            MouseEvent oldTargetEvent = SwingUtilities.convertMouseEvent(this.eventRootPane, rootEvent, (Component)((Object)this.currentTarget));
            this.currentTarget.dragCardExit(oldTargetEvent);
        }
        this.currentTarget = null;
    }

    protected Dimension getCardDimension() {
        if (this.cardDimension == null) {
            this.cardDimension = new Dimension(ClientDefaultSettings.dimensions.getFrameWidth(), ClientDefaultSettings.dimensions.getFrameHeight());
        }
        return this.cardDimension;
    }

    public boolean isDragging() {
        return this.isDragging;
    }
}

