/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.client.cards.BigCard;
import mage.client.cards.CardEventProducer;
import mage.client.cards.CardEventSource;
import mage.client.cards.DragCardGrid;
import mage.client.cards.ICardGrid;
import mage.client.deckeditor.SortSetting;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.Event;
import mage.client.util.GUISizeHelper;
import mage.client.util.Listener;
import mage.client.util.comparators.CardViewCardTypeComparator;
import mage.client.util.comparators.CardViewColorComparator;
import mage.client.util.comparators.CardViewColorIdentityComparator;
import mage.client.util.comparators.CardViewComparator;
import mage.client.util.comparators.CardViewCostComparator;
import mage.client.util.comparators.CardViewEDHPowerLevelComparator;
import mage.client.util.comparators.CardViewNameComparator;
import mage.client.util.comparators.CardViewNoneComparator;
import mage.client.util.comparators.CardViewRarityComparator;
import mage.view.CardView;
import mage.view.CardsView;

public class CardGrid
extends JLayeredPane
implements CardEventProducer,
ICardGrid {
    protected final CardEventSource cardEventSource = new CardEventSource();
    protected BigCard bigCard;
    protected UUID gameId;
    private final Map<UUID, MageCard> cards = new HashMap<UUID, MageCard>();
    private Dimension cardDimension;
    private final List<JLabel> countLabels = new ArrayList<JLabel>();
    public static final int MAX_IMAGES = 350;

    public CardGrid() {
        this.initComponents();
        this.setGUISize();
        this.setOpaque(false);
    }

    public void clear() {
        for (MouseListener ml : this.getMouseListeners()) {
            this.removeMouseListener(ml);
        }
        this.clearCardEventListeners();
        this.clearCards();
        this.bigCard = null;
    }

    public void changeGUISize() {
        this.setGUISize();
    }

    private void setGUISize() {
        Font countLabelFont = DragCardGrid.getCountLabelFont();
        this.countLabels.stream().forEach(label -> label.setFont(countLabelFont));
        this.cardDimension = GUISizeHelper.editorCardDimension;
    }

    @Override
    public Object getCardsStore() {
        return this.cards;
    }

    @Override
    public void clearCardsStoreBeforeUpdate() {
        this.cards.clear();
    }

    @Override
    public void loadCards(CardsView showCards, SortSetting sortSetting, BigCard bigCard, UUID gameId) {
        this.loadCards(showCards, sortSetting, bigCard, gameId, true);
    }

    @Override
    public void loadCards(CardsView showCards, SortSetting sortSetting, BigCard bigCard, UUID gameId, boolean merge) {
        boolean drawImage = showCards.size() <= 350;
        this.bigCard = bigCard;
        this.gameId = gameId;
        if (merge) {
            for (CardView card : showCards.values()) {
                if (this.cards.containsKey(card.getId())) continue;
                this.addCard(card, bigCard, gameId, drawImage);
            }
            Iterator<Map.Entry<UUID, MageCard>> i = this.cards.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<UUID, MageCard> entry = i.next();
                if (showCards.containsKey((Object)entry.getKey())) continue;
                this.removeCardImg(entry.getKey());
                i.remove();
            }
        } else {
            this.clearCards();
            for (CardView card : showCards.values()) {
                this.addCard(card, bigCard, gameId, drawImage);
            }
        }
        this.drawCards(sortSetting);
        this.setVisible(true);
    }

    private void addCard(CardView card, BigCard bigCard, UUID gameId, boolean drawImage) {
        MageCard cardImg = Plugins.instance.getMageCard(card, bigCard, new CardIconRenderSettings(), this.cardDimension, gameId, drawImage, true, PreferencesDialog.getRenderMode(), true);
        cardImg.setCardContainerRef((Container)this);
        cardImg.update(card);
        this.cards.put(card.getId(), cardImg);
        this.add((Component)cardImg, (Object)10);
    }

    @Override
    public void drawCards(SortSetting sortSetting) {
        this.countLabels.forEach(this::remove);
        this.countLabels.clear();
        int maxWidth = this.getParent().getWidth();
        int vertOffsetPerCardInStack = GUISizeHelper.editorCardVertOffsetInStack;
        int numColumns = maxWidth / this.cardDimension.width;
        int curColumn = 0;
        int curRow = 0;
        if (!this.cards.isEmpty()) {
            CardViewComparator comparator;
            Rectangle rectangle = new Rectangle(this.cardDimension.width, this.cardDimension.height);
            List sortedCards = this.cards.values().stream().map(MageCard::getOriginal).collect(Collectors.toList());
            switch (sortSetting.getSortBy()) {
                case NAME: {
                    comparator = new CardViewNameComparator();
                    break;
                }
                case CARD_TYPE: {
                    comparator = new CardViewCardTypeComparator();
                    break;
                }
                case RARITY: {
                    comparator = new CardViewRarityComparator();
                    break;
                }
                case COLOR: {
                    comparator = new CardViewColorComparator();
                    break;
                }
                case COLOR_IDENTITY: {
                    comparator = new CardViewColorIdentityComparator();
                    break;
                }
                case CASTING_COST: {
                    comparator = new CardViewCostComparator();
                    break;
                }
                case UNSORTED: {
                    comparator = new CardViewNoneComparator();
                    break;
                }
                case EDH_POWER_LEVEL: {
                    comparator = new CardViewEDHPowerLevelComparator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error, unknown sort settings in deck editor: " + (Object)((Object)sortSetting.getSortBy()));
                }
            }
            sortedCards.sort(new CardViewNameComparator());
            sortedCards.sort(comparator);
            MageCard lastCard = null;
            JLabel lastCountLabel = null;
            for (CardView sortedCard : sortedCards) {
                MageCard currentCard = this.cards.get(sortedCard.getId());
                if (sortSetting.isPilesToggle()) {
                    if (lastCard == null) {
                        lastCard = currentCard;
                        lastCountLabel = this.addNewCountLabel(curColumn);
                    }
                    if (comparator.compare(currentCard.getOriginal(), lastCard.getOriginal()) != 0) {
                        curRow = 0;
                        lastCountLabel = this.addNewCountLabel(++curColumn);
                    }
                    String description = comparator.getCategoryName(currentCard.getOriginal());
                    DragCardGrid.updateCountLabel(lastCountLabel, curRow + 1, description);
                    rectangle.setLocation(curColumn * this.cardDimension.width, curRow * vertOffsetPerCardInStack + DragCardGrid.getCountLabelHeight());
                    currentCard.setCardBounds(rectangle.x, rectangle.y, this.cardDimension.width, this.cardDimension.height);
                    this.moveToFront((Component)currentCard);
                    ++curRow;
                    lastCard = currentCard;
                    continue;
                }
                rectangle.setLocation(curColumn * this.cardDimension.width, curRow * vertOffsetPerCardInStack);
                currentCard.setCardBounds(rectangle.x, rectangle.y, this.cardDimension.width, this.cardDimension.height);
                this.moveToFront((Component)currentCard);
                if (++curColumn != numColumns) continue;
                curColumn = 0;
                ++curRow;
            }
        }
        this.resizeArea();
        this.revalidate();
        this.repaint();
    }

    private JLabel addNewCountLabel(int columnNumber) {
        JLabel label = DragCardGrid.createCountLabel(null);
        this.countLabels.add(label);
        this.add((Component)label, (Object)0);
        label.setLocation(columnNumber * this.cardDimension.width, 5);
        label.setSize(this.cardDimension.width, DragCardGrid.getCountLabelHeight());
        label.setVisible(true);
        return label;
    }

    private void clearCards() {
        for (MageCard mageCard : this.cards.values()) {
            mageCard.cleanUp();
        }
        this.cards.clear();
        this.removeAllCardImg();
    }

    private void removeAllCardImg() {
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof MageCard)) continue;
            this.remove(comp);
        }
    }

    private void removeCardImg(UUID cardId) {
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof MageCard) || !((MageCard)comp).getOriginal().getId().equals(cardId)) continue;
            this.remove(comp);
        }
    }

    public void removeCard(UUID cardId) {
        this.removeCardImg(cardId);
        this.cards.remove(cardId);
    }

    @Override
    public void addCardEventListener(Listener<Event> listener) {
        this.cardEventSource.addListener(listener);
    }

    @Override
    public void clearCardEventListeners() {
        this.cardEventSource.clearListeners();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 294, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 197, Short.MAX_VALUE));
    }

    @Override
    public CardEventSource getCardEventSource() {
        return this.cardEventSource;
    }

    private void resizeArea() {
        Dimension area = new Dimension(0, 0);
        Dimension size = this.getPreferredSize();
        for (Component comp : this.getComponents()) {
            Rectangle r = comp.getBounds();
            if (r.x + r.width > area.width) {
                area.width = r.x + r.width;
            }
            if (r.y + r.height <= area.height) continue;
            area.height = r.y + r.height;
        }
        if (size.height != area.height || size.width != area.width) {
            this.setPreferredSize(area);
        }
    }

    @Override
    public void refresh() {
        this.revalidate();
        this.repaint();
    }

    @Override
    public int cardsSize() {
        return this.cards.size();
    }
}

