/*
 * Decompiled with CFR 0.152.
 */
package mage.client.cards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.client.cards.BigCard;
import mage.client.cards.CardEventProducer;
import mage.client.cards.CardEventSource;
import mage.client.cards.DragCardGrid;
import mage.client.cards.ICardGrid;
import mage.client.constants.Constants;
import mage.client.deckeditor.SortSetting;
import mage.client.deckeditor.table.TableModel;
import mage.client.deckeditor.table.UpdateCountsCallback;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ClientEventType;
import mage.client.util.Event;
import mage.client.util.GUISizeHelper;
import mage.client.util.Listener;
import mage.client.util.comparators.CardViewCardTypeComparator;
import mage.client.util.comparators.CardViewColorComparator;
import mage.client.util.comparators.CardViewColorIdentityComparator;
import mage.client.util.comparators.CardViewComparator;
import mage.client.util.comparators.CardViewCostComparator;
import mage.client.util.comparators.CardViewEDHPowerLevelComparator;
import mage.client.util.comparators.CardViewNameComparator;
import mage.client.util.comparators.CardViewNoneComparator;
import mage.client.util.comparators.CardViewRarityComparator;
import mage.client.util.gui.TableSpinnerEditor;
import mage.view.CardView;
import mage.view.CardsView;
import org.mage.card.arcane.ManaSymbolsCellRenderer;

public class CardsList
extends JPanel
implements ICardGrid,
CardEventProducer {
    protected final CardEventSource cardEventSource = new CardEventSource();
    private Dimension cardDimension;
    private final List<JLabel> countLabels = new ArrayList<JLabel>();
    private int cardOffsetInStack;
    private CardsView cards;
    private Map<UUID, MageCard> mageCards = new LinkedHashMap<UUID, MageCard>();
    protected BigCard bigCard;
    protected UUID gameId;
    private SortSetting sortSetting;
    private TableModel mainModel;
    private JTable mainTable;
    private ICardGrid currentView;
    private boolean isLoading;
    private ButtonGroup bgView;
    private JLayeredPane cardArea;
    private JComboBox cbSortBy;
    private JCheckBox chkPiles;
    private JToggleButton jToggleCardView;
    private JToggleButton jToggleListView;
    private JLabel lblCount;
    private JLabel lblCreatureCount;
    private JLabel lblLandCount;
    private JScrollPane panelCardArea;
    private JPanel panelControl;

    public CardsList() {
        this.initComponents();
        this.makeTransparent();
        this.initListViewComponents();
        this.setGUISize();
    }

    public void cleanUp() {
        this.clearCardEventListeners();
        if (this.cards != null) {
            this.cards.clear();
        }
        if (this.mainModel != null) {
            this.mainModel.removeTableModelListener(this.mainTable);
            this.mainModel.clear();
        }
        if (this.cardArea != null) {
            for (MouseListener mouseListener : this.cardArea.getMouseListeners()) {
                this.cardArea.removeMouseListener(mouseListener);
            }
            for (Component component : this.cardArea.getComponents()) {
                if (!(component instanceof MageCard)) continue;
                ((MageCard)component).cleanUp();
            }
            this.cardArea.removeAll();
        }
        if (this.mainTable != null) {
            for (MouseListener mouseListener : this.mainTable.getMouseListeners()) {
                this.mainTable.removeMouseListener(mouseListener);
            }
        }
        if (this.currentView != null) {
            this.currentView.clearCardEventListeners();
        }
        this.mageCards.clear();
        this.bigCard = null;
    }

    public void changeGUISize() {
        this.setGUISize();
        this.redrawCards();
    }

    private void setGUISize() {
        this.mainTable.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.mainTable.setFont(GUISizeHelper.tableFont);
        this.mainTable.setRowHeight(GUISizeHelper.tableRowHeight);
        this.cardDimension = GUISizeHelper.editorCardDimension;
        this.cardOffsetInStack = GUISizeHelper.editorCardVertOffsetInStack;
    }

    private void makeTransparent() {
        this.panelCardArea.setOpaque(false);
        this.cardArea.setOpaque(false);
        this.panelCardArea.getViewport().setOpaque(false);
        this.panelControl.setBackground(PreferencesDialog.getCurrentTheme().getDeckEditorToolbarBackgroundColor());
        this.panelControl.setOpaque(true);
        this.cbSortBy.setModel(new DefaultComboBoxModel<Constants.SortBy>(Constants.SortBy.values()));
    }

    private void initListViewComponents() {
        this.mainTable = new JTable();
        this.mainModel = new TableModel();
        this.mainModel.addListeners(this.mainTable);
        this.mainTable.setModel(this.mainModel);
        this.mainTable.setForeground(Color.white);
        DefaultTableCellRenderer myRenderer = (DefaultTableCellRenderer)this.mainTable.getDefaultRenderer(String.class);
        myRenderer.setBackground(new Color(0, 0, 0, 100));
        this.mainTable.getColumnModel().getColumn(0).setMaxWidth(25);
        this.mainTable.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.mainTable.getColumnModel().getColumn(1).setPreferredWidth(110);
        this.mainTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.mainTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.mainTable.getColumnModel().getColumn(4).setPreferredWidth(170);
        this.mainTable.getColumnModel().getColumn(5).setPreferredWidth(30);
        this.mainTable.getColumnModel().getColumn(6).setPreferredWidth(15);
        this.mainTable.getColumnModel().getColumn(7).setPreferredWidth(15);
        this.mainTable.getColumnModel().getColumn(this.mainModel.COLUMN_INDEX_COST).setCellRenderer(new ManaSymbolsCellRenderer());
        this.mainTable.getColumnModel().getColumn(this.mainModel.COLUMN_INDEX_COLOR_IDENTITY).setCellRenderer(new ManaSymbolsCellRenderer());
        if (PreferencesDialog.getCachedValue("draftView", "cardView").equals("listView")) {
            this.jToggleListView.setSelected(true);
            this.panelCardArea.setViewportView(this.mainTable);
            this.currentView = this.mainModel;
            this.cbSortBy.setEnabled(false);
            this.chkPiles.setEnabled(false);
        } else {
            this.jToggleCardView.setSelected(true);
            this.currentView = this;
            this.panelCardArea.setViewportView(this.cardArea);
            this.cbSortBy.setEnabled(true);
            this.chkPiles.setEnabled(true);
        }
        this.mainTable.setOpaque(false);
        this.mainTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if ((e.getClickCount() & 1) == 0 && e.getClickCount() > 0 && !e.isConsumed()) {
                    e.consume();
                    CardsList.this.handleTableDoubleClick(e);
                }
            }
        });
        this.mainModel.setUpdateCountsCallback(new UpdateCountsCallback(this.lblCount, this.lblCreatureCount, this.lblLandCount, null, null, null, null));
        this.cardArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    CardsList.this.cardEventSource.fireEvent(null, e.getComponent(), e.getX(), e.getY(), ClientEventType.CARD_POPUP_MENU);
                }
            }
        });
    }

    @Override
    public CardEventSource getCardEventSource() {
        return this.cardEventSource;
    }

    public void setDeckEditorMode(Constants.DeckEditorMode mode) {
        if (mode == Constants.DeckEditorMode.FREE_BUILDING) {
            this.mainModel.setNumberEditable(true);
            TableColumnModel tcm = this.mainTable.getColumnModel();
            TableColumn tc = tcm.getColumn(0);
            tc.setMaxWidth(55);
            tc.setMinWidth(55);
            tc.setPreferredWidth(55);
            tc.setCellEditor(new TableSpinnerEditor(this));
        }
    }

    public void handleSetNumber(int number) {
        if (this.mainTable.getSelectedRowCount() == 1) {
            this.mainModel.setNumber(this.mainTable.getSelectedRow(), number);
        }
    }

    public void handleTableDoubleClick(MouseEvent e) {
        if (this.mainTable.getSelectedRowCount() > 0) {
            int[] n = this.mainTable.getSelectedRows();
            List<Integer> indexes = this.asList(n);
            Collections.reverse(indexes);
            for (Integer index : indexes) {
                this.mainModel.doubleClick(index, e, false);
            }
        }
    }

    public ICardGrid getMainModel() {
        return this.mainModel;
    }

    public List<Integer> asList(int[] is) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : is) {
            list.add(i);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCards(CardsView showCards, BigCard bigCard, UUID gameId) {
        int selectedRow = -1;
        if (this.currentView.equals(this.mainModel)) {
            selectedRow = this.mainTable.getSelectedRow();
        }
        this.cards = showCards;
        this.bigCard = bigCard;
        this.gameId = gameId;
        this.isLoading = true;
        try {
            this.cbSortBy.setSelectedItem((Object)this.sortSetting.getSortBy());
            this.chkPiles.setSelected(this.sortSetting.isPilesToggle());
        }
        finally {
            this.isLoading = false;
        }
        this.currentView.loadCards(showCards, this.sortSetting, bigCard, gameId);
        if (selectedRow >= 0 && (selectedRow = Math.min(selectedRow, this.mainTable.getRowCount() - 1)) >= 0) {
            this.mainTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    private void redrawCards() {
        if (this.cards == null) {
            this.cards = new CardsView();
        }
        this.currentView.loadCards(this.cards, this.sortSetting, this.bigCard, this.gameId);
    }

    @Override
    public void drawCards(SortSetting sortSetting) {
        for (JLabel label : this.countLabels) {
            this.cardArea.remove(label);
        }
        this.countLabels.clear();
        int maxWidth = this.getParent().getWidth();
        int numColumns = maxWidth / this.cardDimension.width;
        int curColumn = 0;
        int curRow = 0;
        int maxRow = 0;
        int maxColumn = 0;
        CardViewComparator comparator = null;
        Map<UUID, MageCard> oldMageCards = this.mageCards;
        this.mageCards = new LinkedHashMap<UUID, MageCard>();
        for (Map.Entry view : this.cards.entrySet()) {
            UUID uuid = (UUID)view.getKey();
            CardView cardView = (CardView)view.getValue();
            if (oldMageCards.containsKey(uuid)) {
                this.mageCards.put(uuid, oldMageCards.get(uuid));
                oldMageCards.remove(uuid);
                continue;
            }
            this.mageCards.put(uuid, this.addCard(cardView, this.bigCard, this.gameId));
        }
        for (MageCard card : oldMageCards.values()) {
            this.cardArea.remove((Component)card);
        }
        if (this.cards != null && !this.cards.isEmpty()) {
            Rectangle rectangle = new Rectangle(this.cardDimension.width, this.cardDimension.height);
            ArrayList<CardView> sortedCards = new ArrayList<CardView>(this.cards.values());
            switch (sortSetting.getSortBy()) {
                case NAME: {
                    comparator = new CardViewNameComparator();
                    break;
                }
                case RARITY: {
                    comparator = new CardViewRarityComparator();
                    break;
                }
                case CARD_TYPE: {
                    comparator = new CardViewCardTypeComparator();
                    break;
                }
                case COLOR: {
                    comparator = new CardViewColorComparator();
                    break;
                }
                case COLOR_IDENTITY: {
                    comparator = new CardViewColorIdentityComparator();
                    break;
                }
                case CASTING_COST: {
                    comparator = new CardViewCostComparator();
                    break;
                }
                case UNSORTED: {
                    comparator = new CardViewNoneComparator();
                    break;
                }
                case EDH_POWER_LEVEL: {
                    comparator = new CardViewEDHPowerLevelComparator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error, unknown sort settings in deck editor: " + (Object)((Object)sortSetting.getSortBy()));
                }
            }
            sortedCards.sort(new CardViewNameComparator());
            sortedCards.sort(comparator);
            CardView lastCard = null;
            JLabel lastCountLabel = null;
            for (CardView card : sortedCards) {
                if (sortSetting.isPilesToggle()) {
                    if (lastCard == null) {
                        lastCard = card;
                        lastCountLabel = this.addNewCountLabel(curColumn);
                    }
                    if (comparator.compare(card, lastCard) != 0) {
                        maxRow = Math.max(maxRow, curRow);
                        curRow = 0;
                        lastCountLabel = this.addNewCountLabel(++curColumn);
                    }
                    String description = comparator.getCategoryName(card);
                    DragCardGrid.updateCountLabel(lastCountLabel, curRow + 1, description);
                    rectangle.setLocation(curColumn * this.cardDimension.width, curRow * this.cardOffsetInStack + DragCardGrid.getCountLabelHeight());
                    this.setCardBounds(this.mageCards.get(card.getId()), rectangle);
                    ++curRow;
                    lastCard = card;
                    continue;
                }
                rectangle.setLocation(curColumn * this.cardDimension.width, curRow * this.cardOffsetInStack);
                this.setCardBounds(this.mageCards.get(card.getId()), rectangle);
                if (++curColumn != numColumns) continue;
                maxColumn = Math.max(maxColumn, curColumn);
                curColumn = 0;
                ++curRow;
            }
        }
        maxRow = Math.max(maxRow, curRow);
        maxColumn = Math.max(maxColumn, curColumn);
        this.updateCounts();
        this.cardArea.setPreferredSize(new Dimension((maxColumn + 1) * this.cardDimension.width, this.cardDimension.height + maxRow * this.cardOffsetInStack));
        this.cardArea.revalidate();
        this.revalidate();
        this.repaint();
        this.setVisible(true);
    }

    private JLabel addNewCountLabel(int columnNumber) {
        JLabel label = DragCardGrid.createCountLabel(null);
        this.countLabels.add(label);
        this.cardArea.add((Component)label, (Object)0);
        label.setLocation(columnNumber * this.cardDimension.width, 5);
        label.setSize(this.cardDimension.width, DragCardGrid.getCountLabelHeight());
        label.setVisible(true);
        return label;
    }

    private void updateCounts() {
        int landCount = 0;
        int creatureCount = 0;
        int sorceryCount = 0;
        int instantCount = 0;
        int enchantmentCount = 0;
        int artifactCount = 0;
        for (CardView card : this.cards.values()) {
            if (card.isLand()) {
                ++landCount;
            }
            if (card.isCreature()) {
                ++creatureCount;
            }
            if (card.isSorcery()) {
                ++sorceryCount;
            }
            if (card.isInstant()) {
                ++instantCount;
            }
            if (card.isEnchantment()) {
                ++enchantmentCount;
            }
            if (!card.isArtifact()) continue;
            ++artifactCount;
        }
        int count = this.cards != null ? this.cards.size() : 0;
        this.lblCount.setText(Integer.toString(count));
        this.lblCreatureCount.setText(Integer.toString(creatureCount));
        this.lblLandCount.setText(Integer.toString(landCount));
    }

    private MageCard addCard(CardView card, BigCard bigCard, UUID gameId) {
        MageCard cardImg = Plugins.instance.getMageCard(card, bigCard, new CardIconRenderSettings(), this.cardDimension, gameId, true, true, PreferencesDialog.getRenderMode(), true);
        cardImg.setCardContainerRef((Container)this);
        cardImg.update(card);
        this.cardArea.add((Component)cardImg, (Object)10);
        return cardImg;
    }

    private void setCardBounds(MageCard card, Rectangle rectangle) {
        card.setCardBounds(rectangle.x, rectangle.y, this.cardDimension.width, this.cardDimension.height);
        this.cardArea.moveToFront((Component)card);
    }

    @Override
    public void addCardEventListener(Listener<Event> listener) {
        this.cardEventSource.addListener(listener);
        this.mainModel.addCardEventListener(listener);
    }

    @Override
    public Object getCardsStore() {
        return this.cards;
    }

    @Override
    public void clearCardsStoreBeforeUpdate() {
        this.cards.clear();
        this.mageCards.clear();
    }

    @Override
    public void loadCards(CardsView showCards, SortSetting sortSetting, BigCard bigCard, UUID gameId) {
        this.loadCards(showCards, sortSetting, bigCard, gameId, true);
    }

    @Override
    public void loadCards(CardsView showCards, SortSetting sortSetting, BigCard bigCard, UUID gameId, boolean merge) {
        this.cards = showCards;
        this.bigCard = bigCard;
        this.gameId = gameId;
        this.drawCards(sortSetting);
    }

    @Override
    public void refresh() {
        this.redrawCards();
    }

    @Override
    public void clearCardEventListeners() {
        this.cardEventSource.clearListeners();
        this.mainModel.clearCardEventListeners();
    }

    private void initComponents() {
        this.bgView = new ButtonGroup();
        this.panelControl = new JPanel();
        this.lblCount = new JLabel();
        this.lblLandCount = new JLabel();
        this.lblCreatureCount = new JLabel();
        this.chkPiles = new JCheckBox();
        this.cbSortBy = new JComboBox();
        this.jToggleListView = new JToggleButton();
        this.jToggleCardView = new JToggleButton();
        this.panelCardArea = new JScrollPane();
        this.cardArea = new JLayeredPane();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setMinimumSize(new Dimension(30, 30));
        this.setPreferredSize(!Beans.isDesignTime() ? GUISizeHelper.editorCardDimension : new Dimension(600, 600));
        this.setRequestFocusEnabled(false);
        this.panelControl.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.panelControl.setMinimumSize(new Dimension(616, 23));
        this.panelControl.setName("");
        this.panelControl.setPreferredSize(new Dimension(616, 23));
        this.panelControl.setRequestFocusEnabled(false);
        this.lblCount.setIcon(new ImageIcon(this.getClass().getResource("/buttons/deck_pack.png")));
        this.lblCount.setText("999");
        this.lblCount.setToolTipText("Number of all cards in this area.");
        this.lblCount.setCursor(new Cursor(0));
        this.lblCount.setFocusable(false);
        this.lblCount.setInheritsPopupMenu(false);
        this.lblCount.setRequestFocusEnabled(false);
        this.lblCount.setVerifyInputWhenFocusTarget(false);
        this.lblLandCount.setHorizontalAlignment(2);
        this.lblLandCount.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_land.png")));
        this.lblLandCount.setText("999");
        this.lblLandCount.setToolTipText("Number of lands.");
        this.lblLandCount.setVerticalAlignment(1);
        this.lblLandCount.setCursor(new Cursor(0));
        this.lblLandCount.setFocusable(false);
        this.lblLandCount.setInheritsPopupMenu(false);
        this.lblLandCount.setRequestFocusEnabled(false);
        this.lblLandCount.setVerifyInputWhenFocusTarget(false);
        this.lblCreatureCount.setHorizontalAlignment(2);
        this.lblCreatureCount.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_creatures.png")));
        this.lblCreatureCount.setText("999");
        this.lblCreatureCount.setToolTipText("Number of creatures.");
        this.lblCreatureCount.setVerticalAlignment(1);
        this.lblCreatureCount.setCursor(new Cursor(0));
        this.lblCreatureCount.setFocusable(false);
        this.lblCreatureCount.setInheritsPopupMenu(false);
        this.lblCreatureCount.setRequestFocusEnabled(false);
        this.lblCreatureCount.setVerifyInputWhenFocusTarget(false);
        this.chkPiles.setText("Piles");
        this.chkPiles.setHorizontalAlignment(2);
        this.chkPiles.setMargin(new Insets(3, 2, 2, 2));
        this.chkPiles.addActionListener(evt -> this.chkPilesActionPerformed(evt));
        this.cbSortBy.setModel(new DefaultComboBoxModel<String>(new String[]{"SortBy"}));
        this.cbSortBy.setToolTipText("Sort the cards if card view is active.");
        this.cbSortBy.setMaximumSize(new Dimension(120, 20));
        this.cbSortBy.setMinimumSize(new Dimension(120, 20));
        this.cbSortBy.setName("SortBy");
        this.cbSortBy.setOpaque(false);
        this.cbSortBy.setPreferredSize(new Dimension(120, 20));
        this.cbSortBy.addActionListener(evt -> this.cbSortByActionPerformed(evt));
        this.bgView.add(this.jToggleListView);
        this.jToggleListView.setIcon(new ImageIcon(this.getClass().getResource("/buttons/list_panel.png")));
        this.jToggleListView.setToolTipText("Shows the cards as a list.");
        this.jToggleListView.setBorder(null);
        this.jToggleListView.setHorizontalTextPosition(10);
        this.jToggleListView.setMargin(new Insets(2, 6, 2, 6));
        this.jToggleListView.setMaximumSize(new Dimension(37, 25));
        this.jToggleListView.setMinimumSize(new Dimension(37, 25));
        this.jToggleListView.setPreferredSize(new Dimension(44, 22));
        this.jToggleListView.addActionListener(evt -> this.jToggleListViewActionPerformed(evt));
        this.bgView.add(this.jToggleCardView);
        this.jToggleCardView.setIcon(new ImageIcon(this.getClass().getResource("/buttons/card_panel.png")));
        this.jToggleCardView.setToolTipText("Shows the card as images.");
        this.jToggleCardView.setHorizontalTextPosition(10);
        this.jToggleCardView.setMargin(new Insets(2, 6, 2, 6));
        this.jToggleCardView.setPreferredSize(new Dimension(40, 22));
        this.jToggleCardView.addActionListener(evt -> this.jToggleCardViewActionPerformed(evt));
        GroupLayout panelControlLayout = new GroupLayout(this.panelControl);
        this.panelControl.setLayout(panelControlLayout);
        panelControlLayout.setHorizontalGroup(panelControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelControlLayout.createSequentialGroup().addComponent(this.lblCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLandCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCreatureCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkPiles).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbSortBy, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToggleListView, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleCardView, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        panelControlLayout.setVerticalGroup(panelControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelControlLayout.createSequentialGroup().addGroup(panelControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelControlLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCount).addComponent(this.lblLandCount).addComponent(this.lblCreatureCount).addComponent(this.chkPiles)).addComponent(this.cbSortBy, -2, -1, -2).addComponent(this.jToggleListView, -2, -1, -2).addComponent(this.jToggleCardView, -2, -1, -2)).addGap(0, 0, 0)));
        this.jToggleListView.getAccessibleContext().setAccessibleDescription("Switch between image and table view.");
        this.panelCardArea.setBorder(BorderFactory.createBevelBorder(1));
        this.panelCardArea.setViewportView(this.cardArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelControl, -2, 467, Short.MAX_VALUE).addComponent(this.panelCardArea));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panelControl, -2, -1, -2).addGap(2, 2, 2).addComponent(this.panelCardArea, -1, 179, Short.MAX_VALUE)));
    }

    private void jToggleCardViewActionPerformed(ActionEvent evt) {
        this.currentView = this;
        this.panelCardArea.setViewportView(this.cardArea);
        this.cbSortBy.setEnabled(true);
        this.chkPiles.setEnabled(true);
        PreferencesDialog.saveValue("draftView", "cardView");
        this.redrawCards();
    }

    private void jToggleListViewActionPerformed(ActionEvent evt) {
        this.currentView = this.mainModel;
        this.panelCardArea.setViewportView(this.mainTable);
        this.cbSortBy.setEnabled(false);
        this.chkPiles.setEnabled(false);
        PreferencesDialog.saveValue("draftView", "listView");
        this.redrawCards();
    }

    private void cbSortByActionPerformed(ActionEvent evt) {
        if (!this.isLoading) {
            this.sortSetting.setSortBy((Constants.SortBy)((Object)this.cbSortBy.getSelectedItem()));
            this.drawCards(this.sortSetting);
        }
    }

    private void chkPilesActionPerformed(ActionEvent evt) {
        if (!this.isLoading) {
            this.sortSetting.setPilesToggle(this.chkPiles.isSelected());
            this.drawCards(this.sortSetting);
        }
    }

    public void setDisplayNoCopies(boolean value) {
        this.mainModel.setDisplayNoCopies(value);
    }

    @Override
    public int cardsSize() {
        return this.cards.size();
    }

    public void setSortBy(Constants.SortBy sortBy) {
        if (sortBy != null) {
            this.cbSortBy.setSelectedIndex(sortBy.ordinal());
        }
    }

    public void setSortSetting(SortSetting sortSetting) {
        this.sortSetting = sortSetting;
    }
}

