/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.cards.decks.Deck;
import mage.client.components.LegalityLabel;
import mage.client.util.GUISizeHelper;
import mage.deck.Commander;

public class EdhPowerLevelLegalityLabel
extends LegalityLabel {
    private final Commander commanderDeckType = new Commander();
    private final List<String> foundPowerCards = new ArrayList<String>();

    public EdhPowerLevelLegalityLabel() {
        super("EDH Power Level: ?", null);
        this.setPreferredSize(DIM_PREFERRED_3_OF_3);
    }

    @Override
    public List<String> selectCards() {
        return this.foundPowerCards;
    }

    @Override
    public void validateDeck(Deck deck) {
        ArrayList<String> foundInfo = new ArrayList<String>();
        int level = this.commanderDeckType.getEdhPowerLevel(deck, this.foundPowerCards, foundInfo);
        this.setText(String.format("EDH Power Level: %d", level));
        Pattern pattern = Pattern.compile("\\+(\\d+)");
        foundInfo.sort((o1, o2) -> {
            int score2;
            Matcher matcher = pattern.matcher((CharSequence)o1);
            int score1 = matcher.find() ? Integer.parseInt(matcher.group(1)) : 0;
            matcher = pattern.matcher((CharSequence)o2);
            int n = score2 = matcher.find() ? Integer.parseInt(matcher.group(1)) : 0;
            if (score1 != score2) {
                return Integer.compare(score2, score1);
            }
            return o1.compareTo((String)o2);
        });
        this.showStateInfo(this.formatCardsInfoTooltip(level, foundInfo));
    }

    private String formatCardsInfoTooltip(int level, List<String> foundInfo) {
        int infoFontSize = Math.round((float)GUISizeHelper.cardTooltipFont.getSize() * 0.6f);
        int maxLimit = 25;
        String extraInfo = this.foundPowerCards.size() <= maxLimit ? "" : String.format("<li style=\"margin-bottom: 2px;\">and %d more cards</li>", this.foundPowerCards.size() - maxLimit);
        return foundInfo.stream().limit(maxLimit).reduce("<html><body><p>EDH Power Level: <span style='color:#b8860b;font-weight:bold;'>" + level + "</span></p><br><u>Found <span style='font-weight:bold;'>" + this.foundPowerCards.size() + "</span> cards with power levels (click to select it)</u><br><ul style=\"font-size: " + infoFontSize + "px; width: " + 400 + "px; padding-left: 10px; margin: 0;\">", (str, info) -> str + String.format("<li style=\"margin-bottom: 2px;\">%s</li>", info), String::concat) + extraInfo + "</ul></body></html>";
    }
}

