/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ImageButton
extends JButton {
    private Image image;
    private String text;

    public ImageButton(String text, Image image) {
        super(new ImageIcon(image));
        this.image = image;
        this.text = text;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.text != null) {
            g.setColor(Color.GRAY);
            int dx = 15;
            int dy = 17;
            g.setColor(Color.WHITE);
            if (this.text.length() > 5) {
                g.drawString(this.text, 8, dy);
            } else {
                g.drawString(this.text, dx, dy);
            }
        }
    }

    public void setImage(Image src) {
        this.image = src;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.repaint();
    }
}

