/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import mage.client.dialog.PreferencesDialog;

public class KeyBindButton
extends JButton
implements ActionListener {
    private final PreferencesDialog preferences;
    private final String key;
    private PopupItem item;
    private JPopupMenu menu;
    private int keyCode;
    private int modifierCode;
    private String text;

    public KeyBindButton() {
        this((PreferencesDialog)null, (String)null);
    }

    public KeyBindButton(PreferencesDialog preferences, String key) {
        this.preferences = preferences;
        this.key = key;
        this.addActionListener(this);
        this.fixText();
    }

    private JPopupMenu createPopupMenu() {
        this.menu = new JPopupMenu();
        this.item = new PopupItem();
        this.menu.add(this.item);
        return this.menu;
    }

    private void applyNewKeycode(int code, int modifier) {
        this.preferences.getKeybindButtons().stream().filter(b -> b != this).filter(b -> b.keyCode == code && b.modifierCode == modifier).forEach(b -> {
            b.setKeyCode(0);
            b.setModifierCode(0);
        });
        this.setKeyCode(code);
        this.setModifierCode(modifier);
        this.menu.setVisible(false);
    }

    private void fixText() {
        if (this.keyCode == 0) {
            this.text = "<none>";
        } else {
            String codeStr = KeyEvent.getKeyText(this.keyCode);
            String modStr = KeyEvent.getKeyModifiersText(this.modifierCode);
            this.text = (modStr.isEmpty() ? "" : modStr + " + ") + codeStr;
        }
        this.repaint();
    }

    public void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
        switch (keyCode) {
            case 27: 
            case 32: {
                this.keyCode = 0;
            }
        }
        this.fixText();
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setModifierCode(int modifierCode) {
        this.modifierCode = modifierCode;
        if (modifierCode != 8 && modifierCode != 2 && modifierCode != 1) {
            this.modifierCode = 0;
        }
        this.fixText();
    }

    public int getModifierCode() {
        return this.modifierCode;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPopupMenu m = this.createPopupMenu();
        m.setPopupSize(this.getWidth(), this.getHeight());
        m.show(this, 0, 0);
        this.item.requestFocusInWindow();
    }

    private class PopupItem
    extends JLabel
    implements KeyListener {
        public PopupItem() {
            super("Press a key");
            this.addKeyListener(this);
            this.setFocusable(true);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                KeyBindButton.this.menu.setVisible(false);
                return;
            }
            if (e.getKeyCode() == 32) {
                KeyBindButton.this.setKeyCode(0);
                KeyBindButton.this.setModifierCode(0);
                KeyBindButton.this.menu.setVisible(false);
                return;
            }
            switch (e.getModifiers()) {
                case 0: 
                case 1: 
                case 2: 
                case 8: {
                    break;
                }
                default: {
                    return;
                }
            }
            switch (e.getKeyCode()) {
                case 16: 
                case 17: 
                case 18: {
                    return;
                }
            }
            KeyBindButton.this.applyNewKeycode(e.getKeyCode(), e.getModifiers());
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

