/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JButton;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.GUISizeHelper;

public class KeyboundButton
extends JButton {
    private float guiScale = 1.0f;
    private final String key;
    private boolean showKey;
    private String drawingText;
    private Font keyFont;
    private boolean tinting = false;

    public KeyboundButton(String key, boolean showKey) {
        this.key = key;
        this.showKey = showKey;
        this.updateFont();
        this.updateDrawingText();
    }

    private void updateFont() {
        this.keyFont = new Font("SansSerif", 1, this.sizeMod(13));
    }

    private void updateDrawingText() {
        this.drawingText = this.showKey ? PreferencesDialog.getCachedKeyText(this.key) : "";
    }

    public void updateGuiScale(float guiScale) {
        this.guiScale = guiScale;
        this.updateFont();
        this.invalidate();
    }

    public void setShowKey(boolean showKey) {
        this.showKey = showKey;
        this.updateDrawingText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (this.ui != null && g != null) {
            Graphics sg = g.create();
            try {
                this.ui.update(sg, this);
                if (this.tinting) {
                    sg.setColor(new Color(0, 0, 0, 32));
                    sg.fillRoundRect(this.sizeMod(2), this.sizeMod(2), this.getWidth() - this.sizeMod(4), this.getHeight() - this.sizeMod(4), this.sizeMod(6), this.sizeMod(6));
                }
                sg.setColor(this.tinting ? Color.lightGray : Color.white);
                if (!this.drawingText.isEmpty()) {
                    sg.setFont(this.keyFont);
                    int textWidth = sg.getFontMetrics(this.keyFont).stringWidth(this.drawingText);
                    int centerX = (this.getWidth() - textWidth) / 2;
                    sg.drawString(this.drawingText, centerX, this.sizeMod(28));
                }
            }
            finally {
                sg.dispose();
            }
        }
    }

    public void setTint(boolean tinting) {
        this.tinting = tinting;
        this.repaint();
    }

    private int sizeMod(int value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScale);
    }

    private float sizeMod(float value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScale);
    }
}

