/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidator;
import mage.cards.decks.DeckValidatorError;
import org.unbescape.html.HtmlEscape;
import org.unbescape.html.HtmlEscapeLevel;
import org.unbescape.html.HtmlEscapeType;

public class LegalityLabel
extends JLabel {
    protected static final Color COLOR_UNKNOWN = new Color(174, 174, 174);
    protected static final Color COLOR_LEGAL = new Color(117, 152, 110);
    protected static final Color COLOR_PARTLY_LEGAL = new Color(191, 176, 80);
    protected static final Color COLOR_NOT_LEGAL = new Color(191, 84, 74);
    protected static final Color COLOR_TEXT = new Color(255, 255, 255);
    protected static final Dimension DIM_MINIMUM = new Dimension(75, 25);
    protected static final Dimension DIM_MAXIMUM = new Dimension(150, 75);
    protected static final Dimension DIM_PREFERRED_1_OF_3 = new Dimension(75, 25);
    protected static final Dimension DIM_PREFERRED_2_OF_3 = new Dimension(LegalityLabel.DIM_PREFERRED_1_OF_3.width * 2 + 5, 25);
    protected static final Dimension DIM_PREFERRED_3_OF_3 = new Dimension(LegalityLabel.DIM_PREFERRED_1_OF_3.width * 3 + 10, 25);
    protected static final Dimension DIM_PREFERRED_1_OF_5 = new Dimension((LegalityLabel.DIM_PREFERRED_3_OF_3.width - 20) / 5, 25);
    protected static final int TOOLTIP_TABLE_WIDTH = 400;
    protected static final int TOOLTIP_MAX_ERRORS = 20;
    protected Deck currentDeck;
    protected String errorMessage;
    protected DeckValidator validator;

    public LegalityLabel(String text, DeckValidator validator) {
        super(text);
        this.validator = validator;
        this.setBackground(COLOR_UNKNOWN);
        this.setForeground(COLOR_TEXT);
        this.setHorizontalAlignment(0);
        this.setMinimumSize(DIM_MINIMUM);
        this.setMaximumSize(DIM_MAXIMUM);
        this.setName(text);
        this.setOpaque(true);
        this.setPreferredSize(DIM_PREFERRED_1_OF_3);
    }

    public LegalityLabel(DeckValidator validator) {
        this(validator.getShortName(), validator);
    }

    public LegalityLabel() {
        this.setBackground(COLOR_UNKNOWN);
        this.setForeground(COLOR_TEXT);
        this.setHorizontalAlignment(0);
        this.setMinimumSize(DIM_MINIMUM);
        this.setMaximumSize(DIM_MAXIMUM);
        this.setOpaque(true);
        this.setPreferredSize(DIM_PREFERRED_1_OF_3);
    }

    public static JButton createHideButton() {
        JButton button = new JButton("Hide");
        button.setHorizontalAlignment(0);
        button.setMinimumSize(DIM_MINIMUM);
        button.setMaximumSize(DIM_MAXIMUM);
        button.setPreferredSize(DIM_PREFERRED_1_OF_3);
        return button;
    }

    protected String escapeHtml(String string) {
        return HtmlEscape.escapeHtml((String)string, (HtmlEscapeType)HtmlEscapeType.HTML4_NAMED_REFERENCES_DEFAULT_TO_HEXA, (HtmlEscapeLevel)HtmlEscapeLevel.LEVEL_0_ONLY_MARKUP_SIGNIFICANT_EXCEPT_APOS);
    }

    protected String formatInvalidTooltip(List<DeckValidatorError> sortedErrorsList) {
        return sortedErrorsList.stream().reduce("<html><body><p>Deck is <span style='color:#BF544A;font-weight:bold;'>INVALID</span></p><u>The following problems have been found (click to select problem cards):</u><br><table style=\"table-layout: fixed; width: 400px\">", (str, error) -> String.format("%s<tr><td style=\"word-wrap: break-word\"><b>%s</b></td><td style=\"word-wrap: break-word\">%s</td></tr>", str, this.escapeHtml(error.getGroup()), this.escapeHtml(error.getMessage())), String::concat) + "</table></body></html>";
    }

    protected String formatPartlyValidTooltip(List<DeckValidatorError> sortedErrorsList) {
        return sortedErrorsList.stream().reduce("<html><body><p>Deck is <span style='color:#b8860b;font-weight:bold;'>PARTLY VALID</span></p><u>The following problems have been found (click to select problem cards):</u><br><table style=\"table-layout: fixed; width: 400px\">", (str, error) -> String.format("%s<tr><td style=\"word-wrap: break-word\"><b>%s</b></td><td style=\"word-wrap: break-word\">%s</td></tr>", str, this.escapeHtml(error.getGroup()), this.escapeHtml(error.getMessage())), String::concat) + "</table></body></html>";
    }

    private String appendErrorMessage(String string) {
        if (this.errorMessage.isEmpty()) {
            return string;
        }
        if (string.contains("<html>")) {
            return string.replaceFirst("((</body>)?</html>)", String.format("<br><br>The following errors occurred while loading the deck:<br>%s$1", this.escapeHtml(this.errorMessage)));
        }
        return string.concat("\n\nThe following errors occurred while loading the deck:\n" + this.errorMessage);
    }

    public void showState(Color color) {
        this.setBackground(color);
    }

    public void showState(Color color, String tooltip, boolean useErrors) {
        this.setBackground(color);
        if (useErrors) {
            this.setToolTipText(this.appendErrorMessage(tooltip));
        } else {
            this.setToolTipText(tooltip);
        }
    }

    public void showStateInfo(String tooltip) {
        this.showState(COLOR_LEGAL, tooltip, false);
    }

    public void showStateUnknown(String tooltip) {
        this.showState(COLOR_UNKNOWN, tooltip, true);
    }

    public void showStateLegal(String tooltip) {
        this.showState(COLOR_LEGAL, tooltip, true);
    }

    public void showStatePartlyLegal(String tooltip) {
        this.showState(COLOR_PARTLY_LEGAL, tooltip, true);
    }

    public void showStateNotLegal(String tooltip) {
        this.showState(COLOR_NOT_LEGAL, tooltip, true);
    }

    public void validateDeck(Deck deck) {
        this.errorMessage = "";
        this.currentDeck = deck;
        if (deck == null) {
            this.showStateUnknown("<html><body><b>No deck loaded!</b></body></html>");
            return;
        }
        if (this.validator == null) {
            this.showStateUnknown("<html><body><b>No deck type selected!</b></body></html>");
            return;
        }
        try {
            if (this.validator.validate(deck)) {
                this.showStateLegal("<html><body>Deck is <span style='color:green;font-weight:bold;'>VALID</span></body></html>");
            } else if (this.validator.isPartlyValid()) {
                this.showStatePartlyLegal(this.formatPartlyValidTooltip(this.validator.getErrorsListSorted(20)));
            } else {
                this.showStateNotLegal(this.formatInvalidTooltip(this.validator.getErrorsListSorted(20)));
            }
        }
        catch (Exception e) {
            this.showStateUnknown(String.format("<html><body><b>Deck could not be validated!</b><br>The following error occurred while validating this deck:<br>%s</body></html>", this.escapeHtml(e.getMessage())));
        }
    }

    public List<String> selectCards() {
        if (this.validator == null) {
            return Collections.emptyList();
        }
        return this.validator.getErrorsList().stream().map(DeckValidatorError::getCardName).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

