/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.UUID;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import mage.cards.action.TransferData;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.cards.VirtualCardInfo;
import mage.client.components.MageUI;
import mage.client.dialog.PreferencesDialog;
import mage.client.game.GamePanel;
import mage.game.command.Dungeon;
import mage.game.command.Plane;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.view.CardView;
import mage.view.DungeonView;
import mage.view.PlaneView;

public class MageEditorPane
extends JEditorPane {
    private static final int CHAT_TOOLTIP_DELAY_MS = 50;
    private static Element lastUrlElementEntered = null;
    final HTMLEditorKit kit = new HTMLEditorKit();
    final HTMLDocument doc;
    private boolean hyperlinkEnabled = false;
    VirtualCardInfo cardInfo = new VirtualCardInfo();
    UUID gameId = null;
    BigCard bigCard = null;

    public MageEditorPane() {
        this.setEditorKit(this.kit);
        this.doc = (HTMLDocument)this.getDocument();
        this.kit.getStyleSheet().addRule(" a { text-decoration: none; } ");
        this.changeGUISize(this.getFont());
    }

    public void changeGUISize(Font font) {
        this.setFont(font);
        String bodyRule = "body {  font-family: " + font.getFamily() + ";  font-size: " + font.getSize() + "pt; }";
        this.kit.getStyleSheet().addRule(bodyRule);
    }

    public void enableTextLabelMode() {
        this.setOpaque(false);
        this.setFocusable(false);
        this.setBorder(null);
        this.setAutoscrolls(false);
        this.setBackground(new Color(0, 0, 0, 0));
    }

    public void setGameData(UUID gameId, BigCard bigCard) {
        this.gameId = gameId;
        this.bigCard = bigCard;
    }

    public void cleanUp() {
        this.setCursorToDefault();
    }

    private void addHyperlinkHandlers() {
        if (Arrays.stream(this.getHyperlinkListeners()).findAny().isPresent()) {
            throw new IllegalStateException("Wrong code usage: popup links support enabled already");
        }
        this.addHyperlinkListener(e -> MageUI.threadPoolPopups.submit(() -> {
            if (PreferencesDialog.getCachedValue("showTooltipsDelay", 300) == 0) {
                return;
            }
            HashMap<String, String> extraData = new HashMap<String, String>();
            if (e.getSourceElement() instanceof HTMLDocument.RunElement) {
                HTMLDocument.RunElement el = (HTMLDocument.RunElement)e.getSourceElement();
                Enumeration<?> attNames = el.getAttributeNames();
                while (attNames.hasMoreElements()) {
                    Object attName = attNames.nextElement();
                    Object attValue = el.getAttribute(attName);
                    if (!(attValue instanceof SimpleAttributeSet)) continue;
                    SimpleAttributeSet attReal = (SimpleAttributeSet)attValue;
                    Enumeration<?> attRealNames = attReal.getAttributeNames();
                    while (attRealNames.hasMoreElements()) {
                        Object attRealName = attRealNames.nextElement();
                        Object attRealValue = attReal.getAttribute(attRealName);
                        String name = attRealName.toString();
                        String value = attRealValue.toString();
                        extraData.put(name, value);
                    }
                }
            }
            CardView needCard = null;
            GamePanel gamePanel = MageFrame.getGame(this.gameId);
            if (gamePanel != null) {
                try {
                    UUID needObjectId = UUID.fromString(extraData.getOrDefault("object_id", ""));
                    needCard = gamePanel.getLastGameData().findCard(needObjectId);
                }
                catch (IllegalArgumentException needObjectId) {
                    // empty catch block
                }
            }
            String cardName = e.getDescription().substring(1);
            String alternativeName = CardUtil.urlDecode(extraData.getOrDefault("alternative_name", ""));
            if (!alternativeName.isEmpty()) {
                cardName = alternativeName;
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                Dungeon dungeon;
                Plane plane;
                CardInfo card;
                CardView cardView;
                AttributeSet as = e.getSourceElement().getAttributes();
                AttributeSet asAnchor = (AttributeSet)as.getAttribute(HTML.Tag.A);
                if (asAnchor != null) {
                    this.urlHighlightEnable(e.getSourceElement());
                }
                if ((cardView = needCard) == null && (card = (CardInfo)CardRepository.instance.findCards(cardName).stream().findFirst().orElse(null)) != null) {
                    cardView = new CardView(card.createMockCard());
                }
                if (cardView == null && (plane = Plane.createPlaneByFullName(cardName)) != null) {
                    cardView = new CardView(new PlaneView(plane, null));
                }
                if (cardView == null && (dungeon = Dungeon.createDungeon(cardName, false)) != null) {
                    cardView = new CardView(new DungeonView(dungeon));
                }
                if (cardView != null) {
                    this.cardInfo.init(cardView, this.bigCard, this.gameId);
                    this.cardInfo.setTooltipDelay(50);
                    this.cardInfo.setPopupAutoLocationMode(TransferData.PopupAutoLocationMode.PUT_NEAR_MOUSE_POSITION);
                    SwingUtilities.invokeLater(() -> {
                        this.cardInfo.onMouseEntered(MouseInfo.getPointerInfo().getLocation());
                        this.cardInfo.onMouseMoved(MouseInfo.getPointerInfo().getLocation());
                    });
                }
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SwingUtilities.invokeLater(() -> this.cardInfo.onMouseWheel(MouseInfo.getPointerInfo().getLocation()));
            }
            if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.urlHighlightDisable();
                SwingUtilities.invokeLater(() -> this.cardInfo.onMouseExited());
            }
        }));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                MageEditorPane.this.cardInfo.onMouseExited();
                MageEditorPane.this.setCursorToDefault();
            }
        });
    }

    private void setCursorToDefault() {
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent != null) {
            parent.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setCursorToHand() {
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent != null) {
            parent.setCursor(new Cursor(12));
        }
    }

    private void urlHighlightEnable(Element hyperlinkElement) {
        if (hyperlinkElement != lastUrlElementEntered) {
            lastUrlElementEntered = hyperlinkElement;
            this.changeUrlTextDecoration(hyperlinkElement, "underline");
        }
        this.setCursorToHand();
    }

    private void urlHighlightDisable() {
        if (lastUrlElementEntered != null) {
            this.changeUrlTextDecoration(lastUrlElementEntered, "none");
            lastUrlElementEntered = null;
        }
        this.setCursorToDefault();
    }

    private void changeUrlTextDecoration(Element el, String decoration) {
        if (lastUrlElementEntered != null) {
            HTMLDocument doc = (HTMLDocument)this.getDocument();
            int start = el.getStartOffset();
            int end = el.getEndOffset();
            StyleSheet ss = doc.getStyleSheet();
            Style style = ss.addStyle("HighlightedUrl", null);
            style.addAttribute(CSS.Attribute.TEXT_DECORATION, decoration);
            doc.setCharacterAttributes(start, end - start, style, false);
        }
    }

    @Override
    public void setText(String text) {
        super.setText("");
        this.append(text);
    }

    public void append(String text) {
        try {
            if (this.hyperlinkEnabled) {
                text = GameLog.injectPopupSupport(text);
            }
            this.kit.insertHTML(this.doc, this.doc.getLength(), text, 0, 0, null);
            int len = this.getDocument().getLength();
            this.setCaretPosition(len);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void enableHyperlinksAndCardPopups() {
        if (this.isEditable()) {
            throw new IllegalStateException("Wrong code usage: hyper links works with non-editable components");
        }
        this.hyperlinkEnabled = true;
        this.addHyperlinkHandlers();
    }
}

