/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components;

import java.awt.Color;
import javax.swing.SwingUtilities;
import mage.client.components.MageEditorPane;
import mage.client.util.GUISizeHelper;
import org.mage.card.arcane.ManaSymbols;

public class MageTextArea
extends MageEditorPane {
    private String currentText;
    private int currentPanelWidth;

    public MageTextArea() {
        this.setEditable(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setFocusable(false);
        this.enableHyperlinksAndCardPopups();
    }

    @Override
    public void setText(String text) {
        this.setText(text, 0);
    }

    public void setText(String text, int panelWidth) {
        if (text == null) {
            return;
        }
        if (text.equals(this.currentText) && panelWidth == this.currentPanelWidth) {
            return;
        }
        this.currentText = text;
        this.currentPanelWidth = panelWidth;
        StringBuilder buffer = new StringBuilder();
        buffer.append("<body style='font-family:Dialog;font-size:");
        buffer.append(GUISizeHelper.gameFeedbackPanelMainMessageFontSize);
        buffer.append("pt;margin:3px 3px 3px 3px;color: #FFFFFF'><b><center>");
        text = text.replace("\r\n", "<div style='font-size:5pt'></div>");
        String basicText = ManaSymbols.replaceSymbolsWithHTML(text, ManaSymbols.Type.DIALOG);
        if (!text.isEmpty()) {
            buffer.append(basicText);
        }
        buffer.append("</b></center></body></html>");
        SwingUtilities.invokeLater(() -> {
            String promptText = buffer.toString();
            MageTextArea.super.setText(promptText);
            if (panelWidth > 0 && this.getPreferredSize().getWidth() > (double)panelWidth) {
                String tooltip = "<html><center><body style='font-family:Dialog;font-size:" + GUISizeHelper.gameFeedbackPanelMainMessageFontSize + "pt;color: #FFFFFF'><p width='500'>" + basicText + "</p></body></html>";
                MageTextArea.super.setToolTipText(tooltip);
            } else {
                MageTextArea.super.setToolTipText(null);
            }
            this.setCaretPosition(0);
        });
    }
}

