/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components.ability;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mage.abilities.Modes;
import mage.client.SessionHandler;
import mage.client.cards.BigCard;
import mage.client.components.ColorPane;
import mage.client.components.ability.BackgroundPainter;
import mage.client.components.ability.MageScrollbarUI;
import mage.client.dialog.MageDialog;
import mage.client.game.GamePanel;
import mage.client.util.GUISizeHelper;
import mage.client.util.ImageHelper;
import mage.util.CardUtil;
import mage.view.AbilityPickerView;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import org.mage.card.arcane.ManaSymbols;

public class AbilityPicker
extends JXPanel
implements MouseWheelListener {
    private static final String DEFAULT_MESSAGE = "Choose spell or ability to play (single-click)";
    private static final int DIALOG_WIDTH = 440;
    private static final int DIALOG_HEIGHT = 260;
    private static final String CHOICE_PREFIX = "<html>";
    private static final Logger log = Logger.getLogger(AbilityPicker.class);
    private JList rows;
    private List<Object> choices;
    private String message = "Choose spell or ability to play (single-click)";
    float guiScaleMod = 1.0f;
    private UUID gameId;
    private BackgroundPainter mwPanelPainter;
    private JScrollPane jScrollPane2;
    private ColorPane title;
    private Image rightImage;
    private Image rightImageHovered;
    private static final String IMAGE_RIGHT_PATH = "/game/right.png";
    private static final String IMAGE_RIGHT_HOVERED_PATH = "/game/right_hovered.png";
    private static final Color SELECTED_COLOR = new Color(64, 147, 208);
    private boolean selected = false;

    public AbilityPicker() {
        this(1.0f);
    }

    public AbilityPicker(float guiScaleMod) {
        this.createAllComponents(guiScaleMod);
    }

    public void init(UUID gameId, BigCard bigCard) {
        this.gameId = gameId;
        this.title.setGameData(gameId, bigCard);
    }

    public void cleanUp() {
        for (MouseListener ml : this.getMouseListeners()) {
            this.removeMouseListener(ml);
        }
    }

    private int sizeMod(int value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScaleMod);
    }

    private float sizeMod(float value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScaleMod);
    }

    public void fullRefresh(float guiScaleMod) {
        this.cleanUp();
        this.removeAll();
        this.createAllComponents(guiScaleMod);
        this.invalidate();
    }

    public void createAllComponents(float guiScaleMod) {
        this.guiScaleMod = guiScaleMod;
        this.setSize(this.sizeMod(440), this.sizeMod(260));
        this.initComponents();
        this.jScrollPane2.setOpaque(false);
        this.jScrollPane2.getViewport().setOpaque(false);
        UIManager.put("ScrollBar.width", this.sizeMod(17));
        this.jScrollPane2.getHorizontalScrollBar().setUI(new MageScrollbarUI());
        this.jScrollPane2.getVerticalScrollBar().setUI(new MageScrollbarUI());
    }

    public void show(AbilityPickerView choices, Point p) {
        this.choices = new ArrayList<Object>();
        this.selected = true;
        this.setMessageAndPrepare(choices.getMessage());
        boolean wasCancelButton = false;
        for (Map.Entry choice : choices.getChoices().entrySet()) {
            wasCancelButton = wasCancelButton || ((UUID)choice.getKey()).equals(Modes.CHOOSE_OPTION_CANCEL_ID);
            String htmlText = CHOICE_PREFIX + ManaSymbols.replaceSymbolsWithHTML(CardUtil.getTextWithFirstCharUpperCase((String)choice.getValue()), ManaSymbols.Type.DIALOG);
            this.choices.add(new AbilityPickerAction((UUID)choice.getKey(), htmlText));
        }
        if (!wasCancelButton) {
            this.choices.add(new AbilityPickerAction(null, "Cancel"));
        }
        this.show(this.choices);
    }

    private void show(List<Object> choices) {
        this.choices = choices;
        this.selected = true;
        this.rows.setListData(this.choices.toArray());
        this.rows.setSelectedIndex(0);
        this.selected = false;
        this.title.setText(this.message);
        this.setVisible(true);
        MageDialog.makeWindowCentered((Component)((Object)this), this.getWidth(), this.getHeight());
    }

    private void initComponents() {
        Color textColor = Color.white;
        this.mwPanelPainter = new BackgroundPainter();
        this.jScrollPane2 = new JScrollPane();
        this.setBackground(textColor);
        this.setBackgroundPainter((Painter)this.mwPanelPainter);
        this.title = new ColorPane();
        this.title.setFont(new Font("Times New Roman", 1, this.sizeMod(15)));
        this.title.setEditable(false);
        this.title.setFocusCycleRoot(false);
        this.title.setOpaque(false);
        this.title.setForeground(textColor);
        this.title.setExtBackgroundColor(this.mwPanelPainter);
        this.title.setBorder(BorderFactory.createEmptyBorder());
        this.title.enableHyperlinksAndCardPopups();
        this.title.setText(this.message);
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setHorizontalScrollBarPolicy(30);
        this.jScrollPane2.setVerticalScrollBarPolicy(20);
        this.rightImage = ImageHelper.loadImage(IMAGE_RIGHT_PATH);
        this.rightImageHovered = ImageHelper.loadImage(IMAGE_RIGHT_HOVERED_PATH);
        this.setOpaque(false);
        this.rows = new JList();
        this.rows.setBackground(textColor);
        this.rows.setCellRenderer(new ImageRenderer());
        this.rows.ensureIndexIsVisible(this.rows.getModel().getSize());
        this.rows.setSelectionMode(0);
        this.rows.setLayoutOrientation(0);
        this.rows.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.rows.setMinimumSize(new Dimension(this.sizeMod(67), this.sizeMod(16)));
        this.rows.setOpaque(false);
        this.rows.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (SwingUtilities.isLeftMouseButton(evt) && !AbilityPicker.this.rows.isSelectionEmpty()) {
                    AbilityPicker.this.objectMouseClicked(evt);
                }
            }
        });
        this.rows.setSelectedIndex(0);
        this.rows.setFont(new Font("Times New Roman", 1, this.sizeMod(17)));
        this.rows.setBorder(BorderFactory.createEmptyBorder());
        this.rows.addMouseWheelListener(this);
        this.jScrollPane2.setViewportView(this.rows);
        this.jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane2, -1, this.sizeMod(422), Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.title).addPreferredGap(0, this.sizeMod(5), Short.MAX_VALUE).add(this.sizeMod(1), this.sizeMod(1), this.sizeMod(1))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createParallelGroup(1))))).add(this.sizeMod(10), this.sizeMod(10), this.sizeMod(10))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.title, -2, this.sizeMod(72), -2).add(this.sizeMod(5), this.sizeMod(5), this.sizeMod(5)).add((GroupLayout.Group)layout.createParallelGroup(3))).add((GroupLayout.Group)layout.createSequentialGroup().add(this.sizeMod(8), this.sizeMod(8), this.sizeMod(8)))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1)).addPreferredGap(0).add((Component)this.jScrollPane2, -2, this.sizeMod(180), -2).addContainerGap(this.sizeMod(23), Short.MAX_VALUE)));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int direction = e.getWheelRotation() < 0 ? -1 : 1;
        int index = this.rows.getSelectedIndex() + direction;
        if (index < 0) {
            index = 0;
        } else if (index >= this.choices.size()) {
            index = this.choices.size() - 1;
        }
        this.rows.setSelectedIndex(index);
        this.rows.repaint();
    }

    private void objectMouseClicked(MouseEvent event) {
        int index = this.rows.getSelectedIndex();
        AbilityPickerAction action = (AbilityPickerAction)this.choices.get(index);
        action.actionPerformed(null);
    }

    @Deprecated
    private synchronized void startModal() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (!this.selected) {
                    MouseEvent e;
                    MouseEvent m;
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    boolean dispatch = true;
                    if (event instanceof MouseEvent && !this.contains((m = SwingUtilities.convertMouseEvent((Component)(e = (MouseEvent)event).getSource(), e, (Component)((Object)this))).getPoint()) && e.getID() != 506) {
                        dispatch = false;
                    }
                    if (!dispatch) continue;
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (!(source instanceof MenuComponent)) continue;
                    ((MenuComponent)source).dispatchEvent(event);
                }
            } else {
                while (!this.selected) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void cancel() {
        try {
            SessionHandler.sendPlayerBoolean(this.gameId, false);
        }
        catch (Exception e) {
            log.error((Object)("Couldn't cancel choose dialog: " + e), (Throwable)e);
        }
    }

    private void setMessageAndPrepare(String message) {
        this.message = message != null ? message + " (single-click or hotkeys)" : DEFAULT_MESSAGE;
        this.message = CHOICE_PREFIX + this.message;
    }

    private void tryChoiceDone() {
        if (!this.isVisible() || this.choices == null) {
            return;
        }
        for (Object obj : this.choices) {
            AbilityPickerAction action = (AbilityPickerAction)obj;
            if (!Modes.CHOOSE_OPTION_DONE_ID.equals(action.id)) continue;
            action.actionPerformed(null);
            break;
        }
    }

    private void tryChoiceCancel() {
        AbilityPickerAction action;
        if (!this.isVisible() || this.choices == null) {
            return;
        }
        for (Object obj : this.choices) {
            action = (AbilityPickerAction)obj;
            if (!Modes.CHOOSE_OPTION_CANCEL_ID.equals(action.id)) continue;
            action.actionPerformed(null);
            break;
        }
        for (Object obj : this.choices) {
            action = (AbilityPickerAction)obj;
            if (action.id != null) continue;
            this.cancel();
            break;
        }
    }

    private void tryChoiceOption(int choiceNumber) {
        if (!this.isVisible() || this.choices == null) {
            return;
        }
        String need = choiceNumber + ".";
        for (Object obj : this.choices) {
            AbilityPickerAction action = (AbilityPickerAction)obj;
            if (!action.toString().startsWith(CHOICE_PREFIX + need)) continue;
            action.actionPerformed(null);
            break;
        }
    }

    public void injectHotkeys(GamePanel panel, String commandsPrefix) {
        int c = 2;
        HashMap<Integer, Integer> numbers = new HashMap<Integer, Integer>();
        numbers.put(49, 1);
        numbers.put(50, 2);
        numbers.put(51, 3);
        numbers.put(52, 4);
        numbers.put(53, 5);
        numbers.put(54, 6);
        numbers.put(55, 7);
        numbers.put(56, 8);
        numbers.put(57, 9);
        numbers.forEach((vk, num) -> {
            KeyStroke ks = KeyStroke.getKeyStroke(vk, 0);
            panel.getInputMap(c).put(ks, commandsPrefix + "_CHOOSE_" + num);
            panel.getActionMap().put(commandsPrefix + "_CHOOSE_" + num, new AbstractAction((Integer)num){
                final /* synthetic */ Integer val$num;
                {
                    this.val$num = n;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbilityPicker.this.tryChoiceOption(this.val$num);
                }
            });
        });
        panel.getInputMap(c).put(KeyStroke.getKeyStroke(32, 0), commandsPrefix + "_CHOOSE_DONE");
        panel.getInputMap(c).put(KeyStroke.getKeyStroke(10, 0), commandsPrefix + "_CHOOSE_DONE");
        panel.getActionMap().put(commandsPrefix + "_CHOOSE_DONE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbilityPicker.this.tryChoiceDone();
            }
        });
        panel.getInputMap(c).put(KeyStroke.getKeyStroke(8, 0), commandsPrefix + "_CHOOSE_CANCEL");
        panel.getActionMap().put(commandsPrefix + "_CHOOSE_CANCEL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbilityPicker.this.tryChoiceCancel();
            }
        });
    }

    public class AbilityPickerAction
    extends AbstractAction {
        private final UUID id;

        public AbilityPickerAction(UUID id, String choice) {
            this.id = id;
            this.putValue("Name", choice);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.id == null) {
                AbilityPicker.this.cancel();
            } else {
                SessionHandler.sendPlayerUUID(AbilityPicker.this.gameId, this.id);
            }
            AbilityPicker.this.setVisible(false);
            AbilityPicker.this.selected = true;
        }

        public String toString() {
            return (String)this.getValue("Name");
        }
    }

    class ImageRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 7689696087189956997L;

        ImageRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)c;
            label.setOpaque(false);
            label.setForeground(Color.white);
            if (AbilityPicker.this.choices.size() <= index) {
                return label;
            }
            Object object = AbilityPicker.this.choices.get(index);
            String name = object.toString();
            label.setText(name);
            if (isSelected) {
                label.setIcon(new ImageIcon(AbilityPicker.this.rightImageHovered));
                label.setForeground(SELECTED_COLOR);
                label.setBorder(BorderFactory.createEmptyBorder());
            } else {
                label.setIcon(new ImageIcon(AbilityPicker.this.rightImage));
            }
            return label;
        }
    }
}

