/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components.ability;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.jdesktop.swingx.painter.AbstractPainter;

public class BackgroundPainter
extends AbstractPainter {
    private final Color bgColor = Color.black;
    static final float BACKGROUND_ALPHA = 0.6f;

    public BackgroundPainter() {
        this.setAntialiasing(true);
    }

    protected void doPaint(Graphics2D g2, Object o, int i, int i1) {
        float alpha = 0.6f;
        Component c = (Component)o;
        Composite composite = g2.getComposite();
        if (composite instanceof AlphaComposite) {
            alpha *= ((AlphaComposite)composite).getAlpha();
        }
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        g2.setColor(this.bgColor);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, c.getWidth() - 1, c.getHeight() - 1, 24.0, 24.0);
        g2.fill(rect);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(-c.getWidth(), (double)c.getHeight() / 3.0, (double)c.getWidth() * 3.0, (double)c.getHeight() * 2.0);
        Area area = new Area(new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        area.subtract(new Area(ellipse));
        area.intersect(new Area(rect));
        alpha = 0.1f;
        if (composite instanceof AlphaComposite) {
            alpha *= ((AlphaComposite)composite).getAlpha();
        }
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        g2.setColor(new Color(1.0f, 1.0f, 1.0f));
        g2.fill(area);
        g2.setComposite(composite);
    }
}

