/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components.ability;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.plaf.metal.MetalScrollButton;

public class MageScrollButton
extends MetalScrollButton {
    private static final ImageIcon buttonLeft = new ImageIcon(MageScrollButton.class.getResource("/buttons/left.png"));
    private static final ImageIcon buttonRight = new ImageIcon(MageScrollButton.class.getResource("/buttons/right.png"));
    private static final ImageIcon buttonUp = new ImageIcon(MageScrollButton.class.getResource("/buttons/up.png"));
    private static final ImageIcon buttonDown = new ImageIcon(MageScrollButton.class.getResource("/buttons/down.png"));
    private int width;

    public MageScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
        this.setOpaque(false);
        this.width = width;
        buttonUp.setImage(buttonUp.getImage().getScaledInstance(width, width, 4));
        buttonDown.setImage(buttonDown.getImage().getScaledInstance(width, width, 4));
        buttonLeft.setImage(buttonLeft.getImage().getScaledInstance(width, width, 4));
        buttonRight.setImage(buttonRight.getImage().getScaledInstance(width, width, 4));
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.width);
    }

    @Override
    public void paint(Graphics g) {
        switch (this.getDirection()) {
            case 7: {
                buttonLeft.paintIcon(null, g, 0, 0);
                break;
            }
            case 3: {
                buttonRight.paintIcon(null, g, 0, 0);
                break;
            }
            case 1: {
                buttonUp.paintIcon(null, g, 0, 0);
                break;
            }
            case 5: {
                buttonDown.paintIcon(null, g, 0, 0);
            }
        }
    }
}

