/*
 * Decompiled with CFR 0.152.
 */
package mage.client.components.tray;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.util.concurrent.TimeUnit;
import mage.client.MageFrame;
import org.apache.log4j.Logger;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public enum MageTray {
    instance;

    private static final Logger log;
    private Image mainImage;
    private Image flashedImage;
    private TrayIcon trayIcon;
    private int state = 0;

    public void install() {
        if (!SystemTray.isSupported()) {
            log.warn((Object)"SystemTray is not supported");
            return;
        }
        try {
            this.mainImage = ImageManagerImpl.instance.getAppSmallImage();
            this.flashedImage = ImageManagerImpl.instance.getAppFlashedImage();
            this.trayIcon = new TrayIcon(this.mainImage);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(e -> {
                this.stopBlink();
                MageFrame frame = MageFrame.getInstance();
                frame.setVisible(true);
                frame.setState(0);
            });
            SystemTray tray = SystemTray.getSystemTray();
            PopupMenu popup = new PopupMenu();
            MenuItem imagesItem = new MenuItem("Download images");
            MenuItem iconsItem = new MenuItem("Download icons");
            MenuItem stopBlinkItem = new MenuItem("Stop blinking");
            MenuItem preferencesItem = new MenuItem("Preferences...");
            MenuItem aboutItem = new MenuItem("About Mage");
            MenuItem exitItem = new MenuItem("Exit");
            imagesItem.addActionListener(e -> MageFrame.getInstance().downloadImages());
            iconsItem.addActionListener(e -> MageFrame.getInstance().downloadAdditionalResources());
            stopBlinkItem.addActionListener(e -> this.stopBlink());
            preferencesItem.addActionListener(e -> MageFrame.getInstance().btnPreferencesActionPerformed(null));
            aboutItem.addActionListener(e -> MageFrame.getInstance().btnAboutActionPerformed(null));
            exitItem.addActionListener(e -> MageFrame.getInstance().exitApp());
            popup.add(imagesItem);
            popup.add(iconsItem);
            popup.add(stopBlinkItem);
            popup.add(preferencesItem);
            popup.addSeparator();
            popup.add(aboutItem);
            popup.addSeparator();
            popup.add(exitItem);
            this.trayIcon.setPopupMenu(popup);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e2) {
                log.error((Object)"TrayIcon could not be added: ", (Throwable)e2);
            }
        }
        catch (Exception e3) {
            log.error((Object)e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void blink() {
        if (this.state != 0) return;
        Class<MageTray> clazz = MageTray.class;
        synchronized (MageTray.class) {
            if (this.state != 0) return;
            this.state = 1;
            new Thread(() -> {
                try {
                    boolean i = false;
                    while (this.state != 3) {
                        this.trayIcon.setImage(!i ? this.mainImage : this.flashedImage);
                        TimeUnit.MILLISECONDS.sleep(600L);
                        i = !i;
                    }
                    this.trayIcon.setImage(this.mainImage);
                    this.state = 0;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stopBlink() {
        if (this.state == 1) {
            this.state = 3;
        }
    }

    public void displayMessage(String message) {
        if (this.trayIcon != null) {
            this.trayIcon.displayMessage("Mage", message, TrayIcon.MessageType.INFO);
        }
    }

    static {
        log = Logger.getLogger(MageTray.class);
    }
}

