/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deck.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.ExpansionRepository;
import mage.client.deck.generator.DeckGeneratorDialog;
import mage.client.deck.generator.DeckGeneratorPool;
import mage.client.util.sets.ConstructedFormats;
import mage.constants.CardType;
import mage.constants.ColoredManaSymbol;
import mage.constants.SuperType;
import mage.util.RandomUtil;

public final class DeckGenerator {
    protected static final int MAX_TRIES = 8196;
    private static DeckGeneratorDialog genDialog;
    protected static DeckGeneratorPool genPool;

    public static String generateDeck() {
        genDialog = new DeckGeneratorDialog();
        if (genDialog.getSelectedColors() != null) {
            Deck deck = DeckGenerator.buildDeck();
            return genDialog.saveDeck(deck);
        }
        return null;
    }

    protected static Deck buildDeck() {
        String selectedColors = genDialog.getSelectedColors();
        ArrayList<ColoredManaSymbol> allowedColors = new ArrayList<ColoredManaSymbol>();
        selectedColors = selectedColors != null ? selectedColors.toUpperCase(Locale.ENGLISH) : DeckGenerator.getRandomColors("X");
        String format = genDialog.getSelectedFormat();
        List<String> setsToUse = ConstructedFormats.getSetsByFormat(format);
        if (setsToUse == null) {
            throw new DeckGeneratorException("Deck sets aren't initialized; please connect to a server to update the database.");
        }
        if (setsToUse.isEmpty()) {
            setsToUse = ExpansionRepository.instance.getSetCodes();
        }
        int deckSize = genDialog.getDeckSize();
        if (selectedColors.contains("X")) {
            selectedColors = DeckGenerator.getRandomColors(selectedColors);
        }
        for (int i = 0; i < selectedColors.length(); ++i) {
            char c = selectedColors.charAt(i);
            allowedColors.add(ColoredManaSymbol.lookup(c));
        }
        return DeckGenerator.generateDeck(deckSize, allowedColors, setsToUse);
    }

    private static String getRandomColors(String selectedColors) {
        int i;
        ArrayList<Character> availableColors = new ArrayList<Character>();
        for (ColoredManaSymbol cms : ColoredManaSymbol.values()) {
            availableColors.add(Character.valueOf(cms.toString().charAt(0)));
        }
        StringBuilder generatedColors = new StringBuilder();
        int randomColors = 0;
        for (i = 0; i < selectedColors.length(); ++i) {
            char currentColor = selectedColors.charAt(i);
            if (currentColor != 'X') {
                generatedColors.append(currentColor);
                availableColors.remove(new Character(currentColor));
                continue;
            }
            ++randomColors;
        }
        for (i = 0; i < randomColors && !availableColors.isEmpty(); ++i) {
            int index = RandomUtil.nextInt(availableColors.size());
            generatedColors.append(availableColors.remove(index));
        }
        return generatedColors.toString();
    }

    private static Deck generateDeck(int deckSize, List<ColoredManaSymbol> allowedColors, List<String> setsToUse) {
        genPool = new DeckGeneratorPool(deckSize, genDialog.getCreaturePercentage(), genDialog.getNonCreaturePercentage(), genDialog.getLandPercentage(), allowedColors, genDialog.isSingleton(), genDialog.isColorless(), genDialog.isCommander(), genDialog.isAdvanced(), genDialog.getDeckGeneratorCMC());
        String[] sets = setsToUse.toArray(new String[setsToUse.size()]);
        CardCriteria creatureCriteria = new CardCriteria();
        creatureCriteria.setCodes(sets);
        creatureCriteria.notTypes(CardType.LAND);
        creatureCriteria.types(CardType.CREATURE);
        if (!genDialog.useArtifacts()) {
            creatureCriteria.notTypes(CardType.ARTIFACT);
        }
        CardCriteria nonCreatureCriteria = new CardCriteria();
        nonCreatureCriteria.setCodes(sets);
        nonCreatureCriteria.notTypes(CardType.LAND);
        nonCreatureCriteria.notTypes(CardType.CREATURE);
        if (!genDialog.useArtifacts()) {
            nonCreatureCriteria.notTypes(CardType.ARTIFACT);
        }
        CardCriteria nonBasicLandCriteria = new CardCriteria();
        nonBasicLandCriteria.setCodes(sets);
        nonBasicLandCriteria.types(CardType.LAND);
        nonBasicLandCriteria.notSupertypes(SuperType.BASIC);
        Map<String, List<CardInfo>> basicLands = DeckGeneratorPool.generateBasicLands(setsToUse);
        DeckGeneratorPool.generateSpells(creatureCriteria, genPool.getCreatureCount(), genPool.getCommandersCount());
        DeckGeneratorPool.generateSpells(nonCreatureCriteria, genPool.getNonCreatureCount(), 0);
        DeckGeneratorPool.generateLands(genDialog.useNonBasicLand(), nonBasicLandCriteria, basicLands);
        return genPool.getDeck();
    }

    static void addBasicLands(int landsNeeded, Map<String, Double> percentage, Map<String, Integer> count, Map<String, List<CardInfo>> basicLands) {
        int colorTotal = 0;
        ColoredManaSymbol colorToAdd = ColoredManaSymbol.U;
        for (Map.Entry<String, Integer> c : count.entrySet()) {
            colorTotal += c.getValue().intValue();
        }
        while (landsNeeded > 0) {
            double minPercentage = -2.147483648E9;
            for (ColoredManaSymbol color : ColoredManaSymbol.values()) {
                double neededPercentage = percentage.get(color.toString());
                if (neededPercentage <= 0.0) continue;
                int currentCount = count.get(color.toString());
                double thisPercentage = 0.0;
                if (currentCount > 0) {
                    thisPercentage = (double)currentCount / (double)colorTotal * 100.0;
                }
                if (!(neededPercentage - thisPercentage > minPercentage)) continue;
                colorToAdd = color;
                minPercentage = neededPercentage - thisPercentage;
            }
            genPool.addCard(DeckGenerator.getBasicLand(colorToAdd, basicLands));
            count.put(colorToAdd.toString(), count.get(colorToAdd.toString()) + 1);
            ++colorTotal;
            --landsNeeded;
        }
    }

    private static Card getBasicLand(ColoredManaSymbol color, Map<String, List<CardInfo>> basicLands) {
        String landName = DeckGeneratorPool.getBasicLandName(color.toString());
        List<CardInfo> basicLandsInfo = basicLands.get(landName);
        return basicLandsInfo.get(RandomUtil.nextInt(basicLandsInfo.size())).createMockCard().copy();
    }

    public static class DeckGeneratorException
    extends RuntimeException {
        public DeckGeneratorException(String message) {
            super(message);
        }
    }
}

