/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deck.generator;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.client.deck.generator.DeckGenerator;
import mage.client.deck.generator.DeckGeneratorCMC;
import mage.constants.ColoredManaSymbol;
import mage.constants.Rarity;
import mage.util.RandomUtil;
import mage.util.TournamentUtil;
import org.apache.log4j.Logger;

public class DeckGeneratorPool {
    private static final Logger logger = Logger.getLogger(DeckGeneratorPool.class);
    public static final int DEFAULT_CREATURE_PERCENTAGE = 38;
    public static final int DEFAULT_NON_CREATURE_PERCENTAGE = 21;
    public static final int DEFAULT_LAND_PERCENTAGE = 41;
    private final List<ColoredManaSymbol> allowedColors;
    private final boolean colorlessAllowed;
    private final List<DeckGeneratorCMC.CMC> poolCMCs;
    private final int creatureCount;
    private final int nonCreatureCount;
    private final int commandersCount;
    private final int landCount;
    private final boolean isSingleton;
    private final int deckSize;
    private final Map<String, Integer> cardCounts;
    private boolean monoColored;
    private final List<Card> deckCards;
    private final Map<String, Card> reserveSpells;
    private final Deck deck;

    public DeckGeneratorPool(int deckSize, int creaturePercentage, int nonCreaturePercentage, int landPercentage, List<ColoredManaSymbol> allowedColors, boolean isSingleton, boolean colorlessAllowed, boolean isCommander, boolean isAdvanced, DeckGeneratorCMC deckGeneratorCMC) {
        block12: {
            block11: {
                this.cardCounts = new HashMap<String, Integer>();
                this.monoColored = false;
                this.deckCards = new ArrayList<Card>();
                this.reserveSpells = new HashMap<String, Card>();
                this.deckSize = deckSize;
                this.allowedColors = allowedColors;
                this.colorlessAllowed = colorlessAllowed;
                this.commandersCount = isCommander ? 1 : 0;
                this.isSingleton = isSingleton || isCommander;
                this.deck = new Deck();
                if (!isAdvanced) break block11;
                this.creatureCount = (int)Math.ceil((double)deckSize / 100.0 * (double)creaturePercentage);
                this.nonCreatureCount = (int)Math.ceil((double)deckSize / 100.0 * (double)nonCreaturePercentage);
                this.landCount = (int)Math.ceil((double)deckSize / 100.0 * (double)landPercentage);
                switch (this.deckSize) {
                    case 100: {
                        this.poolCMCs = deckGeneratorCMC.get100CardPoolCMC();
                        break block12;
                    }
                    case 60: {
                        this.poolCMCs = deckGeneratorCMC.get60CardPoolCMC();
                        break block12;
                    }
                    case 40: {
                        this.poolCMCs = deckGeneratorCMC.get40CardPoolCMC();
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported deck size: " + this.deckSize);
                    }
                }
            }
            this.creatureCount = (int)Math.ceil((double)deckSize / 100.0 * 38.0);
            this.nonCreatureCount = (int)Math.ceil((double)deckSize / 100.0 * 21.0);
            this.landCount = (int)Math.ceil((double)deckSize / 100.0 * 41.0);
            switch (this.deckSize) {
                case 100: {
                    this.poolCMCs = DeckGeneratorCMC.Default.get100CardPoolCMC();
                    break;
                }
                case 60: {
                    this.poolCMCs = DeckGeneratorCMC.Default.get60CardPoolCMC();
                    break;
                }
                case 40: {
                    this.poolCMCs = DeckGeneratorCMC.Default.get40CardPoolCMC();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported deck size: " + this.deckSize);
                }
            }
        }
        if (allowedColors.size() == 1) {
            this.monoColored = true;
        }
    }

    public List<DeckGeneratorCMC.CMC> getCMCsForSpellCount(int cardsCount) {
        ArrayList<DeckGeneratorCMC.CMC> adjustedCMCs = new ArrayList<DeckGeneratorCMC.CMC>(this.poolCMCs);
        for (DeckGeneratorCMC.CMC deckCMC : adjustedCMCs) {
            deckCMC.setAmount((int)Math.ceil(deckCMC.percentage * (float)cardsCount));
        }
        return adjustedCMCs;
    }

    public boolean isValidSpellCard(Card card) {
        int cardCount = this.getCardCount(card.getName());
        return cardCount < (this.isSingleton ? 1 : 4) && this.cardFitsChosenColors(card);
    }

    public boolean isValidLandCard(Card card) {
        int cardCount = this.getCardCount(card.getName());
        return cardCount < (this.isSingleton ? 1 : 4);
    }

    public void addCard(Card card) {
        int count = this.cardCounts.getOrDefault(card.getName(), 0);
        this.cardCounts.put(card.getName(), count + 1);
        this.deckCards.add(card);
        if (this.deckCards.stream().distinct().collect(Collectors.toList()).size() != this.deckCards.size()) {
            System.out.println("wtf " + card.getName());
        }
    }

    public void clearCards(boolean isClearReserve) {
        this.cardCounts.clear();
        this.deckCards.clear();
        if (isClearReserve) {
            this.reserveSpells.clear();
        }
    }

    public boolean tryAddReserve(Card card, int cardCMC) {
        if (cardCMC < 7 && this.getCardCount(card.getName()) == 0 && !this.reserveSpells.containsKey(card.getName())) {
            this.reserveSpells.put(card.getName(), card);
            return true;
        }
        return false;
    }

    private boolean cardFitsChosenColors(Card card) {
        Set needColors = this.allowedColors.stream().map(ColoredManaSymbol::toString).collect(Collectors.toSet());
        List<ObjectColor> cardColors = card.getColorIdentity().getColors();
        for (ObjectColor cardColor : cardColors) {
            if (needColors.contains(cardColor.toString())) continue;
            return false;
        }
        return !cardColors.isEmpty() || this.colorlessAllowed;
    }

    public Map<String, Double> calculateSpellColorPercentages() {
        HashMap<String, Integer> colorCount = new HashMap<String, Integer>();
        for (ColoredManaSymbol color : ColoredManaSymbol.values()) {
            colorCount.put(color.toString(), 0);
        }
        int totalCount = 0;
        List<Card> fixedSpells = this.getFixedSpells();
        for (Card spell : fixedSpells) {
            for (String symbol : spell.getManaCostSymbols()) {
                if (!DeckGeneratorPool.isColoredManaSymbol(symbol = symbol.replace("{", "").replace("}", ""))) continue;
                for (ColoredManaSymbol allowed : this.allowedColors) {
                    if (!symbol.contains(allowed.toString())) continue;
                    int cnt = (Integer)colorCount.get(allowed.toString());
                    colorCount.put(allowed.toString(), cnt + 1);
                    ++totalCount;
                }
            }
        }
        HashMap<String, Double> percentages = new HashMap<String, Double>();
        for (Map.Entry singleCount : colorCount.entrySet()) {
            String color = (String)singleCount.getKey();
            int count = (Integer)singleCount.getValue();
            double percentage = (double)count / (double)totalCount * 100.0;
            percentages.put(color, percentage);
        }
        return percentages;
    }

    public Map<String, Integer> countManaProduced(List<Card> deckLands) {
        HashMap<String, Integer> manaCounts = new HashMap<String, Integer>();
        for (ColoredManaSymbol color : ColoredManaSymbol.values()) {
            manaCounts.put(color.toString(), 0);
        }
        for (Card land : deckLands) {
            for (Ability landAbility : land.getAbilities()) {
                for (ColoredManaSymbol symbol : this.allowedColors) {
                    String abilityString = landAbility.getRule();
                    if (!this.landTapsForAllowedColor(abilityString, symbol.toString())) continue;
                    Integer count = (Integer)manaCounts.get(symbol.toString());
                    manaCounts.put(symbol.toString(), count + 1);
                }
            }
        }
        return manaCounts;
    }

    public List<Card> filterLands(List<CardInfo> landCardsInfo) {
        ArrayList<Card> matchingLandList = new ArrayList<Card>();
        for (CardInfo landCardInfo : landCardsInfo) {
            Card landCard = landCardInfo.createMockCard();
            if (!this.landProducesChosenColors(landCard)) continue;
            matchingLandList.add(landCard);
        }
        return matchingLandList;
    }

    public static String getBasicLandName(String symbolString) {
        switch (symbolString) {
            case "B": {
                return "Swamp";
            }
            case "G": {
                return "Forest";
            }
            case "R": {
                return "Mountain";
            }
            case "U": {
                return "Island";
            }
            case "W": {
                return "Plains";
            }
        }
        return "";
    }

    public Deck getDeck() {
        this.deck.getCards().clear();
        this.deck.getSideboard().clear();
        ArrayList<Card> useCards = new ArrayList<Card>(this.deckCards);
        ArrayList<Card> useCommanders = new ArrayList<Card>();
        if (this.commandersCount > 0) {
            List possibleCommanders = this.deckCards.stream().filter(this::isValidCommander).collect(Collectors.toList());
            Card nextCommander = (Card)RandomUtil.randomFromCollection(possibleCommanders);
            while (nextCommander != null && useCommanders.size() < this.commandersCount) {
                useCards.remove(nextCommander);
                useCommanders.add(nextCommander);
            }
        }
        this.deck.getCards().addAll(useCards);
        this.deck.getSideboard().addAll(useCommanders);
        return this.deck;
    }

    public int getCreatureCount() {
        return this.creatureCount;
    }

    public int getCommandersCount() {
        return this.commandersCount;
    }

    public int getNonCreatureCount() {
        return this.nonCreatureCount;
    }

    public int getLandCount() {
        return this.landCount;
    }

    public boolean isMonoColoredDeck() {
        return this.monoColored;
    }

    public int getDeckSize() {
        return this.deckSize;
    }

    private List<Card> getFixedSpells() {
        int nonLandSize;
        int spellsSize = this.deckCards.size();
        if (spellsSize < (nonLandSize = this.deckSize - this.landCount)) {
            Card card;
            int needExtraSpells = nonLandSize - spellsSize;
            ArrayList<Card> possibleSpells = new ArrayList<Card>(this.reserveSpells.values());
            while (needExtraSpells > 0 && (card = RandomUtil.randomFromCollection(possibleSpells)) != null) {
                if (this.isValidSpellCard(card)) {
                    --needExtraSpells;
                    this.deckCards.add(card);
                }
                possibleSpells.remove(card);
            }
        }
        if (spellsSize > nonLandSize) {
            int removeCount = spellsSize - nonLandSize;
            for (int i = 0; i < removeCount; ++i) {
                this.deckCards.remove(RandomUtil.randomFromCollection(this.deckCards));
            }
        }
        if (this.deckCards.size() != nonLandSize) {
            logger.info((Object)"Can't generate full deck for selected settings - try again or choose more sets and less colors (wrong non land cards amount)");
        }
        return this.deckCards;
    }

    private boolean landTapsForAllowedColor(String ability, String symbol) {
        return ability.matches(".*Add \\{" + symbol + "\\}.");
    }

    private boolean landProducesChosenColors(Card card) {
        Abilities<Ability> landAbilities = card.getAbilities();
        int count = 0;
        for (Ability ability : landAbilities) {
            String abilityString = ability.getRule();
            for (ColoredManaSymbol symbol : this.allowedColors) {
                if (!this.landTapsForAllowedColor(abilityString, symbol.toString())) continue;
                ++count;
            }
            if (count <= true) continue;
            return true;
        }
        return false;
    }

    private boolean isValidCommander(Card card) {
        if (!card.isCreature() || !card.isLegendary()) {
            return false;
        }
        for (ColoredManaSymbol symbol : this.allowedColors) {
            if (card.getColor().contains(new ObjectColor(symbol.toString()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isColoredManaSymbol(String symbol) {
        if (symbol.contains("/")) {
            return true;
        }
        for (ColoredManaSymbol c : ColoredManaSymbol.values()) {
            if (symbol.charAt(0) != c.toString().charAt(0)) continue;
            return true;
        }
        return false;
    }

    private int getCardCount(String cardName) {
        Integer cC = this.cardCounts.get(cardName);
        if (cC == null) {
            this.cardCounts.put(cardName, 0);
        }
        return this.cardCounts.get(cardName);
    }

    protected static void generateLands(boolean useNonBasicLand, CardCriteria criteria, Map<String, List<CardInfo>> basicLands) {
        List<Card> landCards;
        int allCount;
        DeckGeneratorPool genPool = DeckGenerator.genPool;
        int tries = 0;
        int countNonBasic = 0;
        int landsCount = genPool.getLandCount();
        ArrayList<Card> deckLands = new ArrayList<Card>();
        Map<String, Double> percentage = genPool.calculateSpellColorPercentages();
        if (!genPool.isMonoColoredDeck() && useNonBasicLand && (allCount = (landCards = genPool.filterLands(CardRepository.instance.findCards(criteria))).size()) > 0) {
            while (countNonBasic < landsCount / 2) {
                Card card = landCards.get(RandomUtil.nextInt(allCount));
                if (genPool.isValidLandCard(card)) {
                    Card addedCard = card.copy();
                    deckLands.add(addedCard);
                    genPool.addCard(addedCard);
                    ++countNonBasic;
                }
                if (++tries <= 8196) continue;
                break;
            }
        }
        Map<String, Integer> count = genPool.countManaProduced(deckLands);
        DeckGenerator.addBasicLands(landsCount - countNonBasic, percentage, count, basicLands);
    }

    /*
     * Unable to fully structure code
     */
    protected static void generateSpells(CardCriteria criteria, int needCardsCount, int needCommandersCount) {
        block12: {
            genPool = DeckGenerator.genPool;
            if (needCommandersCount > 0 && !genPool.cardCounts.isEmpty()) {
                throw new IllegalArgumentException("Wrong code usage: generateSpells with creatures and commanders must be called as first");
            }
            cardsPool = CardRepository.instance.findCards(criteria).stream().map((Function<CardInfo, Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createMockCard(), (Lmage/cards/repository/CardInfo;)Lmage/cards/Card;)()).filter((Predicate<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isValidSpellCard(mage.cards.Card ), (Lmage/cards/Card;)Z)((DeckGeneratorPool)genPool)).collect(Collectors.toList());
            commandersPool = cardsPool.stream().filter((Predicate<Card>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isValidCommander(mage.cards.Card ), (Lmage/cards/Card;)Z)((DeckGeneratorPool)genPool)).collect(Collectors.toList());
            deckCMCs = genPool.getCMCsForSpellCount(needCardsCount);
            usedCardsCount = 0;
            validCommanders = 0;
            reservesAdded = 0;
            if (cardsPool.size() > 0 && cardsPool.size() >= needCardsCount) {
                tries = 0;
                possibleCards = new ArrayList<T>(cardsPool);
                possibleCommanders = new ArrayList<T>(commandersPool);
                block0: while (true) {
                    if (++tries > 8196) {
                        DeckGeneratorPool.logger.info((Object)"Can't generate full deck for selected settings - try again or choose more sets and less colors (max tries exceeded)");
                        break block12;
                    }
                    if (usedCardsCount >= needCardsCount) {
                        if (validCommanders < needCommandersCount) {
                            usedCardsCount = 0;
                            validCommanders = 0;
                            deckCMCs = genPool.getCMCsForSpellCount(needCardsCount);
                            genPool.clearCards(true);
                            possibleCards = new ArrayList<T>(cardsPool);
                            possibleCommanders = new ArrayList<T>(commandersPool);
                            continue;
                        }
                        break block12;
                    }
                    if (possibleCards.isEmpty()) {
                        throw new IllegalStateException("Not enough cards to generate deck (possible cards is empty)");
                    }
                    card = null;
                    if (validCommanders < needCommandersCount && !possibleCommanders.isEmpty()) {
                        card = (Card)RandomUtil.randomFromCollection(possibleCommanders);
                    }
                    if (card == null) {
                        card = (Card)RandomUtil.randomFromCollection(possibleCards);
                    }
                    if (!genPool.isValidSpellCard(card)) {
                        possibleCards.remove(card);
                        possibleCommanders.remove(card);
                        continue;
                    }
                    cardCMC = card.getManaValue();
                    var15_15 = deckCMCs.iterator();
                    while (true) {
                        if (var15_15.hasNext()) ** break;
                        continue block0;
                        deckCMC = var15_15.next();
                        if (cardCMC >= deckCMC.min && cardCMC <= deckCMC.max) {
                            needAmount = deckCMC.getAmount();
                            if (needAmount <= 0) continue;
                            deckCMC.setAmount(needAmount - 1);
                            genPool.addCard(card.copy());
                            ++usedCardsCount;
                            if (!genPool.isValidCommander(card)) continue;
                            ++validCommanders;
                            continue;
                        }
                        if (reservesAdded >= genPool.getDeckSize() / 2 || !genPool.tryAddReserve(card, cardCMC)) continue;
                        ++reservesAdded;
                    }
                    break;
                }
            }
            throw new IllegalStateException("Not enough cards to generate deck (cards pool too small)");
        }
    }

    protected static Map<String, List<CardInfo>> generateBasicLands(List<String> setsToUse) {
        Set<String> landSets = TournamentUtil.getLandSetCodeForDeckSets(setsToUse);
        CardCriteria criteria = new CardCriteria();
        if (!landSets.isEmpty()) {
            criteria.setCodes(landSets.toArray(new String[landSets.size()]));
        }
        criteria.ignoreSetsWithSnowLands();
        HashMap<String, List<CardInfo>> basicLandMap = new HashMap<String, List<CardInfo>>();
        for (ColoredManaSymbol c : ColoredManaSymbol.values()) {
            String landName = DeckGeneratorPool.getBasicLandName(c.toString());
            criteria.rarities(Rarity.LAND).name(landName);
            List<CardInfo> cards = CardRepository.instance.findCards(criteria);
            if (cards.isEmpty()) {
                criteria.setCodes("M15");
                cards = CardRepository.instance.findCards(criteria);
            }
            basicLandMap.put(landName, cards);
        }
        return basicLandMap;
    }
}

