/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deck.generator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class RatioAdjustingSliderPanel
extends JPanel {
    private JStorageSlider creatureSlider;
    private JStorageSlider nonCreatureSlider;
    private JStorageSlider landSlider;
    private final List<JLabel> textLabels = new ArrayList<JLabel>();
    private AdjustingSliderGroup sg;

    public RatioAdjustingSliderPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.creatureSlider = new JStorageSlider(0, 100, 38);
        this.nonCreatureSlider = new JStorageSlider(0, 100, 21);
        this.landSlider = new JStorageSlider(0, 100, 41);
        this.sg = new AdjustingSliderGroup(this.creatureSlider, this.nonCreatureSlider, this.landSlider);
        this.setLayout(new GridLayout(3, 1));
        this.add(this.createSliderPanel("Creatures          ", this.creatureSlider));
        this.add(this.createSliderPanel("Non-creatures   ", this.nonCreatureSlider));
        this.add(this.createSliderPanel("Lands                ", this.landSlider));
        this.setEnabled(true);
    }

    private JPanel createSliderPanel(String label, JStorageSlider slider) {
        JPanel sliderPanel = new JPanel(new BorderLayout());
        JLabel titleLabel = new JLabel(label);
        this.textLabels.add(titleLabel);
        sliderPanel.add((Component)titleLabel, "West");
        slider.setToolTipText("Percentage of " + label.trim().toLowerCase(Locale.ENGLISH) + " in the generated deck.");
        sliderPanel.add((Component)slider, "Center");
        JLabel percentageLabel = RatioAdjustingSliderPanel.createChangingPercentageLabel(slider);
        this.textLabels.add(percentageLabel);
        sliderPanel.add((Component)percentageLabel, "East");
        return sliderPanel;
    }

    private static JLabel createChangingPercentageLabel(JSlider slider) {
        JLabel label = new JLabel("      " + slider.getValue() + '%');
        slider.addChangeListener(e -> {
            String value = String.valueOf(slider.getValue());
            StringBuilder labelBuilder = new StringBuilder();
            for (int i = 0; i < 5 - value.length(); ++i) {
                labelBuilder.append("  ");
            }
            labelBuilder.append(value);
            labelBuilder.append('%');
            label.setText(labelBuilder.toString());
        });
        return label;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JStorageSlider slider : this.sg.getSliders()) {
            slider.setEnabled(enabled);
        }
        for (JLabel label : this.textLabels) {
            label.setEnabled(enabled);
        }
    }

    public void resetValues() {
        for (JStorageSlider slider : this.sg.getSliders()) {
            slider.resetDefault();
        }
    }

    public int getCreaturePercentage() {
        return this.creatureSlider.getValue();
    }

    public int getNonCreaturePercentage() {
        return this.nonCreatureSlider.getValue();
    }

    public int getLandPercentage() {
        return this.landSlider.getValue();
    }

    public void setCreaturePercentage(int percentage) {
        this.creatureSlider.setValue(percentage);
        this.creatureSlider.previousValue = percentage;
    }

    public void setNonCreaturePercentage(int percentage) {
        this.nonCreatureSlider.setValue(percentage);
        this.nonCreatureSlider.previousValue = percentage;
    }

    public void setLandPercentage(int percentage) {
        this.landSlider.setValue(percentage);
        this.landSlider.previousValue = percentage;
    }

    private static class AdjustingSliderGroup {
        private final ArrayList<JStorageSlider> storageSliders = new ArrayList();
        private int sliderIndex = 0;

        AdjustingSliderGroup(JStorageSlider ... sliders) {
            for (JStorageSlider slider : sliders) {
                this.storageSliders.add(slider);
                slider.addChangeListener(e -> this.fireSliderChangedEvent((JStorageSlider)e.getSource()));
            }
        }

        public void fireSliderChangedEvent(JStorageSlider source) {
            if (!source.getValueIsAdjusting()) {
                return;
            }
            int change = source.getValue() - source.getPreviousValue();
            this.updateSliderPosition(change, source);
        }

        private void updateSliderPosition(int change, JStorageSlider source) {
            int remaining = change;
            while (remaining != 0) {
                JStorageSlider slider = this.storageSliders.get(this.sliderIndex);
                if (slider != source && (remaining < 0 || remaining > 0 && slider.getValue() > 0)) {
                    int adjustment = Integer.signum(remaining);
                    slider.setValue(slider.getValue() - adjustment);
                    remaining -= adjustment;
                }
                this.sliderIndex = (this.sliderIndex + 1) % this.storageSliders.size();
            }
            for (JStorageSlider slider : this.storageSliders) {
                slider.setPreviousValue(slider.getValue());
            }
        }

        List<JStorageSlider> getSliders() {
            return this.storageSliders;
        }
    }

    private static class JStorageSlider
    extends JSlider {
        private final int defaultValue;
        private int previousValue;

        public JStorageSlider(int min, int max, int value) {
            super(min, max, value);
            this.previousValue = value;
            this.defaultValue = value;
            this.setMinorTickSpacing(5);
            this.setMajorTickSpacing(10);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.setLabelTable(this.createStandardLabels(10));
        }

        public int getPreviousValue() {
            return this.previousValue;
        }

        public void setPreviousValue(int value) {
            this.previousValue = value;
        }

        public void resetDefault() {
            this.setValue(this.defaultValue);
            this.previousValue = this.defaultValue;
        }
    }
}

