/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import mage.MageObject;
import mage.ObjectColor;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.PennyDreadfulLegalityUtil;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.repository.ExpansionRepository;
import mage.cards.repository.RepositoryEvent;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.cards.CardGrid;
import mage.client.cards.DragCardSource;
import mage.client.cards.DragCardTarget;
import mage.client.cards.ICardGrid;
import mage.client.constants.Constants;
import mage.client.deckeditor.SortSetting;
import mage.client.deckeditor.SortSettingBase;
import mage.client.deckeditor.table.TableModel;
import mage.client.dialog.CheckBoxList;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.GUISizeHelper;
import mage.client.util.gui.FastSearchUtil;
import mage.client.util.sets.ConstructedFormats;
import mage.constants.CardType;
import mage.constants.Rarity;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.CardTextPredicate;
import mage.filter.predicate.card.ExpansionSetPredicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.game.events.Listener;
import mage.view.CardView;
import mage.view.CardsView;
import org.apache.log4j.Logger;
import org.mage.card.arcane.ManaSymbolsCellRenderer;

public class CardSelector
extends JPanel
implements ComponentListener,
DragCardTarget {
    private static final Logger logger = Logger.getLogger(CardSelector.class);
    private final String MULTI_SETS_SELECTION_TEXT = "Multiple sets selected";
    private final List<Card> cards = new ArrayList<Card>();
    private BigCard bigCard;
    private boolean limited = false;
    private final SortSetting sortSetting;
    private static final Map<String, Integer> pdAllowed = new HashMap<String, Integer>();
    private static Listener<RepositoryEvent> setsDbListener = null;
    private boolean isSetsFilterLoading = false;
    private final ActionListener searchAction = evt -> this.jButtonSearchActionPerformed(evt);
    private TableModel mainModel;
    private JTable mainTable;
    private ICardGrid currentView;
    private final CheckBoxList listCodeSelected;
    private ButtonGroup bgView;
    private JButton btnBooster;
    private JButton btnClear;
    private JButton btnExpansionSearch;
    private JLabel cardCount;
    private JLabel cardCountLabel;
    private JPanel cardSelectorBottomPanel;
    private JScrollPane cardSelectorScrollPane;
    private JComboBox<String> cbExpansionSet;
    private JComboBox<Constants.SortBy> cbSortBy;
    private JCheckBox chkNames;
    private JCheckBox chkPennyDreadful;
    private JCheckBox chkPiles;
    private JCheckBox chkRules;
    private JCheckBox chkTypes;
    private JCheckBox chkUnique;
    private JButton jButtonAddToMain;
    private JButton jButtonAddToSideboard;
    private JButton jButtonClean;
    private JButton jButtonRemoveFromMain;
    private JButton jButtonRemoveFromSideboard;
    private JButton jButtonSearch;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JTextField jTextFieldSearch;
    private JToggleButton jToggleCardView;
    private JToggleButton jToggleListView;
    private JToggleButton tbArifiacts;
    private JToggleButton tbBlack;
    private JToggleButton tbBlue;
    private JToolBar tbColor;
    private JToggleButton tbColorless;
    private JToggleButton tbCommon;
    private JToggleButton tbCreatures;
    private JToggleButton tbEnchantments;
    private JToggleButton tbGreen;
    private JToggleButton tbInstants;
    private JToggleButton tbLand;
    private JToggleButton tbMythic;
    private JToggleButton tbPlaneswalkers;
    private JToggleButton tbRare;
    private JToolBar tbRarities;
    private JToggleButton tbRed;
    private JToggleButton tbSorceries;
    private JToggleButton tbSpecial;
    private JToolBar tbTypes;
    private JToggleButton tbUncommon;
    private JToggleButton tbWhite;
    private final CardGrid cardGrid;

    public CardSelector() {
        this.sortSetting = SortSettingBase.getInstance();
        this.initComponents();
        this.cardGrid = new CardGrid();
        this.makeTransparent();
        this.initListViewComponents();
        this.setGUISize();
        this.currentView = this.mainModel;
        this.listCodeSelected = new CheckBoxList();
        ArrayList<String> checkboxes = new ArrayList<String>();
        for (String item : ConstructedFormats.getTypes(false)) {
            if (item.equals("- All Sets")) continue;
            checkboxes.add(item);
        }
        this.listCodeSelected.setListData(checkboxes.toArray());
    }

    private void makeTransparent() {
        this.addComponentListener(this);
        this.setOpaque(false);
        this.cardGrid.setOpaque(false);
        this.cardSelectorScrollPane.setOpaque(false);
        this.cardSelectorScrollPane.getViewport().setOpaque(false);
        this.cbSortBy.setModel(new DefaultComboBoxModel<Constants.SortBy>(Constants.SortBy.values()));
        this.cbSortBy.setSelectedItem((Object)this.sortSetting.getSortBy());
        this.jTextFieldSearch.addActionListener(this.searchAction);
        this.tbColor.setBackground(PreferencesDialog.getCurrentTheme().getDeckEditorToolbarBackgroundColor());
        this.tbColor.setOpaque(true);
        this.tbTypes.setBackground(PreferencesDialog.getCurrentTheme().getDeckEditorToolbarBackgroundColor());
        this.tbTypes.setOpaque(true);
        this.cardSelectorBottomPanel.setBackground(PreferencesDialog.getCurrentTheme().getDeckEditorToolbarBackgroundColor());
        this.cardSelectorBottomPanel.setOpaque(true);
    }

    private void initListViewComponents() {
        this.mainTable = new JTable();
        this.mainModel = new TableModel();
        this.mainModel.addListeners(this.mainTable);
        this.mainTable.setModel(this.mainModel);
        this.mainTable.setForeground(Color.white);
        DefaultTableCellRenderer myRenderer = (DefaultTableCellRenderer)this.mainTable.getDefaultRenderer(String.class);
        myRenderer.setBackground(new Color(0, 0, 0, 100));
        this.mainTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.mainTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.mainTable.getColumnModel().getColumn(1).setPreferredWidth(110);
        this.mainTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.mainTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.mainTable.getColumnModel().getColumn(4).setPreferredWidth(170);
        this.mainTable.getColumnModel().getColumn(5).setPreferredWidth(30);
        this.mainTable.getColumnModel().getColumn(6).setPreferredWidth(15);
        this.mainTable.getColumnModel().getColumn(7).setPreferredWidth(15);
        this.mainTable.getColumnModel().getColumn(this.mainModel.COLUMN_INDEX_COST).setCellRenderer(new ManaSymbolsCellRenderer());
        this.mainTable.getColumnModel().getColumn(this.mainModel.COLUMN_INDEX_COLOR_IDENTITY).setCellRenderer(new ManaSymbolsCellRenderer());
        this.cardSelectorScrollPane.setViewportView(this.mainTable);
        this.mainTable.setOpaque(false);
        this.cbSortBy.setEnabled(false);
        this.chkPiles.setEnabled(false);
        this.chkNames.setSelected("true".equals(MageFrame.getPreferences().get("deckEditorSearchNames", "true")));
        this.chkTypes.setSelected("true".equals(MageFrame.getPreferences().get("deckEditorSearchTypes", "true")));
        this.chkRules.setSelected("true".equals(MageFrame.getPreferences().get("deckEditorSearchRules", "true")));
        this.chkUnique.setSelected("true".equals(MageFrame.getPreferences().get("deckEditorSearchUnique", "false")));
        this.mainTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if ((e.getClickCount() & 1) == 0 && e.getClickCount() > 0 && !e.isConsumed()) {
                    e.consume();
                    if (e.isAltDown()) {
                        CardSelector.this.jButtonAddToSideboardActionPerformed(null);
                    } else {
                        CardSelector.this.jButtonAddToMainActionPerformed(null);
                    }
                }
            }
        });
        this.jToggleCardView.setToolTipText(this.jToggleCardView.getToolTipText() + " (works only up to " + 350 + " cards).");
    }

    public void cleanUp() {
        this.cardGrid.clear();
        this.mainModel.clear();
        MageFrame.getPreferences().put("deckEditorSearchNames", Boolean.toString(this.chkNames.isSelected()));
        MageFrame.getPreferences().put("deckEditorSearchRules", Boolean.toString(this.chkRules.isSelected()));
        MageFrame.getPreferences().put("deckEditorSearchTypes", Boolean.toString(this.chkTypes.isSelected()));
        MageFrame.getPreferences().put("deckEditorSearchUnique", Boolean.toString(this.chkUnique.isSelected()));
        ExpansionRepository.instance.unsubscribe(setsDbListener);
    }

    public void changeGUISize() {
        this.setGUISize();
        this.cardGrid.changeGUISize();
        if (this.currentView instanceof CardGrid) {
            this.currentView.drawCards(this.sortSetting);
        }
    }

    private void setGUISize() {
        this.mainTable.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.mainTable.setFont(GUISizeHelper.tableFont);
        this.mainTable.setRowHeight(GUISizeHelper.tableRowHeight);
    }

    public void switchToGrid() {
        this.jToggleListView.setSelected(false);
        this.jToggleCardView.setSelected(true);
        this.currentView = this.cardGrid;
        this.cardSelectorScrollPane.setViewportView(this.cardGrid);
        this.cbSortBy.setEnabled(true);
        this.chkPiles.setEnabled(true);
        this.jButtonAddToMain.setEnabled(false);
        this.jButtonAddToSideboard.setEnabled(false);
        this.filterCards();
        this.chkPiles.setSelected(true);
        this.currentView.drawCards(this.sortSetting);
    }

    public void loadSideboard(List<Card> sideboard, BigCard bigCard) {
        this.bigCard = bigCard;
        this.btnBooster.setVisible(false);
        this.btnClear.setVisible(false);
        this.cbExpansionSet.setVisible(false);
        this.btnExpansionSearch.setVisible(false);
        this.limited = true;
        this.cards.clear();
        this.cards.addAll(sideboard);
        this.filterCards();
    }

    public void loadCards(BigCard bigCard) {
        this.bigCard = bigCard;
        this.btnBooster.setVisible(true);
        this.btnClear.setVisible(true);
        this.cbExpansionSet.setVisible(true);
        this.btnExpansionSearch.setVisible(true);
        try {
            this.isSetsFilterLoading = true;
            this.cbExpansionSet.setSelectedIndex(0);
        }
        finally {
            this.isSetsFilterLoading = false;
        }
        this.filterCards();
    }

    private FilterCard buildFilter() {
        FilterCard filter = new FilterCard();
        String name = this.jTextFieldSearch.getText().trim();
        filter.add(new CardTextPredicate(name, this.chkNames.isSelected(), this.chkTypes.isSelected(), this.chkRules.isSelected(), this.chkUnique.isSelected()));
        if (this.limited) {
            ArrayList<Predicate<MageObject>> predicates = new ArrayList<Predicate<MageObject>>();
            if (this.tbGreen.isSelected()) {
                predicates.add(new ColorPredicate(ObjectColor.GREEN));
            }
            if (this.tbRed.isSelected()) {
                predicates.add(new ColorPredicate(ObjectColor.RED));
            }
            if (this.tbBlack.isSelected()) {
                predicates.add(new ColorPredicate(ObjectColor.BLACK));
            }
            if (this.tbBlue.isSelected()) {
                predicates.add(new ColorPredicate(ObjectColor.BLUE));
            }
            if (this.tbWhite.isSelected()) {
                predicates.add(new ColorPredicate(ObjectColor.WHITE));
            }
            if (this.tbColorless.isSelected()) {
                predicates.add(ColorlessPredicate.instance);
            }
            filter.add(Predicates.or(predicates));
            predicates.clear();
            if (this.tbLand.isSelected()) {
                predicates.add(CardType.LAND.getPredicate());
            }
            if (this.tbArifiacts.isSelected()) {
                predicates.add(CardType.ARTIFACT.getPredicate());
            }
            if (this.tbCreatures.isSelected()) {
                predicates.add(CardType.CREATURE.getPredicate());
            }
            if (this.tbEnchantments.isSelected()) {
                predicates.add(CardType.ENCHANTMENT.getPredicate());
            }
            if (this.tbInstants.isSelected()) {
                predicates.add(CardType.INSTANT.getPredicate());
            }
            if (this.tbSorceries.isSelected()) {
                predicates.add(CardType.SORCERY.getPredicate());
            }
            if (this.tbPlaneswalkers.isSelected()) {
                predicates.add(CardType.PLANESWALKER.getPredicate());
            }
            filter.add(Predicates.or(predicates));
            List<String> filteredSets = this.getFilteredSets();
            if (!filteredSets.isEmpty()) {
                ArrayList<ExpansionSetPredicate> expansionPredicates = new ArrayList<ExpansionSetPredicate>();
                for (String setCode : filteredSets) {
                    expansionPredicates.add(new ExpansionSetPredicate(setCode));
                }
                filter.add(Predicates.or(expansionPredicates));
            }
        }
        return filter;
    }

    private void setSetsSelection(String newSelection) {
        for (int index = 0; index < this.cbExpansionSet.getItemCount(); ++index) {
            if (!this.cbExpansionSet.getItemAt(index).equals(newSelection) || this.cbExpansionSet.getSelectedIndex() == index) continue;
            this.cbExpansionSet.setSelectedIndex(index);
        }
    }

    private List<String> getFilteredSets() {
        ArrayList<String> res = new ArrayList<String>();
        if (!this.cbExpansionSet.isVisible()) {
            return res;
        }
        if (this.listCodeSelected.getCheckedIndices().length <= 1) {
            String expansionSelection = this.cbExpansionSet.getSelectedItem().toString();
            if (!expansionSelection.equals("- All Sets") && !expansionSelection.startsWith("Multiple sets selected")) {
                res.addAll(ConstructedFormats.getSetsByFormat(expansionSelection));
            }
        } else {
            int[] choiseValue = this.listCodeSelected.getCheckedIndices();
            ListModel x = this.listCodeSelected.getModel();
            for (int itemIndex : choiseValue) {
                List<String> listReceived = ConstructedFormats.getSetsByFormat(x.getElementAt(itemIndex).toString());
                listReceived.stream().filter(item -> !res.contains(item)).forEachOrdered(res::add);
            }
        }
        return res;
    }

    private CardCriteria buildCriteria() {
        List<String> filteredSets;
        CardCriteria criteria = new CardCriteria();
        criteria.black(this.tbBlack.isSelected());
        criteria.blue(this.tbBlue.isSelected());
        criteria.green(this.tbGreen.isSelected());
        criteria.red(this.tbRed.isSelected());
        criteria.white(this.tbWhite.isSelected());
        criteria.colorless(this.tbColorless.isSelected());
        if (this.tbLand.isSelected()) {
            criteria.types(CardType.LAND);
        }
        if (this.tbArifiacts.isSelected()) {
            criteria.types(CardType.ARTIFACT);
        }
        if (this.tbCreatures.isSelected()) {
            criteria.types(CardType.CREATURE);
        }
        if (this.tbEnchantments.isSelected()) {
            criteria.types(CardType.ENCHANTMENT);
        }
        if (this.tbInstants.isSelected()) {
            criteria.types(CardType.INSTANT);
        }
        if (this.tbSorceries.isSelected()) {
            criteria.types(CardType.SORCERY);
        }
        if (this.tbPlaneswalkers.isSelected()) {
            criteria.types(CardType.PLANESWALKER);
        }
        if (this.tbCommon.isSelected()) {
            criteria.rarities(Rarity.COMMON);
            criteria.rarities(Rarity.LAND);
        }
        if (this.tbUncommon.isSelected()) {
            criteria.rarities(Rarity.UNCOMMON);
        }
        if (this.tbRare.isSelected()) {
            criteria.rarities(Rarity.RARE);
        }
        if (this.tbMythic.isSelected()) {
            criteria.rarities(Rarity.MYTHIC);
        }
        if (this.tbSpecial.isSelected()) {
            criteria.rarities(Rarity.SPECIAL);
            criteria.rarities(Rarity.BONUS);
        }
        if (!(filteredSets = this.getFilteredSets()).isEmpty()) {
            criteria.setCodes(filteredSets.toArray(new String[0]));
        }
        return criteria;
    }

    private boolean inverter(boolean invert, String string1, String string2) {
        if (invert) {
            return string1.equals(string2);
        }
        return !string1.equals(string2);
    }

    private void filterCardsColor(int modifiers, String actionCommand) {
        if ((modifiers & 8) == 8 || (modifiers & 2) == 2) {
            boolean invert = (modifiers & 8) == 8;
            this.tbBlack.setSelected(this.inverter(invert, this.tbBlack.getActionCommand(), actionCommand));
            this.tbBlue.setSelected(this.inverter(invert, this.tbBlue.getActionCommand(), actionCommand));
            this.tbColorless.setSelected(this.inverter(invert, this.tbColorless.getActionCommand(), actionCommand));
            this.tbGreen.setSelected(this.inverter(invert, this.tbGreen.getActionCommand(), actionCommand));
            this.tbRed.setSelected(this.inverter(invert, this.tbRed.getActionCommand(), actionCommand));
            this.tbWhite.setSelected(this.inverter(invert, this.tbWhite.getActionCommand(), actionCommand));
        }
        this.filterCards();
    }

    private void filterCardsType(int modifiers, String actionCommand) {
        if ((modifiers & 8) == 8 || (modifiers & 2) == 2) {
            boolean invert = (modifiers & 8) == 8;
            this.tbArifiacts.setSelected(this.inverter(invert, this.tbArifiacts.getActionCommand(), actionCommand));
            this.tbCreatures.setSelected(this.inverter(invert, this.tbCreatures.getActionCommand(), actionCommand));
            this.tbEnchantments.setSelected(this.inverter(invert, this.tbEnchantments.getActionCommand(), actionCommand));
            this.tbInstants.setSelected(this.inverter(invert, this.tbInstants.getActionCommand(), actionCommand));
            this.tbLand.setSelected(this.inverter(invert, this.tbLand.getActionCommand(), actionCommand));
            this.tbPlaneswalkers.setSelected(this.inverter(invert, this.tbPlaneswalkers.getActionCommand(), actionCommand));
            this.tbSorceries.setSelected(this.inverter(invert, this.tbSorceries.getActionCommand(), actionCommand));
        }
        this.filterCards();
    }

    private void filterCardsRarity(int modifiers, String actionCommand) {
        if ((modifiers & 8) == 8 || (modifiers & 2) == 2) {
            boolean invert = (modifiers & 8) == 8;
            this.tbCommon.setSelected(this.inverter(invert, this.tbCommon.getActionCommand(), actionCommand));
            this.tbUncommon.setSelected(this.inverter(invert, this.tbUncommon.getActionCommand(), actionCommand));
            this.tbRare.setSelected(this.inverter(invert, this.tbRare.getActionCommand(), actionCommand));
            this.tbMythic.setSelected(this.inverter(invert, this.tbMythic.getActionCommand(), actionCommand));
            this.tbSpecial.setSelected(this.inverter(invert, this.tbSpecial.getActionCommand(), actionCommand));
        }
        this.filterCards();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterCards() {
        FilterCard filter = this.buildFilter();
        MageFrame.getDesktop().setCursor(new Cursor(3));
        try {
            this.currentView.clearCardsStoreBeforeUpdate();
            ArrayList<Card> filteredCards = new ArrayList<Card>();
            if (this.chkPennyDreadful.isSelected() && pdAllowed.isEmpty()) {
                pdAllowed.putAll(PennyDreadfulLegalityUtil.getLegalCardList());
            }
            if (this.limited) {
                for (Card card : this.cards) {
                    if (!filter.match(card, (Game)null)) continue;
                    filteredCards.add(card);
                }
            } else {
                List<CardInfo> foundCards = CardRepository.instance.findCards(this.buildCriteria());
                for (CardInfo cardInfo : foundCards) {
                    Card card;
                    if (this.chkPennyDreadful.isSelected() && !pdAllowed.containsKey(cardInfo.getName()) || !filter.match(card = cardInfo.createMockCard(), (Game)null)) continue;
                    filteredCards.add(card);
                }
            }
            if (this.currentView instanceof CardGrid && filteredCards.size() > 350) {
                this.toggleViewMode();
            }
            this.currentView.loadCards(new CardsView(filteredCards), this.sortSetting, this.bigCard, null, false);
            this.cardCount.setText(String.valueOf(filteredCards.size()));
        }
        finally {
            MageFrame.getDesktop().setCursor(new Cursor(0));
        }
    }

    private void debugObjectMemorySize(String name, Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            logger.info((Object)(name + ": " + baos.size()));
        }
        catch (Throwable e) {
            logger.fatal((Object)("Can't find object size: " + e.getMessage()), e);
        }
    }

    public void setCardCount(int value) {
        this.cardCount.setText(String.valueOf(value));
    }

    public List<ICardGrid> getCardGridComponents() {
        ArrayList<ICardGrid> components = new ArrayList<ICardGrid>();
        components.add(this.mainModel);
        components.add(this.cardGrid);
        return components;
    }

    public void removeCard(UUID cardId) {
        this.mainModel.removeCard(cardId);
        this.cardGrid.removeCard(cardId);
        for (Card card : this.cards) {
            if (!card.getId().equals(cardId)) continue;
            this.cards.remove(card);
            break;
        }
    }

    private void reloadSetsCombobox() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(ConstructedFormats.getTypes(false).toArray());
        this.cbExpansionSet.setModel(model);
    }

    private void initComponents() {
        this.bgView = new ButtonGroup();
        this.tbColor = new JToolBar();
        this.tbRed = new JToggleButton();
        this.tbGreen = new JToggleButton();
        this.tbBlue = new JToggleButton();
        this.tbBlack = new JToggleButton();
        this.tbWhite = new JToggleButton();
        this.tbColorless = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.cbExpansionSet = new JComboBox();
        this.btnExpansionSearch = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.chkPennyDreadful = new JCheckBox();
        this.btnBooster = new JButton();
        this.btnClear = new JButton();
        this.tbTypes = new JToolBar();
        this.tbLand = new JToggleButton();
        this.tbCreatures = new JToggleButton();
        this.tbArifiacts = new JToggleButton();
        this.tbSorceries = new JToggleButton();
        this.tbInstants = new JToggleButton();
        this.tbEnchantments = new JToggleButton();
        this.tbPlaneswalkers = new JToggleButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.chkPiles = new JCheckBox();
        this.jSeparator3 = new JToolBar.Separator();
        this.cbSortBy = new JComboBox();
        this.jSeparator4 = new JToolBar.Separator();
        this.jToggleListView = new JToggleButton();
        this.jToggleCardView = new JToggleButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.tbRarities = new JToolBar();
        this.tbCommon = new JToggleButton();
        this.tbUncommon = new JToggleButton();
        this.tbRare = new JToggleButton();
        this.tbMythic = new JToggleButton();
        this.tbSpecial = new JToggleButton();
        this.cardSelectorScrollPane = new JScrollPane();
        this.cardSelectorBottomPanel = new JPanel();
        this.jButtonAddToMain = new JButton();
        this.jButtonRemoveFromMain = new JButton();
        this.jButtonAddToSideboard = new JButton();
        this.jButtonRemoveFromSideboard = new JButton();
        this.jTextFieldSearch = new JTextField();
        this.chkNames = new JCheckBox();
        this.chkTypes = new JCheckBox();
        this.chkRules = new JCheckBox();
        this.chkUnique = new JCheckBox();
        this.jButtonSearch = new JButton();
        this.jButtonClean = new JButton();
        this.cardCountLabel = new JLabel();
        this.cardCount = new JLabel();
        this.tbColor.setFloatable(false);
        this.tbColor.setRollover(true);
        this.tbColor.setToolTipText("Hold the ALT-key while clicking to deselect all other colors or hold the CTRL-key to select only all other colors.");
        this.tbColor.setBorderPainted(false);
        this.tbColor.setName("");
        this.tbRed.setIcon(new ImageIcon(this.getClass().getResource("/buttons/color_red_off.png")));
        this.tbRed.setSelected(true);
        this.tbRed.setToolTipText("<html><font color='red'><strong>Red</strong></font><br/>" + this.tbColor.getToolTipText());
        this.tbRed.setActionCommand("Red");
        this.tbRed.setFocusable(false);
        this.tbRed.setHorizontalTextPosition(0);
        this.tbRed.setSelectedIcon(new ImageIcon(this.getClass().getResource("/buttons/color_red.png")));
        this.tbRed.setVerticalTextPosition(3);
        this.tbRed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbRedActionPerformed(evt);
            }
        });
        this.tbColor.add(this.tbRed);
        this.tbGreen.setIcon(new ImageIcon(this.getClass().getResource("/buttons/color_green_off.png")));
        this.tbGreen.setSelected(true);
        this.tbGreen.setToolTipText("<html><font color='Green'><strong>Green</strong></font><br/>" + this.tbColor.getToolTipText());
        this.tbGreen.setActionCommand("Green");
        this.tbGreen.setFocusable(false);
        this.tbGreen.setHorizontalTextPosition(0);
        this.tbGreen.setSelectedIcon(new ImageIcon(this.getClass().getResource("/buttons/color_green.png")));
        this.tbGreen.setVerifyInputWhenFocusTarget(false);
        this.tbGreen.setVerticalTextPosition(3);
        this.tbGreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbGreenActionPerformed(evt);
            }
        });
        this.tbColor.add(this.tbGreen);
        this.tbBlue.setIcon(new ImageIcon(this.getClass().getResource("/buttons/color_blueOff.png")));
        this.tbBlue.setSelected(true);
        this.tbBlue.setToolTipText("<html><font color='blue'><strong>Blue</strong></font><br/>" + this.tbColor.getToolTipText());
        this.tbBlue.setActionCommand("Blue");
        this.tbBlue.setFocusable(false);
        this.tbBlue.setHorizontalTextPosition(0);
        this.tbBlue.setSelectedIcon(new ImageIcon(this.getClass().getResource("/buttons/color_blue.png")));
        this.tbBlue.setVerticalTextPosition(3);
        this.tbBlue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbBlueActionPerformed(evt);
            }
        });
        this.tbColor.add(this.tbBlue);
        this.tbBlack.setIcon(new ImageIcon(this.getClass().getResource("/buttons/color_black_off.png")));
        this.tbBlack.setSelected(true);
        this.tbBlack.setToolTipText("<html><font color='black'><strong>Black</strong></font><br/>" + this.tbColor.getToolTipText());
        this.tbBlack.setActionCommand("Black");
        this.tbBlack.setFocusable(false);
        this.tbBlack.setHorizontalTextPosition(0);
        this.tbBlack.setSelectedIcon(new ImageIcon(this.getClass().getResource("/buttons/color_black.png")));
        this.tbBlack.setVerticalTextPosition(3);
        this.tbBlack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbBlackActionPerformed(evt);
            }
        });
        this.tbColor.add(this.tbBlack);
        this.tbWhite.setIcon(new ImageIcon(this.getClass().getResource("/buttons/color_white_off.png")));
        this.tbWhite.setSelected(true);
        this.tbWhite.setToolTipText("<html><font color='grey'><strong>White</strong></font><br/>" + this.tbColor.getToolTipText());
        this.tbWhite.setActionCommand("White");
        this.tbWhite.setFocusable(false);
        this.tbWhite.setHorizontalTextPosition(0);
        this.tbWhite.setSelectedIcon(new ImageIcon(this.getClass().getResource("/buttons/color_white.png")));
        this.tbWhite.setVerticalTextPosition(3);
        this.tbWhite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbWhiteActionPerformed(evt);
            }
        });
        this.tbColor.add(this.tbWhite);
        this.tbColorless.setIcon(new ImageIcon(this.getClass().getResource("/buttons/colorless_off.png")));
        this.tbColorless.setSelected(true);
        this.tbColorless.setToolTipText("<html>Colorless<br/>" + this.tbColor.getToolTipText());
        this.tbColorless.setActionCommand("Colorless");
        this.tbColorless.setFocusable(false);
        this.tbColorless.setHorizontalTextPosition(0);
        this.tbColorless.setSelectedIcon(new ImageIcon(this.getClass().getResource("/buttons/colorless.png")));
        this.tbColorless.setVerticalTextPosition(3);
        this.tbColorless.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbColorlessActionPerformed(evt);
            }
        });
        this.tbColor.add(this.tbColorless);
        this.tbColor.add(this.jSeparator1);
        this.reloadSetsCombobox();
        this.cbExpansionSet.setMaximumSize(new Dimension(250, 25));
        this.cbExpansionSet.setMinimumSize(new Dimension(250, 25));
        this.cbExpansionSet.setName("cbExpansionSet");
        this.cbExpansionSet.setPreferredSize(new Dimension(250, 25));
        this.cbExpansionSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.cbExpansionSetActionPerformed(evt);
            }
        });
        setsDbListener = new Listener<RepositoryEvent>(){

            @Override
            public void event(RepositoryEvent event) {
                if (event.getEventType().equals((Object)RepositoryEvent.RepositoryEventType.DB_UPDATED)) {
                    CardSelector.this.reloadSetsCombobox();
                }
            }
        };
        ExpansionRepository.instance.subscribe(setsDbListener);
        this.tbColor.add(this.cbExpansionSet);
        this.btnExpansionSearch.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_32.png")));
        this.btnExpansionSearch.setToolTipText("Fast search set or expansion");
        this.btnExpansionSearch.setAlignmentX(1.0f);
        this.btnExpansionSearch.setFocusable(false);
        this.btnExpansionSearch.setHorizontalTextPosition(0);
        this.btnExpansionSearch.setPreferredSize(new Dimension(23, 23));
        this.btnExpansionSearch.setVerticalTextPosition(3);
        this.btnExpansionSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.btnExpansionSearchActionPerformed(evt);
            }
        });
        this.tbColor.add(this.btnExpansionSearch);
        this.tbColor.add(this.jSeparator2);
        this.chkPennyDreadful.setText("Penny Dreadful Only");
        this.chkPennyDreadful.setToolTipText("Will only allow Penny Dreadful legal cards to be shown.");
        this.chkPennyDreadful.setFocusable(false);
        this.chkPennyDreadful.setHorizontalTextPosition(4);
        this.chkPennyDreadful.setVerticalTextPosition(3);
        this.chkPennyDreadful.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.chkPilesActionPerformed(evt);
            }
        });
        this.tbColor.add(this.chkPennyDreadful);
        this.btnBooster.setText("Open Booster");
        this.btnBooster.setToolTipText("Generates a booster of the selected set and adds the cards to the card selector.");
        this.btnBooster.setFocusable(false);
        this.btnBooster.setHorizontalTextPosition(0);
        this.btnBooster.setVerticalTextPosition(3);
        this.btnBooster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.btnBoosterActionPerformed(evt);
            }
        });
        this.tbColor.add(this.btnBooster);
        this.btnClear.setText("Clear");
        this.btnClear.setFocusable(false);
        this.btnClear.setHorizontalTextPosition(0);
        this.btnClear.setVerticalTextPosition(3);
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.btnClearActionPerformed(evt);
            }
        });
        this.tbColor.add(this.btnClear);
        this.tbTypes.setFloatable(false);
        this.tbTypes.setRollover(true);
        this.tbTypes.setToolTipText("Hold the ALT-key while clicking to deselect all other card types or hold the CTRL-key to only select all other card types.");
        this.tbTypes.setPreferredSize(new Dimension(732, 27));
        this.tbLand.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_land.png")));
        this.tbLand.setSelected(true);
        this.tbLand.setToolTipText("<html><strong>Land</strong><br/>" + this.tbTypes.getToolTipText());
        this.tbLand.setActionCommand("Lands");
        this.tbLand.setFocusable(false);
        this.tbLand.setHorizontalTextPosition(0);
        this.tbLand.setVerticalTextPosition(3);
        this.tbLand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbLandActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.tbLand);
        this.tbCreatures.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_creatures.png")));
        this.tbCreatures.setSelected(true);
        this.tbCreatures.setToolTipText("<html><strong>Creatures</strong><br/>" + this.tbTypes.getToolTipText());
        this.tbCreatures.setActionCommand("Creatures");
        this.tbCreatures.setFocusable(false);
        this.tbCreatures.setHorizontalTextPosition(0);
        this.tbCreatures.setVerticalTextPosition(3);
        this.tbCreatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbCreaturesActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.tbCreatures);
        this.tbArifiacts.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_artifact.png")));
        this.tbArifiacts.setSelected(true);
        this.tbArifiacts.setToolTipText("<html><strong>Artifacts</strong><br/>" + this.tbTypes.getToolTipText());
        this.tbArifiacts.setActionCommand("Artifacts");
        this.tbArifiacts.setFocusable(false);
        this.tbArifiacts.setHorizontalTextPosition(0);
        this.tbArifiacts.setVerticalTextPosition(3);
        this.tbArifiacts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbArifiactsActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.tbArifiacts);
        this.tbSorceries.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_sorcery.png")));
        this.tbSorceries.setSelected(true);
        this.tbSorceries.setToolTipText("<html><strong>Sorceries</strong><br/>" + this.tbTypes.getToolTipText());
        this.tbSorceries.setActionCommand("Soceries");
        this.tbSorceries.setFocusable(false);
        this.tbSorceries.setHorizontalTextPosition(0);
        this.tbSorceries.setVerticalTextPosition(3);
        this.tbSorceries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbSorceriesActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.tbSorceries);
        this.tbInstants.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_instant.png")));
        this.tbInstants.setSelected(true);
        this.tbInstants.setToolTipText("<html><strong>Instants</strong><br/>" + this.tbTypes.getToolTipText());
        this.tbInstants.setActionCommand("Instants");
        this.tbInstants.setFocusable(false);
        this.tbInstants.setHorizontalTextPosition(0);
        this.tbInstants.setVerticalTextPosition(3);
        this.tbInstants.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbInstantsActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.tbInstants);
        this.tbEnchantments.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_enchantment.png")));
        this.tbEnchantments.setSelected(true);
        this.tbEnchantments.setToolTipText("<html><strong>Enchantments</strong><br/>" + this.tbTypes.getToolTipText());
        this.tbEnchantments.setActionCommand("Enchantments");
        this.tbEnchantments.setFocusable(false);
        this.tbEnchantments.setHorizontalTextPosition(0);
        this.tbEnchantments.setVerticalTextPosition(3);
        this.tbEnchantments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbEnchantmentsActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.tbEnchantments);
        this.tbPlaneswalkers.setIcon(new ImageIcon(this.getClass().getResource("/buttons/type_planeswalker.png")));
        this.tbPlaneswalkers.setSelected(true);
        this.tbPlaneswalkers.setToolTipText("<html><strong>Planeswalker</strong><br/>" + this.tbTypes.getToolTipText());
        this.tbPlaneswalkers.setActionCommand("Planeswalkers");
        this.tbPlaneswalkers.setFocusable(false);
        this.tbPlaneswalkers.setHorizontalTextPosition(0);
        this.tbPlaneswalkers.setVerticalTextPosition(3);
        this.tbPlaneswalkers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbPlaneswalkersActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.tbPlaneswalkers);
        this.tbTypes.add(this.jSeparator6);
        this.chkPiles.setText("Piles");
        this.chkPiles.setToolTipText("Shows the card in piles by the selected sort.");
        this.chkPiles.setFocusable(false);
        this.chkPiles.setHorizontalTextPosition(4);
        this.chkPiles.setVerticalTextPosition(3);
        this.chkPiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.chkPilesActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.chkPiles);
        this.tbTypes.add(this.jSeparator3);
        this.cbSortBy.setMaximumSize(new Dimension(120, 20));
        this.cbSortBy.setMinimumSize(new Dimension(120, 20));
        this.cbSortBy.setPreferredSize(new Dimension(120, 20));
        this.cbSortBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.cbSortByActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.cbSortBy);
        this.tbTypes.add(this.jSeparator4);
        this.bgView.add(this.jToggleListView);
        this.jToggleListView.setIcon(new ImageIcon(this.getClass().getResource("/buttons/list_panel.png")));
        this.jToggleListView.setSelected(true);
        this.jToggleListView.setToolTipText("Shows the cards as a list.");
        this.jToggleListView.setBorderPainted(false);
        this.jToggleListView.setFocusable(false);
        this.jToggleListView.setHorizontalTextPosition(0);
        this.jToggleListView.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleListView.setMaximumSize(new Dimension(37, 22));
        this.jToggleListView.setMinimumSize(new Dimension(37, 22));
        this.jToggleListView.setPreferredSize(new Dimension(37, 22));
        this.jToggleListView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jToggleListViewActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.jToggleListView);
        this.bgView.add(this.jToggleCardView);
        this.jToggleCardView.setIcon(new ImageIcon(this.getClass().getResource("/buttons/card_panel.png")));
        this.jToggleCardView.setToolTipText("Shows the card as images.");
        this.jToggleCardView.setBorderPainted(false);
        this.jToggleCardView.setFocusable(false);
        this.jToggleCardView.setHorizontalTextPosition(0);
        this.jToggleCardView.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleCardView.setMaximumSize(new Dimension(37, 22));
        this.jToggleCardView.setMinimumSize(new Dimension(37, 22));
        this.jToggleCardView.setName("");
        this.jToggleCardView.setPreferredSize(new Dimension(37, 22));
        this.jToggleCardView.setVerticalTextPosition(3);
        this.jToggleCardView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jToggleCardViewActionPerformed(evt);
            }
        });
        this.tbTypes.add(this.jToggleCardView);
        this.tbTypes.add(this.jSeparator5);
        this.tbRarities.setFloatable(false);
        this.tbRarities.setRollover(true);
        this.tbRarities.setToolTipText("Hold the ALT-key while clicking to deselect all other card rarities or hold the CTRL-key to only select all other card rarities.");
        this.tbCommon.setIcon(new ImageIcon(this.getClass().getResource("/buttons/rarity_common_20.png")));
        this.tbCommon.setSelected(true);
        this.tbCommon.setToolTipText("<html><strong>Common</strong><br/>" + this.tbRarities.getToolTipText());
        this.tbCommon.setActionCommand("Common");
        this.tbCommon.setFocusable(false);
        this.tbCommon.setHorizontalTextPosition(0);
        this.tbCommon.setVerticalTextPosition(3);
        this.tbCommon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbCommonActionPerformed(evt);
            }
        });
        this.tbRarities.add(this.tbCommon);
        this.tbUncommon.setIcon(new ImageIcon(this.getClass().getResource("/buttons/rarity_uncommon_20.png")));
        this.tbUncommon.setSelected(true);
        this.tbUncommon.setToolTipText("<html><strong>Uncommon</strong><br/>" + this.tbRarities.getToolTipText());
        this.tbUncommon.setActionCommand("Uncommon");
        this.tbUncommon.setFocusable(false);
        this.tbUncommon.setHorizontalTextPosition(0);
        this.tbUncommon.setVerticalTextPosition(3);
        this.tbUncommon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbUncommonActionPerformed(evt);
            }
        });
        this.tbRarities.add(this.tbUncommon);
        this.tbRare.setIcon(new ImageIcon(this.getClass().getResource("/buttons/rarity_rare_20.png")));
        this.tbRare.setSelected(true);
        this.tbRare.setToolTipText("<html><strong>Rare</strong><br/>" + this.tbRarities.getToolTipText());
        this.tbRare.setActionCommand("Rare");
        this.tbRare.setFocusable(false);
        this.tbRare.setHorizontalTextPosition(0);
        this.tbRare.setVerticalTextPosition(3);
        this.tbRare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbRareActionPerformed(evt);
            }
        });
        this.tbRarities.add(this.tbRare);
        this.tbMythic.setIcon(new ImageIcon(this.getClass().getResource("/buttons/rarity_mythic_20.png")));
        this.tbMythic.setSelected(true);
        this.tbMythic.setToolTipText("<html><strong>Mythic</strong><br/>" + this.tbRarities.getToolTipText());
        this.tbMythic.setActionCommand("Mythic");
        this.tbMythic.setFocusable(false);
        this.tbMythic.setHorizontalTextPosition(0);
        this.tbMythic.setVerticalTextPosition(3);
        this.tbMythic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbMythicActionPerformed(evt);
            }
        });
        this.tbRarities.add(this.tbMythic);
        this.tbSpecial.setIcon(new ImageIcon(this.getClass().getResource("/buttons/rarity_special_20.png")));
        this.tbSpecial.setSelected(true);
        this.tbSpecial.setToolTipText("<html><strong>Special</strong><br/>" + this.tbRarities.getToolTipText());
        this.tbSpecial.setActionCommand("Special");
        this.tbSpecial.setFocusable(false);
        this.tbSpecial.setHorizontalTextPosition(0);
        this.tbSpecial.setVerticalTextPosition(3);
        this.tbSpecial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.tbSpecialActionPerformed(evt);
            }
        });
        this.tbRarities.add(this.tbSpecial);
        this.tbTypes.add(this.tbRarities);
        this.cardSelectorScrollPane.setToolTipText("<HTML>Double click to add the card to the main deck.<br/>\nALT + Double click to add the card to the sideboard.");
        this.cardSelectorBottomPanel.setOpaque(false);
        this.cardSelectorBottomPanel.setPreferredSize(new Dimension(897, 40));
        this.jButtonAddToMain.setIcon(new ImageIcon(this.getClass().getResource("/buttons/deck_in.png")));
        this.jButtonAddToMain.setToolTipText("<html>Add selected cards to deck.<br/>\nAlternative: <strong>Double click</strong> the card in card selector to move a card to the deck.");
        this.jButtonAddToMain.setMargin(null);
        this.jButtonAddToMain.setMaximumSize(new Dimension(35, 23));
        this.jButtonAddToMain.setMinimumSize(new Dimension(35, 23));
        this.jButtonAddToMain.setPreferredSize(new Dimension(30, 28));
        this.jButtonAddToMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jButtonAddToMainActionPerformed(evt);
            }
        });
        this.jButtonRemoveFromMain.setIcon(new ImageIcon(this.getClass().getResource("/buttons/deck_out.png")));
        this.jButtonRemoveFromMain.setToolTipText("Remove selected cards from deck");
        this.jButtonRemoveFromMain.setMargin(null);
        this.jButtonRemoveFromMain.setMaximumSize(new Dimension(42, 23));
        this.jButtonRemoveFromMain.setMinimumSize(new Dimension(42, 23));
        this.jButtonRemoveFromMain.setPreferredSize(new Dimension(30, 28));
        this.jButtonRemoveFromMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jButtonRemoveFromMainActionPerformed(evt);
            }
        });
        this.jButtonAddToSideboard.setIcon(new ImageIcon(this.getClass().getResource("/buttons/sideboard_in.png")));
        this.jButtonAddToSideboard.setToolTipText("<html>Add selected cards to sideboard.<br/>\nAlternative: <strong>ALT key + Double click</strong> the card in card selector to move a card to the sideboard.");
        this.jButtonAddToSideboard.setMargin(new Insets(2, 0, 2, 0));
        this.jButtonAddToSideboard.setMaximumSize(new Dimension(100, 30));
        this.jButtonAddToSideboard.setMinimumSize(new Dimension(10, 30));
        this.jButtonAddToSideboard.setPreferredSize(new Dimension(30, 28));
        this.jButtonAddToSideboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jButtonAddToSideboardActionPerformed(evt);
            }
        });
        this.jButtonRemoveFromSideboard.setIcon(new ImageIcon(this.getClass().getResource("/buttons/sideboard_out.png")));
        this.jButtonRemoveFromSideboard.setToolTipText("Remove selected cards from sideboard.");
        this.jButtonRemoveFromSideboard.setMargin(new Insets(2, 0, 2, 0));
        this.jButtonRemoveFromSideboard.setMaximumSize(new Dimension(10, 30));
        this.jButtonRemoveFromSideboard.setMinimumSize(new Dimension(100, 30));
        this.jButtonRemoveFromSideboard.setPreferredSize(new Dimension(30, 28));
        this.jButtonRemoveFromSideboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jButtonRemoveFromSideboardActionPerformed(evt);
            }
        });
        this.jTextFieldSearch.setToolTipText("Search cards by any data like name or mana symbols like {W}, {U}, {C}, etc (use quotes for exact search)");
        this.chkNames.setSelected(true);
        this.chkNames.setText("Names");
        this.chkNames.setToolTipText("Search in card names.");
        this.chkNames.setFocusable(false);
        this.chkNames.setHorizontalTextPosition(4);
        this.chkNames.setMaximumSize(new Dimension(67, 16));
        this.chkNames.setMinimumSize(new Dimension(67, 16));
        this.chkNames.setPreferredSize(new Dimension(67, 16));
        this.chkNames.setVerticalTextPosition(3);
        this.chkNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.chkNamesActionPerformed(evt);
            }
        });
        this.chkTypes.setSelected(true);
        this.chkTypes.setText("Types");
        this.chkTypes.setToolTipText("Search in card types.");
        this.chkTypes.setFocusable(false);
        this.chkTypes.setHorizontalTextPosition(4);
        this.chkTypes.setMaximumSize(new Dimension(63, 16));
        this.chkTypes.setMinimumSize(new Dimension(63, 16));
        this.chkTypes.setPreferredSize(new Dimension(63, 16));
        this.chkTypes.setVerticalTextPosition(3);
        this.chkTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.chkTypesActionPerformed(evt);
            }
        });
        this.chkRules.setSelected(true);
        this.chkRules.setText("Rules");
        this.chkRules.setToolTipText("Search in card rules.");
        this.chkRules.setFocusable(false);
        this.chkRules.setHorizontalTextPosition(4);
        this.chkRules.setMaximumSize(new Dimension(59, 16));
        this.chkRules.setMinimumSize(new Dimension(59, 16));
        this.chkRules.setPreferredSize(new Dimension(59, 16));
        this.chkRules.setVerticalTextPosition(3);
        this.chkRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.chkRulesActionPerformed(evt);
            }
        });
        this.chkUnique.setSelected(false);
        this.chkUnique.setText("Unique");
        this.chkUnique.setToolTipText("Show only the first found card of every card name.");
        this.chkUnique.setFocusable(false);
        this.chkUnique.setHorizontalTextPosition(4);
        this.chkUnique.setMaximumSize(new Dimension(69, 16));
        this.chkUnique.setMinimumSize(new Dimension(69, 16));
        this.chkUnique.setPreferredSize(new Dimension(69, 16));
        this.chkUnique.setVerticalTextPosition(3);
        this.chkUnique.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.chkUniqueActionPerformed(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.setToolTipText("Performs the search.");
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClean.setText("Clear");
        this.jButtonClean.setToolTipText("Clears the search field.");
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardSelector.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.cardCountLabel.setText("Card count:");
        this.cardCountLabel.setToolTipText("Number of cards currently shown.");
        this.cardCount.setText("0");
        GroupLayout cardSelectorBottomPanelLayout = new GroupLayout(this.cardSelectorBottomPanel);
        this.cardSelectorBottomPanel.setLayout(cardSelectorBottomPanelLayout);
        cardSelectorBottomPanelLayout.setHorizontalGroup(cardSelectorBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cardSelectorBottomPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jButtonAddToMain, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jButtonRemoveFromMain, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jButtonAddToSideboard, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jButtonRemoveFromSideboard, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSearch, -2, 219, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClean).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkNames, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkTypes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkRules, -2, -1, -2).addGap(5, 5, 5).addComponent(this.chkUnique, -2, -1, -2).addGap(5, 5, 5).addComponent(this.cardCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cardCount, -2, 48, -2).addContainerGap(-1, Short.MAX_VALUE)));
        cardSelectorBottomPanelLayout.setVerticalGroup(cardSelectorBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cardSelectorBottomPanelLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(cardSelectorBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkTypes, -1, -1, Short.MAX_VALUE).addComponent(this.chkRules, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.chkUnique, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.chkNames, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(cardSelectorBottomPanelLayout.createSequentialGroup().addGroup(cardSelectorBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonRemoveFromMain, -2, -1, -2).addComponent(this.jButtonAddToSideboard, -2, -1, -2).addComponent(this.jButtonRemoveFromSideboard, -2, -1, -2).addGroup(cardSelectorBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSearch, -2, -1, -2).addComponent(this.jButtonSearch).addComponent(this.jButtonClean).addComponent(this.cardCount).addComponent(this.jButtonAddToMain, -1, -1, -2).addComponent(this.cardCountLabel))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.cardCountLabel.getAccessibleContext().setAccessibleName("cardCountLabel");
        this.cardCount.getAccessibleContext().setAccessibleName("cardCount");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbColor, -1, -1, Short.MAX_VALUE).addComponent(this.tbTypes, -1, 1057, Short.MAX_VALUE).addComponent(this.cardSelectorScrollPane).addComponent(this.cardSelectorBottomPanel, -1, 1057, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tbColor, -2, -1, -2).addGap(0, 0, 0).addComponent(this.tbTypes, -2, -1, -2).addGap(0, 0, 0).addComponent(this.cardSelectorScrollPane, -1, 237, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.cardSelectorBottomPanel, -2, 31, -2)));
    }

    private void cbExpansionSetActionPerformed(ActionEvent evt) {
        if (this.isSetsFilterLoading) {
            return;
        }
        if (!this.cbExpansionSet.getSelectedItem().toString().startsWith("Multiple sets selected")) {
            int currentSelection = this.cbExpansionSet.getSelectedIndex();
            this.isSetsFilterLoading = true;
            try {
                if (this.cbExpansionSet.getItemAt(0).startsWith("Multiple sets selected")) {
                    this.cbExpansionSet.removeItemAt(0);
                    currentSelection = Math.max(0, currentSelection - 1);
                }
            }
            finally {
                this.isSetsFilterLoading = false;
            }
            this.listCodeSelected.uncheckAll();
            if (currentSelection > 0) {
                this.listCodeSelected.setChecked(currentSelection - 1, true);
            }
        }
        this.filterCards();
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.cards.clear();
        this.limited = false;
        this.filterCards();
    }

    private void btnBoosterActionPerformed(ActionEvent evt) {
        List<String> sets = this.getFilteredSets();
        if (sets.size() == 1) {
            ExpansionSet expansionSet;
            if (!this.limited) {
                this.limited = true;
                this.cards.clear();
            }
            if ((expansionSet = (ExpansionSet)Sets.getInstance().get(sets.get(0))) != null) {
                List<Card> booster = expansionSet.createBooster();
                this.cards.addAll(booster);
                this.filterCards();
            }
        } else {
            MageFrame.getInstance().showMessage("An expansion set must be selected to be able to generate a booster.");
        }
    }

    private void cbSortByActionPerformed(ActionEvent evt) {
        if (this.cbSortBy.getSelectedItem() instanceof Constants.SortBy && this.currentView != null) {
            this.sortSetting.setSortBy((Constants.SortBy)((Object)this.cbSortBy.getSelectedItem()));
            this.currentView.drawCards(this.sortSetting);
        }
    }

    private void chkPilesActionPerformed(ActionEvent evt) {
        if (this.cbSortBy.getSelectedItem() instanceof Constants.SortBy && this.currentView != null) {
            this.sortSetting.setPilesToggle(this.chkPiles.isSelected());
            this.currentView.drawCards(this.sortSetting);
        }
    }

    private void jToggleListViewActionPerformed(ActionEvent evt) {
        if (!(this.currentView instanceof TableModel)) {
            this.toggleViewMode();
        }
        this.filterCards();
    }

    private void jToggleCardViewActionPerformed(ActionEvent evt) {
        if (this.currentView.cardsSize() > 350) {
            this.jToggleCardView.setSelected(false);
            this.jToggleListView.setSelected(true);
            MageFrame.getInstance().showMessage("The card view can't be used for more than 350 cards.");
        } else {
            if (!(this.currentView instanceof CardGrid)) {
                this.toggleViewMode();
            }
            this.filterCards();
        }
    }

    private void jButtonAddToMainActionPerformed(ActionEvent evt) {
        if (this.mainTable.getSelectedRowCount() > 0) {
            int[] n = this.mainTable.getSelectedRows();
            List<Integer> indexes = this.asList(n);
            Collections.reverse(indexes);
            for (Integer index : indexes) {
                this.mainModel.doubleClick(index, null, false);
            }
            if (this.limited) {
                this.mainModel.fireTableDataChanged();
            }
        }
    }

    private void jButtonAddToSideboardActionPerformed(ActionEvent evt) {
        if (this.mainTable.getSelectedRowCount() > 0) {
            int[] n = this.mainTable.getSelectedRows();
            List<Integer> indexes = this.asList(n);
            Collections.reverse(indexes);
            for (Integer index : indexes) {
                this.mainModel.doubleClick(index, null, true);
            }
            if (this.limited) {
                this.mainModel.fireTableDataChanged();
            }
        }
    }

    private void jButtonRemoveFromMainActionPerformed(ActionEvent evt) {
        this.mainModel.removeFromMainEvent(0);
    }

    private void jButtonRemoveFromSideboardActionPerformed(ActionEvent evt) {
        this.mainModel.removeFromSideEvent(0);
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.filterCards();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        this.jTextFieldSearch.setText("");
        this.filterCards();
    }

    private void tbRedActionPerformed(ActionEvent evt) {
        this.filterCardsColor(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbGreenActionPerformed(ActionEvent evt) {
        this.filterCardsColor(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbBlueActionPerformed(ActionEvent evt) {
        this.filterCardsColor(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbBlackActionPerformed(ActionEvent evt) {
        this.filterCardsColor(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbWhiteActionPerformed(ActionEvent evt) {
        this.filterCardsColor(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbColorlessActionPerformed(ActionEvent evt) {
        this.filterCardsColor(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbCreaturesActionPerformed(ActionEvent evt) {
        this.filterCardsType(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbArifiactsActionPerformed(ActionEvent evt) {
        this.filterCardsType(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbSorceriesActionPerformed(ActionEvent evt) {
        this.filterCardsType(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbInstantsActionPerformed(ActionEvent evt) {
        this.filterCardsType(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbEnchantmentsActionPerformed(ActionEvent evt) {
        this.filterCardsType(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbPlaneswalkersActionPerformed(ActionEvent evt) {
        this.filterCardsType(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbLandActionPerformed(ActionEvent evt) {
        this.filterCardsType(evt.getModifiers(), evt.getActionCommand());
    }

    private void chkNamesActionPerformed(ActionEvent evt) {
    }

    private void chkTypesActionPerformed(ActionEvent evt) {
    }

    private void chkRulesActionPerformed(ActionEvent evt) {
    }

    private void chkUniqueActionPerformed(ActionEvent evt) {
    }

    private void btnExpansionSearchActionPerformed(ActionEvent evt) {
        int[] oldChecks = this.listCodeSelected.getCheckedIndices();
        FastSearchUtil.showFastSearchForStringComboBox(this.listCodeSelected, "Select set or expansion", () -> {
            int[] newChecks = this.listCodeSelected.getCheckedIndices();
            if (Arrays.equals(oldChecks, newChecks)) {
                return;
            }
            this.isSetsFilterLoading = true;
            try {
                if (this.cbExpansionSet.getItemAt(0).startsWith("Multiple sets selected")) {
                    this.cbExpansionSet.removeItemAt(0);
                }
                if (newChecks.length == 0) {
                    this.cbExpansionSet.setSelectedIndex(0);
                } else if (newChecks.length == 1) {
                    this.setSetsSelection(this.listCodeSelected.getModel().getElementAt(newChecks[0]).toString());
                } else {
                    String message = String.format("%s: %d", "Multiple sets selected", newChecks.length);
                    this.cbExpansionSet.insertItemAt(message, 0);
                    this.cbExpansionSet.setSelectedIndex(0);
                }
            }
            finally {
                this.isSetsFilterLoading = false;
            }
            this.filterCards();
        });
    }

    private void tbCommonActionPerformed(ActionEvent evt) {
        this.filterCardsRarity(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbUncommonActionPerformed(ActionEvent evt) {
        this.filterCardsRarity(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbRareActionPerformed(ActionEvent evt) {
        this.filterCardsRarity(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbMythicActionPerformed(ActionEvent evt) {
        this.filterCardsRarity(evt.getModifiers(), evt.getActionCommand());
    }

    private void tbSpecialActionPerformed(ActionEvent evt) {
        this.filterCardsRarity(evt.getModifiers(), evt.getActionCommand());
    }

    private void toggleViewMode() {
        if (this.currentView instanceof CardGrid) {
            this.jToggleListView.setSelected(true);
            this.jToggleCardView.setSelected(false);
            this.currentView = this.mainModel;
            this.cardSelectorScrollPane.setViewportView(this.mainTable);
            this.cbSortBy.setEnabled(false);
            this.chkPiles.setEnabled(false);
            this.jButtonAddToMain.setEnabled(true);
            this.jButtonAddToSideboard.setEnabled(true);
        } else {
            this.jToggleCardView.setSelected(true);
            this.jToggleListView.setSelected(false);
            this.currentView = this.cardGrid;
            this.cardSelectorScrollPane.setViewportView(this.cardGrid);
            this.cbSortBy.setEnabled(true);
            this.chkPiles.setEnabled(true);
            this.jButtonAddToMain.setEnabled(false);
            this.jButtonAddToSideboard.setEnabled(false);
        }
    }

    public List<Integer> asList(int[] is) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : is) {
            list.add(i);
        }
        return list;
    }

    public void refresh() {
        SwingUtilities.invokeLater(() -> this.currentView.refresh());
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.cbSortBy.getSelectedItem() instanceof Constants.SortBy) {
            this.currentView.drawCards(this.sortSetting);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.cbSortBy.getSelectedItem() instanceof Constants.SortBy) {
            this.currentView.drawCards(this.sortSetting);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.cbSortBy.getSelectedItem() instanceof Constants.SortBy) {
            this.currentView.drawCards(this.sortSetting);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (this.cbSortBy.getSelectedItem() instanceof Constants.SortBy) {
            this.currentView.drawCards(this.sortSetting);
        }
    }

    @Override
    public void dragCardEnter(MouseEvent e) {
    }

    @Override
    public void dragCardMove(MouseEvent e) {
    }

    @Override
    public void dragCardExit(MouseEvent e) {
    }

    @Override
    public void dragCardDrop(MouseEvent e, DragCardSource source, Collection<CardView> cards) {
    }

    private static void makeButtonPopup(AbstractButton button, JPopupMenu popup) {
        button.addActionListener(e -> popup.show(button, 0, button.getHeight()));
    }
}

