/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckFormats;
import mage.cards.decks.exporter.DeckExporter;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.client.util.AppUtil;

public class DeckExportClipboardDialog
extends MageDialog {
    private Deck deck;
    private ArrayList<DeckFormats> formats = new ArrayList();
    private JButton buttonCancel;
    private JButton buttonCopy;
    private JButton buttonOK;
    private JComboBox<String> comboFormats;
    private JEditorPane editData;
    private JLabel labelData;
    private JPanel panelCommands;
    private JScrollPane panelData;

    public DeckExportClipboardDialog() {
        this.initComponents();
    }

    public void showDialog(Deck deck) {
        this.deck = deck;
        this.formats.clear();
        this.comboFormats.removeAllItems();
        for (DeckFormats df : DeckFormats.values()) {
            this.formats.add(df);
            this.comboFormats.addItem(df.getExporter().getDescription());
        }
        if (this.comboFormats.getItemCount() > 0) {
            this.comboFormats.setSelectedIndex(0);
        }
        this.onRefreshData();
        this.setModal(true);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.makeWindowCentered();
        this.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.setVisible(true);
    }

    private void onOK() {
        this.onCopyToClipboard();
        this.removeDialog();
    }

    private void onCancel() {
        this.removeDialog();
    }

    private void onRefreshData() {
        int formatIndex = this.comboFormats.getSelectedIndex();
        if (formatIndex < 0 || formatIndex >= this.formats.size()) {
            return;
        }
        DeckExporter exporter = this.formats.get(formatIndex).getExporter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.writeDeck(baos, this.deck.prepareCardsOnlyDeck());
        this.editData.setText(baos.toString());
        this.editData.setCaretPosition(0);
    }

    private void onCopyToClipboard() {
        AppUtil.setClipboardData(this.editData.getText());
    }

    private void initComponents() {
        this.panelData = new JScrollPane();
        this.editData = new JEditorPane();
        this.labelData = new JLabel();
        this.panelCommands = new JPanel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.buttonCopy = new JButton();
        this.comboFormats = new JComboBox();
        this.setTitle("Export to clipboard");
        this.setMinimumSize(new Dimension(400, 400));
        this.panelData.setHorizontalScrollBarPolicy(32);
        this.panelData.setVerticalScrollBarPolicy(22);
        this.panelData.setViewportView(this.editData);
        this.labelData.setText("Choose deck format:");
        this.buttonOK.setText("Copy");
        this.buttonOK.setToolTipText("Import deck from current text");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckExportClipboardDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Close");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckExportClipboardDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonCopy.setIcon(new ImageIcon(this.getClass().getResource("/buttons/copy_24.png")));
        this.buttonCopy.setToolTipText("Copy current text to clipboard");
        this.buttonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckExportClipboardDialog.this.buttonCopyActionPerformed(evt);
            }
        });
        GroupLayout panelCommandsLayout = new GroupLayout(this.panelCommands);
        this.panelCommands.setLayout(panelCommandsLayout);
        panelCommandsLayout.setHorizontalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelCommandsLayout.createSequentialGroup().addComponent(this.buttonCopy, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonOK, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, 100, -2)));
        panelCommandsLayout.setVerticalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, 30, -2).addComponent(this.buttonOK, -2, 30, -2)).addComponent(this.buttonCopy, GroupLayout.Alignment.TRAILING, -2, 30, -2))));
        this.comboFormats.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboFormats.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DeckExportClipboardDialog.this.comboFormatsItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCommands, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.panelData, -1, 364, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboFormats, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelData).addComponent(this.comboFormats, -2, 30, -2)).addGap(10, 10, 10).addComponent(this.panelData, -1, 520, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCommands, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.onCancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.onOK();
    }

    private void buttonCopyActionPerformed(ActionEvent evt) {
        this.onCopyToClipboard();
    }

    private void comboFormatsItemStateChanged(ItemEvent evt) {
        this.onRefreshData();
    }
}

