/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Optional;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import mage.cards.decks.importer.MtgaImporter;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.util.DeckUtil;

public class DeckImportClipboardDialog
extends MageDialog {
    private static final String FORMAT_TEXT = "// MTGO format example:\n// 1 Library of Congress\n// 3 Cryptic Gateway\n//\n// MTGA, moxfield, archidekt format example:\n// Deck\n// 4 Accumulated Knowledge (A25) 40\n// 2 Adarkar Wastes (EOC) 147\n// Commander\n// 1 Grizzly Bears\n//\n// Importing deck can take some time to finish\n\n// Your current clipboard:\n\n";
    private DeckImportClipboardCallback callback = null;
    private JButton buttonCancel;
    private JButton buttonOK;
    private JButton buttonPaste;
    private JEditorPane editData;
    private JLabel labelData;
    private JPanel panelCommands;
    private JScrollPane panelData;

    public DeckImportClipboardDialog() {
        this.initComponents();
    }

    public void showDialog(DeckImportClipboardCallback callback) {
        this.callback = callback;
        this.onRefreshClipboard();
        this.setModal(true);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.makeWindowCentered();
        this.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.setVisible(true);
    }

    private Optional<String> getClipboardStringData() {
        try {
            return Optional.of((String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor));
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException exception) {
            return Optional.empty();
        }
    }

    private void onOK() {
        String importData = this.editData.getText();
        String tempDeckPath = MtgaImporter.isMTGA(importData = importData.replace(FORMAT_TEXT, "").trim()) ? DeckUtil.writeTextToTempFile("cbimportdeck", ".mtga", importData) : DeckUtil.writeTextToTempFile(importData);
        if (this.callback != null) {
            this.callback.onImportDone(tempDeckPath);
        }
        this.onCancel();
    }

    private void onCancel() {
        this.removeDialog();
    }

    private void onRefreshClipboard() {
        this.editData.setText(FORMAT_TEXT + this.getClipboardStringData().orElse(""));
        this.editData.setCaretPosition(FORMAT_TEXT.length());
    }

    private void initComponents() {
        this.panelData = new JScrollPane();
        this.editData = new JEditorPane();
        this.labelData = new JLabel();
        this.panelCommands = new JPanel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.buttonPaste = new JButton();
        this.setTitle("Import from clipboard");
        this.setMinimumSize(new Dimension(400, 400));
        this.panelData.setHorizontalScrollBarPolicy(32);
        this.panelData.setVerticalScrollBarPolicy(22);
        this.panelData.setViewportView(this.editData);
        this.labelData.setLabelFor(this.editData);
        this.labelData.setText("Deck in text format to import:");
        this.buttonOK.setText("Import");
        this.buttonOK.setToolTipText("Import deck from current text");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckImportClipboardDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Close");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckImportClipboardDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonPaste.setIcon(new ImageIcon(this.getClass().getResource("/buttons/paste_24.png")));
        this.buttonPaste.setToolTipText("Paste text from clipboard");
        this.buttonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeckImportClipboardDialog.this.buttonPasteActionPerformed(evt);
            }
        });
        GroupLayout panelCommandsLayout = new GroupLayout(this.panelCommands);
        this.panelCommands.setLayout(panelCommandsLayout);
        panelCommandsLayout.setHorizontalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelCommandsLayout.createSequentialGroup().addComponent(this.buttonPaste, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 128, Short.MAX_VALUE).addComponent(this.buttonOK, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, 100, -2)));
        panelCommandsLayout.setVerticalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, 30, -2).addComponent(this.buttonOK, -2, 30, -2)).addComponent(this.buttonPaste, GroupLayout.Alignment.TRAILING, -2, 30, -2))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.panelCommands, -1, -1, Short.MAX_VALUE)).addComponent(this.panelData, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.labelData).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.labelData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelData, -1, 440, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCommands, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.onCancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.onOK();
    }

    private void buttonPasteActionPerformed(ActionEvent evt) {
        this.onRefreshClipboard();
    }

    public static interface DeckImportClipboardCallback {
        public void onImportDone(String var1);
    }
}

