/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor.collection.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import mage.cards.repository.ExpansionRepository;
import mage.cards.repository.RepositoryEvent;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.deckeditor.collection.viewer.CollectionViewerPane;
import mage.client.deckeditor.collection.viewer.MageBook;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.gui.FastSearchUtil;
import mage.client.util.sets.ConstructedFormats;
import mage.game.events.Listener;
import org.apache.log4j.Logger;

public final class CollectionViewerPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(CollectionViewerPanel.class);
    protected static final String LAYOYT_CONFIG_KEY = "collectionViewerLayoutConfig";
    private static final String FORMAT_CONFIG_KEY = "collectionViewerFormat";
    private static Listener<RepositoryEvent> setsDbListener = null;
    private JPanel buttonsPanel;
    private JPanel jPanel2;
    private JPanel setPanel;
    private JButton btnSetFastSearch;
    private BigCard bigCard;
    private JButton btnExit;
    private JComboBox formats;
    private MageBook mageBook;
    private JRadioButton small3x3;
    private JRadioButton big4x4;

    public CollectionViewerPanel() {
        this.initComponents();
        try {
            String format = PreferencesDialog.getCachedValue(FORMAT_CONFIG_KEY, ConstructedFormats.getDefault());
            this.formats.setSelectedItem(format);
        }
        catch (Exception e) {
            logger.fatal((Object)"Error setting selected format", (Throwable)e);
        }
    }

    public void cleanUp() {
        this.hidePopup();
        this.bigCard = null;
        ExpansionRepository.instance.unsubscribe(setsDbListener);
    }

    private void reloadFormatCombobox() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(ConstructedFormats.getTypes(true).toArray());
        this.formats.setModel(model);
        this.formats.setSelectedItem(ConstructedFormats.getDefault());
    }

    public void initComponents() {
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setOpaque(false);
        this.bigCard = new BigCard();
        BoxLayout boxlayout = new BoxLayout(this.buttonsPanel, 3);
        this.buttonsPanel.setLayout(boxlayout);
        this.btnExit = new JButton();
        this.btnExit.setAlignmentX(0.0f);
        this.buttonsPanel.add(this.btnExit);
        JLabel label1 = new JLabel("Choose format:");
        label1.setAlignmentX(0.0f);
        label1.setForeground(Color.white);
        this.buttonsPanel.add(label1);
        this.setPanel = new JPanel();
        this.setPanel.setLayout(new BoxLayout(this.setPanel, 2));
        this.setPanel.setOpaque(false);
        this.setPanel.setPreferredSize(new Dimension(200, 25));
        this.setPanel.setMaximumSize(new Dimension(200, 25));
        this.setPanel.setAlignmentX(0.0f);
        this.buttonsPanel.add(this.setPanel);
        this.formats = new JComboBox();
        this.reloadFormatCombobox();
        setsDbListener = new Listener<RepositoryEvent>(){

            @Override
            public void event(RepositoryEvent event) {
                if (event.getEventType().equals((Object)RepositoryEvent.RepositoryEventType.DB_UPDATED)) {
                    CollectionViewerPanel.this.reloadFormatCombobox();
                }
            }
        };
        ExpansionRepository.instance.subscribe(setsDbListener);
        this.formats.addActionListener(e -> {
            if (this.mageBook != null) {
                String format = (String)this.formats.getSelectedItem();
                MageFrame.getPreferences().put(FORMAT_CONFIG_KEY, format);
                this.mageBook.updateDispayedSets(format);
            }
        });
        this.formats.setAlignmentX(0.0f);
        this.formats.setMinimumSize(new Dimension(50, 25));
        this.formats.setPreferredSize(new Dimension(50, 25));
        this.formats.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.setPanel.add(this.formats);
        this.btnSetFastSearch = new JButton();
        this.btnSetFastSearch.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_24.png")));
        this.btnSetFastSearch.setToolTipText("Fast search set or expansion");
        this.btnSetFastSearch.setAlignmentX(1.0f);
        this.btnSetFastSearch.setMinimumSize(new Dimension(24, 24));
        this.btnSetFastSearch.setPreferredSize(new Dimension(32, 32));
        this.btnSetFastSearch.setMaximumSize(new Dimension(32, 32));
        this.btnSetFastSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FastSearchUtil.showFastSearchForStringComboBox(CollectionViewerPanel.this.formats, "Select set or expansion");
            }
        });
        this.setPanel.add(this.btnSetFastSearch);
        JLabel label2 = new JLabel("Choose size:");
        label2.setAlignmentX(0.0f);
        label2.setForeground(Color.white);
        this.buttonsPanel.add(label2);
        this.small3x3 = new JRadioButton("3x3");
        this.small3x3.setForeground(Color.white);
        boolean selected3x3 = MageFrame.getPreferences().get(LAYOYT_CONFIG_KEY, "small").equals("small");
        this.small3x3.setSelected(selected3x3);
        this.small3x3.addActionListener(e -> {
            this.big4x4.setSelected(false);
            this.mageBook.updateSize("small");
            MageFrame.getPreferences().put(LAYOYT_CONFIG_KEY, "small");
        });
        this.buttonsPanel.add(this.small3x3);
        this.big4x4 = new JRadioButton("4x4");
        this.big4x4.setForeground(Color.white);
        this.big4x4.setSelected(!selected3x3);
        this.big4x4.addActionListener(e -> {
            this.small3x3.setSelected(false);
            this.mageBook.updateSize("big");
            MageFrame.getPreferences().put(LAYOYT_CONFIG_KEY, "big");
        });
        this.buttonsPanel.add(this.big4x4);
        JLabel label3 = new JLabel("Switch tabs:");
        label3.setAlignmentX(0.0f);
        label3.setForeground(Color.white);
        this.buttonsPanel.add(label3);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(new Dimension(200, 100));
        buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        buttonPanel.setOpaque(false);
        buttonPanel.setAlignmentX(0.0f);
        this.buttonsPanel.add(buttonPanel);
        JButton prev = new JButton("Prev");
        prev.addActionListener(e -> this.mageBook.prev());
        buttonPanel.add(prev);
        JButton next = new JButton("Next");
        next.addActionListener(e -> this.mageBook.next());
        buttonPanel.add(next);
        JLabel labelCardTokenSwitch = new JLabel("Show cards or tokens:");
        labelCardTokenSwitch.setAlignmentX(0.0f);
        labelCardTokenSwitch.setForeground(Color.white);
        this.buttonsPanel.add(labelCardTokenSwitch);
        JCheckBox cardsOrTokens = new JCheckBox("Display Cards");
        cardsOrTokens.setSelected(true);
        cardsOrTokens.setForeground(Color.white);
        cardsOrTokens.setToolTipText("Select to show Cards for the chosen set.  When unselected, will show Tokens, Emblems and Planes for the set instead");
        cardsOrTokens.addActionListener(e -> this.mageBook.cardsOrTokens(cardsOrTokens.isSelected()));
        this.buttonsPanel.add(cardsOrTokens);
        this.buttonsPanel.add(Box.createVerticalGlue());
        this.bigCard.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.bigCard.setAlignmentX(0.0f);
        this.bigCard.setAlignmentY(1.0f);
        this.buttonsPanel.add(this.bigCard);
        this.jPanel2 = new MageBookContainer();
        this.jPanel2.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonsPanel, -2, 261, -2).addGap(0, 0, 0).addComponent(this.jPanel2, -2, 604, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 615, Short.MAX_VALUE));
        this.btnExit.setText("Exit");
        this.btnExit.addActionListener(evt -> this.btnExitActionPerformed(evt));
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.removeCollectionViewer();
    }

    private void hidePopup() {
        Plugins.instance.getActionCallback().mouseExited(null, null);
    }

    public void removeCollectionViewer() {
        Container c;
        this.cleanUp();
        for (c = this.getParent(); c != null && !(c instanceof CollectionViewerPane); c = c.getParent()) {
        }
        if (c != null) {
            ((CollectionViewerPane)c).removeFrame();
        }
    }

    public void showCards() {
        if (this.mageBook != null) {
            this.mageBook.showCardsOrTokens();
        }
    }

    private final class MageBookContainer
    extends JPanel {
        private JPanel jPanel;
        private JScrollPane jScrollPane1;

        public MageBookContainer() {
            this.initComponents();
        }

        public void initComponents() {
            this.jPanel = new JPanel();
            this.jScrollPane1 = new JScrollPane(this.jPanel);
            this.jScrollPane1.getViewport().setBackground(new Color(0, 0, 0, 0));
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBackground(new Color(0, 0, 0, 0));
            CollectionViewerPanel.this.mageBook = new MageBook(CollectionViewerPanel.this.bigCard);
            this.jPanel.add(CollectionViewerPanel.this.mageBook);
            this.setLayout(new BorderLayout());
            this.add((Component)this.jScrollPane1, "Center");
        }
    }
}

