/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor.collection.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.CardDimensions;
import mage.cards.ExpansionSet;
import mage.cards.MageCard;
import mage.cards.RateCard;
import mage.cards.Sets;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.repository.ExpansionRepository;
import mage.cards.repository.TokenInfo;
import mage.cards.repository.TokenRepository;
import mage.cards.repository.TokenType;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.components.HoverButton;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ClientDefaultSettings;
import mage.client.util.ImageHelper;
import mage.client.util.NaturalOrderCardNumberComparator;
import mage.client.util.audio.AudioManager;
import mage.client.util.sets.ConstructedFormats;
import mage.components.ImagePanel;
import mage.components.ImagePanelStyle;
import mage.constants.MageObjectType;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TokenImpl;
import mage.game.permanent.token.custom.XmageToken;
import mage.view.CardView;
import mage.view.DungeonView;
import mage.view.EmblemView;
import mage.view.PermanentView;
import mage.view.PlaneView;
import org.apache.log4j.Logger;
import org.mage.card.arcane.ManaSymbols;

public class MageBook
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MageBook.class);
    public static final String LAYOUT_3X3 = "small";
    public static final String LAYOUT_4X4 = "big";
    private static final int CARD_CAPTION_OFFSET_Y = 8;
    private JPanel jPanelTop;
    private JPanel jPanelCaption;
    private JLabel setCaption;
    private JLabel setInfo;
    private JPanel jPanelLeft;
    private ImagePanel jPanelCenter;
    private JPanel jPanelRight;
    private JLayeredPane jLayeredPane;
    private final BigCard bigCard;
    private HoverButton pageLeft;
    private HoverButton pageRight;
    private int currentPage = 0;
    private String currentSet = "RTR";
    private static CardDimensions cardDimensions = new CardDimensions(1.2);
    private static final Logger log = Logger.getLogger(MageBook.class);
    private Dimension cardDimension;
    private List<String> setsToDisplay = new ArrayList<String>();
    private final List<HoverButton> tabs = new ArrayList<HoverButton>();
    private int selectedTab;
    private boolean showCardsOrTokens = true;
    private boolean stateChanged = false;
    private static final String CENTER_PANEL_IMAGE_PATH = "/book_bg.jpg";
    private static final String RIGHT_PANEL_IMAGE_PATH = "/book_right.jpg";
    private static final String LEFT_PANEL_IMAGE_PATH = "/book_left.jpg";
    private static final String LEFT_PAGE_BUTTON_IMAGE_PATH = "/book_pager_left.png";
    private static final String RIGHT_PAGE_BUTTON_IMAGE_PATH = "/book_pager_right.png";
    private static final String LEFT_TAB_IMAGE_PATH = "/tab_left.png";
    private static final String RIGHT_TAB_IMAGE_PATH = "/tab_right.png";
    private static final int OFFSET_X = 25;
    private static final int OFFSET_Y = 20;
    private static final int LEFT_RIGHT_PAGES_WIDTH = 40;
    private static final Color NOT_IMPLEMENTED = new Color(220, 220, 220, 150);
    private Configuration conf;

    public MageBook(BigCard bigCard) {
        this.bigCard = bigCard;
        this.setsToDisplay = ConstructedFormats.getSetsByFormat(ConstructedFormats.getDefault());
        boolean selected3x3 = MageFrame.getPreferences().get("collectionViewerLayoutConfig", LAYOUT_3X3).equals(LAYOUT_3X3);
        this.conf = selected3x3 ? new _3x3Configuration() : new _4x4Configuration();
        this.initComponents();
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setSize(this.conf.WIDTH, this.conf.HEIGHT);
        this.setPreferredSize(new Dimension(this.conf.WIDTH, this.conf.HEIGHT));
        this.setMinimumSize(new Dimension(this.conf.WIDTH, this.conf.HEIGHT));
        this.jPanelLeft = this.getImagePanel(LEFT_PANEL_IMAGE_PATH, ImagePanelStyle.TILED);
        this.jPanelLeft.setPreferredSize(new Dimension(40, 0));
        this.jPanelLeft.setLayout(null);
        this.jPanelCenter = this.getImagePanel(CENTER_PANEL_IMAGE_PATH, ImagePanelStyle.SCALED);
        this.jPanelCenter.setLayout((LayoutManager)new BorderLayout());
        this.jPanelRight = this.getImagePanel(RIGHT_PANEL_IMAGE_PATH, ImagePanelStyle.TILED);
        this.jPanelRight.setPreferredSize(new Dimension(40, 0));
        this.jPanelRight.setLayout(null);
        this.jLayeredPane = new JLayeredPane();
        this.jPanelCenter.add((JComponent)this.jLayeredPane, (Object)"Center");
        BufferedImage image = ImageHelper.loadImage(LEFT_PAGE_BUTTON_IMAGE_PATH);
        this.pageLeft = new HoverButton(null, image, image, image, new Rectangle(64, 64));
        this.pageLeft.setBounds(0, 0, 64, 64);
        this.pageLeft.setVisible(false);
        this.pageLeft.setObserver(() -> {
            --this.currentPage;
            if (this.currentPage == 0) {
                this.pageLeft.setVisible(false);
            }
            this.pageRight.setVisible(true);
            AudioManager.playPrevPage();
            this.showCardsOrTokens();
        });
        image = ImageHelper.loadImage(RIGHT_PAGE_BUTTON_IMAGE_PATH);
        this.pageRight = new HoverButton(null, image, image, image, new Rectangle(64, 64));
        this.pageRight.setBounds(this.conf.WIDTH - 80 - 64, 0, 64, 64);
        this.pageRight.setVisible(false);
        this.pageRight.setObserver(() -> {
            ++this.currentPage;
            this.pageLeft.setVisible(true);
            this.pageRight.setVisible(false);
            AudioManager.playNextPage();
            this.showCardsOrTokens();
        });
        this.addSetTabs();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanelLeft, "Before");
        this.add((Component)this.jPanelCenter, "Center");
        this.add((Component)this.jPanelRight, "After");
        int captionHeight = Math.max(30, this.pageLeft.getHeight());
        this.jPanelTop = new JPanel();
        this.jPanelTop.setLayout(new BorderLayout());
        this.jPanelTop.setPreferredSize(new Dimension(captionHeight, captionHeight));
        this.jPanelCenter.add((JComponent)this.jPanelTop, (Object)"North");
        this.pageRight.setPreferredSize(new Dimension(this.pageRight.getWidth(), this.pageRight.getHeight()));
        this.jPanelTop.add((Component)this.pageRight, "East");
        this.pageLeft.setPreferredSize(new Dimension(this.pageLeft.getWidth(), this.pageLeft.getHeight()));
        this.jPanelTop.add((Component)this.pageLeft, "West");
        this.jPanelCaption = new JPanel();
        this.jPanelCaption.setLayout(new BorderLayout());
        this.jPanelCaption.setOpaque(false);
        this.jPanelTop.add((Component)this.jPanelCaption, "Center");
        this.setCaption = new JLabel();
        this.setCaption.setHorizontalAlignment(0);
        this.setCaption.setFont(this.jLayeredPane.getFont().deriveFont(25.0f));
        this.setCaption.setText("EMPTY CAPTION");
        this.jPanelCaption.add((Component)this.setCaption, "North");
        this.setInfo = new JLabel();
        this.setInfo.setHorizontalAlignment(0);
        this.setInfo.setFont(this.jLayeredPane.getFont().deriveFont(17.0f));
        this.setInfo.setText("EMPTY STATS");
        this.jPanelCaption.add((Component)this.setInfo, "South");
        cardDimensions = new CardDimensions(0.45);
    }

    private void addSetTabs() {
        this.jPanelLeft.removeAll();
        this.jPanelRight.removeAll();
        this.tabs.clear();
        BufferedImage image = ImageHelper.loadImage(LEFT_TAB_IMAGE_PATH);
        BufferedImage imageRight = ImageHelper.loadImage(RIGHT_TAB_IMAGE_PATH);
        int y = 0;
        int dy = 0;
        if (this.setsToDisplay.size() > 1) {
            dy = (this.conf.HEIGHT - 120) / (this.setsToDisplay.size() - 1) + 1;
        }
        int count = 0;
        JPanel currentPanel = this.jPanelLeft;
        HoverButton currentTab = null;
        for (String set : this.setsToDisplay) {
            HoverButton tab = new HoverButton(null, image, image, image, new Rectangle(39, 120));
            Image setImage = ManaSymbols.getSetSymbolImage(set);
            if (setImage != null) {
                tab.setOverlayImage(setImage);
            }
            tab.setSet(set);
            tab.setBounds(0, y, 39, 120);
            String _set = set;
            int _index = count;
            tab.setObserver(() -> {
                if (!this.currentSet.equals(_set) || this.currentPage != 0 || this.stateChanged) {
                    AudioManager.playAnotherTab();
                    MageBook mageBook = this;
                    synchronized (mageBook) {
                        this.selectedTab = _index;
                    }
                    this.currentPage = 0;
                    this.currentSet = _set;
                    this.pageLeft.setVisible(false);
                    this.pageRight.setVisible(false);
                    this.addSetTabs();
                    this.showCardsOrTokens();
                }
            });
            this.tabs.add(tab);
            currentPanel.add(tab, JLayeredPane.DEFAULT_LAYER + count++, 0);
            y += dy;
            if (!set.equals(this.currentSet)) continue;
            currentPanel = this.jPanelRight;
            image = imageRight;
            currentTab = tab;
            this.selectedTab = count - 1;
        }
        this.jPanelLeft.revalidate();
        this.jPanelLeft.repaint();
        this.jPanelRight.revalidate();
        this.jPanelRight.repaint();
        if (currentTab != null) {
            currentTab.drawSet();
            currentTab.repaint();
        }
    }

    public void showCardsOrTokens() {
        this.stateChanged = false;
        this.updateCardStats(this.currentSet, this.showCardsOrTokens);
        List<Object> items = this.showCardsOrTokens ? this.loadCards() : this.loadTokens();
        this.showItems(items);
    }

    public List<Object> loadTokens() {
        ArrayList<Object> res = new ArrayList<Object>();
        ArrayList<TokenInfo> allTokens = new ArrayList<TokenInfo>(TokenRepository.instance.getByType(TokenType.TOKEN));
        allTokens.addAll(TokenRepository.instance.getByType(TokenType.XMAGE));
        allTokens.removeIf(token -> !token.getSetCode().equals(this.currentSet));
        allTokens.forEach(token -> {
            TokenImpl newToken;
            switch (token.getTokenType()) {
                case XMAGE: {
                    newToken = new XmageToken(token.getName());
                    break;
                }
                default: {
                    newToken = TokenImpl.createTokenByClassName(token.getFullClassFileName());
                }
            }
            if (newToken != null) {
                newToken.setExpansionSetCode(this.currentSet);
                newToken.setImageNumber(token.getImageNumber());
                res.add(newToken);
            }
        });
        List<TokenInfo> allEmblems = TokenRepository.instance.getByType(TokenType.EMBLEM).stream().filter(token -> token.getSetCode().equals(this.currentSet)).collect(Collectors.toList());
        allEmblems.forEach(token -> {
            try {
                Class<?> c = Class.forName(token.getFullClassFileName());
                Constructor<?> cons = c.getConstructor(new Class[0]);
                Object newEmblem = cons.newInstance(new Object[0]);
                if (newEmblem instanceof Emblem) {
                    ((Emblem)newEmblem).setExpansionSetCode(this.currentSet);
                    res.add(newEmblem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        List<TokenInfo> allPlanes = TokenRepository.instance.getByType(TokenType.PLANE).stream().filter(token -> token.getSetCode().equals(this.currentSet)).collect(Collectors.toList());
        allPlanes.forEach(token -> {
            try {
                Class<?> c = Class.forName(token.getFullClassFileName());
                Constructor<?> cons = c.getConstructor(new Class[0]);
                Object newPlane = cons.newInstance(new Object[0]);
                if (newPlane instanceof Plane) {
                    ((Plane)newPlane).setExpansionSetCode(this.currentSet);
                    res.add(newPlane);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        List<TokenInfo> allDungeons = TokenRepository.instance.getByType(TokenType.DUNGEON).stream().filter(token -> token.getSetCode().equals(this.currentSet)).collect(Collectors.toList());
        allDungeons.forEach(token -> {
            try {
                Class<?> c = Class.forName(token.getFullClassFileName());
                Constructor<?> cons = c.getConstructor(new Class[0]);
                Object newDungeon = cons.newInstance(new Object[0]);
                if (newDungeon instanceof Dungeon) {
                    ((Dungeon)newDungeon).setExpansionSetCode(this.currentSet);
                    res.add(newDungeon);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return res;
    }

    public void showItems(List<Object> allItems) {
        this.jLayeredPane.removeAll();
        int start = this.currentPage * this.conf.CARDS_PER_PAGE;
        int end = Math.min(allItems.size(), start + this.conf.CARDS_PER_PAGE);
        List<Object> needItems = allItems.subList(start, end);
        this.pageRight.setVisible(allItems.size() > end);
        this.pageLeft.setVisible(this.currentPage > 0);
        if (!needItems.isEmpty()) {
            int size = needItems.size();
            Rectangle rectangle = new Rectangle();
            rectangle.translate(25, 20);
            for (int i = 0; i < Math.min(this.conf.CARDS_PER_PAGE / 2, size); ++i) {
                this.addItem(needItems.get(i), rectangle);
                rectangle = CardPosition.translatePosition(i, rectangle, this.conf);
            }
            int second_page_x = this.conf.WIDTH - 80 - (cardDimensions.getFrameWidth() + 17) * this.conf.CARD_COLUMNS + 17 - 25;
            rectangle.setLocation(second_page_x, 20);
            for (int i = this.conf.CARDS_PER_PAGE / 2; i < Math.min(this.conf.CARDS_PER_PAGE, size); ++i) {
                this.addItem(needItems.get(i), rectangle);
                rectangle = CardPosition.translatePosition(i - this.conf.CARDS_PER_PAGE / 2, rectangle, this.conf);
            }
        }
        this.jLayeredPane.repaint();
    }

    private void addItem(Object item, Rectangle position) {
        if (item instanceof CardView) {
            this.addCard((CardView)item, this.bigCard, null, position, true);
        } else if (item instanceof Token) {
            this.addToken((Token)item, this.bigCard, null, position);
        } else if (item instanceof Emblem) {
            this.addEmblem((Emblem)item, this.bigCard, null, position);
        } else if (item instanceof Dungeon) {
            this.addDungeon((Dungeon)item, this.bigCard, null, position);
        } else if (item instanceof Plane) {
            this.addPlane((Plane)item, this.bigCard, null, position);
        } else {
            logger.error((Object)("ERROR, unknown extra item type in mage viewer: " + item.getClass().getCanonicalName()), new Throwable());
        }
    }

    private void addCard(CardView card, BigCard bigCard, UUID gameId, Rectangle rectangle, boolean asCard) {
        if (this.cardDimension == null) {
            this.cardDimension = new Dimension(ClientDefaultSettings.dimensions.getFrameWidth(), ClientDefaultSettings.dimensions.getFrameHeight());
        }
        MageCard cardImg = Plugins.instance.getMageCard(card, bigCard, new CardIconRenderSettings(), this.cardDimension, gameId, true, true, PreferencesDialog.getRenderMode(), true);
        cardImg.setCardContainerRef((Container)this.jLayeredPane);
        cardImg.update(card);
        cardImg.setCardBounds(rectangle.x, rectangle.y, cardDimensions.getFrameWidth(), cardDimensions.getFrameHeight());
        this.jLayeredPane.add((Component)cardImg, JLayeredPane.DEFAULT_LAYER, 10);
        cardImg.setCardCaptionTopOffset(8);
        if (asCard) {
            JLabel cardNumber = new JLabel();
            int dy = -5;
            cardNumber.setBounds(rectangle.x, rectangle.y + cardImg.getCardLocation().getCardHeight() + dy, cardDimensions.getFrameWidth(), 20);
            cardNumber.setHorizontalAlignment(0);
            cardNumber.setFont(this.jLayeredPane.getFont().deriveFont(this.jLayeredPane.getFont().getStyle() | 1));
            cardNumber.setText(card.getCardNumber());
            this.jLayeredPane.add(cardNumber);
            JLabel draftRating = new JLabel();
            dy = -10 + cardNumber.getHeight();
            draftRating.setBounds(rectangle.x, rectangle.y + cardImg.getCardLocation().getCardHeight() + dy, cardDimensions.getFrameWidth(), 20);
            draftRating.setHorizontalAlignment(0);
            draftRating.setFont(this.jLayeredPane.getFont().deriveFont(this.jLayeredPane.getFont().getStyle() | 1));
            if (card.getMageObjectType().equals((Object)MageObjectType.CARD)) {
                draftRating.setText("draft rating: " + RateCard.rateCard((CardView)card, Collections.emptyList()));
            } else {
                draftRating.setText("");
            }
            this.jLayeredPane.add(draftRating);
        }
    }

    private void addToken(Token token, BigCard bigCard, UUID gameId, Rectangle rectangle) {
        if (this.cardDimension == null) {
            this.cardDimension = new Dimension(ClientDefaultSettings.dimensions.getFrameWidth(), ClientDefaultSettings.dimensions.getFrameHeight());
        }
        PermanentToken fakePermanent = new PermanentToken(token, UUID.randomUUID(), null);
        fakePermanent.removeSummoningSickness();
        PermanentView permanentView = new PermanentView((Permanent)fakePermanent, null, null, null);
        permanentView.setInViewerOnly(true);
        MageCard cardImg = Plugins.instance.getMagePermanent(permanentView, bigCard, new CardIconRenderSettings(), this.cardDimension, gameId, true, PreferencesDialog.getRenderMode(), true);
        cardImg.setCardContainerRef((Container)this.jLayeredPane);
        this.jLayeredPane.add((Component)cardImg, JLayeredPane.DEFAULT_LAYER, 10);
        cardImg.update((CardView)permanentView);
        cardImg.setCardBounds(rectangle.x, rectangle.y, cardDimensions.getFrameWidth(), cardDimensions.getFrameHeight());
    }

    private void addEmblem(Emblem emblem, BigCard bigCard, UUID gameId, Rectangle rectangle) {
        CardView cardView = new CardView(new EmblemView(emblem, null));
        this.addCard(cardView, bigCard, gameId, rectangle, false);
    }

    private void addDungeon(Dungeon dungeon, BigCard bigCard, UUID gameId, Rectangle rectangle) {
        CardView cardView = new CardView(new DungeonView(dungeon));
        this.addCard(cardView, bigCard, gameId, rectangle, false);
    }

    private void addPlane(Plane plane, BigCard bigCard, UUID gameId, Rectangle rectangle) {
        CardView cardView = new CardView(new PlaneView(plane, null));
        this.addCard(cardView, bigCard, gameId, rectangle, false);
    }

    private List<Object> loadCards() {
        CardCriteria criteria = new CardCriteria();
        criteria.setCodes(this.currentSet);
        List<CardInfo> cards = CardRepository.instance.findCards(criteria);
        cards.sort(new NaturalOrderCardNumberComparator());
        ArrayList<Object> res = new ArrayList<Object>();
        cards.forEach(card -> res.add(new CardView(card.createMockCard())));
        return res;
    }

    private List<CardInfo> getCards(int page, String set) {
        CardCriteria criteria = new CardCriteria();
        criteria.setCodes(set);
        List<CardInfo> cards = CardRepository.instance.findCards(criteria);
        cards.sort(new NaturalOrderCardNumberComparator());
        int start = page * this.conf.CARDS_PER_PAGE;
        int end = page * this.conf.CARDS_PER_PAGE + this.conf.CARDS_PER_PAGE;
        if (end > cards.size()) {
            end = cards.size();
        }
        if (cards.size() > end) {
            this.pageRight.setVisible(true);
        }
        return cards.subList(start, end);
    }

    private void updateCardStats(String setCode, boolean isCardsShow) {
        if (setCode.equals("XMAGE")) {
            this.setCaption.setText("Inner Xmage images");
            this.setInfo.setText("");
            return;
        }
        ExpansionSet set = Sets.findSet(setCode);
        if (set == null) {
            this.setCaption.setText("ERROR");
            this.setInfo.setText("ERROR");
            return;
        }
        this.setCaption.setText(set.getCode() + " - " + set.getName());
        if (!isCardsShow) {
            this.setInfo.setText("");
            return;
        }
        List haveNumbers = set.getSetCardInfo().stream().map(ExpansionSet.SetCardInfo::getCardNumberAsInt).collect(Collectors.toList());
        int startNumber = haveNumbers.stream().min(Integer::compareTo).orElse(9999);
        int endNumber = haveNumbers.stream().max(Integer::compareTo).orElse(0);
        int countHave = haveNumbers.size();
        int countNotHave = IntStream.range(startNumber, endNumber + 1).map(x -> haveNumbers.contains(x) ? 0 : 1).sum();
        this.setInfo.setText(String.format("%d cards of %d are available", countHave, countHave + countNotHave));
        if (countNotHave > 0) {
            this.setInfo.setForeground(new Color(150, 0, 0));
        } else {
            this.setInfo.setForeground(this.jLayeredPane.getForeground());
        }
    }

    private ImagePanel getImagePanel(String filename, ImagePanelStyle type) {
        try {
            InputStream is = this.getClass().getResourceAsStream(filename);
            if (is == null) {
                throw new FileNotFoundException("Couldn't find " + filename + " in resources.");
            }
            BufferedImage background = ImageIO.read(is);
            if (background == null) {
                throw new FileNotFoundException("Couldn't find " + filename + " in resources.");
            }
            return new ImagePanel(background, type);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void updateDispayedSets(String format) {
        this.setsToDisplay = ConstructedFormats.getSetsByFormat(format);
        if (this.setsToDisplay.isEmpty()) {
            this.setsToDisplay = ExpansionRepository.instance.getSetCodes();
        }
        this.addSetTabs();
        this.tabs.get(0).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        MageBook mageBook = this;
        synchronized (mageBook) {
            ++this.selectedTab;
            if (this.selectedTab >= this.tabs.size()) {
                this.selectedTab = 0;
            }
            this.tabs.get(this.selectedTab).execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prev() {
        MageBook mageBook = this;
        synchronized (mageBook) {
            --this.selectedTab;
            if (this.selectedTab < 0) {
                this.selectedTab = this.tabs.size() - 1;
            }
            this.tabs.get(this.selectedTab).execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cardsOrTokens(boolean showCards) {
        MageBook mageBook = this;
        synchronized (mageBook) {
            this.selectedTab = 0;
            this.showCardsOrTokens = !this.showCardsOrTokens;
            this.stateChanged = true;
            this.tabs.get(this.selectedTab).execute();
        }
    }

    public void updateSize(String size) {
        switch (size) {
            case "small": {
                this.conf = new _3x3Configuration();
                break;
            }
            case "big": {
                this.conf = new _4x4Configuration();
                break;
            }
            default: {
                return;
            }
        }
        this.currentPage = 0;
        this.pageLeft.setVisible(false);
        this.setSize(this.conf.WIDTH, this.conf.HEIGHT);
        this.setPreferredSize(new Dimension(this.conf.WIDTH, this.conf.HEIGHT));
        this.setMinimumSize(new Dimension(this.conf.WIDTH, this.conf.HEIGHT));
        this.addSetTabs();
        this.showCardsOrTokens();
    }

    class _4x4Configuration
    extends Configuration {
        _4x4Configuration() {
            this.WIDTH = 1250;
            this.HEIGHT = 900;
            this.CARD_ROWS = 4;
            this.CARD_COLUMNS = 4;
            this.CARDS_PER_PAGE = 32;
            this.dx = new int[]{1, 1, 1, -3, 1, 1, 1, -3, 1, 1, 1, -3, 1, 1, 1, -3};
            this.dy = new int[]{0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1};
        }
    }

    class _3x3Configuration
    extends Configuration {
        _3x3Configuration() {
            this.WIDTH = 950;
            this.HEIGHT = 700;
            this.CARD_ROWS = 3;
            this.CARD_COLUMNS = 3;
            this.CARDS_PER_PAGE = 18;
            this.dx = new int[]{1, 1, -2, 1, 1, -2, 1, 1, 2, 1, -2, 1, 1, -2, 1, 1};
            this.dy = new int[]{0, 0, 1, 0, 0, 1, 0, 0, -2, 0, 1, 0, 0, 1, 0, 0};
        }
    }

    static abstract class Configuration {
        public int CARDS_PER_PAGE;
        public int CARD_ROWS;
        public int CARD_COLUMNS;
        public int WIDTH;
        public int HEIGHT;
        public int[] dx;
        public int[] dy;

        Configuration() {
        }
    }

    private static final class CardPosition {
        public static final int GAP_X = 17;
        public static final int GAP_Y = 45;

        private CardPosition() {
        }

        public static Rectangle translatePosition(int index, Rectangle r, Configuration conf) {
            Rectangle rect = new Rectangle(r);
            rect.translate((cardDimensions.getFrameWidth() + 17) * conf.dx[index], (cardDimensions.getFrameHeight() + 45) * conf.dy[index]);
            return rect;
        }
    }
}

