/*
 * Decompiled with CFR 0.152.
 */
package mage.client.deckeditor.table;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import mage.cards.RateCard;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.cards.CardEventSource;
import mage.client.cards.ICardGrid;
import mage.client.deckeditor.SortSetting;
import mage.client.deckeditor.table.MageCardComparator;
import mage.client.deckeditor.table.UpdateCountsCallback;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ClientDefaultSettings;
import mage.client.util.ClientEventType;
import mage.client.util.Event;
import mage.client.util.Listener;
import mage.client.util.gui.GuiDisplayUtil;
import mage.constants.EnlargeMode;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.SimpleCardView;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.mage.card.arcane.ManaSymbols;

public class TableModel
extends AbstractTableModel
implements ICardGrid {
    private static final long serialVersionUID = -528008802935423088L;
    private static final Logger log = Logger.getLogger(TableModel.class);
    protected final CardEventSource cardEventSource = new CardEventSource();
    protected BigCard bigCard;
    protected UUID gameId;
    private final Map<UUID, CardView> cards = new LinkedHashMap<UUID, CardView>();
    private final Map<String, Integer> cardsNoCopies = new LinkedHashMap<String, Integer>();
    private final List<CardView> view = new ArrayList<CardView>();
    private Dimension cardDimension;
    private boolean displayNoCopies = false;
    private UpdateCountsCallback updateCountsCallback;
    private final String[] column = new String[]{"Qty", "Name", "Cost", "Color", "Type", "Stats", "Rarity", "Set", "Card number", "Draft Rating", "Color Identity"};
    public final int COLUMN_INDEX_COST = 2;
    public final int COLUMN_INDEX_RATING = 9;
    public final int COLUMN_INDEX_COLOR_IDENTITY = 10;
    private SortSetting sortSetting;
    private int recentSortedColumn;
    private boolean recentAscending;
    private boolean numberEditable = false;

    public void clear() {
        this.clearCardEventListeners();
        this.clearCards();
        this.view.clear();
    }

    @Override
    public Object getCardsStore() {
        return this.cards;
    }

    @Override
    public void clearCardsStoreBeforeUpdate() {
        this.cards.clear();
        this.view.clear();
    }

    @Override
    public void loadCards(CardsView showCards, SortSetting sortSetting, BigCard bigCard, UUID gameId) {
        this.loadCards(showCards, sortSetting, bigCard, gameId, true);
    }

    @Override
    public void loadCards(CardsView showCards, SortSetting sortSetting, BigCard bigCard, UUID gameId, boolean merge) {
        if (this.sortSetting == null) {
            this.sortSetting = sortSetting;
        }
        this.bigCard = bigCard;
        this.gameId = gameId;
        int landCount = 0;
        int creatureCount = 0;
        int instantCount = 0;
        int sorceryCount = 0;
        int enchantmentCount = 0;
        int artifactCount = 0;
        if (!merge) {
            this.clearCards();
            for (CardView card : showCards.values()) {
                this.addCard(card, bigCard, gameId);
            }
        } else {
            for (CardView card : showCards.values()) {
                if (!this.cards.containsKey(card.getId())) {
                    this.addCard(card, bigCard, gameId);
                }
                if (this.updateCountsCallback == null) continue;
                if (card.isLand()) {
                    ++landCount;
                }
                if (card.isCreature()) {
                    ++creatureCount;
                }
                if (card.isInstant()) {
                    ++instantCount;
                }
                if (card.isSorcery()) {
                    ++sorceryCount;
                }
                if (card.isEnchantment()) {
                    ++enchantmentCount;
                }
                if (!card.isArtifact()) continue;
                ++artifactCount;
            }
            Iterator<Map.Entry<UUID, CardView>> i = this.cards.entrySet().iterator();
            block2: while (i.hasNext()) {
                Map.Entry<UUID, CardView> entry = i.next();
                if (showCards.containsKey((Object)entry.getKey())) continue;
                i.remove();
                if (this.displayNoCopies) {
                    Integer count;
                    String key = entry.getValue().getName() + entry.getValue().getExpansionSetCode() + entry.getValue().getCardNumber();
                    if (!this.cardsNoCopies.containsKey(key)) continue;
                    Integer n = count = this.cardsNoCopies.get(key);
                    Integer n2 = count = Integer.valueOf(count - 1);
                    if (count > 0) {
                        this.cardsNoCopies.put(key, count);
                    } else {
                        this.cardsNoCopies.remove(key);
                    }
                    for (int j = 0; j < this.view.size(); ++j) {
                        CardView cv = this.view.get(j);
                        if (!cv.getId().equals(entry.getValue().getId())) continue;
                        if (count > 0) {
                            String key1 = cv.getName() + cv.getExpansionSetCode() + cv.getCardNumber();
                            for (CardView cardView2 : this.cards.values()) {
                                String key2 = cardView2.getName() + cardView2.getExpansionSetCode() + cardView2.getCardNumber();
                                if (!key1.equals(key2)) continue;
                                this.view.set(j, cardView2);
                                continue block2;
                            }
                            continue block2;
                        }
                        this.view.remove(j);
                        continue block2;
                    }
                    continue;
                }
                this.view.removeIf(cardView -> cardView.getId().equals(entry.getKey()));
            }
            if (this.updateCountsCallback != null) {
                this.updateCountsCallback.update(this.cards.size(), creatureCount, landCount, sorceryCount, instantCount, enchantmentCount, artifactCount);
            }
        }
        this.sort(this.sortSetting.getSortIndex(), this.sortSetting.isAscending());
        this.drawCards(sortSetting);
    }

    @Override
    public void refresh() {
        this.fireTableDataChanged();
    }

    public void clearCards() {
        this.view.clear();
        this.cards.clear();
    }

    @Override
    public int getRowCount() {
        return this.view.size();
    }

    @Override
    public int getColumnCount() {
        return this.column.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.column[n];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getColumn(this.view.get(row), column);
    }

    private Object getColumn(Object obj, int column) {
        CardView c = (CardView)obj;
        switch (column) {
            case 0: {
                if (this.displayNoCopies) {
                    String key = c.getName() + c.getExpansionSetCode() + c.getCardNumber();
                    Integer count = this.cardsNoCopies.get(key);
                    return count != null ? count : "";
                }
                return "";
            }
            case 1: {
                return c.getDisplayFullName();
            }
            case 2: {
                return ManaSymbols.getClearManaCost(c.getManaCostStr());
            }
            case 3: {
                return c.getColorText();
            }
            case 4: {
                return c.getTypeText();
            }
            case 5: {
                return c.isCreature() ? c.getPower() + '/' + c.getToughness() : "-";
            }
            case 6: {
                return c.getRarity() == null ? "" : c.getRarity().toString();
            }
            case 7: {
                return c.getExpansionSetCode();
            }
            case 8: {
                return c.getCardNumber();
            }
            case 9: {
                return RateCard.rateCard((CardView)c, Collections.emptyList());
            }
            case 10: {
                return ManaSymbols.getClearManaCost(c.getOriginalColorIdentity());
            }
        }
        return "error";
    }

    private void addCard(CardView card, BigCard bigCard, UUID gameId) {
        if (this.cardDimension == null) {
            this.cardDimension = new Dimension(ClientDefaultSettings.dimensions.getFrameWidth(), ClientDefaultSettings.dimensions.getFrameHeight());
        }
        this.cards.put(card.getId(), card);
        if (this.displayNoCopies) {
            String key = card.getName() + card.getExpansionSetCode() + card.getCardNumber();
            Integer count = 1;
            if (this.cardsNoCopies.containsKey(key)) {
                count = this.cardsNoCopies.get(key) + 1;
            } else {
                this.view.add(card);
            }
            this.cardsNoCopies.put(key, count);
        } else {
            this.view.add(card);
        }
    }

    @Override
    public void drawCards(SortSetting sortSetting) {
        this.fireTableDataChanged();
    }

    public void removeCard(UUID cardId) {
        this.cards.remove(cardId);
        this.view.removeIf(cardView -> cardView.getId().equals(cardId));
    }

    @Override
    public void addCardEventListener(Listener<Event> listener) {
        this.cardEventSource.addListener(listener);
    }

    @Override
    public void clearCardEventListeners() {
        this.cardEventSource.clearListeners();
    }

    public void setNumber(int index, int number) {
        CardView card = this.view.get(index);
        this.cardEventSource.fireEvent((SimpleCardView)card, ClientEventType.SET_NUMBER, number);
    }

    public void doubleClick(int index, MouseEvent e, boolean forceFakeAltDown) {
        CardView card = this.view.get(index);
        this.cardEventSource.fireEvent((SimpleCardView)card, ClientEventType.CARD_DOUBLE_CLICK, e, forceFakeAltDown);
    }

    public void removeFromMainEvent(int index) {
        this.cardEventSource.fireEvent(ClientEventType.DECK_REMOVE_SELECTION_MAIN);
    }

    public void removeFromSideEvent(int index) {
        this.cardEventSource.fireEvent(ClientEventType.DECK_REMOVE_SELECTION_SIDEBOARD);
    }

    public void addListeners(final JTable table) {
        table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent ev) {
            }

            @Override
            public void keyTyped(KeyEvent ev) {
            }

            @Override
            public void keyReleased(KeyEvent ev) {
                int row = table.getSelectedRow();
                if (row != -1) {
                    TableModel.this.showImage(row);
                }
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int row = table.getSelectedRow();
                if (row != -1) {
                    TableModel.this.showImage(row);
                }
            }
        });
        MouseAdapter mouse = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                TableColumnModel columnModel = table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = table.convertColumnIndexToModel(viewColumn);
                if (column != -1) {
                    boolean asc = true;
                    if (TableModel.this.recentSortedColumn == column) {
                        asc = !TableModel.this.recentAscending;
                    }
                    TableModel.this.sortSetting.setSortIndex(column);
                    TableModel.this.sortSetting.setAscending(asc);
                    TableModel.this.sort(column, asc);
                    TableModel.this.fireTableDataChanged();
                }
            }
        };
        table.getTableHeader().addMouseListener(mouse);
    }

    private void showImage(int row) {
        CardView card = this.view.get(row);
        if (!card.getId().equals(this.bigCard.getCardId())) {
            if (!MageFrame.isLite()) {
                BufferedImage image = Plugins.instance.getOriginalImage(card);
                if (image instanceof BufferedImage) {
                    this.bigCard.setCard(card.getId(), EnlargeMode.NORMAL, image, new ArrayList<String>(), false);
                } else {
                    this.drawCardText(card);
                }
            } else {
                this.drawCardText(card);
            }
        }
    }

    private void drawCardText(CardView card) {
        JXPanel panel = GuiDisplayUtil.getDescription(card, this.bigCard.getWidth(), this.bigCard.getHeight());
        panel.setVisible(true);
        this.bigCard.hideTextComponent();
        this.bigCard.addJXPanel(card.getId(), panel);
    }

    public List<CardView> getCardsView() {
        return this.view;
    }

    public boolean sort(int column, boolean ascending) {
        this.recentSortedColumn = column;
        this.recentAscending = ascending;
        MageCardComparator sorter = new MageCardComparator(column, ascending);
        this.view.sort(sorter);
        this.fireTableDataChanged();
        return true;
    }

    public int getRecentSortedColumn() {
        return this.recentSortedColumn;
    }

    public boolean isRecentAscending() {
        return this.recentAscending;
    }

    public void setDisplayNoCopies(boolean value) {
        this.displayNoCopies = value;
    }

    public void setUpdateCountsCallback(UpdateCountsCallback callback) {
        this.updateCountsCallback = callback;
    }

    public void setNumberEditable(boolean numberEditable) {
        this.numberEditable = numberEditable;
    }

    @Override
    public int cardsSize() {
        return this.cards.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.numberEditable && col == 0) {
            return true;
        }
        return super.isCellEditable(row, col);
    }
}

