/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import mage.cards.Card;
import mage.cards.FrameStyle;
import mage.cards.decks.Deck;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;
import mage.client.MageFrame;
import mage.client.constants.Constants;
import mage.client.dialog.MageDialog;
import mage.client.util.gui.FastSearchUtil;
import mage.constants.Rarity;
import mage.util.DeckBuildUtils;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;
import org.mage.card.arcane.ManaSymbols;

public class AddLandDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(MageDialog.class);
    private Deck deck;
    private Constants.DeckEditorMode mode;
    private AddLandCallback callback = null;
    private static final int DEFAULT_SEALED_DECK_CARD_NUMBER = 40;
    private JButton btnAutoAdd;
    private JButton btnCancel;
    private JButton btnOK;
    private JButton btnSetFastSearch;
    private JComboBox cbLandSet;
    private JCheckBox ckbFullArtLands;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel lblDeckSize;
    private JLabel lblForest;
    private JLabel lblForestIcon;
    private JLabel lblIsland;
    private JLabel lblIslandIcon;
    private JLabel lblLandSet;
    private JLabel lblMountain;
    private JLabel lblMountainIcon;
    private JLabel lblPains;
    private JLabel lblPlainsIcon;
    private JLabel lblSwamp;
    private JLabel lblSwampIcon;
    private JPanel panelSet;
    private JSpinner spnDeckSize;
    private JSpinner spnForest;
    private JSpinner spnIsland;
    private JSpinner spnMountain;
    private JSpinner spnPlains;
    private JSpinner spnSwamp;

    public AddLandDialog() {
        this.initComponents();
        this.setModal(true);
    }

    public void showDialog(Deck deck, Constants.DeckEditorMode mode, AddLandCallback callback) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2;
        BufferedImage bufferedImage3;
        BufferedImage bufferedImage4;
        this.deck = deck;
        this.mode = mode;
        this.callback = callback;
        TreeSet<String> landSetNames = new TreeSet<String>();
        String defaultSetName = null;
        if (mode != Constants.DeckEditorMode.FREE_BUILDING) {
            ExpansionInfo expansionInfo;
            for (String string : deck.getExpansionSetCodes()) {
                expansionInfo = ExpansionRepository.instance.getSetByCode(string);
                if (expansionInfo == null || !expansionInfo.hasBasicLands() || CardRepository.haveSnowLands(expansionInfo.getCode()).booleanValue()) continue;
                defaultSetName = expansionInfo.getName();
                break;
            }
            if (defaultSetName == null) {
                block1: for (String string : deck.getExpansionSetCodes()) {
                    expansionInfo = ExpansionRepository.instance.getSetByCode(string);
                    if (expansionInfo == null) continue;
                    List<ExpansionInfo> blockSets = ExpansionRepository.instance.getSetsFromBlock(expansionInfo.getBlockName());
                    for (ExpansionInfo blockSet : blockSets) {
                        if (!blockSet.hasBasicLands() || CardRepository.haveSnowLands(expansionInfo.getCode()).booleanValue()) continue;
                        defaultSetName = expansionInfo.getName();
                        continue block1;
                    }
                }
            }
        }
        List<ExpansionInfo> basicLandSets = ExpansionRepository.instance.getSetsWithBasicLandsByReleaseDate();
        for (ExpansionInfo expansionInfo : basicLandSets) {
            if (mode != Constants.DeckEditorMode.FREE_BUILDING && CardRepository.haveSnowLands(expansionInfo.getCode()).booleanValue()) continue;
            landSetNames.add(expansionInfo.getName());
        }
        if (landSetNames.isEmpty()) {
            throw new IllegalArgumentException("No set with basic land was found (possible memory problems, need client restart)");
        }
        if (landSetNames.size() > 1) {
            landSetNames.add("<Random lands>");
        }
        this.cbLandSet.setModel(new DefaultComboBoxModel<Object>(landSetNames.toArray()));
        if (defaultSetName != null) {
            for (int i = 0; i < this.cbLandSet.getItemCount(); ++i) {
                String string = (String)this.cbLandSet.getItemAt(i);
                if (!string.equalsIgnoreCase(defaultSetName)) continue;
                this.cbLandSet.setSelectedIndex(i);
                break;
            }
        }
        this.spnDeckSize.setValue(40);
        BufferedImage bufferedImage5 = ManaSymbols.getSizedManaSymbol("G", 15);
        if (bufferedImage5 != null) {
            this.lblForestIcon.setIcon(new ImageIcon(bufferedImage5));
        }
        if ((bufferedImage4 = ManaSymbols.getSizedManaSymbol("U", 15)) != null) {
            this.lblIslandIcon.setIcon(new ImageIcon(bufferedImage4));
        }
        if ((bufferedImage3 = ManaSymbols.getSizedManaSymbol("W", 15)) != null) {
            this.lblPlainsIcon.setIcon(new ImageIcon(bufferedImage3));
        }
        if ((bufferedImage2 = ManaSymbols.getSizedManaSymbol("R", 15)) != null) {
            this.lblMountainIcon.setIcon(new ImageIcon(bufferedImage2));
        }
        if ((bufferedImage = ManaSymbols.getSizedManaSymbol("B", 15)) != null) {
            this.lblSwampIcon.setIcon(new ImageIcon(bufferedImage));
        }
        this.getRootPane().setDefaultButton(this.btnOK);
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.makeWindowCentered();
        this.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.setVisible(true);
    }

    private void addLands(String landName, int number, boolean useFullArt) {
        String landSetName = (String)this.cbLandSet.getSelectedItem();
        ExpansionInfo expansionInfo = null;
        CardCriteria criteria = new CardCriteria();
        if (!landSetName.equals("<Random lands>")) {
            expansionInfo = ExpansionRepository.instance.getSetByName(landSetName);
            if (expansionInfo == null) {
                throw new IllegalArgumentException("Code of Set " + landSetName + " not found");
            }
            criteria.setCodes(expansionInfo.getCode());
        } else {
            criteria.ignoreSetsWithSnowLands();
        }
        if (this.mode == Constants.DeckEditorMode.FREE_BUILDING && expansionInfo != null && CardRepository.haveSnowLands(expansionInfo.getCode()).booleanValue()) {
            criteria.nameContains(landName);
        } else {
            criteria.name(landName);
        }
        criteria.rarities(Rarity.LAND);
        List<CardInfo> cards = CardRepository.instance.findCards(criteria);
        if (cards.isEmpty()) {
            logger.error((Object)("No basic lands found in Set: " + landSetName));
            criteria = new CardCriteria();
            criteria.rarities(Rarity.LAND).name(landName);
            criteria.setCodes("M15");
            cards = CardRepository.instance.findCards(criteria);
        }
        int foundLands = 0;
        int foundNoneAfter = 0;
        int i = 0;
        while (foundLands != number && foundNoneAfter < 1000) {
            boolean useLand;
            Card land = cards.get(RandomUtil.nextInt(cards.size())).createMockCard();
            boolean bl = useLand = !useFullArt;
            if (useFullArt && (land.getFrameStyle() == FrameStyle.BFZ_FULL_ART_BASIC || land.getFrameStyle() == FrameStyle.UGL_FULL_ART_BASIC || land.getFrameStyle() == FrameStyle.UNH_FULL_ART_BASIC || land.getFrameStyle() == FrameStyle.UST_FULL_ART_BASIC || land.getFrameStyle() == FrameStyle.ZEN_FULL_ART_BASIC)) {
                useLand = true;
            }
            if (useLand) {
                this.deck.getCards().add(land);
                ++foundLands;
                foundNoneAfter = 0;
            } else {
                ++foundNoneAfter;
            }
            ++i;
        }
        if (foundNoneAfter >= 1000 && useFullArt) {
            MageFrame.getInstance().showMessage("Unable to add enough " + landName + "s.  You encountered an error in adding chosen lands.  Unable to find enough full art lands in the set " + landSetName + ".");
        }
    }

    private void onCancel() {
        this.removeDialog();
    }

    private void onOK() {
        int nForest = ((Number)this.spnForest.getValue()).intValue();
        int nIsland = ((Number)this.spnIsland.getValue()).intValue();
        int nMountain = ((Number)this.spnMountain.getValue()).intValue();
        int nPlains = ((Number)this.spnPlains.getValue()).intValue();
        int nSwamp = ((Number)this.spnSwamp.getValue()).intValue();
        boolean useFullArt = this.ckbFullArtLands.isSelected();
        this.addLands("Forest", nForest, useFullArt);
        this.addLands("Island", nIsland, useFullArt);
        this.addLands("Mountain", nMountain, useFullArt);
        this.addLands("Plains", nPlains, useFullArt);
        this.addLands("Swamp", nSwamp, useFullArt);
        if (this.callback != null) {
            this.callback.onLandsAdded();
        }
        this.onCancel();
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.lblLandSet = new JLabel();
        this.lblForest = new JLabel();
        this.spnForest = new JSpinner();
        this.lblForestIcon = new JLabel();
        this.lblIsland = new JLabel();
        this.spnIsland = new JSpinner();
        this.lblIslandIcon = new JLabel();
        this.lblMountain = new JLabel();
        this.spnMountain = new JSpinner();
        this.lblMountainIcon = new JLabel();
        this.lblPains = new JLabel();
        this.spnPlains = new JSpinner();
        this.lblPlainsIcon = new JLabel();
        this.lblSwamp = new JLabel();
        this.spnSwamp = new JSpinner();
        this.lblSwampIcon = new JLabel();
        this.lblDeckSize = new JLabel();
        this.spnDeckSize = new JSpinner();
        this.btnAutoAdd = new JButton();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.panelSet = new JPanel();
        this.cbLandSet = new JComboBox();
        this.btnSetFastSearch = new JButton();
        this.ckbFullArtLands = new JCheckBox();
        this.jButton2.setText("jButton2");
        this.jLabel1.setText("jLabel1");
        this.setTitle("Add Land");
        this.lblLandSet.setText("From set:");
        this.lblForest.setText("Forest:");
        this.spnForest.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.lblForestIcon.setMaximumSize(new Dimension(22, 20));
        this.lblForestIcon.setMinimumSize(new Dimension(22, 20));
        this.lblForestIcon.setPreferredSize(new Dimension(22, 20));
        this.lblIsland.setText("Island:");
        this.spnIsland.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.lblIslandIcon.setMaximumSize(new Dimension(22, 20));
        this.lblIslandIcon.setMinimumSize(new Dimension(22, 20));
        this.lblIslandIcon.setPreferredSize(new Dimension(22, 20));
        this.lblMountain.setText("Mountain:");
        this.spnMountain.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.lblMountainIcon.setMaximumSize(new Dimension(22, 20));
        this.lblMountainIcon.setMinimumSize(new Dimension(22, 20));
        this.lblMountainIcon.setPreferredSize(new Dimension(22, 20));
        this.lblPains.setText("Plains:");
        this.spnPlains.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.lblPlainsIcon.setMaximumSize(new Dimension(22, 20));
        this.lblPlainsIcon.setMinimumSize(new Dimension(22, 20));
        this.lblPlainsIcon.setPreferredSize(new Dimension(22, 20));
        this.lblSwamp.setText("Swamp:");
        this.spnSwamp.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.lblSwampIcon.setMaximumSize(new Dimension(22, 20));
        this.lblSwampIcon.setMinimumSize(new Dimension(22, 20));
        this.lblSwampIcon.setPreferredSize(new Dimension(22, 20));
        this.lblDeckSize.setText("Deck size:");
        this.spnDeckSize.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.btnAutoAdd.setText("Suggest lands");
        this.btnAutoAdd.setToolTipText("<HTML>Propose related to the mana costs of the cards in the deck<br>\nthe number of lands to add to get to the set deck size.");
        this.btnAutoAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddLandDialog.this.btnAutoAddActionPerformed(evt);
            }
        });
        this.btnOK.setText("Add lands");
        this.btnOK.setToolTipText("Add the selected number of basic lands to the deck.");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddLandDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddLandDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.panelSet.setLayout(new BoxLayout(this.panelSet, 2));
        this.cbLandSet.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbLandSet.setMinimumSize(new Dimension(20, 20));
        this.panelSet.add(this.cbLandSet);
        this.btnSetFastSearch.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_24.png")));
        this.btnSetFastSearch.setToolTipText("Search for set");
        this.btnSetFastSearch.setAlignmentX(1.0f);
        this.btnSetFastSearch.setPreferredSize(new Dimension(23, 23));
        this.btnSetFastSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddLandDialog.this.btnSetFastSearchActionPerformed(evt);
            }
        });
        this.panelSet.add(this.btnSetFastSearch);
        this.ckbFullArtLands.setText("Only full art lands");
        this.ckbFullArtLands.setToolTipText("For example, lands from ZEN/UST/HOU");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMountain).addComponent(this.lblForest, GroupLayout.Alignment.TRAILING).addComponent(this.lblLandSet, GroupLayout.Alignment.TRAILING).addComponent(this.lblIsland, GroupLayout.Alignment.TRAILING).addComponent(this.lblPains, GroupLayout.Alignment.TRAILING).addComponent(this.lblSwamp, GroupLayout.Alignment.TRAILING)).addComponent(this.lblDeckSize)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnOK, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 100, -2).addContainerGap()).addComponent(this.ckbFullArtLands).addComponent(this.panelSet, -2, 219, -2).addGroup(layout.createSequentialGroup().addComponent(this.spnForest, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblForestIcon, -2, 20, -2)).addGroup(layout.createSequentialGroup().addComponent(this.spnIsland, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblIslandIcon, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.spnMountain, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMountainIcon, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.spnSwamp, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSwampIcon, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.spnDeckSize, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnAutoAdd))).addGroup(layout.createSequentialGroup().addComponent(this.spnPlains, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPlainsIcon, -2, -1, -2).addGap(36, 36, 36)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLandSet).addComponent(this.panelSet, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblForestIcon, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblForest).addComponent(this.spnForest, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblIsland).addComponent(this.spnIsland, -2, -1, -2)).addComponent(this.lblIslandIcon, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMountain).addComponent(this.spnMountain, -2, -1, -2)).addComponent(this.lblMountainIcon, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPains).addComponent(this.spnPlains, -2, -1, -2)).addComponent(this.lblPlainsIcon, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSwamp).addComponent(this.spnSwamp, -2, -1, -2)).addComponent(this.lblSwampIcon, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ckbFullArtLands).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAutoAdd).addComponent(this.lblDeckSize).addComponent(this.spnDeckSize, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK, -2, 30, -2).addComponent(this.btnCancel, -2, 30, -2)).addContainerGap()));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.onCancel();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.onOK();
    }

    private void btnAutoAddActionPerformed(ActionEvent evt) {
        this.autoAddLands();
    }

    private void btnSetFastSearchActionPerformed(ActionEvent evt) {
        FastSearchUtil.showFastSearchForStringComboBox(this.cbLandSet, "Select set or expansion");
    }

    private void autoAddLands() {
        int deckSize = ((Number)this.spnDeckSize.getValue()).intValue();
        int[] lands = DeckBuildUtils.landCountSuggestion(deckSize, this.deck.getMaindeckCards());
        this.spnPlains.setValue(lands[0]);
        this.spnIsland.setValue(lands[1]);
        this.spnSwamp.setValue(lands[2]);
        this.spnMountain.setValue(lands[3]);
        this.spnForest.setValue(lands[4]);
    }

    public static interface AddLandCallback {
        public void onLandsAdded();
    }
}

