/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mage.client.cards.BigCard;
import mage.client.components.ColorPane;
import mage.client.components.MageDesktopIconifySupport;
import mage.client.dialog.MageDialog;
import mage.client.util.GUISizeHelper;
import mage.client.util.SettingsManager;
import mage.client.util.gui.GuiDisplayUtil;
import mage.util.GameLog;
import mage.util.RandomUtil;
import mage.view.CardView;
import mage.view.EmblemView;
import mage.view.GameView;
import mage.view.PlayerView;
import org.apache.log4j.Logger;
import org.mage.card.arcane.ManaSymbols;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public class CardHintsHelperDialog
extends MageDialog
implements MageDesktopIconifySupport {
    private static final Logger logger = Logger.getLogger(CardHintsHelperDialog.class);
    public static final int GUI_MAX_CARD_HINTS_DIALOGS_PER_GAME = 5;
    private static final String WINDOW_TITLE = "Card hints helper";
    private static final String FILTER_ALL = "ALL";
    private static final String SEARCH_EMPTY_TEXT = "search";
    private static final String SEARCH_TOOLTIP = "Filter hints by any words in player, card, id or hint";
    private static final String EMPTY_HINTS_WARNING = "<br>Game not started or nothing to show";
    private static final int MAX_CARD_IDS_PER_HINT = 3;
    private boolean positioned = false;
    private GameView lastGameView = null;
    private final List<CardHintInfo> lastHints = new ArrayList<CardHintInfo>();
    private String currentFilter = "ALL";
    private CardHintGroupBy currentGroup = CardHintGroupBy.GROUP_BY_HINTS;
    private String currentSearch = "";
    private JComboBox<String> comboFilterBy;
    private JComboBox<String> comboGroupBy;
    private JPanel commands;
    private ColorPane hintsView;
    private JScrollPane scrollView;
    private JTextField search;
    private JButton searchClear;
    private JPanel searchPanel;

    public CardHintsHelperDialog() {
        this.initComponents();
        this.hintsView.enableHyperlinksAndCardPopups();
        Color backColor = Color.gray;
        this.setOpaque(true);
        this.setBackground(backColor);
        this.hintsView.setExtBackgroundColor(backColor);
        this.hintsView.setSelectionColor(Color.gray);
        this.scrollView.setOpaque(true);
        this.scrollView.setBackground(backColor);
        this.scrollView.setViewportBorder(null);
        this.scrollView.getViewport().setOpaque(true);
        this.scrollView.getViewport().setBackground(backColor);
        this.setModal(false);
        this.setFrameIcon(new ImageIcon(ImageManagerImpl.instance.getLookedAtImage()));
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.search.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CardHintsHelperDialog.this.onSearchStart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CardHintsHelperDialog.this.onSearchStart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CardHintsHelperDialog.this.onSearchStart();
            }
        });
        this.updateTitle();
        this.changeGUISize();
    }

    private void updateTitle() {
        ArrayList<String> settings = new ArrayList<String>();
        if (!Objects.equals(this.currentFilter, FILTER_ALL)) {
            settings.add(this.currentFilter);
        }
        settings.add(this.currentGroup.toString());
        if (!this.currentSearch.isEmpty() && !this.currentSearch.equals(SEARCH_EMPTY_TEXT)) {
            settings.add(this.currentSearch);
        }
        String newTitle = String.format("%s [%s]", WINDOW_TITLE, String.join((CharSequence)", ", settings));
        this.setTitle(newTitle);
        this.setTitelBarToolTip(newTitle);
    }

    public void cleanUp() {
        this.lastGameView = null;
        this.lastHints.clear();
    }

    public void setGameData(GameView gameView, UUID gameId, BigCard bigCard) {
        this.hintsView.setGameData(gameId, bigCard);
        ArrayList<String> filters = new ArrayList<String>();
        filters.add(FILTER_ALL);
        gameView.getPlayers().stream().filter(PlayerView::getControlled).map(PlayerView::getName).findFirst().ifPresent(filters::add);
        filters.addAll(gameView.getPlayers().stream().filter(p -> !p.getControlled()).map(PlayerView::getName).collect(Collectors.toList()));
        this.comboFilterBy.setModel(new DefaultComboBoxModel<String>(filters.toArray(new String[0])));
        this.comboFilterBy.addActionListener(evt -> {
            this.currentFilter = (String)this.comboFilterBy.getSelectedItem();
            this.updateHints();
        });
        this.comboGroupBy.setModel(new DefaultComboBoxModel<CardHintGroupBy>(CardHintGroupBy.values()));
        this.comboGroupBy.addActionListener(evt -> {
            this.currentGroup = (CardHintGroupBy)((Object)((Object)this.comboGroupBy.getSelectedItem()));
            this.updateHints();
        });
    }

    public void loadHints(GameView newGameView) {
        if (newGameView == null) {
            return;
        }
        if (this.lastGameView != newGameView) {
            this.lastGameView = newGameView;
        }
        this.lastHints.clear();
        PlayerView currentPlayer = this.lastGameView.getPlayers().stream().filter(PlayerView::getControlled).findFirst().orElse(null);
        this.lastGameView.getMyHand().values().forEach(card -> this.lastHints.add(new CardHintInfo(currentPlayer, "hand", (CardView)card)));
        this.lastGameView.getMyHelperEmblems().values().forEach(card -> this.lastHints.add(new CardHintInfo(currentPlayer, "xmage", (CardView)card)));
        this.lastGameView.getStack().values().forEach(card -> this.lastHints.add(new CardHintInfo(currentPlayer, "stack", (CardView)card)));
        for (PlayerView player : this.lastGameView.getPlayers()) {
            player.getBattlefield().values().forEach(card -> this.lastHints.add(new CardHintInfo(player, "battlefield", (CardView)card)));
            player.getCommandObjectList().forEach(object -> {
                if (object instanceof CardView) {
                    this.lastHints.add(new CardHintInfo(player, "command", (CardView)object));
                } else if (object instanceof EmblemView) {
                    // empty if block
                }
            });
            player.getGraveyard().values().forEach(card -> this.lastHints.add(new CardHintInfo(player, "graveyard", (CardView)card)));
            player.getExile().values().forEach(card -> this.lastHints.add(new CardHintInfo(player, "exile", (CardView)card)));
        }
        this.lastHints.removeIf(info -> !info.card.getRules().contains("<br/><hintstart/>"));
        this.updateHints();
    }

    public void updateHints() {
        ArrayList<CardHintInfo> filteredCards = new ArrayList<CardHintInfo>(this.lastHints);
        if (!this.currentFilter.equals(FILTER_ALL)) {
            filteredCards.removeIf(info -> info.player == null || !info.player.getName().equals(this.currentFilter));
        }
        if (!this.currentSearch.isEmpty()) {
            ArrayList<String> needSearches = new ArrayList<String>(Arrays.asList(this.currentSearch.toLowerCase(Locale.ENGLISH).trim().split(" ")));
            filteredCards.removeIf(info -> !info.containsText(needSearches));
        }
        ArrayList<String> renderData = new ArrayList<String>();
        switch (this.currentGroup) {
            default: {
                Map<String, List<CardHintInfo>> groupsByZone = this.prepareGroupByPlayerAndZones(filteredCards, true, false);
                groupsByZone.forEach((group, groupCards) -> {
                    if (groupCards.isEmpty()) {
                        return;
                    }
                    if (!renderData.isEmpty()) {
                        renderData.add("<br>");
                    }
                    CardHintInfo sampleData = (CardHintInfo)groupCards.get(0);
                    renderData.add(String.format("<b>%s</b>:", GameLog.getColoredPlayerName(sampleData.player == null ? "watcher" : sampleData.player.getName())));
                    Map<String, List<CardHintInfo>> groupByHints = this.prepareGroupByHints((List<CardHintInfo>)groupCards);
                    groupByHints.forEach((groupByHint, groupByHintCards) -> {
                        if (groupByHintCards.isEmpty()) {
                            return;
                        }
                        String renderLine = groupByHint;
                        String cardNames = groupByHintCards.stream().limit(3L).map(info -> GameLog.getColoredObjectIdName(info.card.getColor(), info.card.getId(), String.format("[%s]", info.card.getId().toString().substring(0, 3)), "", info.card.getName())).collect(Collectors.joining(", "));
                        if (groupByHintCards.size() > 3) {
                            cardNames = cardNames + String.format(" and %d other", groupByHintCards.size() - 3);
                        }
                        renderLine = renderLine + " (" + cardNames + ")";
                        renderData.add(renderLine);
                    });
                });
                break;
            }
            case GROUP_BY_CARDS: {
                Map<String, List<CardHintInfo>> groupsByZone = this.prepareGroupByPlayerAndZones(filteredCards, true, true);
                groupsByZone.forEach((group, groupCards) -> {
                    if (groupCards.isEmpty()) {
                        return;
                    }
                    if (!renderData.isEmpty()) {
                        renderData.add("<br>");
                    }
                    CardHintInfo sampleData = (CardHintInfo)groupCards.get(0);
                    renderData.add(String.format("<b>%s - %s</b>:", GameLog.getColoredPlayerName(sampleData.player == null ? "watcher" : sampleData.player.getName()), sampleData.zone));
                    groupCards.forEach(info -> {
                        List<String> hints = CardHintsHelperDialog.parseCardHints(info.card.getRules());
                        if (hints != null) {
                            String cardName = GameLog.getColoredObjectIdName(info.card.getColor(), info.card.getId(), info.card.getName(), String.format("[%s]", info.card.getId().toString().substring(0, 3)), null);
                            renderData.addAll(hints.stream().map(s -> cardName + ": " + s).collect(Collectors.toList()));
                        }
                    });
                });
                break;
            }
        }
        if (renderData.isEmpty()) {
            renderData.add(EMPTY_HINTS_WARNING);
        }
        String renderFinal = String.join((CharSequence)"<br>", renderData);
        int oldPos = this.scrollView.getVerticalScrollBar().getValue();
        this.hintsView.setText("<html>" + ManaSymbols.replaceSymbolsWithHTML(renderFinal, ManaSymbols.Type.CHAT));
        SwingUtilities.invokeLater(() -> this.scrollView.getVerticalScrollBar().setValue(oldPos));
        this.updateTitle();
        this.showAndPositionWindow();
    }

    private Map<String, List<CardHintInfo>> prepareGroupByPlayerAndZones(List<CardHintInfo> currentHints, boolean groupByPlayer, boolean groupByZone) {
        if (!groupByPlayer && !groupByZone) {
            throw new IllegalArgumentException("Wrong code usage: must use minimum one group param");
        }
        LinkedHashMap<String, List<CardHintInfo>> res = new LinkedHashMap<String, List<CardHintInfo>>();
        if (currentHints.isEmpty()) {
            return res;
        }
        String lastGroupName = null;
        ArrayList<CardHintInfo> lastGroupCards = null;
        for (CardHintInfo info : currentHints) {
            String currentGroupName = "";
            if (groupByPlayer) {
                currentGroupName = currentGroupName + "@" + (info.player == null ? "null" : info.player.getName());
            }
            if (groupByZone) {
                currentGroupName = currentGroupName + "@" + info.zone;
            }
            if (lastGroupCards == null || !lastGroupName.equals(currentGroupName)) {
                lastGroupName = currentGroupName;
                lastGroupCards = new ArrayList<CardHintInfo>();
                res.put(currentGroupName, lastGroupCards);
            }
            lastGroupCards.add(info);
        }
        res.forEach((zone, infos) -> infos.sort(Comparator.comparing(o -> o.card.getName())));
        return res;
    }

    private Map<String, List<CardHintInfo>> prepareGroupByHints(List<CardHintInfo> currentHints) {
        LinkedHashMap<String, List<CardHintInfo>> res = new LinkedHashMap<String, List<CardHintInfo>>();
        if (currentHints.isEmpty()) {
            return res;
        }
        List<String> allPossibleHints = currentHints.stream().map(info -> CardHintsHelperDialog.parseCardHints(info.card.getRules())).filter(Objects::nonNull).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
        allPossibleHints.forEach(currentHintName -> {
            ArrayList<CardHintInfo> cards = res.getOrDefault(currentHintName, null);
            if (cards == null) {
                cards = new ArrayList<CardHintInfo>();
                res.put((String)currentHintName, (List<CardHintInfo>)cards);
            }
            for (CardHintInfo info : currentHints) {
                if (!info.card.getRules().contains(currentHintName)) continue;
                cards.add(info);
            }
        });
        res.forEach((hint, cards) -> cards.sort(Comparator.comparing(o -> o.card.getId())));
        return res;
    }

    private static List<String> parseCardHints(List<String> rules) {
        if (rules.isEmpty() || !rules.contains("<br/><hintstart/>")) {
            return null;
        }
        ArrayList<String> hints = new ArrayList<String>();
        boolean started = false;
        for (String rule : rules) {
            if (rule.equals("<br/><hintstart/>")) {
                started = true;
                continue;
            }
            if (!started) continue;
            hints.add(rule);
        }
        return hints;
    }

    @Override
    public void changeGUISize() {
        this.setGUISize(GUISizeHelper.dialogFont);
        this.validate();
        this.repaint();
    }

    private void setGUISize(Font font) {
        this.comboFilterBy.setFont(font);
        this.comboGroupBy.setFont(font);
        this.search.setFont(font);
        this.searchClear.setFont(font);
        this.searchClear.setPreferredSize(GUISizeHelper.dialogGuiScaleSize(this.searchClear.getPreferredSize()));
        this.hintsView.changeGUISize(font);
        this.scrollView.setFont(font);
        this.scrollView.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.scrollView.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
    }

    @Override
    public void show() {
        super.show();
        if (this.positioned) {
            this.showAndPositionWindow();
        }
    }

    private void showAndPositionWindow() {
        SwingUtilities.invokeLater(() -> {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width > 0 && height > 0) {
                Point centered = SettingsManager.instance.getComponentPosition(width, height);
                if (!this.positioned) {
                    int xPos = centered.x / 2 + RandomUtil.nextInt(50);
                    int yPos = centered.y / 2 + RandomUtil.nextInt(50);
                    this.setLocation(xPos, yPos);
                    this.show();
                    this.positioned = true;
                }
                GuiDisplayUtil.keepComponentInsideFrame(centered.x, centered.y, this);
            }
        });
    }

    private void onSearchFocused() {
        if (SEARCH_EMPTY_TEXT.equals(this.search.getText())) {
            this.search.setText("");
        } else if (this.search.getText().length() > 0) {
            this.search.selectAll();
        }
    }

    private void onSearchStart() {
        String newSearch;
        String string = newSearch = SEARCH_EMPTY_TEXT.equals(this.search.getText()) ? "" : this.search.getText();
        if (!this.currentSearch.equals(newSearch)) {
            this.currentSearch = newSearch;
            this.updateHints();
        }
    }

    private void onSearchClear() {
        this.search.setText(SEARCH_EMPTY_TEXT);
        this.currentSearch = "";
        this.updateHints();
    }

    private void initComponents() {
        this.scrollView = new JScrollPane();
        this.hintsView = new ColorPane();
        this.commands = new JPanel();
        this.comboFilterBy = new JComboBox();
        this.comboGroupBy = new JComboBox();
        this.searchPanel = new JPanel();
        this.search = new JTextField();
        this.searchClear = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setTitle(WINDOW_TITLE);
        this.setMinimumSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(400, 300));
        this.setTitelBarToolTip("<Not Set>");
        this.getContentPane().setLayout(new BorderLayout());
        this.scrollView.setBorder(null);
        this.scrollView.setOpaque(true);
        this.hintsView.setEditable(false);
        this.hintsView.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.hintsView.setFont(new Font("Arial", 0, 14));
        this.hintsView.setText("<html> test text");
        this.hintsView.setFocusable(false);
        this.hintsView.setOpaque(true);
        this.scrollView.setViewportView(this.hintsView);
        this.getContentPane().add((Component)this.scrollView, "Center");
        this.commands.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.commands.setLayout(new GridLayout(1, 3, 5, 5));
        this.comboFilterBy.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.commands.add(this.comboFilterBy);
        this.comboGroupBy.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.commands.add(this.comboGroupBy);
        this.searchPanel.setLayout(new BorderLayout());
        this.search.setText(SEARCH_EMPTY_TEXT);
        this.search.setToolTipText(SEARCH_TOOLTIP);
        this.search.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CardHintsHelperDialog.this.searchFocusGained(evt);
            }
        });
        this.searchPanel.add((Component)this.search, "Center");
        this.searchClear.setIcon(new ImageIcon(this.getClass().getResource("/buttons/sideboard_out.png")));
        this.searchClear.setToolTipText("Clear search field");
        this.searchClear.setPreferredSize(new Dimension(23, 23));
        this.searchClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardHintsHelperDialog.this.searchClearActionPerformed(evt);
            }
        });
        this.searchPanel.add((Component)this.searchClear, "East");
        this.commands.add(this.searchPanel);
        this.getContentPane().add((Component)this.commands, "North");
        this.pack();
    }

    private void searchFocusGained(FocusEvent evt) {
        this.onSearchFocused();
    }

    private void searchClearActionPerformed(ActionEvent evt) {
        this.onSearchClear();
    }

    private static enum CardHintGroupBy {
        GROUP_BY_HINTS("Hints"),
        GROUP_BY_CARDS("Cards");

        private final String name;

        private CardHintGroupBy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class CardHintInfo {
        final PlayerView player;
        final String zone;
        final CardView card;
        final List<String> hints;
        String searchBase;
        String searchHints;

        public CardHintInfo(PlayerView player, String zone, CardView card) {
            List newHints;
            this.player = player;
            this.zone = zone;
            this.card = card;
            this.hints = new ArrayList<String>();
            if (this.card != null && (newHints = CardHintsHelperDialog.parseCardHints(this.card.getRules())) != null) {
                this.hints.addAll(newHints);
            }
            this.searchBase = (player == null ? "" : player.getName()) + "@" + zone + "@" + (card == null ? "" : card.getIdName());
            this.searchHints = String.join((CharSequence)"@", this.hints);
            this.searchBase = this.searchBase.toLowerCase(Locale.ENGLISH);
            this.searchHints = this.searchHints.toLowerCase(Locale.ENGLISH);
        }

        public boolean containsText(List<String> searches) {
            return searches.stream().anyMatch(s -> this.searchBase.contains((CharSequence)s) || this.searchHints.contains((CharSequence)s));
        }
    }
}

