/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Closeable;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import mage.choices.ChoiceImpl;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PickChoiceDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.dialog.RegisterUserDialog;
import mage.client.dialog.ResetPasswordDialog;
import mage.client.preference.MagePreferences;
import mage.client.util.AppUtil;
import mage.client.util.ClientDefaultSettings;
import mage.client.util.gui.countryBox.CountryComboBox;
import mage.client.util.gui.countryBox.CountryItemEditor;
import mage.remote.Connection;
import mage.utils.StreamUtils;
import org.apache.log4j.Logger;

public class ConnectDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(ConnectDialog.class);
    private Connection connection;
    private ConnectTask task;
    private final RegisterUserDialog registerUserDialog;
    private final ResetPasswordDialog resetPasswordDialog;
    ConnectCallback callback = null;
    private final ActionListener connectAction = evt -> this.btnConnectActionPerformed(evt);
    private JButton btnCancel;
    private JButton btnCheckStatus;
    private JButton btnConnect;
    private JButton btnFindBeta;
    private JButton btnFindEU;
    private JButton btnFindLocal;
    private JButton btnFindMain;
    private JButton btnFindOther;
    private JButton btnFindUs;
    private JButton btnFlagSearch;
    private JButton btnForgotPassword;
    private JButton btnRegister;
    private JButton btnWhatsNew;
    private CountryComboBox cbFlag;
    private JCheckBox chkAutoConnect;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLabel jLabel1;
    private JButton jProxySettingsButton;
    private JLabel lblFastConnect;
    private JLabel lblFlag;
    private JLabel lblPassword;
    private JLabel lblPort;
    private JLabel lblServer;
    private JLabel lblStatus;
    private JLabel lblUserName;
    private JPanel panelFast;
    private JPanel panelFlag;
    private JPanel panelServer;
    private JPasswordField txtPassword;
    private JTextField txtPort;
    private JTextField txtServer;
    private JTextField txtUserName;

    public ConnectDialog() {
        this.initComponents();
        this.txtServer.addActionListener(this.connectAction);
        this.txtPort.addActionListener(this.connectAction);
        this.txtUserName.addActionListener(this.connectAction);
        this.txtPassword.addActionListener(this.connectAction);
        this.registerUserDialog = new RegisterUserDialog();
        MageFrame.getDesktop().add((Component)this.registerUserDialog, this.registerUserDialog.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.resetPasswordDialog = new ResetPasswordDialog();
        MageFrame.getDesktop().add((Component)this.resetPasswordDialog, this.resetPasswordDialog.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
    }

    public void showDialog(ConnectCallback callback) {
        this.lblStatus.setText("");
        String serverAddress = MagePreferences.getServerAddressWithDefault(ClientDefaultSettings.serverName);
        this.txtServer.setText(serverAddress);
        this.txtPort.setText(Integer.toString(MagePreferences.getServerPortWithDefault(ClientDefaultSettings.port)));
        this.txtUserName.setText(MagePreferences.getUserName(serverAddress));
        this.txtPassword.setText(MagePreferences.getPassword(serverAddress));
        this.chkAutoConnect.setSelected(Boolean.parseBoolean(MageFrame.getPreferences().get("autoConnect", "false")));
        String selectedFlag = MageFrame.getPreferences().get("connectFlag", "world");
        for (int i = 0; i < this.cbFlag.getItemCount(); ++i) {
            String[] name = (String[])this.cbFlag.getItemAt(i);
            if (!name[1].equals(selectedFlag)) continue;
            this.cbFlag.setSelectedIndex(i);
            break;
        }
        this.setModal(true);
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.setLocation(50, 50);
        this.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.setVisible(true);
    }

    private void onCancel() {
        MageFrame.getPreferences().put("autoConnect", Boolean.toString(this.chkAutoConnect.isSelected()));
        MageFrame.getPreferences().put("connectFlag", ((CountryItemEditor)this.cbFlag.getEditor()).getImageItem());
        if (this.task != null && !this.task.isDone()) {
            this.task.cancel(true);
        } else {
            this.hideDialog();
            if (this.callback != null) {
                this.callback.onConnectClosed();
            }
        }
    }

    private void saveSettings() {
        String serverAddress = this.txtServer.getText().trim();
        MagePreferences.setServerAddress(serverAddress);
        MagePreferences.setServerPort(Integer.parseInt(this.txtPort.getText().trim()));
        MagePreferences.setUserName(serverAddress, this.txtUserName.getText().trim());
        MagePreferences.setPassword(serverAddress, String.valueOf(this.txtPassword.getPassword()).trim());
        MageFrame.getPreferences().put("autoConnect", Boolean.toString(this.chkAutoConnect.isSelected()));
        MagePreferences.saveLastServer();
    }

    private void setServerSettings(String address, String port, boolean needRegistration) {
        this.txtServer.setText(address);
        this.txtPort.setText(port);
        this.txtUserName.setText(MagePreferences.getUserName(address));
        if (needRegistration) {
            this.txtPassword.setText(MagePreferences.getPassword(address));
        } else {
            this.txtPassword.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chooseAndSetServerSettingsFromOther() {
        Closeable in = null;
        Closeable output = null;
        try {
            ArrayList servers = new ArrayList();
            if (servers.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Couldn't find any server.");
                return;
            }
            String selectedServer = (String)JOptionPane.showInputDialog(null, "Choose XMage Public Server:", "Input", 1, null, servers.toArray(), servers.get(0));
            if (selectedServer != null) {
                String[] params = selectedServer.split(":");
                if (params.length == 3) {
                    this.setServerSettings(params[1], params[2], true);
                } else {
                    JOptionPane.showMessageDialog(null, "Wrong server data format.");
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        finally {
            StreamUtils.closeQuietly(in);
            StreamUtils.closeQuietly(output);
        }
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.lblUserName = new JLabel();
        this.txtUserName = new JTextField();
        this.lblPassword = new JLabel();
        this.txtPassword = new JPasswordField();
        this.lblFlag = new JLabel();
        this.chkAutoConnect = new JCheckBox();
        this.jProxySettingsButton = new JButton();
        this.btnConnect = new JButton();
        this.btnCancel = new JButton();
        this.lblStatus = new JLabel();
        this.btnRegister = new JButton();
        this.btnForgotPassword = new JButton();
        this.lblFastConnect = new JLabel();
        this.panelFlag = new JPanel();
        this.cbFlag = new CountryComboBox();
        this.filler1 = new Box.Filler(new Dimension(5, 0), new Dimension(4, 0), new Dimension(5, Short.MAX_VALUE));
        this.btnFlagSearch = new JButton();
        this.panelFast = new JPanel();
        this.btnFindMain = new JButton();
        this.btnFindLocal = new JButton();
        this.btnFindBeta = new JButton();
        this.btnFindUs = new JButton();
        this.btnFindOther = new JButton();
        this.btnFindEU = new JButton();
        this.panelServer = new JPanel();
        this.txtServer = new JTextField();
        this.txtPort = new JTextField();
        this.lblPort = new JLabel();
        this.btnCheckStatus = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 50), new Dimension(0, 50), new Dimension(Short.MAX_VALUE, 50));
        this.btnWhatsNew = new JButton();
        this.jLabel1 = new JLabel();
        this.setTitle("Connect to server");
        this.lblServer.setHorizontalAlignment(4);
        this.lblServer.setLabelFor(this.txtServer);
        this.lblServer.setText("Server name:");
        this.lblUserName.setHorizontalAlignment(4);
        this.lblUserName.setLabelFor(this.txtUserName);
        this.lblUserName.setText("Username:");
        this.lblPassword.setHorizontalAlignment(4);
        this.lblPassword.setLabelFor(this.txtPassword);
        this.lblPassword.setText("Password:");
        this.lblFlag.setHorizontalAlignment(4);
        this.lblFlag.setLabelFor(this.txtUserName);
        this.lblFlag.setText("User's flag:");
        this.chkAutoConnect.setText("Automatically connect to this server next time");
        this.chkAutoConnect.setToolTipText("<HTML>If active this connect dialog will not be shown if you choose to connect.<br>\nInstead XMage tries to connect to the last server you were connected to.");
        this.chkAutoConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.chkAutoConnectActionPerformed(evt);
            }
        });
        this.jProxySettingsButton.setText("Proxy Settings...");
        this.jProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.jProxySettingsButtonActionPerformed(evt);
            }
        });
        this.btnConnect.setFont(new Font("Tahoma", 1, 11));
        this.btnConnect.setText("Connect to server");
        this.btnConnect.setMargin(new Insets(2, 2, 2, 2));
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnConnectActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.setHorizontalTextPosition(0);
        this.btnCancel.setMargin(new Insets(2, 2, 2, 2));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnRegister.setText("Register new user...");
        this.btnRegister.setToolTipText("<html>XMage now supports user authentication.<br>Register your account before you log in.<html>");
        this.btnRegister.setMargin(new Insets(2, 2, 2, 2));
        this.btnRegister.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnRegisterActionPerformed(evt);
            }
        });
        this.btnForgotPassword.setText("Forgot password...");
        this.btnForgotPassword.setToolTipText("<html>You can reset your password if you have registered<br>your account with an email address.</html>");
        this.btnForgotPassword.setMargin(new Insets(2, 2, 2, 2));
        this.btnForgotPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnForgotPasswordActionPerformed(evt);
            }
        });
        this.lblFastConnect.setHorizontalAlignment(0);
        this.lblFastConnect.setLabelFor(this.btnFindMain);
        this.lblFastConnect.setText("Connect to:");
        this.lblFastConnect.setName("");
        this.panelFlag.setMinimumSize(new Dimension(50, 33));
        this.panelFlag.setLayout(new BoxLayout(this.panelFlag, 2));
        this.cbFlag.setEditable(true);
        this.cbFlag.setMaximumRowCount(16);
        this.cbFlag.setAlignmentX(0.0f);
        this.cbFlag.setMinimumSize(new Dimension(50, 18));
        this.cbFlag.setPreferredSize(new Dimension(278, 15));
        this.panelFlag.add(this.cbFlag);
        this.panelFlag.add(this.filler1);
        this.btnFlagSearch.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_24.png")));
        this.btnFlagSearch.setToolTipText("Fast search your flag");
        this.btnFlagSearch.setAlignmentX(1.0f);
        this.btnFlagSearch.setPreferredSize(new Dimension(23, 23));
        this.btnFlagSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnFlagSearchActionPerformed(evt);
            }
        });
        this.panelFlag.add(this.btnFlagSearch);
        this.btnFindMain.setIcon(new ImageIcon(this.getClass().getResource("/flags/de.png")));
        this.btnFindMain.setText("X");
        this.btnFindMain.setToolTipText("Connect to xmage.de (first Europe server, most popular, registration needs)");
        this.btnFindMain.setAlignmentY(0.0f);
        this.btnFindMain.setEnabled(false);
        this.btnFindMain.setMargin(new Insets(2, 2, 2, 2));
        this.btnFindMain.setMaximumSize(new Dimension(42, 23));
        this.btnFindMain.setMinimumSize(new Dimension(42, 23));
        this.btnFindMain.setPreferredSize(new Dimension(23, 23));
        this.btnFindMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnFindMainActionPerformed(evt);
            }
        });
        this.btnFindLocal.setText("LOCAL, AI");
        this.btnFindLocal.setToolTipText("Connect to localhost, AI enabled (run local server from launcher)");
        this.btnFindLocal.setAlignmentY(0.0f);
        this.btnFindLocal.setHorizontalTextPosition(0);
        this.btnFindLocal.setMargin(new Insets(2, 2, 2, 2));
        this.btnFindLocal.setPreferredSize(new Dimension(23, 23));
        this.btnFindLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnFindLocalActionPerformed(evt);
            }
        });
        this.btnFindBeta.setText("BETA");
        this.btnFindBeta.setToolTipText("Connect to BETA server, AI disabled (use any username without registration)");
        this.btnFindBeta.setAlignmentY(0.0f);
        this.btnFindBeta.setHorizontalTextPosition(0);
        this.btnFindBeta.setMargin(new Insets(2, 2, 2, 2));
        this.btnFindBeta.setPreferredSize(new Dimension(23, 23));
        this.btnFindBeta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnFindBetaActionPerformed(evt);
            }
        });
        this.btnFindUs.setIcon(new ImageIcon(this.getClass().getResource("/flags/us.png")));
        this.btnFindUs.setText("US");
        this.btnFindUs.setToolTipText("Connect to us.xmage.today (USA, use any username without registration)");
        this.btnFindUs.setAlignmentY(0.0f);
        this.btnFindUs.setEnabled(false);
        this.btnFindUs.setMargin(new Insets(2, 2, 2, 2));
        this.btnFindUs.setPreferredSize(new Dimension(23, 23));
        this.btnFindUs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnFindUsActionPerformed(evt);
            }
        });
        this.btnFindOther.setText("Other...");
        this.btnFindOther.setToolTipText("Choose server from full servers list");
        this.btnFindOther.setEnabled(false);
        this.btnFindOther.setHorizontalTextPosition(0);
        this.btnFindOther.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnFindOtherActionPerformed(evt);
            }
        });
        this.btnFindEU.setIcon(new ImageIcon(this.getClass().getResource("/flags/europeanunion.png")));
        this.btnFindEU.setText("EU");
        this.btnFindEU.setToolTipText("Connect to eu.xmage.today (second Europe server, use any username without registration)");
        this.btnFindEU.setAlignmentY(0.0f);
        this.btnFindEU.setEnabled(false);
        this.btnFindEU.setMargin(new Insets(2, 2, 2, 2));
        this.btnFindEU.setMaximumSize(new Dimension(42, 23));
        this.btnFindEU.setMinimumSize(new Dimension(42, 23));
        this.btnFindEU.setPreferredSize(new Dimension(23, 23));
        this.btnFindEU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnFindEUActionPerformed(evt);
            }
        });
        GroupLayout panelFastLayout = new GroupLayout(this.panelFast);
        this.panelFast.setLayout(panelFastLayout);
        panelFastLayout.setHorizontalGroup(panelFastLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFastLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.btnFindMain, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFindEU, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFindUs, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFindBeta, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFindLocal, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFindOther, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        panelFastLayout.setVerticalGroup(panelFastLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFastLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelFastLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnFindMain, -2, 30, -2).addComponent(this.btnFindLocal, -2, 30, -2).addComponent(this.btnFindUs, -2, 30, -2).addComponent(this.btnFindBeta, -2, 30, -2).addComponent(this.btnFindOther, -2, 30, -2).addComponent(this.btnFindEU, -2, 30, -2)).addGap(0, 0, 0)));
        this.txtPort.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ConnectDialog.this.keyTyped(evt);
            }
        });
        this.lblPort.setLabelFor(this.txtPort);
        this.lblPort.setText("Port:");
        this.btnCheckStatus.setIcon(new ImageIcon(this.getClass().getResource("/flags/world.png")));
        this.btnCheckStatus.setText("Check online status");
        this.btnCheckStatus.setToolTipText("Go to servers online statuses page");
        this.btnCheckStatus.setAlignmentY(0.0f);
        this.btnCheckStatus.setEnabled(false);
        this.btnCheckStatus.setMargin(new Insets(2, 2, 2, 2));
        this.btnCheckStatus.setPreferredSize(new Dimension(23, 23));
        this.btnCheckStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnCheckStatusActionPerformed(evt);
            }
        });
        GroupLayout panelServerLayout = new GroupLayout(this.panelServer);
        this.panelServer.setLayout(panelServerLayout);
        panelServerLayout.setHorizontalGroup(panelServerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelServerLayout.createSequentialGroup().addComponent(this.txtServer, -2, 212, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPort, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCheckStatus, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        panelServerLayout.setVerticalGroup(panelServerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelServerLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelServerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtServer, -2, -1, -2).addComponent(this.txtPort, -2, -1, -2).addComponent(this.lblPort).addComponent(this.btnCheckStatus, -1, -1, Short.MAX_VALUE))));
        this.btnWhatsNew.setText("Show what's new");
        this.btnWhatsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.btnWhatsNewActionPerformed(evt);
            }
        });
        this.jLabel1.setText("(use empty password for servers without registration)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblUserName, -1, -1, Short.MAX_VALUE).addComponent(this.lblServer, -1, -1, Short.MAX_VALUE).addComponent(this.lblFastConnect, -1, -1, Short.MAX_VALUE).addComponent(this.lblPassword, -1, -1, Short.MAX_VALUE).addComponent(this.lblFlag, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatus, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.chkAutoConnect, -1, -1, Short.MAX_VALUE).addComponent(this.txtUserName).addComponent(this.panelFlag, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnConnect, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnRegister, -1, -1, Short.MAX_VALUE).addComponent(this.btnForgotPassword, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 77, -2)).addComponent(this.panelFast, -1, -1, Short.MAX_VALUE).addComponent(this.panelServer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jProxySettingsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnWhatsNew).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.txtPassword).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler2, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelFast, -1, -1, Short.MAX_VALUE).addComponent(this.lblFastConnect, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelServer, -1, -1, Short.MAX_VALUE).addComponent(this.lblServer, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtUserName, -2, -1, -2).addComponent(this.lblUserName, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPassword).addComponent(this.jLabel1)).addComponent(this.lblPassword, -1, -1, Short.MAX_VALUE))).addComponent(this.filler2, -1, 52, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelFlag, -2, 20, -2).addComponent(this.lblFlag, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkAutoConnect).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jProxySettingsButton, -2, 30, -2).addComponent(this.btnWhatsNew, -2, 30, -2)).addGap(29, 29, 29).addComponent(this.lblStatus, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.btnRegister, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnForgotPassword, -1, -1, Short.MAX_VALUE)).addComponent(this.btnConnect, -1, -1, Short.MAX_VALUE).addComponent(this.btnCancel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(23, 23, 23)));
        this.lblFastConnect.getAccessibleContext().setAccessibleName("Fast connect to:");
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.onCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnConnectActionPerformed(ActionEvent evt) {
        if (this.txtServer.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this.rootPane, "Please provide a server address");
            return;
        }
        if (this.txtPort.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this.rootPane, "Please provide a port number");
            return;
        }
        if (this.txtUserName.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.rootPane, "Please provide a user name");
            return;
        }
        if (Integer.parseInt(this.txtPort.getText()) < 1 || Integer.parseInt(this.txtPort.getText()) > 65535) {
            JOptionPane.showMessageDialog(this.rootPane, "Invalid port number");
            this.txtPort.setText(Integer.toString(MagePreferences.getServerPortWithDefault(ClientDefaultSettings.port)));
            return;
        }
        char[] input = new char[]{};
        try {
            this.connection = new Connection();
            this.connection.setHost(this.txtServer.getText().trim());
            this.connection.setPort(Integer.parseInt(this.txtPort.getText().trim()));
            this.connection.setUsername(this.txtUserName.getText().trim());
            this.connection.setPassword(String.valueOf(this.txtPassword.getPassword()).trim());
            String allMAC = "";
            try {
                allMAC = Connection.getMAC();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            this.connection.setUserIdStr(System.getProperty("user.name") + ":" + System.getProperty("os.name") + ":" + MagePreferences.getUserNames() + ":" + allMAC);
            MageFrame.getPreferences().put("connectFlag", ((CountryItemEditor)this.cbFlag.getEditor()).getImageItem());
            PreferencesDialog.setProxyInformation(this.connection);
            MageFrame.getInstance().setUserPrefsToConnection(this.connection);
            logger.debug((Object)("connecting: " + this.connection.getProxyType() + ' ' + this.connection.getProxyHost() + ' ' + this.connection.getProxyPort()));
            this.task = new ConnectTask();
            this.task.execute();
        }
        finally {
            Arrays.fill(input, '0');
        }
    }

    private void setConnectButtonsState(boolean enable) {
        this.btnConnect.setEnabled(enable);
        this.btnRegister.setEnabled(enable);
        this.btnForgotPassword.setEnabled(enable);
    }

    private void doAfterConnected() {
        this.saveSettings();
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onConnectClosed();
        }
    }

    private void keyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (!Character.isDigit(c)) {
            evt.consume();
        }
    }

    private void chkAutoConnectActionPerformed(ActionEvent evt) {
    }

    private void findPublicServerActionPerformed(ActionEvent evt) {
    }

    private void jProxySettingsButtonActionPerformed(ActionEvent evt) {
        PreferencesDialog.main(new String[]{"Open-Connection-Tab"});
    }

    private void txtUserNameActionPerformed(ActionEvent evt) {
    }

    private void txtPasswordActionPerformed(ActionEvent evt) {
    }

    private void btnRegisterActionPerformed(ActionEvent evt) {
        this.registerUserDialog.showDialog(this.getServer(), this.getPort());
    }

    private void btnForgotPasswordActionPerformed(ActionEvent evt) {
        this.resetPasswordDialog.showDialog(this.getServer(), this.getPort());
    }

    private void connectXmageDe(ActionEvent evt) {
        String serverAddress = "xmage.de";
        this.txtServer.setText(serverAddress);
        this.txtPort.setText("17171");
        this.txtUserName.setText(MagePreferences.getUserName(serverAddress));
        this.txtPassword.setText(MagePreferences.getPassword(serverAddress));
    }

    private void connectLocalhost(ActionEvent evt) {
        String serverAddress = "localhost";
        this.txtServer.setText(serverAddress);
        this.txtPort.setText("17171");
        this.txtUserName.setText(MagePreferences.getUserName(serverAddress));
        this.txtPassword.setText(MagePreferences.getPassword(serverAddress));
    }

    private void connectXmageus(ActionEvent evt) {
        String serverAddress = "us.xmage.today";
        this.txtServer.setText(serverAddress);
        this.txtPort.setText("17171");
        this.txtUserName.setText(MagePreferences.getUserName(serverAddress));
        this.txtPassword.setText(MagePreferences.getPassword(serverAddress));
    }

    private void connectBeta(ActionEvent evt) {
        String serverAddress = "beta.xmage.today";
        this.txtServer.setText(serverAddress);
        this.txtPort.setText("17171");
        this.txtUserName.setText(MagePreferences.getUserName(serverAddress));
        this.txtPassword.setText(MagePreferences.getPassword(serverAddress));
    }

    private void btnFlagSearchActionPerformed(ActionEvent evt) {
        this.doFastFlagSearch();
    }

    private void btnCheckStatusActionPerformed(ActionEvent evt) {
        AppUtil.openUrlInSystemBrowser("http://xmage.today/servers/");
    }

    private void btnWhatsNewActionPerformed(ActionEvent evt) {
        MageFrame.getInstance().showWhatsNewDialog(true);
    }

    private void btnFindMainActionPerformed(ActionEvent evt) {
        this.setServerSettings("xmage.de", "17171", true);
    }

    private void btnFindEUActionPerformed(ActionEvent evt) {
        this.setServerSettings("eu.xmage.today", "17171", false);
    }

    private void btnFindUsActionPerformed(ActionEvent evt) {
        this.setServerSettings("us.xmage.today", "17171", false);
    }

    private void btnFindBetaActionPerformed(ActionEvent evt) {
        this.setServerSettings("beta.xmage.today", "17171", false);
    }

    private void btnFindLocalActionPerformed(ActionEvent evt) {
        this.setServerSettings("localhost", "17171", false);
    }

    private void btnFindOtherActionPerformed(ActionEvent evt) {
        this.chooseAndSetServerSettingsFromOther();
    }

    private void doFastFlagSearch() {
        String[] flagItem;
        ChoiceImpl choice = new ChoiceImpl(false);
        LinkedHashMap<String, String> choiceItems = new LinkedHashMap<String, String>();
        DefaultComboBoxModel flagModel = (DefaultComboBoxModel)this.cbFlag.getModel();
        for (int i = 0; i < flagModel.getSize(); ++i) {
            flagItem = (String[])flagModel.getElementAt(i);
            choiceItems.put(flagItem[1], flagItem[0]);
        }
        choice.setKeyChoices(choiceItems);
        choice.setMessage("Select your country");
        String needSelectValue = null;
        flagItem = (String[])flagModel.getSelectedItem();
        if (flagItem != null) {
            needSelectValue = flagItem[1];
        }
        PickChoiceDialog dlg = new PickChoiceDialog();
        dlg.setWindowSize(300, 500);
        dlg.showDialog(choice, needSelectValue, () -> {
            if (choice.isChosen()) {
                String[] flag = new String[]{choice.getChoiceValue(), choice.getChoiceKey()};
                flagModel.setSelectedItem(flag);
            }
        });
    }

    public String getServer() {
        return this.txtServer.getText();
    }

    public String getPort() {
        return this.txtPort.getText();
    }

    private class ConnectTask
    extends SwingWorker<Boolean, Void> {
        private boolean result = false;
        private String lastConnectError = "";
        private static final int CONNECTION_TIMEOUT_MS = 2100;

        private ConnectTask() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            SwingUtilities.invokeLater(() -> {
                ConnectDialog.this.lblStatus.setText("Connecting...");
                ConnectDialog.this.setConnectButtonsState(false);
            });
            this.result = MageFrame.connect(ConnectDialog.this.connection);
            this.lastConnectError = SessionHandler.getLastConnectError();
            return this.result;
        }

        @Override
        protected void done() {
            try {
                this.get(2100L, TimeUnit.MILLISECONDS);
                SwingUtilities.invokeLater(() -> {
                    if (this.result) {
                        ConnectDialog.this.lblStatus.setText("Connected");
                        SwingUtilities.invokeLater(() -> {
                            ConnectDialog.this.doAfterConnected();
                            MageFrame.getInstance().prepareAndShowServerLobby();
                            ConnectDialog.this.btnConnect.setEnabled(true);
                        });
                    } else {
                        ConnectDialog.this.lblStatus.setText("Could not connect: " + this.lastConnectError);
                    }
                });
            }
            catch (InterruptedException | ExecutionException ex) {
                logger.fatal((Object)"Connection: can't load data from server", (Throwable)ex);
            }
            catch (CancellationException ex) {
                logger.info((Object)"Connect: canceled");
                ConnectDialog.this.lblStatus.setText("Connect was canceled");
            }
            catch (TimeoutException ex) {
                logger.fatal((Object)"Connection: timeout", (Throwable)ex);
            }
            finally {
                if (!this.result) {
                    MageFrame.stopConnecting();
                    SwingUtilities.invokeLater(() -> ConnectDialog.this.setConnectButtonsState(true));
                }
            }
        }
    }

    public static interface ConnectCallback {
        public void onConnectClosed();
    }
}

