/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.client.util.gui.FastSearchUtil;

public class DownloadImagesDialog
extends MageDialog {
    private final Dimension sizeModeMessageOnly;
    private final Dimension sizeModeMessageAndControls;
    private final Map<Component, Boolean> actionsControlStates = new HashMap<Component, Boolean>();
    private DownloadImagesCallback callback = null;
    private JButton buttonCancel;
    private JButton buttonOK;
    private JButton buttonSearchSet;
    private JButton buttonStop;
    private JCheckBox checkboxRedownload;
    private JComboBox<String> comboDownloadThreads;
    private JComboBox<String> comboLanguage;
    private JComboBox<String> comboSets;
    private JComboBox<String> comboSource;
    private Box.Filler filler1;
    private Box.Filler fillerGlobal1;
    private Box.Filler fillerInfo1;
    private Box.Filler fillerInfo2;
    private Box.Filler fillerMain1;
    private Box.Filler fillerMain2;
    private Box.Filler fillerMode1;
    private Box.Filler fillerProgress1;
    private Box.Filler fillerProgress2;
    private Box.Filler fillerglobal2;
    private JLabel labelDownloadThreads;
    private JLabel labelGlobal;
    private JLabel labelInfo;
    private JLabel labelLanguage;
    private JLabel labelMode;
    private JLabel labelSource;
    private JPanel panelCommands;
    private JPanel panelGlobal;
    private JPanel panelInfo;
    private JPanel panelMode;
    private JPanel panelModeInner;
    private JPanel panelModeSelect;
    private JPanel panelProgress;
    private JPanel panelRedownload;
    private JPanel panelSource;
    private JPanel panelSourceCenter;
    private JPanel panelSourceLeft;
    private JPanel panelSourceRight;
    private JProgressBar progress;
    private JPanel tabCustom;
    private JPanel tabMain;
    private JTabbedPane tabsList;

    public DownloadImagesDialog() {
        this.initComponents();
        this.setModal(true);
        this.panelInfo.setAlignmentX(0.5f);
        this.sizeModeMessageAndControls = new Dimension(716, 329);
        this.sizeModeMessageOnly = new Dimension(this.sizeModeMessageAndControls.getSize());
        this.sizeModeMessageOnly.height = 100;
        this.sizeModeMessageOnly.width /= 2;
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadImagesDialog.this.onCancel();
            }
        });
    }

    public void setWindowSize(int width, int heigth) {
        this.setSize(new Dimension(width, heigth));
    }

    public void showDialog(DownloadImagesCallback callback) {
        this.callback = callback;
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.showDownloadControls(false);
        this.setVisible(true);
    }

    public void setGlobalInfo(String info) {
        Dimension newSize = new Dimension(Integer.MAX_VALUE, this.labelGlobal.getPreferredSize().height);
        this.labelGlobal.setPreferredSize(newSize);
        this.labelGlobal.setMaximumSize(newSize);
        this.labelGlobal.setHorizontalAlignment(0);
        this.labelGlobal.setText(info);
    }

    public void setCurrentInfo(String info) {
        this.labelInfo.setText(info);
    }

    public JComboBox getSourcesCombo() {
        return this.comboSource;
    }

    public JComboBox getLaunguagesCombo() {
        return this.comboLanguage;
    }

    public JComboBox getDownloadThreadsCombo() {
        return this.comboDownloadThreads;
    }

    public JComboBox getSetsCombo() {
        return this.comboSets;
    }

    public JButton getStartButton() {
        return this.buttonOK;
    }

    public JButton getCancelButton() {
        return this.buttonCancel;
    }

    public JButton getStopButton() {
        return this.buttonStop;
    }

    public JProgressBar getProgressBar() {
        return this.progress;
    }

    public JCheckBox getRedownloadCheckbox() {
        return this.checkboxRedownload;
    }

    public void showLanguagesSupport(boolean haveSupport) {
        this.labelLanguage.setEnabled(haveSupport);
        this.comboLanguage.setEnabled(haveSupport);
    }

    private void enableActionControl(boolean enable, Component comp) {
        if (enable) {
            comp.setEnabled(this.actionsControlStates.getOrDefault(comp, true));
        } else {
            this.actionsControlStates.putIfAbsent(comp, comp.isEnabled());
            comp.setEnabled(false);
        }
    }

    public void enableActionControls(boolean enable) {
        this.enableActionControl(enable, this.tabsList);
        this.enableActionControl(enable, this.comboSource);
        this.enableActionControl(enable, this.comboSets);
        this.enableActionControl(enable, this.buttonSearchSet);
        this.enableActionControl(enable, this.comboLanguage);
        this.enableActionControl(enable, this.comboDownloadThreads);
        this.enableActionControl(enable, this.checkboxRedownload);
    }

    private void setTabTitle(int tabIndex, String title, String iconResourceName) {
        JLabel lbl = new JLabel(title);
        ImageIcon icon = new ImageIcon(this.getClass().getResource(iconResourceName));
        lbl.setIcon(icon);
        lbl.setIconTextGap(5);
        lbl.setHorizontalTextPosition(4);
        this.tabsList.setTabComponentAt(tabIndex, lbl);
    }

    public void showDownloadControls(boolean needToShow) {
        this.panelGlobal.setVisible(true);
        this.buttonStop.setVisible(!needToShow);
        this.tabsList.setVisible(needToShow);
        this.panelCommands.setVisible(needToShow);
        if (needToShow) {
            this.setWindowSize(this.sizeModeMessageAndControls.width, this.sizeModeMessageAndControls.height);
        } else {
            this.setWindowSize(this.sizeModeMessageOnly.width, this.sizeModeMessageOnly.height);
        }
        this.makeWindowCentered();
        this.setTabTitle(0, "Standard download", "/buttons/card_panel.png");
        this.setTabTitle(1, "Custom download", "/buttons/list_panel.png");
        this.tabsList.getTabComponentAt(1).setEnabled(false);
        this.tabsList.setEnabledAt(1, false);
        this.invalidate();
    }

    private void initComponents() {
        this.panelGlobal = new JPanel();
        this.fillerGlobal1 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 5), new Dimension(Short.MAX_VALUE, 5));
        this.labelGlobal = new JLabel();
        this.buttonStop = new JButton();
        this.fillerglobal2 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 5), new Dimension(Short.MAX_VALUE, 5));
        this.tabsList = new JTabbedPane();
        this.tabMain = new JPanel();
        this.panelInfo = new JPanel();
        this.fillerInfo1 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 5), new Dimension(Short.MAX_VALUE, 5));
        this.labelInfo = new JLabel();
        this.fillerInfo2 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 5), new Dimension(Short.MAX_VALUE, 5));
        this.panelSource = new JPanel();
        this.panelSourceLeft = new JPanel();
        this.labelSource = new JLabel();
        this.comboSource = new JComboBox();
        this.panelSourceCenter = new JPanel();
        this.labelLanguage = new JLabel();
        this.comboLanguage = new JComboBox();
        this.panelSourceRight = new JPanel();
        this.labelDownloadThreads = new JLabel();
        this.comboDownloadThreads = new JComboBox();
        this.panelMode = new JPanel();
        this.panelModeInner = new JPanel();
        this.labelMode = new JLabel();
        this.panelModeSelect = new JPanel();
        this.comboSets = new JComboBox();
        this.fillerMode1 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.buttonSearchSet = new JButton();
        this.panelRedownload = new JPanel();
        this.checkboxRedownload = new JCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 3), new Dimension(Short.MAX_VALUE, 5));
        this.fillerMain1 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 10), new Dimension(Short.MAX_VALUE, 10));
        this.panelProgress = new JPanel();
        this.fillerProgress1 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.progress = new JProgressBar();
        this.fillerProgress2 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.fillerMain2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.tabCustom = new JPanel();
        this.panelCommands = new JPanel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.setTitle("Downloading images");
        this.setPreferredSize(new Dimension(600, 400));
        this.getContentPane().setLayout(new BorderLayout());
        this.panelGlobal.setLayout(new BoxLayout(this.panelGlobal, 1));
        this.panelGlobal.add(this.fillerGlobal1);
        this.labelGlobal.setText("Initializing image download...");
        this.labelGlobal.setAlignmentX(0.5f);
        this.panelGlobal.add(this.labelGlobal);
        this.buttonStop.setText("Cancel");
        this.buttonStop.setAlignmentX(0.5f);
        this.buttonStop.setPreferredSize(new Dimension(65, 30));
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadImagesDialog.this.buttonStopActionPerformed(evt);
            }
        });
        this.panelGlobal.add(this.buttonStop);
        this.panelGlobal.add(this.fillerglobal2);
        this.getContentPane().add((Component)this.panelGlobal, "North");
        this.tabsList.setTabLayoutPolicy(1);
        this.tabMain.setLayout(new BoxLayout(this.tabMain, 1));
        this.panelInfo.setLayout(new BoxLayout(this.panelInfo, 1));
        this.panelInfo.add(this.fillerInfo1);
        this.labelInfo.setText("Missing stats: 12345 card images / 789 token images");
        this.labelInfo.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        this.panelInfo.add(this.labelInfo);
        this.panelInfo.add(this.fillerInfo2);
        this.tabMain.add(this.panelInfo);
        this.panelSource.setMaximumSize(new Dimension(65536, 55));
        this.panelSource.setMinimumSize(new Dimension(352, 55));
        this.panelSource.setPreferredSize(new Dimension(593, 55));
        this.panelSource.setLayout(new BoxLayout(this.panelSource, 0));
        this.panelSourceLeft.setMinimumSize(new Dimension(430, 30));
        this.panelSourceLeft.setLayout(new FlowLayout(3));
        this.labelSource.setText("Images source to download:");
        this.panelSourceLeft.add(this.labelSource);
        this.comboSource.setMaximumRowCount(15);
        this.comboSource.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboSource.setMinimumSize(new Dimension(300, 20));
        this.comboSource.setPreferredSize(new Dimension(400, 25));
        this.panelSourceLeft.add(this.comboSource);
        this.panelSource.add(this.panelSourceLeft);
        this.panelSourceCenter.setAlignmentX(0.0f);
        this.panelSourceCenter.setMaximumSize(new Dimension(130, Short.MAX_VALUE));
        this.panelSourceCenter.setMinimumSize(new Dimension(130, 10));
        this.panelSourceCenter.setPreferredSize(new Dimension(130, 100));
        this.panelSourceCenter.setLayout(new FlowLayout(3));
        this.labelLanguage.setText("Language:");
        this.panelSourceCenter.add(this.labelLanguage);
        this.comboLanguage.setMaximumRowCount(15);
        this.comboLanguage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboLanguage.setPreferredSize(new Dimension(110, 25));
        this.panelSourceCenter.add(this.comboLanguage);
        this.panelSource.add(this.panelSourceCenter);
        this.panelSourceRight.setMinimumSize(new Dimension(150, 30));
        this.panelSourceRight.setPreferredSize(new Dimension(150, 35));
        this.panelSourceRight.setLayout(new FlowLayout(3));
        this.labelDownloadThreads.setText("Download threads:");
        this.panelSourceRight.add(this.labelDownloadThreads);
        this.comboDownloadThreads.setMaximumRowCount(15);
        this.comboDownloadThreads.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboDownloadThreads.setPreferredSize(new Dimension(110, 25));
        this.panelSourceRight.add(this.comboDownloadThreads);
        this.panelSource.add(this.panelSourceRight);
        this.tabMain.add(this.panelSource);
        this.panelMode.setMaximumSize(new Dimension(32869, 55));
        this.panelMode.setMinimumSize(new Dimension(322, 55));
        this.panelMode.setPreferredSize(new Dimension(100, 55));
        this.panelMode.setLayout(new BoxLayout(this.panelMode, 2));
        this.panelModeInner.setMinimumSize(new Dimension(430, 43));
        this.panelModeInner.setLayout(new FlowLayout(0));
        this.labelMode.setText("Sets to download:");
        this.labelMode.setAlignmentY(0.0f);
        this.panelModeInner.add(this.labelMode);
        this.panelModeSelect.setLayout(new BoxLayout(this.panelModeSelect, 0));
        this.comboSets.setMaximumRowCount(15);
        this.comboSets.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboSets.setPreferredSize(new Dimension(373, 25));
        this.panelModeSelect.add(this.comboSets);
        this.panelModeSelect.add(this.fillerMode1);
        this.buttonSearchSet.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_24.png")));
        this.buttonSearchSet.setToolTipText("Search set to download");
        this.buttonSearchSet.setAlignmentX(1.0f);
        this.buttonSearchSet.setPreferredSize(new Dimension(25, 25));
        this.buttonSearchSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadImagesDialog.this.buttonSearchSetActionPerformed(evt);
            }
        });
        this.panelModeSelect.add(this.buttonSearchSet);
        this.panelModeInner.add(this.panelModeSelect);
        this.panelMode.add(this.panelModeInner);
        this.panelRedownload.setAlignmentX(0.0f);
        this.panelRedownload.setMaximumSize(new Dimension(130, Short.MAX_VALUE));
        this.panelRedownload.setMinimumSize(new Dimension(280, 30));
        this.panelRedownload.setPreferredSize(new Dimension(280, 100));
        this.panelRedownload.setLayout(new BorderLayout());
        this.checkboxRedownload.setText("<html>Re-download all selected images");
        this.checkboxRedownload.setVerticalAlignment(3);
        this.panelRedownload.add((Component)this.checkboxRedownload, "Center");
        this.panelRedownload.add((Component)this.filler1, "Last");
        this.panelMode.add(this.panelRedownload);
        this.tabMain.add(this.panelMode);
        this.tabMain.add(this.fillerMain1);
        this.panelProgress.setMaximumSize(new Dimension(32777, 30));
        this.panelProgress.setMinimumSize(new Dimension(20, 30));
        this.panelProgress.setPreferredSize(new Dimension(564, 30));
        this.panelProgress.setLayout(new BoxLayout(this.panelProgress, 0));
        this.panelProgress.add(this.fillerProgress1);
        this.progress.setValue(75);
        this.progress.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.progress.setString("123 of 12313 (120 cards/546 tokens) image downloads finished! Please wait! [123 Mb]");
        this.progress.setStringPainted(true);
        this.panelProgress.add(this.progress);
        this.panelProgress.add(this.fillerProgress2);
        this.tabMain.add(this.panelProgress);
        this.tabMain.add(this.fillerMain2);
        this.tabsList.addTab("Standard download", new ImageIcon(this.getClass().getResource("/buttons/card_panel.png")), this.tabMain);
        this.tabCustom.setLayout(new BoxLayout(this.tabCustom, 1));
        this.tabsList.addTab("Custom download", new ImageIcon(this.getClass().getResource("/buttons/list_panel.png")), this.tabCustom);
        this.getContentPane().add((Component)this.tabsList, "Center");
        this.panelCommands.setAlignmentX(0.0f);
        this.panelCommands.setLayout(new FlowLayout(4));
        this.buttonOK.setText("Start download");
        this.buttonOK.setPreferredSize(new Dimension(120, 30));
        this.panelCommands.add(this.buttonOK);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.setPreferredSize(new Dimension(80, 30));
        this.panelCommands.add(this.buttonCancel);
        this.getContentPane().add((Component)this.panelCommands, "South");
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.onCancel();
    }

    private void buttonSearchSetActionPerformed(ActionEvent evt) {
        FastSearchUtil.showFastSearchForStringComboBox(this.comboSets, "Select set or expansion", 400, 500);
    }

    private void buttonStopActionPerformed(ActionEvent evt) {
    }

    private void onCancel() {
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onDownloadDone();
        }
    }

    public static interface DownloadImagesCallback {
        public void onDownloadDone();
    }
}

