/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.client.util.AppUtil;
import mage.client.util.GUISizeHelper;
import mage.util.CardUtil;

public class ErrorDialog
extends MageDialog {
    private final String GITHUB_ISSUES_PAGE = "https://github.com/magefree/mage/issues";
    private JButton btnCopyToClipboard;
    private JButton btnOK;
    private JButton btnOpenGithub;
    private JScrollPane pnlError;
    private JScrollPane pnlInfo;
    private JTextArea textError;
    private JTextArea textInfo;

    public ErrorDialog() {
        this.initComponents();
    }

    public void showDialog(String errorType, String errorTitle, String errorText) {
        this.textInfo.setText("You can report bugs and create new feature requests at github: https://github.com/magefree/mage/issues");
        this.textInfo.setCaretPosition(0);
        String fullTitle = errorType + " - " + errorTitle;
        this.setTitle(fullTitle);
        String fullError = "Error type: " + fullTitle + "\n\nClient version: " + MageFrame.getInstance().getVersion().toString() + "\nJava version: " + System.getProperty("java.version") + "\nDefault charset: " + Charset.defaultCharset() + "\n\n" + errorText;
        this.textError.setText(fullError);
        this.textError.setCaretPosition(0);
        this.changeGUISize();
        this.pack();
        this.revalidate();
        this.repaint();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        this.textError.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.textInfo.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnCopyToClipboard.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnOpenGithub.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnOK.setFont(GUISizeHelper.gameFeedbackPanelFont);
    }

    private void openGithub() {
        String title = this.getTitle();
        String body = this.textError.getText();
        String labels = "bug";
        String url = String.format("%s/new?labels=%s&title=%s&body=%s", "https://github.com/magefree/mage/issues", CardUtil.urlEncode(labels), CardUtil.urlEncode(title), CardUtil.urlEncode(body));
        AppUtil.openUrlInSystemBrowser(url);
    }

    private void initComponents() {
        this.btnOK = new JButton();
        this.pnlError = new JScrollPane();
        this.textError = new JTextArea();
        this.pnlInfo = new JScrollPane();
        this.textInfo = new JTextArea();
        this.btnCopyToClipboard = new JButton();
        this.btnOpenGithub = new JButton();
        this.setResizable(true);
        this.setTitle("Error");
        this.btnOK.setText("Close");
        this.btnOK.setMaximumSize(new Dimension(59, 33));
        this.btnOK.setMinimumSize(new Dimension(59, 33));
        this.btnOK.setPreferredSize(new Dimension(59, 33));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.textError.setEditable(false);
        this.textError.setColumns(20);
        this.textError.setLineWrap(true);
        this.textError.setRows(5);
        this.textError.setWrapStyleWord(true);
        this.pnlError.setViewportView(this.textError);
        this.textInfo.setEditable(false);
        this.textInfo.setLineWrap(true);
        this.textInfo.setText("[bug report instructions]");
        this.pnlInfo.setViewportView(this.textInfo);
        this.btnCopyToClipboard.setIcon(new ImageIcon(this.getClass().getResource("/buttons/copy_24.png")));
        this.btnCopyToClipboard.setText("Copy error to clipboard");
        this.btnCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.btnCopyToClipboardActionPerformed(evt);
            }
        });
        this.btnOpenGithub.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_24.png")));
        this.btnOpenGithub.setText("Open github and create bug report");
        this.btnOpenGithub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.btnOpenGithubActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlInfo).addComponent(this.pnlError).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnCopyToClipboard, -2, 202, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenGithub).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOK, -2, 96, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.pnlInfo, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlError, -1, 225, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK, -2, -1, -2).addComponent(this.btnCopyToClipboard).addComponent(this.btnOpenGithub)).addGap(12, 12, 12)));
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.hideDialog();
    }

    private void btnCopyToClipboardActionPerformed(ActionEvent evt) {
        AppUtil.setClipboardData(this.textError.getText());
    }

    private void btnOpenGithubActionPerformed(ActionEvent evt) {
        this.openGithub();
    }
}

