/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mage.client.SessionHandler;
import mage.client.dialog.PreferencesDialog;
import org.apache.log4j.Logger;

public class FeedbackDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(PreferencesDialog.class);
    private final String[] feedbackTypes = new String[]{"", "Bug or \"something doesn't work\"", "Feature or \"I need that function\"", "Thank you or \"Devs, you are so cool!\"", "Question or \"I'm so curious about\""};
    private JButton cancelButton;
    private JComboBox cbFeedbackType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JLabel lblProxyPort;
    private JLabel lblProxyServer;
    private JLabel lblProxyType;
    private JLabel lblProxyUserName;
    private JPanel pnlProxy;
    private JButton sendButton;
    private JTextField txtEmail;
    private JTextArea txtFeedbackMessage;
    private JTextField txtIdeaTitle;
    private static final FeedbackDialog dialog = new FeedbackDialog((Frame)new JFrame(), true);

    public FeedbackDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cbFeedbackType.setModel(new DefaultComboBoxModel<String>(this.feedbackTypes));
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.pnlProxy = new JPanel();
        this.lblProxyServer = new JLabel();
        this.txtIdeaTitle = new JTextField();
        this.lblProxyPort = new JLabel();
        this.txtEmail = new JTextField();
        this.lblProxyUserName = new JLabel();
        this.cbFeedbackType = new JComboBox();
        this.lblProxyType = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtFeedbackMessage = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.sendButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Feedback");
        this.lblProxyServer.setText("Enter your idea*");
        this.lblProxyPort.setText("Your email:");
        this.lblProxyUserName.setText("Describe your idea*");
        this.lblProxyType.setText("Category");
        this.txtFeedbackMessage.setColumns(20);
        this.txtFeedbackMessage.setFont(new Font("Tahoma", 0, 11));
        this.txtFeedbackMessage.setRows(5);
        this.txtFeedbackMessage.setText("(300 characters max)");
        this.jScrollPane1.setViewportView(this.txtFeedbackMessage);
        this.jLabel2.setFont(new Font("Tahoma", 2, 11));
        this.jLabel2.setText("(optional)");
        this.jLabel3.setFont(new Font("Tahoma", 2, 11));
        this.jLabel3.setText("(optional)");
        GroupLayout pnlProxyLayout = new GroupLayout(this.pnlProxy);
        this.pnlProxy.setLayout(pnlProxyLayout);
        pnlProxyLayout.setHorizontalGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlProxyLayout.createSequentialGroup().addContainerGap().addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblProxyUserName, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblProxyType, GroupLayout.Alignment.LEADING).addComponent(this.lblProxyServer, GroupLayout.Alignment.LEADING)).addComponent(this.lblProxyPort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlProxyLayout.createSequentialGroup().addComponent(this.cbFeedbackType, 0, 243, Short.MAX_VALUE).addGap(26, 26, 26).addComponent(this.jLabel2, -2, 46, -2).addGap(20, 20, 20)).addGroup(GroupLayout.Alignment.TRAILING, pnlProxyLayout.createSequentialGroup().addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlProxyLayout.createSequentialGroup().addComponent(this.txtEmail, -1, 238, Short.MAX_VALUE).addGap(32, 32, 32).addComponent(this.jLabel3, -2, 46, -2).addGap(9, 9, 9)).addComponent(this.txtIdeaTitle, GroupLayout.Alignment.LEADING, -1, 325, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 325, Short.MAX_VALUE)).addContainerGap()))));
        pnlProxyLayout.setVerticalGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlProxyLayout.createSequentialGroup().addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblProxyServer).addComponent(this.txtIdeaTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbFeedbackType, -2, -1, -2).addComponent(this.lblProxyType).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblProxyUserName).addComponent(this.jScrollPane1, -2, 85, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtEmail, -2, -1, -2).addComponent(this.lblProxyPort)).addContainerGap(21, Short.MAX_VALUE)));
        this.jLabel1.setFont(new Font("Arial", 1, 14));
        this.jLabel1.setForeground(new Color(255, 153, 51));
        this.jLabel1.setText("I suggest you...");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlProxy, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlProxy, -2, -1, -2).addContainerGap(41, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Give feedback", this.jPanel6);
        this.sendButton.setText("Send");
        this.sendButton.addActionListener(evt -> this.sendButtonActionPerformed(evt));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(evt -> this.cancelButtonActionPerformed(evt));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 469, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(324, Short.MAX_VALUE).addComponent(this.sendButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addGap(17, 17, 17)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1, -2, 292, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.sendButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("Feedback");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        dialog.dispose();
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        String email;
        String title = this.txtIdeaTitle.getText().trim();
        if (title.isEmpty()) {
            JOptionPane.showMessageDialog(null, "\"Enter your idea\" is a mandatory field", "Warning", 1);
            return;
        }
        if (title.length() > 100) {
            JOptionPane.showMessageDialog(null, "\"Enter your idea\" value is too long (100 characters max)", "Warning", 1);
            return;
        }
        String type = this.cleanUpType(this.cbFeedbackType.getSelectedItem().toString());
        String message = this.txtFeedbackMessage.getText().trim();
        if (message.isEmpty()) {
            JOptionPane.showMessageDialog(null, "\"Describe your idea\" is a mandatory field.", "Warning", 1);
            return;
        }
        if (message.length() > 300) {
            JOptionPane.showMessageDialog(null, "\"Describe your idea\" value is too long (300 characters max)", "Warning", 1);
        }
        if ((email = this.txtEmail.getText().trim()).length() > 100) {
            email = email.substring(0, 100);
        }
        if (SessionHandler.sendFeedback(title, type, message, email)) {
            JOptionPane.showMessageDialog(null, "Feedback was sent. Thank you!", "Success", 1);
            this.reset();
            dialog.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(null, "Couldn't sent feedback.", "Error", 0);
        }
    }

    private String cleanUpType(String type) {
        if (type == null || type.isEmpty()) {
            return "";
        }
        if (type.toLowerCase(Locale.ENGLISH).startsWith("bug")) {
            return "bug";
        }
        if (type.toLowerCase(Locale.ENGLISH).startsWith("feature")) {
            return "feature";
        }
        if (type.toLowerCase(Locale.ENGLISH).startsWith("thank")) {
            return "thank";
        }
        if (type.toLowerCase(Locale.ENGLISH).startsWith("question")) {
            return "question";
        }
        return "";
    }

    private void reset() {
        this.cbFeedbackType.setSelectedIndex(0);
        this.txtIdeaTitle.setText("");
        this.txtFeedbackMessage.setText("");
        this.txtEmail.setText("");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            if (!dialog.isVisible()) {
                dialog.setLocation(300, 200);
                dialog.setVisible(true);
            } else {
                dialog.requestFocus();
            }
        });
    }

    static {
        dialog.setResizable(false);
    }
}

