/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.event.ActionEvent;
import java.util.UUID;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mage.cards.decks.importer.DeckImporter;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.table.NewPlayerPanel;
import mage.players.PlayerType;
import mage.remote.Session;
import org.apache.log4j.Logger;

public class JoinTableDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(JoinTableDialog.class);
    private UUID tableId;
    private UUID roomId;
    private boolean joined = false;
    private boolean isTournament;
    private JButton btnCancel;
    private JButton btnOK;
    private JLabel lblPassword;
    private NewPlayerPanel newPlayerPanel;
    private JTextField txtPassword;

    public JoinTableDialog() {
        this.initComponents();
        this.newPlayerPanel.showLevel(false);
        this.txtPassword.setText(PreferencesDialog.getCachedValue("newTablePasswordJoin", ""));
    }

    public void showDialog(UUID roomId, UUID tableId, boolean isTournament, boolean isLimited) {
        this.roomId = roomId;
        this.tableId = tableId;
        this.isTournament = isTournament;
        this.newPlayerPanel.setPlayerName(SessionHandler.getUserName());
        this.newPlayerPanel.showDeckElements(!isLimited);
        this.setModal(true);
        this.setLocation(100, 100);
        this.setVisible(true);
    }

    private void initComponents() {
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.newPlayerPanel = new NewPlayerPanel();
        this.lblPassword = new JLabel();
        this.txtPassword = new JTextField();
        this.setTitle("Join Table");
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(evt -> this.btnCancelActionPerformed(evt));
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(evt -> this.btnOKActionPerformed(evt));
        this.lblPassword.setText("Password:");
        this.txtPassword.setText("password");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addComponent(this.newPlayerPanel, -1, 414, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblPassword).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPassword, -2, 120, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.newPlayerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOK)).addContainerGap()));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.joined = false;
        this.hideDialog();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        Session session = SessionHandler.getSession();
        try {
            PreferencesDialog.saveValue("newTablePasswordJoin", this.txtPassword.getText());
            this.joined = this.isTournament ? session.joinTournamentTable(this.roomId, this.tableId, this.newPlayerPanel.getPlayerName(), PlayerType.HUMAN, 1, DeckImporter.importDeckFromFile(this.newPlayerPanel.getDeckFile(), true), this.txtPassword.getText()) : session.joinTable(this.roomId, this.tableId, this.newPlayerPanel.getPlayerName(), PlayerType.HUMAN, 1, DeckImporter.importDeckFromFile(this.newPlayerPanel.getDeckFile(), true), this.txtPassword.getText());
        }
        catch (Exception ex) {
            this.handleError(ex);
        }
        this.hideDialog();
    }

    public boolean isJoined() {
        return this.joined;
    }

    private void handleError(Exception ex) {
        logger.fatal((Object)"Error loading deck", (Throwable)ex);
        JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Error loading deck.", "Error", 0);
    }
}

