/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.event.InvocationEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import mage.client.MageFrame;
import mage.client.components.MageDesktopIconifySupport;
import mage.client.util.SettingsManager;
import mage.client.util.gui.GuiDisplayUtil;
import org.apache.log4j.Logger;

public class MageDialog
extends JInternalFrame {
    private static final Logger LOGGER = Logger.getLogger(MageDialog.class);
    private boolean modal = false;

    public MageDialog() {
        this.initComponents();
        this.setOpaque(true);
        if (this instanceof MageDesktopIconifySupport) {
            BasicInternalFrameUI ui = (BasicInternalFrameUI)this.getUI();
            ui.getNorthPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    if ((e.getClickCount() & 1) == 0 && e.getClickCount() > 0 && !e.isConsumed()) {
                        e.consume();
                        try {
                            MageDialog.this.setIcon(!MageDialog.this.isIcon());
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    public void changeGUISize() {
    }

    public static boolean isModalDialogActivated() {
        for (JInternalFrame frame : MageFrame.getDesktop().getAllFrames()) {
            MageDialog md;
            if (!(frame instanceof MageDialog) || !(md = (MageDialog)frame).isVisible() || !md.isModal()) continue;
            return true;
        }
        return false;
    }

    public static void printFramesOrder(String name) {
        JInternalFrame[] frames = MageFrame.getDesktop().getAllFrames();
        System.out.println("--- " + name + " ---");
        int order = 0;
        for (JInternalFrame frame : frames) {
            ++order;
            int zorder = -1;
            if (frame.getParent() != null) {
                zorder = frame.getParent().getComponentZOrder(frame);
            }
            System.out.println(order + ". " + frame.getClass() + " (" + frame.getTitle() + ") : layer = " + frame.getLayer() + ", zorder = " + zorder);
        }
    }

    @Override
    public void show() {
        super.show();
        if (this.modal) {
            this.setClosable(false);
        }
        this.toFront();
        if (this.modal) {
            this.startModal();
        }
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.toFront();
            try {
                this.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.modal) {
            this.setClosable(false);
            if (value) {
                this.startModal();
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.stopModal();
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this.stopModal());
                }
                catch (InterruptedException ex) {
                    LOGGER.fatal((Object)"MageDialog error", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException ex) {
                    LOGGER.fatal((Object)"MageDialog error", (Throwable)ex);
                }
            }
        }
    }

    private synchronized void startModal() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    MouseEvent e;
                    MouseEvent m;
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    boolean dispatch = true;
                    if (event.getSource() != null && event.getSource() instanceof TrayIcon && !(event instanceof InvocationEvent)) {
                        dispatch = false;
                    }
                    Component popupComponent = null;
                    MouseEvent popupEvent = null;
                    if (event instanceof MouseEvent && event.getSource() instanceof Component && !this.contains((m = SwingUtilities.convertMouseEvent((Component)(e = (MouseEvent)event).getSource(), e, this)).getPoint())) {
                        boolean allowedEvent = false;
                        if (e.getID() == 506 || e.getID() == 503) {
                            allowedEvent = true;
                        }
                        if (!allowedEvent && (popupComponent = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) != null && (popupComponent.getClass().getName().contains("BasicComboPopup") || popupComponent.getClass().getName().contains("JMenuItem"))) {
                            popupEvent = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, popupComponent);
                            allowedEvent = true;
                        }
                        dispatch = allowedEvent;
                    }
                    if (!dispatch) continue;
                    if (popupEvent != null) {
                        popupComponent.dispatchEvent(popupEvent);
                        continue;
                    }
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    LOGGER.warn((Object)("Unable to dispatch: " + event));
                }
            } else {
                while (this.isVisible()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.fatal((Object)"MageDialog error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void stopModal() {
        this.notifyAll();
    }

    public void setModal(boolean modal) {
        this.modal = MageFrame.isGuiModalModeEnabled() && modal;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    public void removeDialog() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException ex) {
            LOGGER.error((Object)"setClosed(false) failed", (Throwable)ex);
        }
        MageFrame.getDesktop().remove(this);
    }

    public void makeWindowCentered() {
        MageDialog.makeWindowCentered(this, this.getWidth(), this.getHeight());
    }

    public static void makeWindowCentered(Component component, int width, int height) {
        Point centered = SettingsManager.instance.getComponentPosition(width, height);
        component.setLocation(centered.x, centered.y);
        GuiDisplayUtil.keepComponentInsideScreen(centered.x, centered.y, component);
    }

    public void setTitelBarToolTip(String text) {
        this.desktopIcon.setToolTipText(text);
        Component[] children = this.getComponents();
        if (children != null) {
            for (Component children1 : children) {
                if (!children1.getClass().getName().equalsIgnoreCase("javax.swing.plaf.synth.SynthInternalFrameTitlePane")) continue;
                ((JComponent)children1).setToolTipText(text);
                break;
            }
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 394, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 274, Short.MAX_VALUE));
        this.pack();
    }
}

