/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckFileFilter;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.dialog.CustomOptionsDialog;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.dialog.RandomPacksSelectorDialog;
import mage.client.table.NewPlayerPanel;
import mage.client.table.TournamentPlayerPanel;
import mage.client.util.IgnoreList;
import mage.client.util.gui.FastSearchUtil;
import mage.constants.MatchBufferTime;
import mage.constants.MatchTimeLimit;
import mage.constants.MultiplayerAttackOption;
import mage.constants.RangeOfInfluence;
import mage.constants.SkillLevel;
import mage.game.GameException;
import mage.game.draft.DraftOptions;
import mage.game.tournament.LimitedOptions;
import mage.game.tournament.TournamentOptions;
import mage.players.PlayerType;
import mage.view.GameTypeView;
import mage.view.TableView;
import mage.view.TournamentTypeView;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ObjectProperty;
import org.jdesktop.beansbinding.Property;

public class NewTournamentDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(NewTournamentDialog.class);
    private static final int MAX_WORKABLE_PLAYERS_PER_GAME = 6;
    private static final String CUBE_FROM_DECK_NAME = "Cube From Deck";
    private final List<PlayerType> prefPlayerTypes = new ArrayList<PlayerType>();
    private final List<Integer> prefPlayerSkills = new ArrayList<Integer>();
    private TableView table;
    private UUID roomId;
    private String lastSessionId;
    private RandomPacksSelectorDialog randomPackSelector;
    private final CustomOptionsDialog customOptions;
    private JTextArea txtRandomPacks;
    private final List<TournamentPlayerPanel> players = new ArrayList<TournamentPlayerPanel>();
    private final List<JPanel> packPanels = new ArrayList<JPanel>();
    private static final int CONSTRUCTION_TIME_MIN = 6;
    private static final int CONSTRUCTION_TIME_MAX = 30;
    private boolean isRandom = false;
    private boolean isRichMan = false;
    private boolean isReshuffled = false;
    private String cubeFromDeckFilename = "";
    private String jumpstartPacksFilename = "";
    private boolean automaticChange = false;
    private JFileChooser fcSelectDeck = null;
    private JFileChooser fcJumpstartSelectDeck = null;
    private JButton btnCancel;
    private JButton btnCustomOptions;
    private JButton btnOk;
    private JButton btnSettingsLoad;
    private JButton btnSettingsSave;
    private JCheckBox cbAllowSpectators;
    private JComboBox cbBufferTime;
    private JComboBox cbDeckType;
    private JComboBox cbDraftCube;
    private JComboBox cbDraftTiming;
    private JComboBox cbGameType;
    private JComboBox cbSkillLevel;
    private JComboBox cbTimeLimit;
    private JComboBox cbTournamentType;
    private JCheckBox chkRated;
    private JCheckBox chkRollbackTurnsAllowed;
    private JCheckBox chkSingleMultiplayerGame;
    private JLabel jLabel6;
    private JLabel lbBufferTime;
    private JLabel lbDeckType;
    private JLabel lbSkillLevel;
    private JLabel lbTimeLimit;
    private JLabel lblConstructionTime;
    private JLabel lblDraftCube;
    private JLabel lblGameType;
    private JLabel lblMinimumRating;
    private JLabel lblName;
    private JLabel lblNbrPlayers;
    private JLabel lblNumRounds;
    private JLabel lblNumWins;
    private JLabel lblPacks;
    private JLabel lblPassword;
    private JLabel lblPlayer1;
    private JLabel lblQuitRatio;
    private JLabel lblSettings;
    private JLabel lblTournamentType;
    private JMenuItem menuLoadSettings1;
    private JMenuItem menuLoadSettings2;
    private JMenuItem menuLoadSettingsDefault;
    private JMenuItem menuLoadSettingsLast;
    private JMenuItem menuSaveSettings1;
    private JMenuItem menuSaveSettings2;
    private NewPlayerPanel player1Panel;
    private JPanel pnlDraftOptions;
    private JPanel pnlOtherPlayers;
    private JPanel pnlPacks;
    private JPanel pnlPlayers;
    private JPanel pnlRandomPacks;
    private JPopupMenu popupLoadSettings;
    private JPopupMenu popupSaveSettings;
    private JPopupMenu.Separator separator1;
    private JPopupMenu.Separator separator2;
    private JSpinner spnConstructTime;
    private JSpinner spnMinimumRating;
    private JSpinner spnNumPlayers;
    private JSpinner spnNumRounds;
    private JSpinner spnNumWins;
    private JSpinner spnQuitRatio;
    private JTextField txtName;
    private JTextField txtPassword;
    private BindingGroup bindingGroup;

    public NewTournamentDialog() {
        this.initComponents();
        this.customOptions = new CustomOptionsDialog(CustomOptionsDialog.SaveLoadKeys.TOURNEY, this.btnCustomOptions);
        MageFrame.getDesktop().add((Component)this.customOptions, this.customOptions.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.lastSessionId = "";
        this.txtName.setText("Tournament");
        this.spnNumWins.setModel(new SpinnerNumberModel(2, 1, 5, 1));
        this.spnConstructTime.setModel(new SpinnerNumberModel(10, 6, 30, 2));
        this.spnNumRounds.setModel(new SpinnerNumberModel(2, 2, 10, 1));
        this.spnQuitRatio.setModel(new SpinnerNumberModel(100, 0, 100, 5));
        this.spnMinimumRating.setModel(new SpinnerNumberModel(0, 0, 3000, 10));
    }

    private int getCurrentNumPlayers() {
        int res = (Integer)this.spnNumPlayers.getValue();
        return Math.max(2, res);
    }

    private int getCurrentNumSeats() {
        if (this.chkSingleMultiplayerGame.isSelected()) {
            return this.getCurrentNumPlayers();
        }
        return 2;
    }

    public void showDialog(UUID roomId) {
        this.roomId = roomId;
        if (!this.lastSessionId.equals(SessionHandler.getSessionId())) {
            this.lastSessionId = SessionHandler.getSessionId();
            this.player1Panel.setPlayerName(SessionHandler.getUserName());
            this.player1Panel.showLevel(false);
            this.cbTournamentType.setModel(new DefaultComboBoxModel<Object>(SessionHandler.getTournamentTypes().toArray()));
            this.cbGameType.setModel(new DefaultComboBoxModel<Object>(SessionHandler.getTournamentGameTypes().toArray()));
            this.cbDeckType.setModel(new DefaultComboBoxModel<String>(SessionHandler.getDeckTypes()));
            this.cbTimeLimit.setModel(new DefaultComboBoxModel<MatchTimeLimit>(MatchTimeLimit.values()));
            this.cbBufferTime.setModel(new DefaultComboBoxModel<MatchBufferTime>(MatchBufferTime.values()));
            this.cbSkillLevel.setModel(new DefaultComboBoxModel<SkillLevel>(SkillLevel.values()));
            this.cbDraftCube.setModel(new DefaultComboBoxModel<String>(SessionHandler.getDraftCubes()));
            this.cbDraftTiming.setModel(new DefaultComboBoxModel<Object>(Arrays.stream(DraftOptions.TimingOption.values()).filter(o -> !o.equals((Object)DraftOptions.TimingOption.NONE)).toArray()));
            this.cbAllowSpectators.setSelected(true);
            this.setModal(true);
            this.setLocation(150, 100);
        }
        this.onLoadSettings(0);
        this.setVisible(true);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.popupSaveSettings = new JPopupMenu();
        this.menuSaveSettings1 = new JMenuItem();
        this.menuSaveSettings2 = new JMenuItem();
        this.popupLoadSettings = new JPopupMenu();
        this.menuLoadSettingsLast = new JMenuItem();
        this.separator1 = new JPopupMenu.Separator();
        this.menuLoadSettings1 = new JMenuItem();
        this.menuLoadSettings2 = new JMenuItem();
        this.separator2 = new JPopupMenu.Separator();
        this.menuLoadSettingsDefault = new JMenuItem();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lbTimeLimit = new JLabel();
        this.cbTimeLimit = new JComboBox();
        this.lbBufferTime = new JLabel();
        this.cbBufferTime = new JComboBox();
        this.lbSkillLevel = new JLabel();
        this.cbSkillLevel = new JComboBox();
        this.lblPassword = new JLabel();
        this.txtPassword = new JTextField();
        this.lblTournamentType = new JLabel();
        this.cbTournamentType = new JComboBox();
        this.lbDeckType = new JLabel();
        this.cbDeckType = new JComboBox();
        this.lblGameType = new JLabel();
        this.cbGameType = new JComboBox();
        this.lblNumWins = new JLabel();
        this.spnNumWins = new JSpinner();
        this.lblDraftCube = new JLabel();
        this.cbDraftCube = new JComboBox();
        this.lblNumRounds = new JLabel();
        this.spnNumRounds = new JSpinner();
        this.lblPacks = new JLabel();
        this.pnlPacks = new JPanel();
        this.lblNbrPlayers = new JLabel();
        this.spnNumPlayers = new JSpinner();
        this.chkSingleMultiplayerGame = new JCheckBox();
        this.pnlDraftOptions = new JPanel();
        this.jLabel6 = new JLabel();
        this.cbDraftTiming = new JComboBox();
        this.cbAllowSpectators = new JCheckBox();
        this.lblPlayer1 = new JLabel();
        this.lblConstructionTime = new JLabel();
        this.chkRollbackTurnsAllowed = new JCheckBox();
        this.spnConstructTime = new JSpinner();
        this.player1Panel = new NewPlayerPanel();
        this.pnlPlayers = new JPanel();
        this.pnlOtherPlayers = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.pnlRandomPacks = new JPanel();
        this.lblQuitRatio = new JLabel();
        this.spnQuitRatio = new JSpinner();
        this.lblMinimumRating = new JLabel();
        this.spnMinimumRating = new JSpinner();
        this.chkRated = new JCheckBox();
        this.btnSettingsSave = new JButton();
        this.btnSettingsLoad = new JButton();
        this.lblSettings = new JLabel();
        this.btnCustomOptions = new JButton();
        this.menuSaveSettings1.setText("Save to config 1");
        this.menuSaveSettings1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.menuSaveSettings1ActionPerformed(evt);
            }
        });
        this.popupSaveSettings.add(this.menuSaveSettings1);
        this.menuSaveSettings2.setText("Save to config 2");
        this.menuSaveSettings2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.menuSaveSettings2ActionPerformed(evt);
            }
        });
        this.popupSaveSettings.add(this.menuSaveSettings2);
        this.menuLoadSettingsLast.setText("Load from last time");
        this.menuLoadSettingsLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.menuLoadSettingsLastActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettingsLast);
        this.popupLoadSettings.add(this.separator1);
        this.menuLoadSettings1.setText("Load from config 1");
        this.menuLoadSettings1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.menuLoadSettings1ActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettings1);
        this.menuLoadSettings2.setText("Load from config 2");
        this.menuLoadSettings2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.menuLoadSettings2ActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettings2);
        this.popupLoadSettings.add(this.separator2);
        this.menuLoadSettingsDefault.setText("Load default settings");
        this.menuLoadSettingsDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.menuLoadSettingsDefaultActionPerformed(evt);
            }
        });
        this.popupLoadSettings.add(this.menuLoadSettingsDefault);
        this.setTitle("New Tournament");
        this.lblName.setText("Name:");
        this.lbTimeLimit.setText("Time Limit:");
        this.lbTimeLimit.setToolTipText("The time a player has for the whole match. If a player runs out of time during a game, they lose the complete match. ");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.cbTimeLimit, (Property)ObjectProperty.create(), (Object)this.lbTimeLimit, (Property)BeanProperty.create((String)"labelFor"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbTimeLimit.setToolTipText("The time a player has for the whole match. If a player runs out of time during a game, they lose the complete match. ");
        this.lbBufferTime.setLabelFor(this.cbBufferTime);
        this.lbBufferTime.setText("Buffer Time:");
        this.lbBufferTime.setToolTipText("The extra time a player gets whenever the timer starts before their normal time limit starts going down.");
        this.cbBufferTime.setToolTipText("The extra time a player gets whenever the timer starts before their normal time limit starts going down.");
        this.lbSkillLevel.setText("Skill Level:");
        this.lbSkillLevel.setToolTipText("The time a player has for the whole match. If a player runs out of time during a game, they lose the complete match. ");
        this.cbSkillLevel.setToolTipText("<HTML>This option can be used to make it easier to find matches<br>\nwith opponents of the appropriate skill level.");
        this.lblPassword.setText("Password:");
        this.lblPassword.setToolTipText("Players have to enter the password to be able to join this table.");
        this.txtPassword.setToolTipText("Players have to enter the password to be able to join this table.");
        this.lblTournamentType.setText("Tournament Type:");
        this.cbTournamentType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbTournamentType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.cbTournamentTypeActionPerformed(evt);
            }
        });
        this.lbDeckType.setText("Deck Type:");
        this.lbDeckType.setFocusable(false);
        this.lblGameType.setText("Game Type:");
        this.lblGameType.setFocusable(false);
        this.cbGameType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.cbGameTypeActionPerformed(evt);
            }
        });
        this.lblNumWins.setText("Wins:");
        this.spnNumWins.setToolTipText("To win a match a player has to win this number of games.");
        this.spnNumWins.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewTournamentDialog.this.spnNumWinsnumPlayersChanged(evt);
            }
        });
        this.lblDraftCube.setText("Draft Cube:");
        this.cbDraftCube.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbDraftCube.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.cbDraftCubeActionPerformed(evt);
            }
        });
        this.lblNumRounds.setText("Number of Swiss Rounds:");
        this.lblNumRounds.setToolTipText("<html>The number of rounds the swiss tournament has in total.<br>\nThe tournaments ends after that number of rounds or<br> \nif there are less than two players left in the tournament.");
        this.spnNumRounds.setToolTipText("<html>The number of rounds the swiss tournament has in total.<br>\nThe tournaments ends after that number of rounds or<br> \nif there are less than two players left in the tournament.");
        this.spnNumRounds.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewTournamentDialog.this.spnNumRoundsnumPlayersChanged(evt);
            }
        });
        this.lblPacks.setFont(new Font("Tahoma", 1, 11));
        this.lblPacks.setText("Packs");
        this.pnlPacks.setBorder(BorderFactory.createEtchedBorder());
        this.pnlPacks.setLayout(new GridLayout(0, 1, 2, 0));
        this.lblNbrPlayers.setText("Players:");
        this.spnNumPlayers.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewTournamentDialog.this.spnNumPlayersStateChanged(evt);
            }
        });
        this.chkSingleMultiplayerGame.setText("play as single game");
        this.chkSingleMultiplayerGame.setToolTipText("<HTML>Allow to play single game with all tourney's players -- e.g. play one game after draft with 4 players");
        this.chkSingleMultiplayerGame.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NewTournamentDialog.this.chkSingleMultiplayerGameItemStateChanged(evt);
            }
        });
        this.jLabel6.setText("Timing:");
        this.cbDraftTiming.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbDraftTiming.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.cbDraftTimingActionPerformed(evt);
            }
        });
        GroupLayout pnlDraftOptionsLayout = new GroupLayout(this.pnlDraftOptions);
        this.pnlDraftOptions.setLayout(pnlDraftOptionsLayout);
        pnlDraftOptionsLayout.setHorizontalGroup(pnlDraftOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDraftOptionsLayout.createSequentialGroup().addComponent(this.jLabel6, -2, 49, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDraftTiming, -2, 140, -2).addContainerGap(19, Short.MAX_VALUE)));
        pnlDraftOptionsLayout.setVerticalGroup(pnlDraftOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDraftOptionsLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(pnlDraftOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, 22, -2).addComponent(this.cbDraftTiming, -2, -1, -2)).addContainerGap()));
        this.cbAllowSpectators.setText("Allow spectators");
        this.cbAllowSpectators.setToolTipText("Allow other players to watch the games of this table.");
        this.lblPlayer1.setFont(new Font("Tahoma", 1, 11));
        this.lblPlayer1.setText("Player 1 (You)");
        this.lblConstructionTime.setText("Construction Time (Minutes):");
        this.chkRollbackTurnsAllowed.setText("Rollbacks");
        this.chkRollbackTurnsAllowed.setToolTipText("<HTML>Allow to rollback to the start of previous turns<br> if all players agree. ");
        this.spnConstructTime.setToolTipText("The time players have to build their deck.");
        this.player1Panel.setPreferredSize(new Dimension(400, 44));
        this.pnlOtherPlayers.setBorder(BorderFactory.createEtchedBorder());
        this.pnlOtherPlayers.setLayout(new GridLayout(0, 1, 2, 0));
        GroupLayout pnlPlayersLayout = new GroupLayout(this.pnlPlayers);
        this.pnlPlayers.setLayout(pnlPlayersLayout);
        pnlPlayersLayout.setHorizontalGroup(pnlPlayersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlOtherPlayers, -1, -1, Short.MAX_VALUE));
        pnlPlayersLayout.setVerticalGroup(pnlPlayersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlOtherPlayers, -1, 15, Short.MAX_VALUE));
        this.btnOk.setText("Create");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.pnlRandomPacks.setBorder(BorderFactory.createEtchedBorder());
        this.pnlRandomPacks.setLayout(new BoxLayout(this.pnlRandomPacks, 1));
        this.lblQuitRatio.setText("Allowed quit %");
        this.lblMinimumRating.setText("Minimum rating:");
        this.lblMinimumRating.setToolTipText("Players with rating less than this value can't join this table");
        this.spnMinimumRating.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewTournamentDialog.this.spnMinimumRatingnumPlayersChanged(evt);
            }
        });
        this.chkRated.setText("Rated game");
        this.chkRated.setToolTipText("Indicates if matches will be rated");
        this.btnSettingsSave.setText("Save...");
        this.btnSettingsSave.setToolTipText("Save settings");
        this.btnSettingsSave.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewTournamentDialog.this.btnSettingsSaveMouseClicked(evt);
            }
        });
        this.btnSettingsLoad.setText("Load...");
        this.btnSettingsLoad.setToolTipText("Load settings");
        this.btnSettingsLoad.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewTournamentDialog.this.btnSettingsLoadMouseClicked(evt);
            }
        });
        this.lblSettings.setText("Settings");
        this.btnCustomOptions.setText("Custom Options...");
        this.btnCustomOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTournamentDialog.this.btnCustomOptionsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlPlayers, -1, -1, Short.MAX_VALUE).addComponent(this.pnlPacks, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPacks).addComponent(this.lblPlayer1).addGroup(layout.createSequentialGroup().addComponent(this.lblNbrPlayers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnNumPlayers, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNumWins).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnNumWins, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkSingleMultiplayerGame))).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.pnlDraftOptions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblNumRounds)).addComponent(this.lblConstructionTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spnConstructTime, -2, 50, -2).addComponent(this.spnNumRounds, -2, 50, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblSettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSettingsLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSettingsSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOk, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 100, -2)).addComponent(this.player1Panel, -1, -1, Short.MAX_VALUE).addComponent(this.pnlRandomPacks, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblTournamentType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbTournamentType, -2, 290, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblDraftCube).addComponent(this.lbDeckType).addComponent(this.lblGameType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDraftCube, -2, 290, -2).addComponent(this.cbDeckType, -2, 290, -2).addComponent(this.cbGameType, -2, 290, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtName, -2, 224, -2)).addGroup(layout.createSequentialGroup().addComponent(this.chkRated).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMinimumRating).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnMinimumRating, -2, 70, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblQuitRatio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnQuitRatio, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbSkillLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSkillLevel, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPassword).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPassword, -1, 127, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCustomOptions)).addGroup(layout.createSequentialGroup().addComponent(this.lbTimeLimit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbTimeLimit, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbBufferTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBufferTime, -2, 101, -2).addGap(87, 87, 87).addComponent(this.chkRollbackTurnsAllowed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAllowSpectators))))).addGap(5, 5, 5)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkRollbackTurnsAllowed).addComponent(this.cbAllowSpectators, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbBufferTime).addComponent(this.cbBufferTime, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtName, -2, -1, -2).addComponent(this.lblName).addComponent(this.lbTimeLimit).addComponent(this.cbTimeLimit, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword, -2, -1, -2).addComponent(this.btnCustomOptions)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblQuitRatio).addComponent(this.spnQuitRatio, -2, -1, -2).addComponent(this.lbSkillLevel).addComponent(this.cbSkillLevel, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkRated).addComponent(this.lblMinimumRating).addComponent(this.spnMinimumRating, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTournamentType, -2, -1, -2).addComponent(this.lblTournamentType)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDraftCube, -2, -1, -2).addComponent(this.lblDraftCube)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDeckType, -2, -1, -2).addComponent(this.lbDeckType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGameType).addComponent(this.cbGameType, -2, -1, -2)))).addGap(0, 0, 0).addComponent(this.lblPacks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.pnlPacks, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlRandomPacks, -1, 20, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spnNumRounds, -2, -1, -2).addComponent(this.lblNumRounds)).addComponent(this.lblNbrPlayers, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spnNumPlayers).addComponent(this.chkSingleMultiplayerGame).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNumWins).addComponent(this.spnNumWins, -2, -1, -2))).addComponent(this.pnlDraftOptions, -2, 0, Short.MAX_VALUE)).addGap(27, 27, 27).addComponent(this.lblPlayer1, -2, 25, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spnConstructTime, -2, -1, -2).addComponent(this.lblConstructionTime))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.player1Panel, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlPlayers, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSettingsLoad, -2, 30, -2).addComponent(this.btnSettingsSave, -2, 30, -2).addComponent(this.lblSettings)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk, -2, 30, -2).addComponent(this.btnCancel, -2, 30, -2))).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void cbTournamentTypeActionPerformed(ActionEvent evt) {
        this.loadTourneyView(false, this.prepareVersionStr(-1, false), this.getCurrentNumPlayers(), this.chkSingleMultiplayerGame.isSelected());
        this.jumpstartPacksFilename = "";
        if (this.cbTournamentType.getSelectedItem().toString().matches(".*Jumpstart.*Custom.*")) {
            this.jumpstartPacksFilename = this.playerLoadJumpstartPacks();
        }
    }

    private void doClose() {
        if (this.customOptions.isVisible()) {
            this.customOptions.hideDialog();
        }
        this.hideDialog();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        int workablePlayers;
        DraftOptions draftOptions;
        TournamentOptions tOptions = this.getTournamentOptions();
        TournamentTypeView tournamentType = (TournamentTypeView)this.cbTournamentType.getSelectedItem();
        if ((tournamentType.isRandom() || tournamentType.isRichMan() || tournamentType.isReshuffled()) && tOptions.getLimitedOptions().getSetCodes().size() < 1) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Warning, you must select at least one set for the pool", "Warning", 2);
            return;
        }
        if (tournamentType.isDraft() && tOptions.getLimitedOptions() instanceof DraftOptions && (draftOptions = (DraftOptions)tOptions.getLimitedOptions()).getTiming() == DraftOptions.TimingOption.NONE) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Warning, you must select draft timing option", "Warning", 2);
            return;
        }
        if (tOptions.getMatchOptions().isSingleGameTourney() && (workablePlayers = tOptions.getPlayerTypes().stream().mapToInt(p -> p.isWorkablePlayer() ? 1 : 0).sum()) > 6) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), String.format("Warning, in single game mode you can choose %d human/ai players but selected %d", 6, workablePlayers), "Warning", 2);
            return;
        }
        if (tournamentType.isDraft() && tOptions.getLimitedOptions().getDraftCubeName() != null && tOptions.getLimitedOptions().getDraftCubeName().contains(CUBE_FROM_DECK_NAME) && (tOptions.getLimitedOptions().getCubeFromDeck() == null || tOptions.getLimitedOptions().getCubeFromDeck().getCards().isEmpty())) {
            JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Found empty cube. You must choose Cube From Deck again and select existing deck file.", "Warning", 2);
            return;
        }
        this.onSaveSettings(0, tOptions);
        this.table = SessionHandler.createTournamentTable(this.roomId, tOptions);
        if (this.table == null) {
            return;
        }
        for (TournamentPlayerPanel player : this.players) {
            if (player.getPlayerType().getSelectedItem() == PlayerType.HUMAN || player.joinTournamentTable(this.roomId, this.table.getTableId(), DeckImporter.importDeckFromFile(this.player1Panel.getDeckFile(), true))) continue;
            SessionHandler.removeTable(this.roomId, this.table.getTableId());
            this.table = null;
            return;
        }
        if (SessionHandler.joinTournamentTable(this.roomId, this.table.getTableId(), this.player1Panel.getPlayerName(), PlayerType.HUMAN, 1, DeckImporter.importDeckFromFile(this.player1Panel.getDeckFile(), true), tOptions.getPassword())) {
            this.doClose();
            return;
        }
        JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Error joining tournament.", "Error", 0);
        SessionHandler.removeTable(this.roomId, this.table.getTableId());
        this.table = null;
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.table = null;
        this.doClose();
    }

    private void applyNewPlayersCount() {
        int compatiblePlayers;
        int numPlayers = this.getCurrentNumPlayers();
        if (numPlayers != (compatiblePlayers = this.getCompatiblePlayersCount(numPlayers))) {
            numPlayers = compatiblePlayers;
            this.spnNumPlayers.setValue(numPlayers);
        }
        this.createPlayers(numPlayers - 1);
        if (this.chkSingleMultiplayerGame.isSelected()) {
            this.spnNumWins.setValue(1);
        }
    }

    private void spnNumPlayersStateChanged(ChangeEvent evt) {
        this.applyNewPlayersCount();
    }

    private void spnNumWinsnumPlayersChanged(ChangeEvent evt) {
        this.applyNewPlayersCount();
    }

    protected String playerLoadDeck() {
        int ret;
        String lastFolder;
        if (this.fcSelectDeck == null) {
            this.fcSelectDeck = new JFileChooser();
            this.fcSelectDeck.setAcceptAllFileFilterUsed(false);
            this.fcSelectDeck.addChoosableFileFilter(new DeckFileFilter("dck", "XMage's deck files (*.dck)"));
        }
        if (!(lastFolder = MageFrame.getPreferences().get("lastDeckFolder", "")).isEmpty()) {
            this.fcSelectDeck.setCurrentDirectory(new File(lastFolder));
        }
        if ((ret = this.fcSelectDeck.showDialog(this, "Select Deck")) == 0) {
            File file = this.fcSelectDeck.getSelectedFile();
            return file.getPath();
        }
        return "";
    }

    protected String playerLoadJumpstartPacks() {
        int ret;
        String lastFolder;
        if (this.fcJumpstartSelectDeck == null) {
            this.fcJumpstartSelectDeck = new JFileChooser();
            this.fcJumpstartSelectDeck.setAcceptAllFileFilterUsed(false);
            this.fcJumpstartSelectDeck.addChoosableFileFilter(new DeckFileFilter("txt", "Jumpstart Packs (*.txt)"));
        }
        if (!(lastFolder = MageFrame.getPreferences().get("lastDeckFolder", "")).isEmpty()) {
            this.fcJumpstartSelectDeck.setCurrentDirectory(new File(lastFolder));
        }
        if ((ret = this.fcJumpstartSelectDeck.showDialog(this, "Select Jumpstart Packs file")) == 0) {
            File file = this.fcJumpstartSelectDeck.getSelectedFile();
            return file.getPath();
        }
        return "";
    }

    private void cbDraftCubeActionPerformed(ActionEvent evt) {
        this.cubeFromDeckFilename = "";
        if (this.cbDraftCube.getSelectedItem().toString().startsWith(CUBE_FROM_DECK_NAME)) {
            this.cubeFromDeckFilename = this.playerLoadDeck();
        }
    }

    private void cbDraftTimingActionPerformed(ActionEvent evt) {
    }

    private void spnNumRoundsnumPlayersChanged(ChangeEvent evt) {
    }

    private void cbGameTypeActionPerformed(ActionEvent evt) {
        this.setGameOptions();
    }

    private void spnMinimumRatingnumPlayersChanged(ChangeEvent evt) {
    }

    private void menuSaveSettings1ActionPerformed(ActionEvent evt) {
        this.onSaveSettings(1);
    }

    private void menuSaveSettings2ActionPerformed(ActionEvent evt) {
        this.onSaveSettings(2);
    }

    private void menuLoadSettingsLastActionPerformed(ActionEvent evt) {
        this.onLoadSettings(0);
    }

    private void menuLoadSettings1ActionPerformed(ActionEvent evt) {
        this.onLoadSettings(1);
    }

    private void menuLoadSettings2ActionPerformed(ActionEvent evt) {
        this.onLoadSettings(2);
    }

    private void menuLoadSettingsDefaultActionPerformed(ActionEvent evt) {
        this.onLoadSettings(-1);
    }

    private void btnSettingsSaveMouseClicked(MouseEvent evt) {
        this.popupSaveSettings.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void btnSettingsLoadMouseClicked(MouseEvent evt) {
        this.popupLoadSettings.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void btnCustomOptionsActionPerformed(ActionEvent evt) {
        this.customOptions.showDialog();
    }

    private void chkSingleMultiplayerGameItemStateChanged(ItemEvent evt) {
        this.applyNewPlayersCount();
    }

    private void setGameOptions() {
        this.createPlayers(this.getCurrentNumPlayers() - 1);
    }

    private int getCompatiblePlayersCount(int count) {
        TournamentTypeView tournamentType = (TournamentTypeView)this.cbTournamentType.getSelectedItem();
        if (tournamentType == null) {
            return count;
        }
        int compatibleMin = tournamentType.getMinPlayers();
        int compatibleMax = tournamentType.getMaxPlayers();
        if (this.chkSingleMultiplayerGame.isSelected()) {
            // empty if block
        }
        int compatibleCount = count;
        compatibleCount = Math.max(compatibleCount, compatibleMin);
        compatibleCount = Math.min(compatibleCount, compatibleMax);
        return compatibleCount;
    }

    private void loadTourneyView(boolean loadPlayerSettings, String versionStr, int numPlayers, boolean isSingleMultiplayerGame) {
        TournamentTypeView tournamentType = (TournamentTypeView)this.cbTournamentType.getSelectedItem();
        this.activatePanelElements(tournamentType);
        numPlayers = this.getCompatiblePlayersCount(numPlayers);
        this.spnNumPlayers.setModel(new SpinnerNumberModel(numPlayers, tournamentType.getMinPlayers(), tournamentType.getMaxPlayers(), 1));
        this.spnNumPlayers.setEnabled(tournamentType.getMinPlayers() != tournamentType.getMaxPlayers());
        this.chkSingleMultiplayerGame.setSelected(isSingleMultiplayerGame);
        this.spnNumPlayers.setValue(numPlayers);
        this.spnNumPlayersStateChanged(null);
        int numWins = Integer.parseInt(PreferencesDialog.getCachedValue("newTournamentNumberOfWins" + versionStr, "2"));
        this.spnNumWins.setValue(numWins);
        if (loadPlayerSettings) {
            String playerData = PreferencesDialog.getCachedValue("newTournamentPlayerTypes" + versionStr, "Human");
            this.prefPlayerTypes.clear();
            for (String playerTypeStr : playerData.split("@@@")) {
                this.prefPlayerTypes.add(PlayerType.getByDescription(playerTypeStr));
            }
            playerData = PreferencesDialog.getCachedValue("newTournamentPlayerSkills" + versionStr, String.valueOf(2));
            this.prefPlayerSkills.clear();
            for (String playerSkillStr : playerData.split("@@@")) {
                this.prefPlayerSkills.add(Integer.parseInt(playerSkillStr));
            }
        }
        this.createPlayers(numPlayers - 1);
        this.preparePacksView(tournamentType);
    }

    private void preparePacksView(TournamentTypeView tournamentType) {
        if (tournamentType.isLimited()) {
            this.isRandom = tournamentType.isRandom();
            this.isRichMan = tournamentType.isRichMan();
            this.isReshuffled = tournamentType.isReshuffled();
            if (this.isRandom || this.isRichMan || this.isReshuffled) {
                this.createRandomPacks();
            } else {
                this.createPacks(tournamentType.getNumBoosters());
            }
        }
    }

    private void setNumberOfSwissRoundsMin(int additionalNumPlayers) {
        int minRounds = additionalNumPlayers + 1 > 4 ? 3 : 2;
        int newValue = Math.max((Integer)this.spnNumRounds.getValue(), minRounds);
        this.spnNumRounds.setModel(new SpinnerNumberModel(newValue, 2, 10, 1));
        this.pack();
        this.revalidate();
        this.repaint();
    }

    private void activatePanelElements(TournamentTypeView tournamentType) {
        this.pnlDraftOptions.setVisible(tournamentType.isDraft());
        this.lblNumRounds.setVisible(!tournamentType.isElimination());
        this.spnNumRounds.setVisible(!tournamentType.isElimination());
        this.lblConstructionTime.setVisible(tournamentType.isLimited());
        this.spnConstructTime.setVisible(tournamentType.isLimited());
        this.lbDeckType.setVisible(!tournamentType.isLimited());
        this.cbDeckType.setVisible(!tournamentType.isLimited());
        this.lblGameType.setVisible(!tournamentType.isLimited());
        this.cbGameType.setVisible(!tournamentType.isLimited());
        this.player1Panel.showDeckElements(!tournamentType.isLimited());
        if (tournamentType.isLimited()) {
            if (tournamentType.isCubeBooster()) {
                this.lblDraftCube.setVisible(true);
                this.cbDraftCube.setVisible(true);
                this.lblPacks.setVisible(false);
                this.pnlPacks.setVisible(false);
                this.pnlRandomPacks.setVisible(false);
            } else if (tournamentType.isRandom() || tournamentType.isRichMan() || tournamentType.isReshuffled()) {
                this.lblDraftCube.setVisible(false);
                this.cbDraftCube.setVisible(false);
                this.lblPacks.setVisible(true);
                this.pnlRandomPacks.setVisible(true);
                this.pnlPacks.setVisible(false);
            } else {
                this.lblDraftCube.setVisible(false);
                this.cbDraftCube.setVisible(false);
                this.lblPacks.setVisible(true);
                this.pnlPacks.setVisible(true);
                this.pnlRandomPacks.setVisible(false);
            }
        } else {
            this.lblDraftCube.setVisible(false);
            this.cbDraftCube.setVisible(false);
            this.lblPacks.setVisible(false);
            this.pnlPacks.setVisible(false);
            this.pnlRandomPacks.setVisible(false);
        }
    }

    private String prepareVersionStr(int version, boolean saveMode) {
        switch (version) {
            case -1: {
                return saveMode ? "" : "-1";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
        }
        return "";
    }

    private void loadRandomPacks(int version) {
        String packNames;
        List<String> packList;
        String versionStr = this.prepareVersionStr(version, false);
        String randomPrefs = PreferencesDialog.getCachedValue("newTournamentPacksRandomDraft" + versionStr, "");
        if (!randomPrefs.isEmpty()) {
            packList = new ArrayList<String>(Arrays.asList(randomPrefs.split(";")));
            packNames = randomPrefs;
        } else {
            ExpansionInfo[] allExpansions = ExpansionRepository.instance.getWithBoostersSortedByReleaseDate();
            packList = Arrays.stream(allExpansions).map(ExpansionInfo::getCode).collect(Collectors.toCollection(ArrayList::new));
            packNames = Arrays.stream(allExpansions).map(ExpansionInfo::getCode).collect(Collectors.joining(";"));
        }
        this.randomPackSelector.setSelectedPacks(packList);
        this.txtRandomPacks.setText(packNames);
    }

    private void createRandomPacks() {
        if (this.pnlRandomPacks.getComponentCount() == 0) {
            if (this.randomPackSelector == null) {
                this.randomPackSelector = new RandomPacksSelectorDialog();
                this.randomPackSelector.setLocationRelativeTo(this);
            }
            this.txtRandomPacks = new JTextArea();
            this.txtRandomPacks.setEnabled(false);
            this.txtRandomPacks.setLineWrap(true);
            this.loadRandomPacks(-1);
            this.txtRandomPacks.setAlignmentX(0.0f);
            this.pnlRandomPacks.add(this.txtRandomPacks);
            JButton btnSelectRandomPacks = new JButton();
            btnSelectRandomPacks.setAlignmentX(0.0f);
            btnSelectRandomPacks.setText("Select sets to be included in the pool");
            btnSelectRandomPacks.setToolTipText("The selected packs will be randomly distributed to players. Each player may open different packs. Duplicates will be avoided.");
            btnSelectRandomPacks.addActionListener(evt -> this.showRandomPackSelectorDialog());
            this.pnlRandomPacks.add(btnSelectRandomPacks);
            this.pnlRandomPacks.setMinimumSize(new Dimension(784, 150));
        }
        this.txtRandomPacks.setText(this.txtRandomPacks.getText());
        this.pack();
        this.revalidate();
        this.repaint();
    }

    private void showRandomPackSelectorDialog() {
        this.randomPackSelector.showDialog(this.isRandom, this.isRichMan, this.isReshuffled);
        this.txtRandomPacks.setText(String.join((CharSequence)";", this.randomPackSelector.getSelectedPacks()));
        this.pack();
        this.revalidate();
        this.repaint();
    }

    private void createPacks(int numPacks) {
        while (this.packPanels.size() > numPacks) {
            this.pnlPacks.remove(this.packPanels.get(this.packPanels.size() - 1));
            this.packPanels.remove(this.packPanels.size() - 1);
        }
        while (this.packPanels.size() < numPacks) {
            JPanel setPanel = new JPanel();
            setPanel.setLayout(new BoxLayout(setPanel, 2));
            setPanel.setOpaque(false);
            this.pnlPacks.add(setPanel);
            this.packPanels.add(setPanel);
            JComboBox<ExpansionInfo> pack = new JComboBox<ExpansionInfo>();
            pack.setModel(new DefaultComboBoxModel<ExpansionInfo>(ExpansionRepository.instance.getWithBoostersSortedByReleaseDate()));
            pack.addActionListener(evt -> this.packActionPerformed(evt));
            pack.setAlignmentX(0.0f);
            pack.setMinimumSize(new Dimension(50, 25));
            pack.setPreferredSize(new Dimension(50, 25));
            pack.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
            setPanel.add(pack);
            JButton searchButton = new JButton();
            searchButton.setIcon(new ImageIcon(this.getClass().getResource("/buttons/search_24.png")));
            searchButton.setToolTipText("Search and select from list");
            searchButton.setAlignmentX(1.0f);
            searchButton.setMinimumSize(new Dimension(24, 24));
            searchButton.setPreferredSize(new Dimension(32, 32));
            searchButton.setMaximumSize(new Dimension(32, 32));
            searchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JButton button = (JButton)evt.getSource();
                    JComboBox combo = NewTournamentDialog.this.findComboInComponent(button.getParent());
                    if (combo != null) {
                        FastSearchUtil.showFastSearchForStringComboBox(combo, "Select value");
                    }
                }
            });
            setPanel.add(searchButton);
        }
        this.pack();
        this.revalidate();
        this.repaint();
    }

    private JComboBox findComboInComponent(Container panel) {
        JComboBox combo = null;
        for (Component comp : panel.getComponents()) {
            if (!(comp instanceof JComboBox)) continue;
            combo = (JComboBox)comp;
            break;
        }
        return combo;
    }

    private void packActionPerformed(ActionEvent evt) {
        JComboBox pack;
        int i;
        JComboBox curentCombo = (JComboBox)evt.getSource();
        int newValue = curentCombo.getSelectedIndex();
        int startIndex = 0;
        for (i = 0; i < this.packPanels.size(); ++i) {
            pack = this.findComboInComponent(this.packPanels.get(i));
            if (pack == null || !pack.equals(curentCombo)) continue;
            startIndex = i + 1;
            break;
        }
        for (i = startIndex; i < this.packPanels.size(); ++i) {
            pack = this.findComboInComponent(this.packPanels.get(i));
            if (pack == null) continue;
            pack.setSelectedIndex(newValue);
        }
    }

    private void createPlayers(int additionalNumPlayers) {
        if (additionalNumPlayers > this.players.size()) {
            while (this.players.size() != additionalNumPlayers) {
                TournamentPlayerPanel playerPanel = new TournamentPlayerPanel();
                this.players.add(playerPanel);
            }
        }
        if (additionalNumPlayers < this.players.size()) {
            while (this.players.size() != additionalNumPlayers) {
                this.players.remove(this.players.size() - 1);
            }
        }
        for (int i = 0; i < this.players.size(); ++i) {
            TournamentPlayerPanel playerPanel = this.players.get(i);
            PlayerType playerType = PlayerType.HUMAN;
            if (i < this.prefPlayerTypes.size()) {
                playerType = this.prefPlayerTypes.get(i);
            }
            int playerSkill = 2;
            if (i < this.prefPlayerSkills.size()) {
                playerSkill = this.prefPlayerSkills.get(i);
            }
            playerPanel.init(i + 2, playerType, playerSkill);
        }
        this.drawPlayers();
        this.setNumberOfSwissRoundsMin(additionalNumPlayers);
    }

    private void drawPlayers() {
        this.pnlOtherPlayers.removeAll();
        for (TournamentPlayerPanel panel : this.players) {
            this.pnlOtherPlayers.add(panel);
            panel.getPlayerType().addActionListener(evt -> {
                if (!this.automaticChange) {
                    this.playerActionPerformed(evt);
                }
            });
        }
        this.pack();
        this.revalidate();
        this.repaint();
    }

    private void playerActionPerformed(ActionEvent evt) {
        boolean start = false;
        int selectedIndex = 0;
        this.automaticChange = true;
        for (TournamentPlayerPanel player : this.players) {
            if (!start) {
                if (!evt.getSource().equals(player.getPlayerType())) continue;
                start = true;
                selectedIndex = player.getPlayerType().getSelectedIndex();
                continue;
            }
            player.getPlayerType().setSelectedIndex(selectedIndex);
        }
        this.automaticChange = false;
    }

    private void loadBoosterPacks(String packString) {
        if (!packString.isEmpty()) {
            String[] packsArray = packString.substring(1, packString.length() - 1).split(",");
            int packNumber = 0;
            block0: for (String pack : packsArray) {
                if (this.packPanels.isEmpty() || this.packPanels.size() < ++packNumber - 1) continue;
                JPanel panel = this.packPanels.get(packNumber - 1);
                JComboBox comboBox = this.findComboInComponent(panel);
                if (comboBox != null) {
                    ComboBoxModel model = comboBox.getModel();
                    int size = model.getSize();
                    for (int i = 0; i < size; ++i) {
                        ExpansionInfo element = (ExpansionInfo)model.getElementAt(i);
                        if (!element.getCode().equals(pack.trim())) continue;
                        comboBox.setSelectedIndex(i);
                        continue block0;
                    }
                    continue;
                }
                logger.error((Object)("Can't find combo component in " + panel.toString()));
            }
        }
    }

    private TournamentOptions getTournamentOptions() {
        TournamentOptions tOptions;
        block23: {
            block20: {
                block22: {
                    TournamentTypeView tournamentType;
                    block21: {
                        tournamentType = (TournamentTypeView)this.cbTournamentType.getSelectedItem();
                        tOptions = new TournamentOptions(this.txtName.getText(), "", this.chkSingleMultiplayerGame.isSelected());
                        tOptions.setTournamentType(tournamentType.getName());
                        tOptions.setPassword(this.txtPassword.getText());
                        tOptions.getPlayerTypes().add(PlayerType.HUMAN);
                        tOptions.setWatchingAllowed(this.cbAllowSpectators.isSelected());
                        tOptions.setQuitRatio((Integer)this.spnQuitRatio.getValue());
                        tOptions.setMinimumRating((Integer)this.spnMinimumRating.getValue());
                        for (TournamentPlayerPanel player : this.players) {
                            tOptions.getPlayerTypes().add((PlayerType)((Object)player.getPlayerType().getSelectedItem()));
                        }
                        if (!tournamentType.isElimination()) {
                            tOptions.setNumberRounds((Integer)this.spnNumRounds.getValue());
                        }
                        if (tournamentType.isDraft()) {
                            DraftOptions options = new DraftOptions();
                            options.setTiming((DraftOptions.TimingOption)((Object)this.cbDraftTiming.getSelectedItem()));
                            tOptions.setLimitedOptions(options);
                        }
                        if (tOptions.getLimitedOptions() == null) {
                            tOptions.setLimitedOptions(new LimitedOptions());
                        }
                        if (!tournamentType.isLimited()) break block20;
                        tOptions.getLimitedOptions().setConstructionTime((Integer)this.spnConstructTime.getValue() * 60);
                        tOptions.getLimitedOptions().setIsRandom(tournamentType.isRandom());
                        tOptions.getLimitedOptions().setIsReshuffled(tournamentType.isReshuffled());
                        tOptions.getLimitedOptions().setIsRichMan(tournamentType.isRichMan());
                        tOptions.getLimitedOptions().setIsJumpstart(tournamentType.isJumpstart());
                        if (tournamentType.isJumpstart() && !this.jumpstartPacksFilename.isEmpty()) {
                            String jumpstartPacksData = "";
                            try {
                                jumpstartPacksData = new String(Files.readAllBytes(Paths.get(this.jumpstartPacksFilename, new String[0])));
                                if (jumpstartPacksData.length() > 300000) {
                                    JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Chosen file too big", "Jumpstart Packs data is too long.  Please trim or choose another file.", 0);
                                    jumpstartPacksData = "";
                                }
                            }
                            catch (IOException e2) {
                                JOptionPane.showMessageDialog(MageFrame.getDesktop(), e2.getMessage(), "Error loading Jumpstart Packs data", 0);
                            }
                            tOptions.getLimitedOptions().setJumpstartPacks(jumpstartPacksData);
                        }
                        if (!tournamentType.isCubeBooster()) break block21;
                        tOptions.getLimitedOptions().setDraftCubeName(this.cbDraftCube.getSelectedItem().toString());
                        if (this.cubeFromDeckFilename.isEmpty()) break block22;
                        Deck cubeFromDeck = new Deck();
                        try {
                            cubeFromDeck = Deck.load(DeckImporter.importDeckFromFile(this.cubeFromDeckFilename, true), true, true);
                        }
                        catch (GameException e1) {
                            JOptionPane.showMessageDialog(MageFrame.getDesktop(), e1.getMessage(), "Error loading deck", 0);
                        }
                        if (cubeFromDeck == null) break block22;
                        cubeFromDeck.clearLayouts();
                        tOptions.getLimitedOptions().setCubeFromDeck(cubeFromDeck);
                        break block22;
                    }
                    if (tournamentType.isRandom() || tournamentType.isRichMan()) {
                        this.isRandom = tournamentType.isRandom();
                        this.isRichMan = tournamentType.isRichMan();
                        this.isReshuffled = tournamentType.isReshuffled();
                        tOptions.getLimitedOptions().getSetCodes().clear();
                        List<String> selected = this.randomPackSelector.getSelectedPacks();
                        Collections.shuffle(selected);
                        int maxPacks = 3 * (this.players.size() + 1);
                        if (tournamentType.isRichMan()) {
                            maxPacks = 36;
                        }
                        if (selected.size() > maxPacks) {
                            StringBuilder infoString = new StringBuilder("More sets were selected than needed. ");
                            infoString.append(maxPacks);
                            infoString.append(" sets will be randomly chosen.");
                            JOptionPane.showMessageDialog(MageFrame.getDesktop(), infoString, "Information", 1);
                            tOptions.getLimitedOptions().getSetCodes().addAll(selected.subList(0, maxPacks));
                        } else {
                            tOptions.getLimitedOptions().getSetCodes().addAll((Collection<String>)selected);
                        }
                    } else if (tournamentType.isReshuffled()) {
                        this.isRandom = tournamentType.isRandom();
                        this.isRichMan = tournamentType.isRichMan();
                        this.isReshuffled = tournamentType.isReshuffled();
                        tOptions.getLimitedOptions().getSetCodes().clear();
                        tOptions.getLimitedOptions().getSetCodes().addAll(this.randomPackSelector.getSelectedPacks());
                    } else {
                        for (JPanel panel : this.packPanels) {
                            JComboBox combo = this.findComboInComponent(panel);
                            if (combo != null) {
                                tOptions.getLimitedOptions().getSetCodes().add(((ExpansionInfo)combo.getSelectedItem()).getCode());
                                continue;
                            }
                            logger.error((Object)("Can't find combo component in " + panel.toString()));
                        }
                    }
                }
                tOptions.getMatchOptions().setDeckType("Limited");
                tOptions.getMatchOptions().setGameType("Two Player Duel");
                tOptions.getMatchOptions().setLimited(true);
                break block23;
            }
            tOptions.getLimitedOptions().setConstructionTime(0);
            tOptions.getLimitedOptions().setNumberBoosters(0);
            tOptions.getLimitedOptions().setDraftCube(null);
            tOptions.getLimitedOptions().setDraftCubeName("");
            tOptions.getMatchOptions().setDeckType((String)this.cbDeckType.getSelectedItem());
            tOptions.getMatchOptions().setGameType(((GameTypeView)this.cbGameType.getSelectedItem()).getName());
            tOptions.getMatchOptions().setLimited(tOptions.getMatchOptions().getDeckType().startsWith("Limited"));
            if (tOptions.getMatchOptions().getDeckType().startsWith("Variant Magic - Freeform Unlimited Commander")) {
                tOptions.getMatchOptions().setLimited(true);
            }
        }
        String serverAddress = SessionHandler.getSession().getServerHost();
        tOptions.getMatchOptions().setBannedUsers(IgnoreList.getIgnoredUsers(serverAddress));
        tOptions.getMatchOptions().setMatchTimeLimit((MatchTimeLimit)((Object)this.cbTimeLimit.getSelectedItem()));
        tOptions.getMatchOptions().setMatchBufferTime((MatchBufferTime)((Object)this.cbBufferTime.getSelectedItem()));
        tOptions.getMatchOptions().setSkillLevel((SkillLevel)((Object)this.cbSkillLevel.getSelectedItem()));
        tOptions.getMatchOptions().setWinsNeeded((Integer)this.spnNumWins.getValue());
        tOptions.getMatchOptions().setAttackOption(MultiplayerAttackOption.MULTIPLE);
        tOptions.getMatchOptions().setRange(RangeOfInfluence.ALL);
        tOptions.getMatchOptions().setRollbackTurnsAllowed(this.chkRollbackTurnsAllowed.isSelected());
        tOptions.getMatchOptions().setRated(this.chkRated.isSelected());
        this.customOptions.writeMatchOptionsTo(tOptions.getMatchOptions());
        return tOptions;
    }

    private void onLoadSettings(int version) {
        int constructionTime;
        String versionStr = this.prepareVersionStr(version, false);
        this.txtName.setText(PreferencesDialog.getCachedValue("newTournamentName" + versionStr, "Tournament"));
        this.txtPassword.setText(PreferencesDialog.getCachedValue("newTournamentPassword" + versionStr, ""));
        int timeLimit = Integer.parseInt(PreferencesDialog.getCachedValue("newTournamentTimeLimit" + versionStr, "1500"));
        for (MatchTimeLimit mtl : MatchTimeLimit.values()) {
            if (mtl.getPrioritySecs() != timeLimit) continue;
            this.cbTimeLimit.setSelectedItem((Object)mtl);
            break;
        }
        int bufferTime = Integer.parseInt(PreferencesDialog.getCachedValue("newTournamentBufferTime" + versionStr, "0"));
        for (MatchBufferTime mtl : MatchBufferTime.values()) {
            if (mtl.getBufferSecs() != bufferTime) continue;
            this.cbBufferTime.setSelectedItem((Object)mtl);
            break;
        }
        String skillLevelDefault = PreferencesDialog.getCachedValue("newTournamentSkillLevel" + versionStr, "Casual");
        for (SkillLevel skillLevel : SkillLevel.values()) {
            if (!skillLevel.toString().equals(skillLevelDefault)) continue;
            this.cbSkillLevel.setSelectedItem((Object)skillLevel);
            break;
        }
        if ((constructionTime = Integer.parseInt(PreferencesDialog.getCachedValue("newTournamentConstructionTime" + versionStr, "600")) / 60) < 6 || constructionTime > 30) {
            constructionTime = 6;
        }
        this.spnConstructTime.setValue(constructionTime);
        String tournamentTypeName = PreferencesDialog.getCachedValue("newTournamentType" + versionStr, "Sealed Elimination");
        for (TournamentTypeView tournamentTypeView : SessionHandler.getTournamentTypes()) {
            if (!tournamentTypeView.getName().equals(tournamentTypeName)) continue;
            this.cbTournamentType.setSelectedItem(tournamentTypeView);
            break;
        }
        this.spnQuitRatio.setValue(Integer.parseInt(PreferencesDialog.getCachedValue("newTournamentQuitRatio" + versionStr, "100")));
        this.spnMinimumRating.setValue(Integer.parseInt(PreferencesDialog.getCachedValue("newTournamentMinimumRating" + versionStr, "0")));
        TournamentTypeView tournamentType = (TournamentTypeView)this.cbTournamentType.getSelectedItem();
        this.activatePanelElements(tournamentType);
        int defaultNumberPlayers = 2;
        if (tournamentType.isLimited()) {
            if (tournamentType.isDraft()) {
                defaultNumberPlayers = 4;
                if (tournamentType.isRandom() || tournamentType.isRichMan() || tournamentType.isReshuffled()) {
                    this.loadRandomPacks(version);
                } else {
                    this.loadBoosterPacks(PreferencesDialog.getCachedValue("newTournamentPacksDraft" + versionStr, ""));
                }
                String draftTiming = PreferencesDialog.getCachedValue("newTournamentDraftTiming" + versionStr, "REGULAR");
                for (DraftOptions.TimingOption timingOption : DraftOptions.TimingOption.values()) {
                    if (!timingOption.toString().equals(draftTiming)) continue;
                    this.cbDraftTiming.setSelectedItem(draftTiming);
                    break;
                }
            } else {
                this.loadBoosterPacks(PreferencesDialog.getCachedValue("newTournamentPacksSealed" + versionStr, ""));
            }
        }
        this.cbAllowSpectators.setSelected(PreferencesDialog.getCachedValue("newTournamentAllowSpectators" + versionStr, "Yes").equals("Yes"));
        this.chkRollbackTurnsAllowed.setSelected(PreferencesDialog.getCachedValue("newTournamentAllowRollbacks" + versionStr, "Yes").equals("Yes"));
        this.chkRated.setSelected(PreferencesDialog.getCachedValue("newTournamentRated" + versionStr, "No").equals("Yes"));
        String deckFile = PreferencesDialog.getCachedValue("newTournamentDeckFile" + versionStr, "");
        if (deckFile != null && !deckFile.isEmpty() && new File(deckFile).exists()) {
            this.player1Panel.setDeckFile(deckFile);
        }
        int numPlayers = Integer.parseInt(PreferencesDialog.getCachedValue("newTournamentNumberPlayers" + versionStr, String.valueOf(defaultNumberPlayers)));
        boolean isSingleMultiplayerGame = PreferencesDialog.getCachedValue("newTournamentSingleMultiplayerGame" + versionStr, "No").equals("Yes");
        this.loadTourneyView(true, versionStr, numPlayers, isSingleMultiplayerGame);
        this.customOptions.onLoadSettings(version);
    }

    private void onSaveSettings(int version) {
        TournamentOptions tOptions = this.getTournamentOptions();
        this.onSaveSettings(version, tOptions);
    }

    private void onSaveSettings(int version, TournamentOptions tOptions) {
        String versionStr = this.prepareVersionStr(version, true);
        PreferencesDialog.saveValue("newTournamentName" + versionStr, tOptions.getName());
        PreferencesDialog.saveValue("newTournamentPassword" + versionStr, tOptions.getPassword());
        PreferencesDialog.saveValue("newTournamentTimeLimit" + versionStr, Integer.toString(tOptions.getMatchOptions().getMatchTimeLimit().getPrioritySecs()));
        PreferencesDialog.saveValue("newTournamentBufferTime" + versionStr, Integer.toString(tOptions.getMatchOptions().getMatchBufferTime().getBufferSecs()));
        if (this.spnConstructTime.isVisible()) {
            PreferencesDialog.saveValue("newTournamentConstructionTime" + versionStr, Integer.toString(tOptions.getLimitedOptions().getConstructionTime()));
        }
        PreferencesDialog.saveValue("newTournamentType" + versionStr, tOptions.getTournamentType());
        PreferencesDialog.saveValue("newTournamentNumberOfWins" + versionStr, Integer.toString(tOptions.getMatchOptions().getWinsNeeded()));
        PreferencesDialog.saveValue("newTournamentQuitRatio" + versionStr, Integer.toString(tOptions.getQuitRatio()));
        PreferencesDialog.saveValue("newTournamentMinimumRating" + versionStr, Integer.toString(tOptions.getMinimumRating()));
        if (tOptions.getTournamentType().startsWith("Sealed")) {
            PreferencesDialog.saveValue("newTournamentPacksSealed" + versionStr, tOptions.getLimitedOptions().getSetCodes().toString());
        }
        if (tOptions.getTournamentType().startsWith("Booster")) {
            DraftOptions draftOptions = (DraftOptions)tOptions.getLimitedOptions();
            if (draftOptions != null) {
                PreferencesDialog.saveValue("newTournamentPacksDraft" + versionStr, draftOptions.getSetCodes().toString());
                PreferencesDialog.saveValue("newTournamentDraftTiming" + versionStr, draftOptions.getTiming().name());
            }
            if (tOptions.getLimitedOptions().getIsRandom() || tOptions.getLimitedOptions().getIsRichMan() || tOptions.getLimitedOptions().getIsReshuffled()) {
                PreferencesDialog.saveValue("newTournamentPacksRandomDraft" + versionStr, String.join((CharSequence)";", this.randomPackSelector.getSelectedPacks()));
            }
        }
        PreferencesDialog.saveValue("newTournamentAllowSpectators" + versionStr, tOptions.isWatchingAllowed() ? "Yes" : "No");
        PreferencesDialog.saveValue("newTournamentAllowRollbacks" + versionStr, tOptions.getMatchOptions().isRollbackTurnsAllowed() ? "Yes" : "No");
        PreferencesDialog.saveValue("newTournamentRated" + versionStr, tOptions.getMatchOptions().isRated() ? "Yes" : "No");
        String deckFile = this.player1Panel.getDeckFile();
        if (deckFile != null && !deckFile.isEmpty()) {
            PreferencesDialog.saveValue("newTournamentDeckFile" + versionStr, deckFile);
        }
        PreferencesDialog.saveValue("newTournamentNumberPlayers" + versionStr, Integer.toString(tOptions.getPlayerTypes().size()));
        PreferencesDialog.saveValue("newTournamentSingleMultiplayerGame" + versionStr, tOptions.getMatchOptions().isSingleGameTourney() ? "Yes" : "No");
        String playerData = this.players.stream().map(panel -> (PlayerType)((Object)((Object)panel.getPlayerType().getSelectedItem()))).map(panel -> panel.toString()).collect(Collectors.joining("@@@"));
        PreferencesDialog.saveValue("newTournamentPlayerTypes" + versionStr, playerData);
        playerData = this.players.stream().map(panel -> String.valueOf(panel.getPlayerSkill())).collect(Collectors.joining("@@@"));
        PreferencesDialog.saveValue("newTournamentPlayerSkills" + versionStr, playerData);
        this.customOptions.onSaveSettings(version, tOptions.getMatchOptions());
    }

    public TableView getTable() {
        return this.table;
    }
}

