/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mage.cards.action.TransferData;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.cards.VirtualCardInfo;
import mage.client.components.MageEditorPane;
import mage.client.dialog.MageDialog;
import mage.client.game.GamePanel;
import mage.client.util.GUISizeHelper;
import mage.client.util.gui.MageDialogState;
import mage.game.command.Dungeon;
import mage.view.CardView;
import mage.view.DungeonView;
import org.mage.card.arcane.ManaSymbols;

public class PickChoiceDialog
extends MageDialog {
    Choice choice;
    int lastModelIndex = -1;
    VirtualCardInfo cardInfo = new VirtualCardInfo();
    BigCard bigCard;
    UUID gameId;
    List<KeyValueItem> allItems = new ArrayList<KeyValueItem>();
    KeyValueItem biggestItem = null;
    PickChoiceCallback callback = null;
    private static final String HTML_HEADERS_TEMPLATE = "<html><div style='text-align: center;'>%s</div></html>";
    private JButton btCancel;
    private JButton btOK;
    private JCheckBox cbSpecial;
    private JTextField editSearch;
    private JLabel labelSearch;
    private JList listChoices;
    private JPanel panelCommands;
    private JPanel panelHeader;
    private JPanel panelSearch;
    private JScrollPane scrollList;
    private MageEditorPane textMessage;
    private MageEditorPane textSubMessage;

    public PickChoiceDialog() {
        this.initComponents();
        this.textMessage.enableHyperlinksAndCardPopups();
        this.textMessage.enableTextLabelMode();
        this.textSubMessage.enableHyperlinksAndCardPopups();
        this.textSubMessage.enableTextLabelMode();
        this.setSize(GUISizeHelper.dialogGuiScaleSize(this.getSize()));
        this.listChoices.setModel(new DefaultListModel());
        this.setModal(true);
    }

    public void showDialog(Choice choice, String startSelectionValue, PickChoiceCallback callback) {
        this.showDialog(choice, startSelectionValue, null, null, null, callback);
    }

    /*
     * WARNING - void declaration
     */
    public void showDialog(final Choice choice, String startSelectionValue, UUID objectId, MageDialogState mageDialogState, BigCard bigCard, PickChoiceCallback callback) {
        KeyValueItem newItem;
        this.choice = choice;
        this.bigCard = bigCard;
        this.gameId = objectId;
        this.callback = callback;
        this.changeGUISize();
        this.setMessageText(this.textMessage, choice.getMessage());
        this.setMessageText(this.textSubMessage, choice.getSubMessage());
        this.btCancel.setEnabled(!choice.isRequired());
        this.cbSpecial.setVisible(choice.isSpecialEnabled());
        this.cbSpecial.setText(choice.getSpecialText());
        this.cbSpecial.setToolTipText(choice.getSpecialHint());
        this.allItems.clear();
        this.biggestItem = null;
        if (choice.isKeyChoice()) {
            for (Map.Entry entry : choice.getKeyChoices().entrySet()) {
                newItem = new KeyValueItem((String)entry.getKey(), (String)entry.getValue(), (String)entry.getValue(), choice.getHintType());
                this.allItems.add(newItem);
                if (this.biggestItem != null && newItem.valueAsHtml.length() <= this.biggestItem.valueAsHtml.length()) continue;
                this.biggestItem = newItem;
            }
        } else {
            for (String string : choice.getChoices()) {
                newItem = new KeyValueItem(string, string, string, choice.getHintType());
                this.allItems.add(newItem);
                if (this.biggestItem != null && newItem.valueAsHtml.length() <= this.biggestItem.valueAsHtml.length()) continue;
                this.biggestItem = newItem;
            }
        }
        if (choice.isSortEnabled()) {
            this.allItems.sort((o1, o2) -> {
                Integer n2;
                Integer n1 = choice.getSortData().get(o1.getKey());
                if (n1.equals(n2 = choice.getSortData().get(o2.getKey()))) {
                    return o1.value.compareTo(o2.value);
                }
                return Integer.compare(n1, n2);
            });
        }
        if (!choice.getHintData().isEmpty()) {
            this.allItems.forEach(item -> {
                List info = choice.getHintData().getOrDefault(item.key, null);
                if (info != null) {
                    item.hintType = ChoiceHintType.valueOf((String)info.get(0));
                    item.hint = (String)info.get(1);
                }
            });
        }
        this.listChoices.setPrototypeCellValue(this.biggestItem);
        if (choice.isSearchEnabled()) {
            this.panelSearch.setVisible(true);
            this.editSearch.setText(choice.getSearchText());
        } else {
            this.panelSearch.setVisible(false);
            this.editSearch.setText("");
        }
        this.editSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                choice.setSearchText(PickChoiceDialog.this.editSearch.getText());
                PickChoiceDialog.this.loadData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                choice.setSearchText(PickChoiceDialog.this.editSearch.getText());
                PickChoiceDialog.this.loadData();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                choice.setSearchText(PickChoiceDialog.this.editSearch.getText());
                PickChoiceDialog.this.loadData();
            }
        });
        this.editSearch.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    PickChoiceDialog.this.doPrevSelect();
                } else if (e.getKeyCode() == 40) {
                    PickChoiceDialog.this.doNextSelect();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.listChoices.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    PickChoiceDialog.this.doChoose();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PickChoiceDialog.this.choiceHintHide();
            }
        });
        this.listChoices.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JList listSource = (JList)e.getSource();
                int index = -1;
                Rectangle r = listSource.getCellBounds(0, listSource.getLastVisibleIndex());
                if (r != null && r.contains(e.getPoint())) {
                    index = listSource.locationToIndex(e.getPoint());
                }
                if (index > -1) {
                    PickChoiceDialog.this.choiceHintShow(index);
                } else {
                    PickChoiceDialog.this.choiceHintHide();
                }
            }
        });
        if (!choice.isRequired()) {
            String cancelName = "cancel";
            InputMap inputMap = this.getRootPane().getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
            ActionMap actionMap = this.getRootPane().getActionMap();
            actionMap.put(cancelName, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickChoiceDialog.this.doCancel();
                }
            });
        }
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        if (mageDialogState != null) {
            mageDialogState.setStateToDialog(this);
        } else {
            this.makeWindowCentered();
        }
        this.loadData();
        if (startSelectionValue != null) {
            void var8_15;
            int selectIndex = -1;
            boolean bl = false;
            while (var8_15 < this.listChoices.getModel().getSize()) {
                KeyValueItem listItem = (KeyValueItem)this.listChoices.getModel().getElementAt((int)var8_15);
                if (listItem.getKey().equals(startSelectionValue)) {
                    selectIndex = var8_15;
                    break;
                }
                ++var8_15;
            }
            if (selectIndex >= 0) {
                this.listChoices.setSelectedIndex(selectIndex);
                this.listChoices.ensureIndexIsVisible(selectIndex);
            }
        }
        this.setVisible(true);
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        this.textMessage.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.textSubMessage.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.labelSearch.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.editSearch.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.cbSpecial.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.listChoices.setFont(GUISizeHelper.tableFont);
        this.btOK.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btCancel.setFont(GUISizeHelper.gameFeedbackPanelFont);
    }

    private void choiceHintShow(int modelIndex) {
        if (this.lastModelIndex != modelIndex) {
            this.cardInfo.onMouseExited();
            this.listChoices.setToolTipText(null);
        }
        KeyValueItem item = (KeyValueItem)this.listChoices.getModel().getElementAt(modelIndex);
        switch (item.getHintType()) {
            case CARD: 
            case CARD_DUNGEON: 
            case GAME_OBJECT: {
                if (this.lastModelIndex != modelIndex) {
                    GamePanel game;
                    if (item.getHintType() == ChoiceHintType.CARD) {
                        this.cardInfo.init(item.getHint(), this.bigCard, this.gameId);
                    } else if (item.getHintType() == ChoiceHintType.CARD_DUNGEON) {
                        CardView cardView = new CardView(new DungeonView(Dungeon.createDungeon(item.getHint(), true)));
                        this.cardInfo.init(cardView, this.bigCard, this.gameId);
                    } else if (item.getHintType() == ChoiceHintType.GAME_OBJECT && (game = MageFrame.getGame(this.gameId)) != null) {
                        UUID objectId = UUID.fromString(item.getHint());
                        CardView cardView = game.getLastGameData().findCard(objectId);
                        if (cardView != null) {
                            this.cardInfo.init(cardView, this.bigCard, this.gameId);
                        }
                    }
                    this.cardInfo.setPopupAutoLocationMode(TransferData.PopupAutoLocationMode.PUT_NEAR_MOUSE_POSITION);
                    this.cardInfo.onMouseEntered(MouseInfo.getPointerInfo().getLocation());
                } else {
                    this.cardInfo.onMouseMoved(MouseInfo.getPointerInfo().getLocation());
                }
                this.lastModelIndex = modelIndex;
                break;
            }
            case TEXT: {
                if (this.lastModelIndex != modelIndex) {
                    String hint = item.getHint();
                    hint = ManaSymbols.replaceSymbolsWithHTML(hint, ManaSymbols.Type.DIALOG);
                    hint = GUISizeHelper.textToHtmlWithSize(hint, this.listChoices.getFont());
                    this.listChoices.setToolTipText(hint);
                }
                this.lastModelIndex = modelIndex;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported hint type " + (Object)((Object)item.getHintType()));
            }
        }
    }

    private void choiceHintHide() {
        this.cardInfo.onMouseExited();
        this.listChoices.setToolTipText(null);
        this.lastModelIndex = -1;
    }

    public void setWindowSize(int width, int height) {
        this.setSize(new Dimension(width, height));
    }

    @Override
    public void hideDialog() {
        this.choiceHintHide();
        super.hideDialog();
    }

    private void loadData() {
        String filter = this.choice.getSearchText();
        if (filter == null) {
            filter = "";
        }
        filter = filter.toLowerCase(Locale.ENGLISH);
        DefaultListModel<KeyValueItem> newModel = new DefaultListModel<KeyValueItem>();
        for (KeyValueItem item : this.allItems) {
            if (this.choice.isSearchEnabled() && !item.getValue().toLowerCase(Locale.ENGLISH).contains(filter)) continue;
            newModel.addElement(item);
        }
        this.listChoices.setModel(newModel);
    }

    private void setMessageText(MageEditorPane editor, String text) {
        editor.setGameData(this.gameId, this.bigCard);
        if (text != null && !text.equals("")) {
            String realText = ManaSymbols.replaceSymbolsWithHTML(text, ManaSymbols.Type.DIALOG);
            editor.setText(String.format(HTML_HEADERS_TEMPLATE, realText));
            editor.setVisible(true);
        } else {
            editor.setText("");
            editor.setVisible(false);
        }
    }

    private void doNextSelect() {
        int maxSel;
        int newSel = this.listChoices.getSelectedIndex() + 1;
        if (newSel <= (maxSel = this.listChoices.getModel().getSize() - 1)) {
            this.listChoices.setSelectedIndex(newSel);
            this.listChoices.ensureIndexIsVisible(newSel);
        }
    }

    private void doPrevSelect() {
        int newSel = this.listChoices.getSelectedIndex() - 1;
        if (newSel >= 0) {
            this.listChoices.setSelectedIndex(newSel);
            this.listChoices.ensureIndexIsVisible(newSel);
        }
    }

    private void doChoose() {
        if (this.setChoice()) {
            this.doClose();
        }
    }

    private void doCancel() {
        this.listChoices.clearSelection();
        this.choice.clearChoice();
        this.doClose();
    }

    private void doClose() {
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onChoiceDone();
        }
    }

    public boolean setChoice() {
        boolean isSpecial;
        KeyValueItem item = (KeyValueItem)this.listChoices.getSelectedValue();
        boolean bl = isSpecial = this.choice.isSpecialEnabled() && this.cbSpecial.isSelected();
        if (item == null && this.listChoices.getModel().getSize() == 1) {
            this.listChoices.setSelectedIndex(0);
            item = (KeyValueItem)this.listChoices.getSelectedValue();
        }
        if (item != null) {
            if (this.choice.isKeyChoice()) {
                this.choice.setChoiceByKey(item.getKey(), isSpecial);
            } else {
                this.choice.setChoice(item.getKey(), isSpecial);
            }
            return true;
        }
        if (this.choice.isSpecialEnabled() && this.choice.isSpecialCanBeEmpty()) {
            if (this.choice.isKeyChoice()) {
                this.choice.setChoiceByKey(null, isSpecial);
            } else {
                this.choice.setChoice(null, isSpecial);
            }
            return true;
        }
        this.choice.clearChoice();
        return false;
    }

    private void initComponents() {
        this.panelHeader = new JPanel();
        this.textMessage = new MageEditorPane();
        this.textSubMessage = new MageEditorPane();
        this.panelSearch = new JPanel();
        this.labelSearch = new JLabel();
        this.editSearch = new JTextField();
        this.scrollList = new JScrollPane();
        this.listChoices = new JList();
        this.panelCommands = new JPanel();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.cbSpecial = new JCheckBox();
        this.setResizable(true);
        this.panelHeader.setLayout(new BorderLayout());
        this.textMessage.setEditable(false);
        this.textMessage.setBorder(null);
        this.textMessage.setText("<html><div style='text-align: center;'>example long message example long message example long message example long message example long message</div></html>");
        this.textMessage.setAutoscrolls(false);
        this.textMessage.setFocusable(false);
        this.textMessage.setOpaque(false);
        this.panelHeader.add((Component)this.textMessage, "Center");
        this.textSubMessage.setEditable(false);
        this.textSubMessage.setBorder(null);
        this.textSubMessage.setText("<html><div style='text-align: center;'>example long message example long</div></html>");
        this.textSubMessage.setAutoscrolls(false);
        this.textSubMessage.setFocusable(false);
        this.textSubMessage.setOpaque(false);
        this.panelHeader.add((Component)this.textSubMessage, "South");
        this.labelSearch.setText("Search:");
        this.editSearch.setText("sample search text");
        GroupLayout panelSearchLayout = new GroupLayout(this.panelSearch);
        this.panelSearch.setLayout(panelSearchLayout);
        panelSearchLayout.setHorizontalGroup(panelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSearchLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.labelSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editSearch).addGap(0, 0, 0)));
        panelSearchLayout.setVerticalGroup(panelSearchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSearchLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(panelSearchLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSearch).addComponent(this.editSearch, -2, -1, -2)).addGap(3, 3, 3)));
        this.listChoices.setModel(new AbstractListModel(){
            String[] strings = new String[]{"item1", "item2", "item3"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollList.setViewportView(this.listChoices);
        this.btOK.setText("Choose");
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickChoiceDialog.this.btOKActionPerformed(evt);
            }
        });
        this.btCancel.setText("Cancel");
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickChoiceDialog.this.btCancelActionPerformed(evt);
            }
        });
        this.cbSpecial.setText("Remember choose");
        GroupLayout panelCommandsLayout = new GroupLayout(this.panelCommands);
        this.panelCommands.setLayout(panelCommandsLayout);
        panelCommandsLayout.setHorizontalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addComponent(this.cbSpecial).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btCancel, -2, 70, -2).addContainerGap()));
        panelCommandsLayout.linkSize(0, this.btCancel, this.btOK);
        panelCommandsLayout.setVerticalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btCancel).addComponent(this.btOK).addComponent(this.cbSpecial)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.btOK);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollList, GroupLayout.Alignment.TRAILING).addComponent(this.panelCommands, -1, -1, Short.MAX_VALUE).addComponent(this.panelHeader, -1, 371, Short.MAX_VALUE).addComponent(this.panelSearch, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelHeader, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelSearch, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollList, -1, 268, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCommands, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void btOKActionPerformed(ActionEvent evt) {
        this.doChoose();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void closeDialog(WindowEvent evt) {
        this.doCancel();
    }

    static class KeyValueItem {
        protected final String key;
        protected String value;
        protected String valueAsHtml;
        protected String hint;
        protected ChoiceHintType hintType;

        public KeyValueItem(String key, String value, String hint, ChoiceHintType hintType) {
            this.key = key;
            this.value = value;
            this.valueAsHtml = "<html>" + ManaSymbols.replaceSymbolsWithHTML(value, ManaSymbols.Type.TABLE);
            this.hint = hint;
            this.hintType = hintType;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getValueAsHtml() {
            return this.valueAsHtml;
        }

        public String getHint() {
            return this.hint;
        }

        public ChoiceHintType getHintType() {
            return this.hintType;
        }

        public String toString() {
            return this.valueAsHtml;
        }
    }

    public static interface PickChoiceCallback {
        public void onChoiceDone();
    }
}

