/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import mage.client.cards.BigCard;
import mage.client.components.MageTextArea;
import mage.client.dialog.MageDialog;
import mage.constants.ColoredManaSymbol;
import mage.util.MultiAmountMessage;
import org.mage.card.arcane.ManaSymbols;

public class PickMultiNumberDialog
extends MageDialog {
    private boolean cancel;
    private PickMultiNumberCallback callback = null;
    private UUID gameId = null;
    private BigCard bigCard = null;
    private List<MageTextArea> infoList = null;
    private List<JSpinner> spinnerList = null;
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel counterText;
    private JLabel header;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel panelCommands;
    private JPanel panelHeader;

    public PickMultiNumberDialog() {
        this.initComponents();
        this.setModal(true);
    }

    public void init(UUID gameId, BigCard bigCard) {
        this.gameId = gameId;
        this.bigCard = bigCard;
    }

    public void showDialog(List<MultiAmountMessage> messages, int min, int max, Map<String, Serializable> options, PickMultiNumberCallback callback) {
        this.cancel = false;
        this.callback = callback;
        this.header.setText("<html>" + ManaSymbols.replaceSymbolsWithHTML((String)((Object)options.get("header")), ManaSymbols.Type.DIALOG));
        this.setTitle((String)((Object)options.get("title")));
        boolean canCancel = options.get("canCancel") != null && (Boolean)options.get("canCancel") != false;
        this.btnCancel.setVisible(canCancel);
        if (this.infoList != null) {
            for (MageTextArea info : this.infoList) {
                this.jPanel1.remove(info);
            }
        }
        if (this.spinnerList != null) {
            for (JSpinner spinner : this.spinnerList) {
                this.jPanel1.remove(spinner);
            }
        }
        int size = messages.size();
        this.infoList = new ArrayList<MageTextArea>(size);
        this.spinnerList = new ArrayList<JSpinner>(size);
        this.jPanel1.setLayout(new GridBagLayout());
        int i = 0;
        while (i < size) {
            String input;
            MageTextArea info = new MageTextArea();
            info.enableTextLabelMode();
            info.setGameData(this.gameId, this.bigCard);
            String manaText = null;
            switch (input = messages.get((int)i).message) {
                case "W": {
                    manaText = ColoredManaSymbol.W.getColorHtmlName();
                    break;
                }
                case "U": {
                    manaText = ColoredManaSymbol.U.getColorHtmlName();
                    break;
                }
                case "B": {
                    manaText = ColoredManaSymbol.B.getColorHtmlName();
                    break;
                }
                case "R": {
                    manaText = ColoredManaSymbol.R.getColorHtmlName();
                    break;
                }
                case "G": {
                    manaText = ColoredManaSymbol.G.getColorHtmlName();
                }
            }
            if (manaText != null) {
                info.setText("{" + input + "}&nbsp;" + manaText);
            } else {
                info.setText(input);
            }
            GridBagConstraints infoC = new GridBagConstraints();
            infoC.weightx = 0.5;
            infoC.gridx = 0;
            infoC.gridy = i;
            this.jPanel1.add((Component)info, infoC);
            this.infoList.add(info);
            JSpinner spinner = new JSpinner();
            spinner.setModel(new SpinnerNumberModel(messages.get((int)i).defaultValue, messages.get((int)i).min, messages.get((int)i).max, 1));
            GridBagConstraints spinnerC = new GridBagConstraints();
            spinnerC.weightx = 0.5;
            spinnerC.gridx = 1;
            spinnerC.gridy = i++;
            spinnerC.ipadx = 20;
            spinner.addChangeListener(e -> this.updateControls(min, max, messages));
            this.jPanel1.add((Component)spinner, spinnerC);
            this.spinnerList.add(spinner);
        }
        this.counterText.setText("0 out of 0");
        this.updateControls(min, max, messages);
        this.pack();
        this.makeWindowCentered();
        this.setVisible(true);
    }

    private void updateControls(int min, int max, List<MultiAmountMessage> messages) {
        int totalChosenAmount = 0;
        boolean chooseEnabled = true;
        for (int i = 0; i < this.spinnerList.size(); ++i) {
            JSpinner jSpinner = this.spinnerList.get(i);
            int value = ((Number)jSpinner.getValue()).intValue();
            totalChosenAmount += value;
            chooseEnabled &= value >= messages.get((int)i).min && value <= messages.get((int)i).max;
        }
        this.counterText.setText(totalChosenAmount + " out of " + max);
        this.btnOk.setEnabled(chooseEnabled &= totalChosenAmount >= min && totalChosenAmount <= max);
    }

    public String getMultiAmount() {
        return this.spinnerList.stream().map(spinner -> ((Number)spinner.getValue()).intValue()).map(String::valueOf).collect(Collectors.joining(" "));
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private void doClose() {
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onChoiceDone();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.panelCommands = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.panelHeader = new JPanel();
        this.header = new JLabel();
        this.counterText = new JLabel();
        this.getContentPane().setLayout(new BorderLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 598, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 828, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.btnOk.setText("Choose");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickMultiNumberDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickMultiNumberDialog.this.btnCancelActionPerformed(evt);
            }
        });
        GroupLayout panelCommandsLayout = new GroupLayout(this.panelCommands);
        this.panelCommands.setLayout(panelCommandsLayout);
        panelCommandsLayout.setHorizontalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap(257, Short.MAX_VALUE).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addContainerGap()));
        panelCommandsLayout.setVerticalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap().addGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getContentPane().add((Component)this.panelCommands, "South");
        this.panelHeader.setLayout(new BorderLayout());
        this.header.setHorizontalAlignment(0);
        this.header.setText("Header 12312321312312");
        this.panelHeader.add((Component)this.header, "North");
        this.counterText.setHorizontalAlignment(0);
        this.counterText.setText("Counter 213123 213 213123213 123 123213123123123");
        this.panelHeader.add((Component)this.counterText, "South");
        this.getContentPane().add((Component)this.panelHeader, "North");
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.doClose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.doClose();
    }

    public static interface PickMultiNumberCallback {
        public void onChoiceDone();
    }
}

