/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import mage.client.MageFrame;
import mage.client.components.MageEditorPane;
import mage.client.dialog.MageDialog;

public class PickNumberDialog
extends MageDialog {
    private boolean cancel;
    private PickNumberCallback callback = null;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JSpinner editAmount;
    private JLabel labelLimits;
    private JPanel panelCommands;
    private JScrollPane scrollMessage;
    private MageEditorPane textMessage;

    public PickNumberDialog() {
        this.initComponents();
        this.textMessage.enableHyperlinksAndCardPopups();
        this.setModal(true);
    }

    public void showDialog(int min, int max, String message, PickNumberCallback callback) {
        this.editAmount.setModel(new SpinnerNumberModel(min, min, max, 1));
        this.textMessage.setContentType("text/html");
        this.textMessage.setText(message);
        this.callback = callback;
        ArrayList<String> limits = new ArrayList<String>();
        if (min != Integer.MIN_VALUE) {
            limits.add("from " + min);
        }
        limits.add("to " + (max == Integer.MAX_VALUE ? "any" : Integer.valueOf(max)));
        this.labelLimits.setText(String.join((CharSequence)" ", limits));
        this.buttonOk.setVisible(true);
        this.buttonCancel.setVisible(false);
        this.pack();
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.getRootPane().setDefaultButton(this.buttonOk);
        ((JSpinner.DefaultEditor)this.editAmount.getEditor()).getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PickNumberDialog.this.buttonOk.doClick();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.makeWindowCentered();
        this.setVisible(true);
    }

    public int getAmount() {
        return ((Number)this.editAmount.getValue()).intValue();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private void doClose() {
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onChoiceDone();
        }
    }

    private void initComponents() {
        this.scrollMessage = new JScrollPane();
        this.textMessage = new MageEditorPane();
        this.editAmount = new JSpinner();
        this.labelLimits = new JLabel();
        this.panelCommands = new JPanel();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.scrollMessage.setHorizontalScrollBarPolicy(31);
        this.scrollMessage.setFocusable(false);
        this.textMessage.setEditable(false);
        this.textMessage.setText("long text long text long text long text long text long text long text long text");
        this.textMessage.setFocusable(false);
        this.textMessage.setOpaque(false);
        this.scrollMessage.setViewportView(this.textMessage);
        this.editAmount.setModel(new SpinnerNumberModel((Number)1, null, null, (Number)1));
        this.labelLimits.setText("min 1, max 123");
        this.buttonOk.setText("Choose");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickNumberDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickNumberDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        GroupLayout panelCommandsLayout = new GroupLayout(this.panelCommands);
        this.panelCommands.setLayout(panelCommandsLayout);
        panelCommandsLayout.setHorizontalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addContainerGap()));
        panelCommandsLayout.setVerticalGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandsLayout.createSequentialGroup().addContainerGap().addGroup(panelCommandsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk).addComponent(this.buttonCancel)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.buttonOk);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollMessage, -1, 183, Short.MAX_VALUE).addComponent(this.panelCommands, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.editAmount, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelLimits).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollMessage, -1, 117, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editAmount, -2, -1, -2).addComponent(this.labelLimits)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelCommands, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.cancel = false;
        this.doClose();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.doClose();
    }

    public static interface PickNumberCallback {
        public void onChoiceDone();
    }
}

