/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import mage.cards.MageCard;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.cards.CardArea;
import mage.client.dialog.MageDialog;
import mage.view.CardsView;

public class PickPileDialog
extends MageDialog {
    private final CardArea pile1;
    private final CardArea pile2;
    private boolean pickedPile1 = false;
    private boolean pickedOK = false;
    private PickPileCallback callback = null;

    public PickPileDialog() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "West");
        panel.setLayout(new BorderLayout(0, 0));
        this.pile1 = new CardArea();
        panel.add((Component)this.pile1, "Center");
        JButton btnChoosePile1 = new JButton("Pile 1");
        btnChoosePile1.addActionListener(e -> this.btnPile1ActionPerformed(e));
        panel.add((Component)btnChoosePile1, "North");
        JPanel panel_1 = new JPanel();
        this.getContentPane().add((Component)panel_1, "East");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.pile2 = new CardArea();
        panel_1.add((Component)this.pile2, "Center");
        JButton btnChoosePile2 = new JButton("Pile 2");
        btnChoosePile2.addActionListener(e -> this.btnPile2ActionPerformed(e));
        panel_1.add((Component)btnChoosePile2, "North");
    }

    public void showDialog(String name, CardsView pile1, CardsView pile2, BigCard bigCard, UUID gameId, PickPileCallback callback) {
        this.pickedOK = false;
        this.pickedPile1 = false;
        this.title = name;
        this.pile1.loadCardsNarrow(pile1, bigCard, gameId);
        this.pile2.loadCardsNarrow(pile2, bigCard, gameId);
        this.callback = callback;
        this.setModal(true);
        this.pack();
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.makeWindowCentered();
        this.setVisible(true);
    }

    public void cleanUp() {
        for (Component comp : this.pile1.getComponents()) {
            if (!(comp instanceof MageCard)) continue;
            ((MageCard)comp).cleanUp();
            this.pile1.remove(comp);
        }
        for (Component comp : this.pile2.getComponents()) {
            if (!(comp instanceof MageCard)) continue;
            ((MageCard)comp).cleanUp();
            this.pile2.remove(comp);
        }
    }

    private void doClose() {
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onChoiceDone();
        }
        this.cleanUp();
        this.removeDialog();
    }

    private void btnPile1ActionPerformed(ActionEvent evt) {
        this.pickedPile1 = true;
        this.pickedOK = true;
        this.doClose();
    }

    private void btnPile2ActionPerformed(ActionEvent evt) {
        this.pickedPile1 = false;
        this.pickedOK = true;
        this.doClose();
    }

    public boolean isPickedPile1() {
        return this.pickedPile1;
    }

    public boolean isPickedOK() {
        return this.pickedOK;
    }

    public static interface PickPileCallback {
        public void onChoiceDone();
    }
}

