/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;

public class RandomPacksSelectorDialog
extends JDialog {
    private boolean boxesCreated;
    public static final String randomDraftDescription = "The selected packs will be randomly distributed to players. Each player may open different packs. Duplicates will be avoided.";
    private JButton btnAll;
    private JButton btnApply;
    private JButton btnNone;
    private JPanel pnlApply;
    private Panel pnlPacks;
    private JPanel pnlSelect;

    public RandomPacksSelectorDialog() {
        this.initComponents();
        this.pnlApply.setToolTipText(randomDraftDescription);
        this.pnlSelect.setToolTipText(randomDraftDescription);
        this.boxesCreated = false;
    }

    private void setType(boolean isRandomDraft, boolean isRichManDraft, boolean isReshuffledDraft) {
        String title = isRandomDraft ? "Random Booster Draft Packs Selector" : (isRichManDraft ? "Rich Man Booster Draft Packs Selector" : (isReshuffledDraft ? "Chaos Reshuffled Draft Set Selector" : "Booster Draft Packs Selector"));
        this.setTitle(title);
    }

    public void showDialog(boolean isRandomDraft, boolean isRichManDraft, boolean isReshuffledDraft) {
        this.setType(isRandomDraft, isRichManDraft, isReshuffledDraft);
        this.createCheckboxes();
        this.pnlPacks.setVisible(true);
        this.pnlPacks.revalidate();
        this.pnlPacks.repaint();
        this.pack();
        this.revalidate();
        this.repaint();
        this.setVisible(true);
        this.setModal(true);
    }

    public void setSelectedPacks(List<String> packs) {
        if (!this.boxesCreated) {
            this.createCheckboxes();
        }
        for (Component pack : this.pnlPacks.getComponents()) {
            JCheckBox thePack = (JCheckBox)pack;
            if (packs.contains(thePack.getText())) {
                thePack.setSelected(true);
                continue;
            }
            thePack.setSelected(false);
        }
    }

    public List<String> getSelectedPacks() {
        ArrayList<String> returnVal = new ArrayList<String>();
        for (Component pack : this.pnlPacks.getComponents()) {
            JCheckBox thePack = (JCheckBox)pack;
            if (!thePack.isSelected()) continue;
            returnVal.add(thePack.getText());
        }
        return returnVal;
    }

    private void createCheckboxes() {
        if (!this.boxesCreated) {
            ExpansionInfo[] allExpansions;
            for (ExpansionInfo exp : allExpansions = ExpansionRepository.instance.getWithBoostersSortedByReleaseDate()) {
                JCheckBox pack = new JCheckBox();
                pack.setSelected(true);
                pack.setText(exp.getCode());
                pack.setToolTipText(exp.getName());
                this.pnlPacks.add(pack);
            }
            this.pnlPacks.setVisible(true);
            this.pack();
            this.boxesCreated = true;
            this.pnlPacks.validate();
        }
    }

    private void initComponents() {
        this.pnlPacks = new Panel();
        this.pnlSelect = new JPanel();
        this.btnNone = new JButton();
        this.btnAll = new JButton();
        this.pnlApply = new JPanel();
        this.btnApply = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Random Booster Draft Packs Selector");
        this.setModal(true);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setPreferredSize(new Dimension(875, 475));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RandomPacksSelectorDialog.this.formWindowClosing(evt);
            }
        });
        this.pnlPacks.setLayout(new GridLayout(14, 14));
        this.pnlSelect.setLayout(new BoxLayout(this.pnlSelect, 2));
        this.btnNone.setText("Select none");
        this.btnNone.setActionCommand("none");
        this.btnNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomPacksSelectorDialog.this.btnNoneActionPerformed(evt);
            }
        });
        this.pnlSelect.add(this.btnNone);
        this.btnAll.setText("Select all");
        this.btnAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomPacksSelectorDialog.this.btnAllActionPerformed(evt);
            }
        });
        this.pnlSelect.add(this.btnAll);
        this.pnlApply.setLayout(new BoxLayout(this.pnlApply, 2));
        this.btnApply.setText("Apply");
        this.btnApply.setToolTipText("At least two packs must be selected");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomPacksSelectorDialog.this.btnApplyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlSelect, -2, 196, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 402, Short.MAX_VALUE).addComponent(this.pnlApply, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnApply)).addComponent(this.pnlPacks, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlPacks, -2, 362, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlApply, -2, 32, -2).addComponent(this.pnlSelect, -2, 32, -2).addComponent(this.btnApply)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnAllActionPerformed(ActionEvent evt) {
        this.setAllCheckBoxes(true);
    }

    private void btnNoneActionPerformed(ActionEvent evt) {
        this.setAllCheckBoxes(false);
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        this.doApply();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doApply();
    }

    public void doApply() {
        if (this.getSelectedPacks().size() < 1) {
            JOptionPane.showMessageDialog(this, "At least one set must be selected", "Error", 0);
        } else {
            this.setVisible(false);
        }
    }

    private void setAllCheckBoxes(boolean value) {
        for (Component pack : this.pnlPacks.getComponents()) {
            JCheckBox thePack = (JCheckBox)pack;
            thePack.setSelected(value);
        }
    }
}

