/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.preference.MagePreferences;
import mage.remote.Connection;
import org.apache.log4j.Logger;

public class RegisterUserDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(RegisterUserDialog.class);
    private Connection connection;
    private ConnectTask task;
    private JButton btnCancel;
    private JButton btnRegister;
    private JLabel lblEmail;
    private JLabel lblEmailReasoning;
    private JLabel lblPassword;
    private JLabel lblPasswordConfirmation;
    private JLabel lblPasswordConfirmationReasoning;
    private JLabel lblPort;
    private JLabel lblServer;
    private JLabel lblStatus;
    private JLabel lblUserName;
    private JTextField txtEmail;
    private JPasswordField txtPassword;
    private JPasswordField txtPasswordConfirmation;
    private JTextField txtPort;
    private JTextField txtServer;
    private JTextField txtUserName;

    public RegisterUserDialog() {
        this.initComponents();
    }

    public void showDialog(String server, String port) {
        this.txtServer.setText(server);
        this.txtPort.setText(port);
        this.lblStatus.setText("");
        this.setModal(true);
        this.setLocation(50, 50);
        this.setVisible(true);
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.lblPort = new JLabel();
        this.lblUserName = new JLabel();
        this.lblPassword = new JLabel();
        this.txtUserName = new JTextField();
        this.txtPassword = new JPasswordField();
        this.btnRegister = new JButton();
        this.btnCancel = new JButton();
        this.lblStatus = new JLabel();
        this.txtServer = new JTextField();
        this.txtPort = new JTextField();
        this.txtEmail = new JTextField();
        this.lblPasswordConfirmation = new JLabel();
        this.txtPasswordConfirmation = new JPasswordField();
        this.lblEmail = new JLabel();
        this.lblPasswordConfirmationReasoning = new JLabel();
        this.lblEmailReasoning = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Register");
        this.lblServer.setLabelFor(this.txtServer);
        this.lblServer.setText("Server:");
        this.lblPort.setLabelFor(this.txtPort);
        this.lblPort.setText("Port:");
        this.lblUserName.setLabelFor(this.txtUserName);
        this.lblUserName.setText("User name:");
        this.lblPassword.setLabelFor(this.txtPassword);
        this.lblPassword.setText("Password:");
        this.txtUserName.addActionListener(evt -> this.txtUserNameActionPerformed(evt));
        this.btnRegister.setText("Register");
        this.btnRegister.addActionListener(evt -> this.btnRegisterActionPerformed(evt));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(evt -> this.btnCancelActionPerformed(evt));
        this.lblPasswordConfirmation.setLabelFor(this.txtPasswordConfirmation);
        this.lblPasswordConfirmation.setText("Password:");
        this.lblEmail.setLabelFor(this.txtEmail);
        this.lblEmail.setText("Email:");
        this.lblPasswordConfirmationReasoning.setFont(new Font("Lucida Grande", 0, 10));
        this.lblPasswordConfirmationReasoning.setLabelFor(this.txtPasswordConfirmation);
        this.lblPasswordConfirmationReasoning.setText("(confirmation)");
        this.lblEmailReasoning.setFont(new Font("Lucida Grande", 0, 10));
        this.lblEmailReasoning.setLabelFor(this.txtEmail);
        this.lblEmailReasoning.setText("(used for password reset and sending initial password)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblPasswordConfirmationReasoning).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblServer).addComponent(this.lblUserName).addComponent(this.lblPort).addComponent(this.lblPassword).addComponent(this.lblPasswordConfirmation).addComponent(this.lblEmail)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtServer, -2, 292, -2).addComponent(this.txtPort, -2, 292, -2).addComponent(this.txtUserName, -2, 292, -2).addComponent(this.txtPassword, -2, 292, -2).addComponent(this.txtPasswordConfirmation, -2, 292, -2).addComponent(this.txtEmail, -2, 292, -2))).addComponent(this.lblEmailReasoning).addGroup(layout.createSequentialGroup().addComponent(this.btnRegister).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE)).addContainerGap(22, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblServer).addComponent(this.txtServer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPort).addComponent(this.txtPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUserName).addComponent(this.txtUserName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPasswordConfirmation, -2, -1, -2).addComponent(this.lblPasswordConfirmation)).addComponent(this.lblPasswordConfirmationReasoning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEmail).addComponent(this.txtEmail, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEmailReasoning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblStatus, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnRegister)).addContainerGap()));
        this.pack();
    }

    private void txtUserNameActionPerformed(ActionEvent evt) {
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.hideDialog();
    }

    private void btnRegisterActionPerformed(ActionEvent evt) {
        if (!Arrays.equals(this.txtPassword.getPassword(), this.txtPasswordConfirmation.getPassword())) {
            MageFrame.getInstance().showError("Passwords don't match.");
            return;
        }
        this.connection = new Connection();
        this.connection.setHost(this.txtServer.getText().trim());
        this.connection.setPort(Integer.parseInt(this.txtPort.getText().trim()));
        this.connection.setUsername(this.txtUserName.getText().trim());
        this.connection.setPassword(String.valueOf(this.txtPassword.getPassword()).trim());
        this.connection.setEmail(this.txtEmail.getText().trim());
        PreferencesDialog.setProxyInformation(this.connection);
        this.task = new ConnectTask();
        this.task.execute();
    }

    private class ConnectTask
    extends SwingWorker<Boolean, Void> {
        private boolean result = false;
        private static final int CONNECTION_TIMEOUT_MS = 2100;

        private ConnectTask() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            RegisterUserDialog.this.lblStatus.setText("Connecting...");
            RegisterUserDialog.this.btnRegister.setEnabled(false);
            this.result = SessionHandler.register(RegisterUserDialog.this.connection);
            return this.result;
        }

        @Override
        protected void done() {
            try {
                this.get(2100L, TimeUnit.MILLISECONDS);
                if (this.result) {
                    MagePreferences.setServerAddress(RegisterUserDialog.this.connection.getHost());
                    MagePreferences.setServerPort(RegisterUserDialog.this.connection.getPort());
                    MagePreferences.setUserName(RegisterUserDialog.this.connection.getHost(), RegisterUserDialog.this.connection.getUsername());
                    MagePreferences.setPassword(RegisterUserDialog.this.connection.getHost(), RegisterUserDialog.this.connection.getPassword());
                    MagePreferences.setEmail(RegisterUserDialog.this.connection.getHost(), RegisterUserDialog.this.connection.getEmail());
                    String message = "Registration succeeded";
                    RegisterUserDialog.this.lblStatus.setText(message);
                    MageFrame.getInstance().showMessage(message);
                    RegisterUserDialog.this.hideDialog();
                } else {
                    RegisterUserDialog.this.lblStatus.setText("Could not register");
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                logger.fatal((Object)"Registration task error", (Throwable)ex);
            }
            catch (CancellationException ex) {
                logger.info((Object)"Registration was canceled");
                RegisterUserDialog.this.lblStatus.setText("Registration was canceled (but an account might have been actually created)");
            }
            catch (TimeoutException ex) {
                logger.fatal((Object)"Registration timeout: ", (Throwable)ex);
            }
            finally {
                MageFrame.stopConnecting();
                RegisterUserDialog.this.btnRegister.setEnabled(true);
            }
        }
    }
}

